/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.controller;

import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.UserSyncDirectory;
import com.centit.framework.system.service.UserSyncDirectoryManager;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.compiler.Pretreatment;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/ldap"})
@Api(value="ldap\u767b\u5f55\u76f8\u5173\u63a5\u53e3", tags={"ldap\u767b\u5f55\u76f8\u5173\u63a5\u53e3"})
public class LdapLogin {
    private static Logger logger = LoggerFactory.getLogger(LdapLogin.class);
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired
    private UserSyncDirectoryManager userSyncDirectoryManager;

    @ApiOperation(value="ldap\u767b\u5f55", notes="ldap\u767b\u5f55")
    @PostMapping(value={"/login"})
    public String login(@RequestParam(value="username") String username, @RequestParam(value="password") String password, @RequestParam(value="returnUrl") String returnUrl, HttpServletResponse response) throws Exception {
        Map<String, Object> map = this.searchLdapUserByloginName(username);
        if (map == null || map.isEmpty()) {
            throw new ObjectException(500, "\u7528\u6237\u627e\u4e0d\u5230\uff01");
        }
        try {
            boolean passed = this.checkUserPasswordByDn(Pretreatment.mapTemplateString((String)"CN={name},CN=Users,DC=centit,DC=com", map), password);
            if (!passed) {
                throw new ObjectException(500, "\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d\u3002");
            }
            CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByLoginName(map.get("sAMAccountName") + "");
            SecurityContextHolder.getContext().setAuthentication((Authentication)ud);
        }
        catch (NamingException e) {
            throw new ObjectException(500, "\u7cfb\u7edf\u9519\u8bef");
        }
        return "redirect:" + returnUrl;
    }

    public Map<String, Object> searchLdapUserByloginName(String loginName) {
        HashMap<String, Object> attributes;
        block8: {
            List list = this.userSyncDirectoryManager.listObjects();
            UserSyncDirectory directory = new UserSyncDirectory();
            if (list != null && list.size() > 0) {
                for (UserSyncDirectory userSyncDirectory : list) {
                    if (!userSyncDirectory.getType().equalsIgnoreCase("LDAP")) continue;
                    directory = userSyncDirectory;
                }
            }
            Properties env = new Properties();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", directory.getUser());
            env.put("java.naming.security.credentials", directory.getUserPwd());
            env.put("java.naming.provider.url", directory.getUrl());
            attributes = new HashMap<String, Object>(20);
            InitialLdapContext ctx = null;
            try {
                ctx = new InitialLdapContext(env, null);
                SearchControls searchCtls = new SearchControls();
                searchCtls.setSearchScope(2);
                ArrayList<String> searchFilters = new ArrayList<String>();
                searchFilters.add("(&(objectCategory=person)(objectClass=user)(sAMAccountName={0}))");
                searchFilters.add("(distinguishedName=CN={0},CN=Users,DC=centit,DC=com)");
                for (String filterStr : searchFilters) {
                    SearchResult sr;
                    Attributes attrs;
                    String principalId;
                    String searchFilter = MessageFormat.format(filterStr, loginName);
                    String[] userReturnedAtts = new String[]{"displayName", "name", "sAMAccountName", "mail", "distinguishedName", "jobNo", "idCard", "mobilePhone", "description", "memberOf"};
                    searchCtls.setReturningAttributes(userReturnedAtts);
                    NamingEnumeration<SearchResult> answer = ctx.search("CN=Users,DC=centit,DC=com", searchFilter, searchCtls);
                    if (!answer.hasMoreElements() || !StringUtils.isNotBlank((CharSequence)(principalId = LdapLogin.getAttributeString(attrs = (sr = answer.next()).getAttributes(), "sAMAccountName")))) continue;
                    NamingEnumeration<? extends Attribute> enumeration = attrs.getAll();
                    while (enumeration.hasMore()) {
                        Attribute attr = enumeration.next();
                        attributes.put(attr.getID(), attr.get());
                    }
                    ctx.close();
                }
                ctx.close();
            }
            catch (NamingException e) {
                if (ctx == null) break block8;
                try {
                    ctx.close();
                }
                catch (NamingException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return attributes;
    }

    public static String getAttributeString(Attributes attrs, String attrName) {
        Attribute attr = attrs.get(attrName);
        if (attr == null) {
            return null;
        }
        try {
            return StringBaseOpt.objectToString((Object)attr.get());
        }
        catch (NamingException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkUserPasswordByDn(String username, String password) throws NamingException {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.provider.url", "LDAP://192.168.128.5:389");
        try (InitialLdapContext ctx = null;){
            ctx = new InitialLdapContext(env, null);
            boolean bl = true;
            return bl;
        }
    }
}

