/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.controller;

import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.users.config.AppConfig;
import com.centit.framework.users.config.WxAppConfig;
import com.centit.framework.users.dto.DingUserDTO;
import com.centit.framework.users.po.Platform;
import com.centit.framework.users.po.UserPlat;
import com.centit.framework.users.service.DingTalkLoginService;
import com.centit.framework.users.service.PlatformService;
import com.centit.framework.users.service.TokenService;
import com.centit.framework.users.service.UserPlatService;
import com.centit.framework.users.service.WeChatService;
import com.centit.support.common.ObjectException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/third"})
@Api(value="\u7b2c\u4e09\u65b9\u5e73\u53f0\u767b\u5f55\u76f8\u5173\u63a5\u53e3", tags={"\u7b2c\u4e09\u65b9\u5e73\u53f0\u767b\u5f55\u76f8\u5173\u63a5\u53e3"})
public class ThirdLogin {
    @Autowired
    private WxMpService wxOpenService;
    @Autowired
    private WxAppConfig wxAppConfig;
    @Autowired
    private AppConfig appConfig;
    @Autowired
    private UserPlatService userPlatService;
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired
    private PlatformService platformService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private DingTalkLoginService dingTalkLoginService;
    @Autowired
    private WeChatService weChatService;
    private static final String WECHAT_LOGIN = "wx";
    private static final String WECHAT_BIND = "wxBind";
    private static final String DING_LOGIN = "ding";
    private static final String DING_BIND = "dingBind";
    private static final String QQ_LOGIN = "QQ";
    private static final String QQ_BIND = "qqBind";

    @ApiOperation(value="\u5fae\u4fe1\u4e8c\u7ef4\u7801\u767b\u5f55/\u7ed1\u5b9a", notes="\u5fae\u4fe1\u4e8c\u7ef4\u7801\u767b\u5f55/\u7ed1\u5b9a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="\u8bf7\u6c42\u7c7b\u578b;\u767b\u5f55:wx;\u7ed1\u5b9a:wxBind;\u9489\u9489:ding", required=true, paramType="body", dataType="String"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u540d,\u7c7b\u578b\u4e3abind\u65f6,\u4e0d\u53ef\u4e3a\u7a7a", required=true, paramType="body", dataType="String")})
    @GetMapping(value={"/login"})
    public void qrAuthorize(@RequestParam(value="type") String type, @RequestParam(value="userCode") String userCode, @RequestParam(value="returnUrl") String returnUrl, HttpServletResponse response) throws IOException {
        String url = "";
        String authorizeUrl = "";
        if (WECHAT_LOGIN.equals(type)) {
            url = this.wxAppConfig.getRedirectLoginUri() + "?type=" + type + "&returnUrl=" + returnUrl;
            authorizeUrl = this.wxOpenService.buildQrConnectUrl(url, "snsapi_login", "");
        } else if (WECHAT_BIND.equals(type)) {
            if (userCode == null || "".equals(userCode)) {
                throw new ObjectException("\u7f3a\u5c11\u53c2\u6570userCode;");
            }
            url = this.wxAppConfig.getRedirectBindUri() + "?type=" + type + "&returnUrl=" + returnUrl + "&userCode=" + userCode;
            authorizeUrl = this.wxOpenService.buildQrConnectUrl(url, "snsapi_login", "");
        } else if (DING_LOGIN.equals(type)) {
            url = URIUtil.encodeURIComponent((String)(this.appConfig.getRedirectUri() + "?type=" + type + "&returnUrl=" + returnUrl));
            authorizeUrl = "https://oapi.dingtalk.com/connect/qrconnect?appid=" + this.appConfig.getAppKey() + "&response_type=code&scope=snsapi_login&redirect_uri=" + url;
        } else if (DING_BIND.equals(type)) {
            if (userCode == null || "".equals(userCode)) {
                throw new ObjectException("\u7f3a\u5c11\u53c2\u6570userCode;");
            }
            url = URIUtil.encodeURIComponent((String)(this.appConfig.getRedirectBindUri() + "?type=" + type + "&returnUrl=" + returnUrl + "&userCode=" + userCode));
            authorizeUrl = "https://oapi.dingtalk.com/connect/qrconnect?appid=" + this.appConfig.getAppKey() + "&response_type=code&scope=snsapi_login&redirect_uri=" + url;
        }
        response.sendRedirect(authorizeUrl);
    }

    @GetMapping(value={"/qrUserInfo"})
    public String qrUserInfo(@RequestParam(value="code") String code, @RequestParam(value="state") String state, @RequestParam(value="returnUrl") String returnUrl, @RequestParam(value="type") String type, HttpServletRequest request) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        UserPlat userPlat = new UserPlat();
        String msg = "";
        if (WECHAT_LOGIN.equals(type)) {
            msg = "\u5fae\u4fe1";
            WxMpUser wxMpUser = this.weChatService.getWxUser(code);
            String openId = wxMpUser.getOpenId();
            String unionId = wxMpUser.getUnionId();
            paramsMap.put("userId", openId);
            paramsMap.put("appKey", this.wxAppConfig.getAppID());
            paramsMap.put("unionId", unionId);
            userPlat = this.userPlatService.getUserPlatByProperties(paramsMap);
        } else if (DING_LOGIN.equals(type)) {
            msg = "\u9489\u9489";
            String accessToken = "";
            ResponseData accessTokenData = this.tokenService.getAccessToken();
            if (accessTokenData.getCode() != 0) {
                throw new ObjectException(accessTokenData.getCode(), accessTokenData.getMessage());
            }
            accessToken = accessTokenData.getData().toString();
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                throw new ObjectException(accessTokenData.getCode(), "\u83b7\u53d6\u9489\u9489access_token\u5931\u8d25");
            }
            ResponseData unionIdData = this.dingTalkLoginService.getUserByCode(code);
            if (unionIdData.getCode() != 0) {
                throw new ObjectException(unionIdData.getCode(), unionIdData.getMessage());
            }
            String unionid = unionIdData.getData().toString();
            ResponseData userIdData = this.dingTalkLoginService.getUserByUnionId(accessToken, unionid);
            if (userIdData.getCode() != 0) {
                throw new ObjectException(userIdData.getCode(), userIdData.getMessage());
            }
            String userId = userIdData.getData().toString();
            paramsMap.put("userId", userId);
            paramsMap.put("corpId", this.appConfig.getCorpId());
            paramsMap.put("appKey", this.appConfig.getAppKey());
            paramsMap.put("appSecret", this.appConfig.getAppSecret());
            userPlat = this.userPlatService.getUserPlatByProperties(paramsMap);
        } else if (QQ_LOGIN.equals(type)) {
            msg = QQ_LOGIN;
        }
        if (userPlat == null) {
            returnUrl = this.appConfig.getRedirectLoginUrl() + "A/login?accessToken=noUser&type=" + type;
        } else {
            CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByUserCode(userPlat.getUserCode());
            SecurityContextHolder.getContext().setAuthentication((Authentication)ud);
            returnUrl = returnUrl != null && returnUrl.contains("?") ? returnUrl + "&accessToken=" + request.getSession().getId() : returnUrl + "?accessToken=" + request.getSession().getId();
        }
        if (returnUrl != null && returnUrl.indexOf("/A/") > -1) {
            returnUrl = returnUrl.replace("/A/", "/#/");
        }
        return "redirect:" + returnUrl;
    }

    @GetMapping(value={"/bindUserInfo"})
    public String bindUserInfo(@RequestParam(value="code") String code, @RequestParam(value="state") String state, @RequestParam(value="userCode") String userCode, @RequestParam(value="returnUrl") String returnUrl, @RequestParam(value="type") String type, HttpServletRequest request) {
        if (userCode == null || "".equals(userCode)) {
            throw new ObjectException((Object)"500", "userCode\u4e3a\u7a7a");
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        UserPlat userPlat = new UserPlat();
        CentitUserDetails userDetails = this.platformEnvironment.loadUserDetailsByUserCode(userCode);
        UserPlat newUser = new UserPlat();
        if (WECHAT_BIND.equals(type)) {
            WxMpUser wxMpUser = this.weChatService.getWxUser(code);
            String openId = wxMpUser.getOpenId();
            String unionId = wxMpUser.getUnionId();
            String weChatName = wxMpUser.getNickname();
            paramsMap.put("appKey", this.wxAppConfig.getAppID());
            paramsMap.put("unionId", unionId);
            userPlat = this.userPlatService.getUserPlatByProperties(paramsMap);
            if (userPlat != null) {
                returnUrl = returnUrl + "?accessToken=noBind&type=" + type;
            } else if (null != userDetails) {
                newUser.setUnionId(unionId);
                newUser.setUserId(openId);
                newUser.setUserCode(userDetails.getUserCode());
                newUser.setPlatId("2");
                newUser.setCorpId("");
                newUser.setAppKey(this.wxAppConfig.getAppID());
                newUser.setAppSecret(this.wxAppConfig.getAppSecret());
                newUser.setUserName(weChatName);
                this.userPlatService.saveUserPlat(newUser);
            }
        } else if (DING_BIND.equals(type)) {
            JSONObject userObject;
            String accessToken = "";
            ResponseData accessTokenData = this.tokenService.getAccessToken();
            if (accessTokenData.getCode() != 0) {
                throw new ObjectException(accessTokenData.getCode(), accessTokenData.getMessage());
            }
            accessToken = accessTokenData.getData().toString();
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                throw new ObjectException((Object)"500", "\u83b7\u53d6\u9489\u9489access_token\u5931\u8d25");
            }
            ResponseData unionIdData = this.dingTalkLoginService.getUserByCode(code);
            if (unionIdData.getCode() != 0) {
                throw new ObjectException(unionIdData.getCode(), unionIdData.getMessage());
            }
            String unionid = unionIdData.getData().toString();
            ResponseData userIdData = this.dingTalkLoginService.getUserByUnionId(accessToken, unionid);
            if (userIdData.getCode() != 0) {
                throw new ObjectException(userIdData.getCode(), userIdData.getMessage());
            }
            String userId = userIdData.getData().toString();
            ResponseData userInfoData = this.dingTalkLoginService.getUserInfo(accessToken, userId);
            if (userInfoData.getCode() != 0) {
                throw new ObjectException(userIdData.getCode(), userIdData.getMessage());
            }
            JSONObject jsonObject = JSONObject.parseObject((String)userInfoData.getData().toString());
            String name = "";
            if (null != jsonObject && null != (userObject = JSONObject.parseObject((String)jsonObject.getString("result")))) {
                name = userObject.getString("name");
            }
            paramsMap.put("userId", userId);
            paramsMap.put("corpId", this.appConfig.getCorpId());
            paramsMap.put("appKey", this.appConfig.getAppKey());
            paramsMap.put("appSecret", this.appConfig.getAppSecret());
            userPlat = this.userPlatService.getUserPlatByProperties(paramsMap);
            if (userPlat != null) {
                returnUrl = returnUrl + "?accessToken=noBind&type=" + type;
            } else if (null != userDetails) {
                newUser.setUserCode(userDetails.getUserCode());
                HashMap<String, Object> platMap = new HashMap<String, Object>();
                platMap.put("corpId", this.appConfig.getCorpId());
                Platform platform = this.platformService.getPlatformByProperties(platMap);
                if (null != platform) {
                    newUser.setPlatId(platform.getPlatId());
                }
                newUser.setCorpId(this.appConfig.getCorpId());
                newUser.setAppKey(this.appConfig.getAppKey());
                newUser.setAppSecret(this.appConfig.getAppSecret());
                newUser.setUnionId(unionid);
                newUser.setUserId(userId);
                newUser.setUserName(name);
                this.userPlatService.saveUserPlat(newUser);
                String regCellPhone = userDetails.getUserInfo().getString("regCellPhone");
                DingUserDTO dingUserDTO = new DingUserDTO();
                dingUserDTO.setUserName(userDetails.getUsername());
                dingUserDTO.setRegCellPhone(regCellPhone);
                dingUserDTO.setPrimaryUnit(userDetails.getCurrentUnitCode());
                this.dingTalkLoginService.userCreate(accessToken, dingUserDTO);
            }
        } else if (QQ_BIND.equals(type)) {
            // empty if block
        }
        if (userPlat == null) {
            returnUrl = returnUrl != null && returnUrl.contains("?") ? returnUrl + "&accessToken=" + request.getSession().getId() : returnUrl + "?accessToken=" + request.getSession().getId();
        }
        if (returnUrl != null && returnUrl.indexOf("/A/") > -1) {
            returnUrl = returnUrl.replace("/A/", "/#/");
        }
        return "redirect:" + returnUrl;
    }
}

