/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingTalkUtil {
    private static final Logger logger = LoggerFactory.getLogger(DingTalkUtil.class);

    public static JSONObject doGetStr(String url) {
        HttpGet httpGet = new HttpGet(url);
        CloseableHttpResponse response = null;
        JSONObject jsonObject = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                jsonObject = JSON.parseObject((String)result);
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (ClientProtocolException e) {
            logger.error("", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        return jsonObject;
    }

    public static JSONObject doPostStr(String url, String outStr) {
        HttpPost httpPost = new HttpPost(url);
        JSONObject jsonObject = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            httpPost.setEntity((HttpEntity)new StringEntity(outStr, "UTF-8"));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            jsonObject = JSON.parseObject((String)result);
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38", (Throwable)e);
        }
        return jsonObject;
    }

    public static JSONObject userCreate(String accessToken, JSONObject userJson) throws IOException {
        String url = "https://oapi.dingtalk.com/topapi/v2/user/create".replace("ACCESS_TOKEN", accessToken);
        String jsonStr = HttpExecutor.jsonPost((HttpExecutorContext)HttpExecutorContext.create(), (String)url, (Object)userJson);
        return DingTalkUtil.doPostStr(url, userJson.toString());
    }

    public static JSONObject departmentCreate(String accessToken, JSONObject deptJson) {
        String url = "https://oapi.dingtalk.com/topapi/v2/department/create".replace("ACCESS_TOKEN", accessToken);
        return DingTalkUtil.doPostStr(url, deptJson.toString());
    }
}

