/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final String FILEPATH = "Permanent_Data";
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static synchronized void write2File(Object json, String fileName) {
        File filePath = new File(FILEPATH);
        JSONObject eJson = null;
        if (!filePath.exists() && !filePath.isDirectory()) {
            filePath.mkdirs();
        }
        File file = new File(FILEPATH + File.separator + fileName + ".xml");
        logger.info("path\uff1a{}, abs path {}", (Object)file.getPath(), (Object)file.getAbsolutePath());
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                logger.error("createNewFile\u5f02\u5e38", (Throwable)e);
            }
        } else {
            eJson = FileUtil.read2JSON(fileName);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            if (eJson == null) {
                writer.write(json.toString());
            } else {
                Object[] array;
                for (Object o : array = ((JSONObject)json).keySet().toArray()) {
                    eJson.put(o.toString(), ((JSONObject)json).get((Object)o.toString()));
                }
                writer.write(eJson.toString());
            }
        }
        catch (IOException e) {
            logger.error("write2File\u5f02\u5e38", (Throwable)e);
        }
    }

    public static JSONObject read2JSON(String fileName) {
        File file = new File(FILEPATH + File.separator + fileName + ".xml");
        if (!file.exists()) {
            return null;
        }
        StringBuilder lastStr = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                lastStr.append(tempString);
            }
        }
        catch (IOException e) {
            logger.error("read2JSON\u5f02\u5e38", (Throwable)e);
        }
        return (JSONObject)JSON.parse((String)lastStr.toString());
    }

    public static Object getValue(String fileName, String key) {
        JSONObject eJSON = null;
        eJSON = FileUtil.read2JSON(fileName);
        if (null != eJSON && eJSON.containsKey((Object)key)) {
            Map values = (Map)JSON.parseObject((String)eJSON.toString(), Map.class);
            return values.get(key);
        }
        return null;
    }

    public static Map<Long, Long> toHashMap(JSONObject js) {
        if (js == null) {
            return null;
        }
        HashMap<Long, Long> data = new HashMap<Long, Long>();
        Set set = js.keySet();
        for (String s : set) {
            String key = String.valueOf(s);
            Long keyLong = Long.valueOf(key);
            String value = js.getString(key);
            Long valueLong = TextUtils.isEmpty((CharSequence)value) ? js.getLong(key) : Long.valueOf(value);
            data.put(keyLong, valueLong);
        }
        return data;
    }
}

