/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.controller;

import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.users.config.JsmotSyncConfig;
import com.centit.framework.users.dto.JsmotUnitDTO;
import com.centit.framework.users.dto.JsmotUserDTO;
import com.centit.framework.users.dto.SmsDTO;
import com.centit.framework.users.service.JsmotSyncService;
import com.centit.framework.users.service.TokenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/jsmot"})
@Api(value="\u4ea4\u901a\u4e91\u5bf9\u63a5\u76f8\u5173\u63a5\u53e3", tags={"\u4ea4\u901a\u4e91\u5bf9\u63a5\u76f8\u5173\u63a5\u53e3"})
public class JsmotSyncController {
    @Autowired
    private JsmotSyncConfig jsmotSyncConfig;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private JsmotSyncService jsmotSyncService;
    @Autowired
    private UnitInfoDao unitInfoDao;

    private String getAccessToken() {
        String accessToken = "";
        ResponseData accessTokenData = this.tokenService.getJsmotAccessToken();
        if (accessTokenData.getCode() != 0) {
            return "";
        }
        accessToken = accessTokenData.getData().toString();
        return accessToken;
    }

    @ApiOperation(value="\u4ea4\u901a\u4e91\u65b0\u589e\u4ece\u4e1a\u4eba\u5458", notes="\u4ea4\u901a\u4e91\u65b0\u589e\u4ece\u4e1a\u4eba\u5458")
    @PostMapping(value={"/usercreate"})
    @WrapUpResponseBody
    public ResponseData userCreate(@RequestBody JsmotUserDTO userInfo) {
        String accessToken = this.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u4ea4\u901a\u4e91accessToken\u5931\u8d25");
        }
        return this.jsmotSyncService.userCreate(accessToken, userInfo);
    }

    @ApiOperation(value="\u4ea4\u901a\u4e91\u65b0\u589e\u4ece\u4e1a\u4f01\u4e1a", notes="\u4ea4\u901a\u4e91\u65b0\u589e\u4ece\u4e1a\u4f01\u4e1a")
    @PostMapping(value={"/unitcreate"})
    @WrapUpResponseBody
    public ResponseData unitCreate(@RequestBody JsmotUnitDTO unitInfo) {
        String accessToken = this.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u4ea4\u901a\u4e91accessToken\u5931\u8d25");
        }
        return this.jsmotSyncService.unitCreate(accessToken, unitInfo);
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237userCode\u83b7\u53d6\u4ece\u4e1a\u4eba\u5458\u8be6\u60c5", notes="\u6839\u636e\u7528\u6237userCode\u83b7\u53d6\u4ece\u4e1a\u4eba\u5458\u8be6\u60c5\u3002")
    @GetMapping(value={"/{userCode}/{flag}"})
    @WrapUpResponseBody
    public ResponseData getCYUserDetail(@PathVariable String userCode, @PathVariable String flag) {
        String accessToken = this.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u4ea4\u901a\u4e91accessToken\u5931\u8d25");
        }
        return this.jsmotSyncService.getCYUserDetail(accessToken, userCode, flag);
    }

    @ApiOperation(value="\u6839\u636e\u4f01\u4e1aid\u83b7\u53d6\u4ece\u4e1a\u4f01\u4e1a\u8be6\u60c5", notes="\u6839\u636e\u4f01\u4e1aid\u83b7\u53d6\u4ece\u4e1a\u4f01\u4e1a\u8be6\u60c5\u3002")
    @GetMapping(value={"/{id}/{flag}"})
    @WrapUpResponseBody
    public ResponseData getUnitInfo(@PathVariable String id, @PathVariable String flag) {
        String accessToken = this.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u4ea4\u901a\u4e91accessToken\u5931\u8d25");
        }
        return this.jsmotSyncService.getCYCorpInfo(accessToken, id, flag);
    }

    private String getSmsAccessToken() {
        String accessToken = "";
        ResponseData accessTokenData = this.tokenService.getSmsAccessToken();
        if (accessTokenData.getCode() != 0) {
            return "";
        }
        accessToken = accessTokenData.getData().toString();
        return accessToken;
    }

    @ApiOperation(value="\u4ea4\u901a\u5385\u77ed\u4fe1\u53d1\u9001", notes="\u4ea4\u901a\u5385\u77ed\u4fe1\u53d1\u9001")
    @PostMapping(value={"/sendsms"})
    @WrapUpResponseBody
    public ResponseData sendSms(@RequestBody SmsDTO smsDTO, HttpServletRequest request) {
        String accessToken = this.getSmsAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u77ed\u4fe1\u5e73\u53f0accessToken\u5931\u8d25");
        }
        return this.jsmotSyncService.sendSms(accessToken, smsDTO);
    }
}

