/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserRole;
import com.centit.framework.system.po.UserRoleId;
import com.centit.framework.system.po.UserSyncDirectory;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.users.config.AppConfig;
import com.centit.framework.users.dao.SocialDeptAuthDao;
import com.centit.framework.users.dto.DingUnitDTO;
import com.centit.framework.users.dto.DingUserDTO;
import com.centit.framework.users.po.SocialDeptAuth;
import com.centit.framework.users.service.DingTalkLoginService;
import com.centit.framework.users.service.TokenService;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.UuidOpt;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiSnsGetuserinfoBycodeRequest;
import com.dingtalk.api.request.OapiUserGetbyunionidRequest;
import com.dingtalk.api.request.OapiV2DepartmentCreateRequest;
import com.dingtalk.api.request.OapiV2DepartmentGetRequest;
import com.dingtalk.api.request.OapiV2DepartmentListsubRequest;
import com.dingtalk.api.request.OapiV2UserCreateRequest;
import com.dingtalk.api.request.OapiV2UserGetRequest;
import com.dingtalk.api.request.OapiV2UserGetbymobileRequest;
import com.dingtalk.api.request.OapiV2UserListRequest;
import com.dingtalk.api.response.OapiSnsGetuserinfoBycodeResponse;
import com.dingtalk.api.response.OapiUserGetbyunionidResponse;
import com.dingtalk.api.response.OapiV2DepartmentCreateResponse;
import com.dingtalk.api.response.OapiV2DepartmentGetResponse;
import com.dingtalk.api.response.OapiV2DepartmentListsubResponse;
import com.dingtalk.api.response.OapiV2UserCreateResponse;
import com.dingtalk.api.response.OapiV2UserGetResponse;
import com.dingtalk.api.response.OapiV2UserGetbymobileResponse;
import com.dingtalk.api.response.OapiV2UserListResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="dingTalkLoginService")
public class DingTalkLoginServiceImpl
implements DingTalkLoginService {
    private static final Logger logger = LoggerFactory.getLogger(DingTalkLoginServiceImpl.class);
    @Autowired
    private AppConfig appConfig;
    @Autowired
    private SocialDeptAuthDao socialDeptAuthDao;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private UnitInfoDao unitInfoDao;
    @Autowired
    private UserInfoDao userInfoDao;
    @Autowired
    private UserUnitDao userUnitDao;
    @Autowired
    private UserRoleDao userRoleDao;

    @Override
    public ResponseData getUserByCode(String authCode) {
        OapiSnsGetuserinfoBycodeResponse response;
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/sns/getuserinfo_bycode");
        OapiSnsGetuserinfoBycodeRequest request = new OapiSnsGetuserinfoBycodeRequest();
        request.setTmpAuthCode(authCode);
        try {
            response = (OapiSnsGetuserinfoBycodeResponse)client.execute((TaobaoRequest)request, this.appConfig.getAppKey(), this.appConfig.getAppSecret());
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/sns/getuserinfo_bycode", (Object)e);
            return ResponseData.makeErrorMessage((String)("Failed to getUserByCode: " + e.getErrMsg()));
        }
        if (!response.isSuccess()) {
            return ResponseData.makeErrorMessage((int)Integer.valueOf(response.getErrorCode()), (String)response.getErrmsg());
        }
        return ResponseData.makeResponseData((Object)response.getUserInfo().getUnionid());
    }

    @Override
    public ResponseData getUserByUnionId(String accessToken, String unionId) {
        OapiUserGetbyunionidResponse response;
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/user/getbyunionid");
        OapiUserGetbyunionidRequest request = new OapiUserGetbyunionidRequest();
        request.setUnionid(unionId);
        try {
            response = (OapiUserGetbyunionidResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/user/get", (Object)e);
            return ResponseData.makeErrorMessage((String)("Failed to getUserByUnionId: " + e.getErrMsg()));
        }
        if (!response.isSuccess()) {
            return ResponseData.makeErrorMessage((int)Integer.valueOf(response.getErrorCode()), (String)response.getErrmsg());
        }
        return ResponseData.makeResponseData((Object)response.getResult().getUserid());
    }

    @Override
    public ResponseData getUserInfo(String accessToken, String userId) {
        OapiV2UserGetResponse response;
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/get");
        OapiV2UserGetRequest request = new OapiV2UserGetRequest();
        request.setUserid(userId);
        request.setLanguage("zh_CN");
        try {
            response = (OapiV2UserGetResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/user/get", (Object)e);
            return ResponseData.makeErrorMessage((String)("Failed to getUserInfo: " + e.getErrMsg()));
        }
        if (!response.isSuccess()) {
            return ResponseData.makeErrorMessage((int)Integer.valueOf(response.getErrorCode()), (String)response.getErrmsg());
        }
        return ResponseData.makeResponseData((Object)response.getBody());
    }

    @Override
    public ResponseData userCreate(String accessToken, DingUserDTO userInfo) {
        OapiV2UserCreateResponse response;
        ResponseData userByMobile = this.getUserByMobile(accessToken, userInfo.getRegCellPhone());
        if (userByMobile.getCode() == 0) {
            return ResponseData.makeResponseData((Object)"\u8be5\u624b\u673a\u7528\u6237\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u540c\u6b65");
        }
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/create");
        OapiV2UserCreateRequest request = new OapiV2UserCreateRequest();
        request.setName(userInfo.getUserName());
        request.setMobile(userInfo.getRegCellPhone());
        SocialDeptAuth socialDeptAuth = (SocialDeptAuth)this.socialDeptAuthDao.getObjectById(userInfo.getPrimaryUnit());
        if (null == socialDeptAuth) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/user/create", (Object)"\u90e8\u95e8\u672a\u540c\u6b65\u5230\u5e73\u53f0\u5e94\u7528");
            return ResponseData.makeErrorMessage((int)500, (String)"Failed to userCreate: \u90e8\u95e8\u672a\u540c\u6b65\u5230\u5e73\u53f0\u5e94\u7528");
        }
        request.setDeptIdList(socialDeptAuth.getDeptId());
        try {
            response = (OapiV2UserCreateResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/user/create", (Object)e);
            return ResponseData.makeErrorMessage((String)("Failed to userCreate: " + e.getErrMsg()));
        }
        if (!response.isSuccess()) {
            return ResponseData.makeErrorMessage((int)Integer.valueOf(response.getErrorCode()), (String)response.getErrmsg());
        }
        return ResponseData.makeResponseData((Object)response.getBody());
    }

    @Override
    public ResponseData unitCreate(String accessToken, DingUnitDTO unitInfo) {
        OapiV2DepartmentCreateResponse response;
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/create");
        OapiV2DepartmentCreateRequest request = new OapiV2DepartmentCreateRequest();
        request.setName(unitInfo.getUnitName());
        if ("".equals(unitInfo.getParentUnit())) {
            request.setParentId(Long.valueOf(1L));
        } else {
            SocialDeptAuth socialDeptAuth = (SocialDeptAuth)this.socialDeptAuthDao.getObjectById(unitInfo.getParentUnit());
            if (null != socialDeptAuth) {
                request.setParentId(Long.valueOf(socialDeptAuth.getDeptId()));
            } else {
                logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/department/create", (Object)"\u672a\u67e5\u8be2\u5230\u7236\u8282\u70b9\u673a\u6784");
                return ResponseData.makeErrorMessage((int)500, (String)"Failed to unitCreate: \u672a\u67e5\u8be2\u5230\u7236\u8282\u70b9\u673a\u6784");
            }
        }
        try {
            response = (OapiV2DepartmentCreateResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/department/create", (Object)e);
            return ResponseData.makeErrorMessage((String)("Failed to unitCreate: " + e.getErrMsg()));
        }
        if (!response.isSuccess()) {
            return ResponseData.makeErrorMessage((int)Integer.valueOf(response.getErrorCode()), (String)response.getErrmsg());
        }
        SocialDeptAuth socialDeptAuth = new SocialDeptAuth();
        socialDeptAuth.setUnitCode(unitInfo.getUnitCode());
        socialDeptAuth.setDeptId(response.getResult().getDeptId().toString());
        this.socialDeptAuthDao.saveNewObject(socialDeptAuth);
        return ResponseData.makeResponseData((Object)response.getBody());
    }

    @Override
    public ResponseData getUnitInfo(String accessToken, String deptId) {
        OapiV2DepartmentGetResponse response = this.getDingUnitinfo(accessToken, deptId);
        if (response == null) {
            return ResponseData.makeErrorMessage((String)"Failed to getDingUnitinfo");
        }
        if (!response.isSuccess()) {
            return ResponseData.makeErrorMessage((int)Integer.valueOf(response.getErrorCode()), (String)response.getErrmsg());
        }
        return ResponseData.makeResponseData((Object)response.getBody());
    }

    @Override
    public JSONArray getUnitList(String accessToken, String deptId) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/listsub");
        OapiV2DepartmentListsubRequest request = new OapiV2DepartmentListsubRequest();
        request.setDeptId(Long.valueOf(deptId));
        request.setLanguage("zh_CN");
        OapiV2DepartmentListsubResponse response = null;
        try {
            response = (OapiV2DepartmentListsubResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/department/create", (Object)e);
        }
        JSONObject jsonObject = JSONObject.parseObject((String)response.getBody());
        return jsonObject.getJSONArray("result");
    }

    @Override
    public JSONObject getUnitUserList(String accessToken, String deptId) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/list");
        OapiV2UserListRequest request = new OapiV2UserListRequest();
        request.setDeptId(Long.valueOf(deptId));
        request.setCursor(Long.valueOf(0L));
        request.setSize(Long.valueOf(100L));
        OapiV2UserListResponse response = null;
        try {
            response = (OapiV2UserListResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/department/get", (Object)e);
        }
        JSONObject jsonObject = JSONObject.parseObject((String)response.getBody());
        return jsonObject;
    }

    private OapiV2DepartmentGetResponse getDingUnitinfo(String accessToken, String deptId) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/get");
        OapiV2DepartmentGetRequest request = new OapiV2DepartmentGetRequest();
        request.setDeptId(Long.valueOf(deptId));
        request.setLanguage("zh_CN");
        OapiV2DepartmentGetResponse response = null;
        try {
            response = (OapiV2DepartmentGetResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/department/get", (Object)e);
        }
        return response;
    }

    private String getAccessToken() {
        String accessToken = "";
        ResponseData accessTokenData = this.tokenService.getAccessToken();
        if (accessTokenData.getCode() != 0) {
            return "";
        }
        accessToken = accessTokenData.getData().toString();
        return accessToken;
    }

    @Override
    public ResponseData getUserByMobile(String accessToken, String mobile) {
        OapiV2UserGetbymobileResponse response;
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/getbymobile");
        OapiV2UserGetbymobileRequest request = new OapiV2UserGetbymobileRequest();
        request.setMobile(mobile);
        try {
            response = (OapiV2UserGetbymobileResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            logger.error("Failed to {}", (Object)"https://oapi.dingtalk.com/topapi/v2/user/getbymobile", (Object)e);
            return ResponseData.makeErrorMessage((String)("Failed to getUserByMobile: " + e.getErrMsg()));
        }
        if (!response.isSuccess()) {
            return ResponseData.makeErrorMessage((int)Integer.valueOf(response.getErrorCode()), (String)response.getErrmsg());
        }
        return ResponseData.makeResponseData((Object)response.getBody());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int synchroniseUserDirectory(UserSyncDirectory directory) {
        try {
            List userList;
            String accessToken = this.getAccessToken();
            Date now = DatetimeOpt.currentUtilDate();
            List list = this.getDeptList("1", new LinkedList<Object>(), accessToken);
            ArrayList<String> deptIdList = new ArrayList<String>();
            deptIdList.add("1");
            if (list != null && list.size() > 0) {
                for (Object obj : list) {
                    boolean createNew;
                    if (obj == null) continue;
                    JSONObject jsonObject = JSONObject.parseObject((String)(obj + ""));
                    deptIdList.add(jsonObject.getString("dept_id"));
                    String unitTag = jsonObject.getString("dept_id");
                    UnitInfo unitInfo = this.unitInfoDao.getUnitByTag(unitTag);
                    boolean bl = createNew = unitInfo == null;
                    if (createNew) {
                        unitInfo = new UnitInfo();
                        unitInfo.setUnitTag(unitTag);
                        unitInfo.setIsValid("T");
                        unitInfo.setUnitType("A");
                        unitInfo.setCreateDate(now);
                        unitInfo.setUnitWord("DING");
                    }
                    String parentId = jsonObject.getString("parent_id");
                    UnitInfo parentUnit = this.unitInfoDao.getUnitByTag(parentId);
                    unitInfo.setUnitName(jsonObject.getString("name"));
                    unitInfo.setLastModifyDate(now);
                    unitInfo.setParentUnit(parentUnit.getUnitCode());
                    if (createNew) {
                        Object[] unitCodeArray;
                        this.unitInfoDao.saveNewObject((Serializable)unitInfo);
                        unitInfo.setUnitPath("/" + unitInfo.getUnitCode());
                        UnitInfo pUnit = this.unitInfoDao.getObjectById(unitInfo.getParentUnit());
                        if (pUnit != null) {
                            unitInfo.setUnitPath(pUnit.getUnitPath() + "/" + unitInfo.getUnitCode());
                            unitInfo.setTopUnit(pUnit.getTopUnit());
                        }
                        if (StringUtils.isBlank((CharSequence)unitInfo.getTopUnit()) && StringUtils.isNotBlank((CharSequence)unitInfo.getUnitPath()) && ArrayUtils.isNotEmpty((Object[])(unitCodeArray = unitInfo.getUnitPath().split("/"))) && unitCodeArray.length > 1) {
                            unitInfo.setTopUnit((String)unitCodeArray[1]);
                        }
                        this.unitInfoDao.updateUnit(unitInfo);
                        continue;
                    }
                    this.unitInfoDao.updateUnit(unitInfo);
                }
            }
            if ((userList = this.getUserList(deptIdList, new LinkedList<JSONObject>(), accessToken)) != null && userList.size() > 0) {
                for (JSONObject jsonObject : userList) {
                    UnitInfo unitInfo;
                    JSONArray unitArray;
                    String regCellPhone;
                    String regEmail;
                    String loginName = jsonObject.getString("userid");
                    String name = jsonObject.getString("name");
                    boolean createUser = false;
                    UserInfo userInfo = this.userInfoDao.getUserByTag(jsonObject.getString("unionid"));
                    if (userInfo == null) {
                        userInfo = new UserInfo();
                        if (loginName != null && !"".equals(loginName)) {
                            userInfo.setLoginName(loginName);
                        } else {
                            userInfo.setLoginName(name);
                        }
                        userInfo.setCreateDate(now);
                        userInfo.setUserName(name);
                        userInfo.setUserWord("DING");
                        createUser = true;
                    }
                    if (StringUtils.isNotBlank((CharSequence)(regEmail = jsonObject.getString("email"))) && regEmail.length() < 60 && this.userInfoDao.getUserByRegEmail(regEmail) == null) {
                        userInfo.setRegEmail(regEmail);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(regCellPhone = jsonObject.getString("mobile"))) && regCellPhone.length() < 15 && this.userInfoDao.getUserByRegCellPhone(regCellPhone) == null) {
                        userInfo.setRegCellPhone(regCellPhone);
                    }
                    if ((unitArray = jsonObject.getJSONArray("dept_id_list")) != null && unitArray.size() > 0 && (unitInfo = this.unitInfoDao.getUnitByTag(unitArray.getString(0))) != null) {
                        Object[] unitCodeArray;
                        userInfo.setPrimaryUnit(unitInfo.getUnitCode());
                        if (null != unitInfo && StringUtils.isNotBlank((CharSequence)unitInfo.getTopUnit())) {
                            userInfo.setTopUnit(unitInfo.getTopUnit());
                        }
                        if (null != unitInfo && StringUtils.isBlank((CharSequence)userInfo.getTopUnit()) && StringUtils.isNotBlank((CharSequence)unitInfo.getUnitPath()) && ArrayUtils.isNotEmpty((Object[])(unitCodeArray = unitInfo.getUnitPath().split("/"))) && unitCodeArray.length > 1) {
                            userInfo.setTopUnit((String)unitCodeArray[1]);
                        }
                    }
                    userInfo.setUpdateDate(now);
                    userInfo.setUserTag(jsonObject.getString("unionid"));
                    if (createUser) {
                        this.userInfoDao.saveNewObject((Serializable)userInfo);
                    } else {
                        this.userInfoDao.updateUser(userInfo);
                    }
                    if (createUser && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{directory.getDefaultUserRole()})) {
                        UserRole role = new UserRole(new UserRoleId(userInfo.getUserCode(), directory.getDefaultUserRole()));
                        role.setObtainDate(now);
                        role.setCreateDate(now);
                        role.setChangeDesc("\u9489\u9489\u540c\u6b65\u65f6\u9ed8\u8ba4\u8bbe\u7f6e\u3002");
                        this.userRoleDao.mergeUserRole(role);
                    }
                    if (!CollectionUtils.isEmpty((Collection)unitArray)) continue;
                    for (Object obj : unitArray) {
                        UnitInfo u = this.unitInfoDao.getUnitByTag(obj + "");
                        UserUnit uu = new UserUnit();
                        uu.setUserUnitId(UuidOpt.getUuidAsString());
                        uu.setUnitCode(u.getUnitCode());
                        uu.setUserCode(userInfo.getUserCode());
                        uu.setCreateDate(now);
                        if (u.getUnitCode().equals(userInfo.getPrimaryUnit())) {
                            uu.setRelType("T");
                        } else {
                            uu.setRelType("F");
                        }
                        uu.setUserRank(directory.getDefaultRank());
                        uu.setUserStation(directory.getDefaultStation());
                        uu.setRankMemo("DING");
                        this.userUnitDao.saveNewObject((Serializable)uu);
                    }
                }
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public List getDeptList(String deptId, List<Object> list, String accessToken) {
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return null;
        }
        JSONArray jsonArray = this.getUnitList(accessToken, deptId);
        if (jsonArray != null && jsonArray.size() > 0) {
            for (Object obj : jsonArray) {
                list.add(obj);
                JSONObject jsonObject = JSONObject.parseObject((String)(obj + ""));
                this.getDeptList(jsonObject.getString("dept_id"), list, accessToken);
            }
        }
        return list;
    }

    public List getUserList(List<String> depts, List<JSONObject> list, String accessToken) {
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return null;
        }
        if (depts != null && depts.size() > 0) {
            for (String dept : depts) {
                JSONObject jsonObject = this.getUnitUserList(accessToken, dept);
                if (jsonObject == null) continue;
                JSONObject jsonObject1 = jsonObject.getJSONObject("result");
                JSONArray jsonArray = new JSONArray();
                if (jsonObject1 != null) {
                    jsonArray = jsonObject1.getJSONArray("list");
                }
                for (Object obj : jsonArray) {
                    list.add(JSONObject.parseObject((String)(obj + "")));
                }
            }
        }
        return list;
    }
}

