/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.UserSyncDirectory;
import com.centit.framework.system.service.UserSyncDirectoryManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.compiler.Pretreatment;
import com.centit.support.security.SecurityOptUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.naming.ldap.InitialLdapContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/ldap"})
@Api(value="ldap\u767b\u5f55\u76f8\u5173\u63a5\u53e3", tags={"ldap\u767b\u5f55\u76f8\u5173\u63a5\u53e3"})
public class LdapLogin
extends BaseController {
    private static final String LDAP_USER_ID = "ldapUserURI";
    private static Logger logger = LoggerFactory.getLogger(LdapLogin.class);
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired
    private UserSyncDirectoryManager userSyncDirectoryManager;
    @Value(value="${security.disable.user}")
    private String disableUser;

    public String getOptId() {
        return "LDAPLOGIN";
    }

    @ApiOperation(value="ldap\u767b\u5f55", notes="ldap\u767b\u5f55")
    @PostMapping(value={"/login"})
    @WrapUpResponseBody
    @RecordOperationLog(content="\u7528\u6237{username}\u4f7f\u7528ldap\u767b\u5f55,\u64cd\u4f5cIP\u5730\u5740:{loginIp}", newValue="ldap\u767b\u5f55")
    public ResponseData login(@RequestParam(value="username") String username, @RequestParam(value="password") String password, HttpServletRequest request) throws Exception {
        username = SecurityOptUtils.decodeSecurityString((String)StringEscapeUtils.unescapeHtml4((String)username));
        password = SecurityOptUtils.decodeSecurityString((String)StringEscapeUtils.unescapeHtml4((String)password));
        if (StringUtils.isNotBlank((CharSequence)this.disableUser)) {
            this.disableUser = StringUtils.deleteWhitespace((String)this.disableUser);
            String[] ignoreUsers = this.disableUser.split(",");
            for (int i = 0; i < ignoreUsers.length; ++i) {
                if (!username.contains(ignoreUsers[i])) continue;
                return ResponseData.makeErrorMessage((String)"\u7981\u7528\u7684\u7528\u6237\u8d26\u53f7");
            }
        }
        List directories = this.userSyncDirectoryManager.listLdapDirectory();
        for (UserSyncDirectory directory : directories) {
            boolean passed;
            if (StringUtils.isBlank((CharSequence)directory.getUrl()) || !(passed = LdapLogin.checkUserPasswordByDn(directory, username, password))) continue;
            CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByLoginName(username);
            ud.setLoginIp(WebOptUtils.getRequestAddr((HttpServletRequest)request));
            SecurityContextHolder.getContext().setAuthentication((Authentication)ud);
            HashMap<String, String> sessionMap = new HashMap<String, String>();
            sessionMap.put("accessToken", request.getSession().getId());
            sessionMap.put("userInfo", (String)ud);
            return ResponseData.makeResponseData(sessionMap);
        }
        return ResponseData.makeErrorMessage((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkUserPasswordByDn(UserSyncDirectory directory, String loginName, String password) {
        JSONObject searchParams = JSON.parseObject((String)directory.getSearchBase());
        String userURIFormat = searchParams.getString("userURIFormat");
        if (StringUtils.isBlank((CharSequence)userURIFormat)) {
            userURIFormat = "{loginName}";
        }
        String userURI = Pretreatment.mapTemplateString((String)userURIFormat, (Object)CollectionsOpt.createHashMap((Object[])new Object[]{"loginName", loginName, "topUnit", directory.getTopUnit()}));
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", userURI);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.provider.url", directory.getUrl());
        InitialLdapContext ctx = null;
        try {
            ctx = new InitialLdapContext(env, null);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
    }
}

