/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.core.datasource;

import com.centit.framework.core.datasource.DynamicDataSourceContextHolder;
import com.centit.framework.core.datasource.TargetDataSource;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ParamName;
import com.centit.support.compiler.VariableFormula;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class DynamicDataSourceAspect {
    @Pointcut(value="@annotation(com.centit.framework.core.datasource.TargetDataSource)")
    public void electDataSourceAspect() {
    }

    public static Map<String, Object> getMethodDescription(JoinPoint joinPoint) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Parameter[] parameters = method.getParameters();
        Object[] arguments = joinPoint.getArgs();
        int nps = parameters.length;
        int nas = arguments.length;
        for (int i = 0; i < nps && i < nas; ++i) {
            String paramName = parameters[i].getName();
            if (parameters[i].isAnnotationPresent(ParamName.class)) {
                ParamName param = parameters[i].getAnnotation(ParamName.class);
                paramName = param.value();
            }
            map.put(paramName, arguments[i]);
        }
        return map;
    }

    @Before(value="electDataSourceAspect() && @annotation(targetDataSource)")
    public void doBefore(JoinPoint joinPoint, TargetDataSource targetDataSource) {
        String targetDataSourceName = targetDataSource.value();
        if (StringUtils.isNotBlank((CharSequence)targetDataSourceName)) {
            if (targetDataSource.mapByParameter()) {
                Map<String, Object> paramsMap = DynamicDataSourceAspect.getMethodDescription(joinPoint);
                targetDataSourceName = StringBaseOpt.castObjectToString((Object)VariableFormula.calculate((String)targetDataSourceName, paramsMap));
            }
            DynamicDataSourceContextHolder.setDataSourceType(targetDataSourceName);
        }
    }

    @AfterThrowing(pointcut="electDataSourceAspect() && @annotation(targetDataSource)", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, TargetDataSource targetDataSource, Throwable e) {
        if (StringUtils.isNotBlank((CharSequence)targetDataSource.value())) {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
    }

    @AfterReturning(pointcut="electDataSourceAspect() && @annotation(targetDataSource)")
    public void doAfterReturning(JoinPoint joinPoint, TargetDataSource targetDataSource) {
        if (StringUtils.isNotBlank((CharSequence)targetDataSource.value())) {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
    }
}

