/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.flyway.plugin;

import com.centit.framework.flyway.plugin.kingbase.KingBaseDbSupport;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.FlywaySqlException;
import org.flywaydb.core.internal.dbsupport.oracle.OracleDbSupport;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;

public class DbSupportFactoryExt {
    private static final Log LOG = LogFactory.getLog(DbSupportFactoryExt.class);

    private DbSupportFactoryExt() {
    }

    public static DbSupport createDbSupport(Connection connection, boolean printInfo) {
        String databaseProductName = DbSupportFactoryExt.getDatabaseProductName(connection);
        if (printInfo) {
            LOG.info("Database: " + DbSupportFactoryExt.getJdbcUrl(connection) + " (" + databaseProductName + ")");
        }
        if (databaseProductName.startsWith("DM")) {
            return new OracleDbSupport(connection);
        }
        if (databaseProductName.startsWith("KingbaseES") || databaseProductName.startsWith("OSCAR")) {
            return new KingBaseDbSupport(connection);
        }
        throw new FlywayException("Unsupported Database: " + databaseProductName);
    }

    private static String getJdbcUrl(Connection connection) {
        try {
            return connection.getMetaData().getURL();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to retrieve the Jdbc connection Url!", e);
        }
    }

    private static String getDatabaseProductName(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData == null) {
                throw new FlywayException("Unable to read database metadata while it is null!");
            }
            String databaseProductName = databaseMetaData.getDatabaseProductName();
            if (databaseProductName == null) {
                throw new FlywayException("Unable to determine database. Product name is null.");
            }
            int databaseMajorVersion = databaseMetaData.getDatabaseMajorVersion();
            int databaseMinorVersion = databaseMetaData.getDatabaseMinorVersion();
            return databaseProductName + " " + databaseMajorVersion + "." + databaseMinorVersion;
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error while determining database product name", e);
        }
    }

    private static String getDatabaseProductVersion(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData == null) {
                throw new FlywayException("Unable to read database metadata while it is null!");
            }
            String databaseProductVersion = databaseMetaData.getDatabaseProductVersion();
            if (databaseProductVersion == null) {
                throw new FlywayException("Unable to determine database. Product version is null.");
            }
            return databaseProductVersion;
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error while determining database product version", e);
        }
    }

    private static String getDriverName(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData == null) {
                throw new FlywayException("Unable to read database metadata while it is null!");
            }
            String driverName = databaseMetaData.getDriverName();
            if (driverName == null) {
                throw new FlywayException("Unable to determine JDBC  driver name. JDBC driver name is null.");
            }
            return driverName;
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error while determining JDBC driver name", e);
        }
    }
}

