/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.model.basedata;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.annotation.JSONField;
import com.centit.framework.core.dao.DictionaryMap;
import com.centit.framework.model.basedata.UserRole;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.support.security.DesensitizeOptUtils;
import com.centit.support.security.SecurityOptUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;

@Entity
@Table(name="F_USERINFO")
@ApiModel(value="\u7cfb\u7edf\u7528\u6237\u4fe1\u606f\u5bf9\u8c61", description="\u7cfb\u7edf\u7528\u6237\u4fe1\u606f\u5bf9\u8c61 UserInfo")
public class UserInfo
implements Serializable {
    private static final long serialVersionUID = -1753127177790732963L;
    @Id
    @Column(name="USER_CODE")
    @ValueGenerator(strategy=GeneratorType.RANDOM_ID, value="11:U")
    @ApiModelProperty(value="\u7528\u6237\u4ee3\u7801", name="userCode")
    private String userCode;
    @JSONField(serialize=false)
    @Column(name="USER_PIN")
    @Length(max=100)
    @ApiModelProperty(value="\u7528\u6237\u5bc6\u7801", name="userPin")
    private @Length(max=100) String userPin;
    @Column(name="IS_VALID")
    @NotBlank
    @Pattern(regexp="[TFAW]")
    @ApiModelProperty(value="\u662f\u5426\u751f\u6548 T:\u751f\u6548 F:\u5931\u6548 A:\u65b0\u5efa\u53ef\u4ee5\u5220\u9664,W\u672a\u52a0\u5165\u4efb\u4f55\u7ec4\u7ec7", name="isValid", required=true)
    private @NotBlank @Pattern(regexp="[TFAW]") String isValid = "T";
    @Column(name="USER_TYPE")
    @Length(max=1)
    @ApiModelProperty(value="\u548c\u6570\u636e\u5b57\u5178\u5173\u8054\uff0c\u4e1a\u52a1\u7cfb\u7edf\u53ef\u4ee5\u81ea\u884c\u89e3\u91ca\u8fd9\u4e2a\u5b57\u6bb5", name="userType")
    private @Length(max=1) String userType = "U";
    @Column(name="LOGIN_NAME")
    @NotBlank
    @Length(max=100)
    @ApiModelProperty(value="\u7528\u6237\u767b\u5f55\u540d \u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", name="loginName", required=true)
    private @NotBlank @Length(max=100) String loginName;
    @Column(name="USER_NAME")
    @NotBlank
    @Length(max=300)
    @ApiModelProperty(value="\u7528\u6237\u59d3\u540d \u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", name="userName", required=true)
    private @NotBlank @Length(max=300) String userName;
    @Column(name="ENGLISH_NAME")
    @Length(max=300)
    @ApiModelProperty(value="\u7528\u6237\u82f1\u6587\u59d3\u540d", name="englishName")
    private @Length(max=300) String englishName;
    @Column(name="USER_DESC")
    @Length(max=256)
    private @Length(max=256) String userDesc;
    @Column(name="LOGIN_TIMES")
    private Long loginTimes;
    @Column(name="ACTIVE_TIME")
    @Temporal(value=TemporalType.DATE)
    private Date activeTime;
    @Column(name="PWD_EXPIRED_TIME")
    @Temporal(value=TemporalType.DATE)
    private Date pwdExpiredTime;
    @Column(name="REG_EMAIL")
    @Email
    @Length(max=60)
    private @Email @Length(max=60) String regEmail;
    @Column(name="USER_PWD")
    @Length(max=20)
    @JSONField(serialize=false)
    private @Length(max=20) String userPwd;
    @Column(name="REG_CELL_PHONE")
    @Length(max=15)
    private @Length(max=15) String regCellPhone;
    @Column(name="ID_CARD_NO")
    @Length(max=20, message="\u5927\u4e8e{max}")
    private @Length(max=20, message="\u5927\u4e8e{max}") String idCardNo;
    @Column(name="USER_WORD")
    @Length(max=100)
    private @Length(max=100) String userWord;
    @Column(name="USER_TAG")
    @Length(max=200)
    private @Length(max=200) String userTag;
    @Column(name="USER_ORDER")
    @Range(max=99999L, min=0L)
    private @Range(max=99999L, min=0L) Long userOrder;
    @Column(name="TOP_UNIT")
    @Length(max=32)
    private @Length(max=32) String topUnit;
    @Column(name="PRIMARY_UNIT")
    @DictionaryMap(fieldName={"primaryUnitName"}, value={"unitCode"})
    private String primaryUnit = null;
    @Column(name="CREATE_DATE", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today()")
    protected Date createDate;
    @Column(name="CREATOR")
    @Length(max=32)
    private @Length(max=32) String creator;
    @Column(name="UPDATOR")
    @Length(max=32)
    private @Length(max=32) String updator;
    @Column(name="UPDATE_DATE")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, occasion=GeneratorTime.NEW_UPDATE, condition=GeneratorCondition.ALWAYS, value="today()")
    private Date updateDate;
    @Column(name="CURRENT_STATION_ID")
    @Length(max=32)
    private @Length(max=32) String currentStationId;
    @JSONField(serialize=false, deserialize=false)
    @Column(name="LAST_ACCESS_TOKEN")
    @Length(max=80)
    private @Length(max=80) String lastAccessToken;
    @Transient
    private String userNamePinyin;
    @Transient
    @JSONField(serialize=false)
    private List<UserRole> userRoles = null;

    @JSONField(serialize=false)
    public String getUserPwd() {
        return this.userPwd;
    }

    public void setUserPwd(String userPwd) {
        this.userPwd = userPwd;
    }

    public String getRegCellPhone() {
        return SecurityOptUtils.decodeSecurityString((String)this.regCellPhone);
    }

    public void setRegCellPhone(String regCellPhone) {
        this.regCellPhone = regCellPhone;
    }

    public String getUserWord() {
        return this.userWord;
    }

    public void setUserWord(String userWord) {
        this.userWord = userWord;
    }

    public String getCurrentStationId() {
        return this.currentStationId;
    }

    public void setCurrentStationId(String currentStationId) {
        this.currentStationId = currentStationId;
    }

    public Date getPwdExpiredTime() {
        return this.pwdExpiredTime;
    }

    public void setPwdExpiredTime(Date pwdExpiredTime) {
        this.pwdExpiredTime = pwdExpiredTime;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    @JSONField(serialize=false)
    public String getUserPin() {
        return this.userPin;
    }

    public void setUserPin(String userpin) {
        this.userPin = userpin;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public void setEnglishName(String englishName) {
        this.englishName = englishName;
    }

    public String getUserTag() {
        return this.userTag;
    }

    public void setUserTag(String userTag) {
        this.userTag = userTag;
    }

    public String getIdCardNo() {
        return this.idCardNo;
    }

    public void setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
    }

    public String getIsValid() {
        return this.isValid;
    }

    public void setIsValid(String userstate) {
        this.isValid = userstate;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public void setUserName(String username) {
        this.userName = username;
    }

    public String getUserDesc() {
        return this.userDesc;
    }

    public void setUserDesc(String userdesc) {
        this.userDesc = userdesc;
    }

    public Long getLoginTimes() {
        return this.loginTimes;
    }

    public void setLoginTimes(Long logintimes) {
        this.loginTimes = logintimes;
    }

    public String getTopUnit() {
        return this.topUnit;
    }

    public void setTopUnit(String topUnit) {
        this.topUnit = topUnit;
    }

    public String getLoginName() {
        if (this.loginName == null) {
            return "";
        }
        return this.loginName;
    }

    public void setLoginName(String loginname) {
        if (loginname == null) {
            return;
        }
        this.loginName = loginname;
    }

    public Date getActiveTime() {
        return this.activeTime;
    }

    public void setActiveTime(Date activetime) {
        this.activeTime = activetime;
    }

    public String getUserNamePinyin() {
        return this.userNamePinyin;
    }

    public void setUserNamePinyin(String usernamepinyin) {
        this.userNamePinyin = usernamepinyin;
    }

    public void setRegEmail(String regEmail) {
        this.regEmail = regEmail;
    }

    public String getRegEmail() {
        return this.regEmail;
    }

    public String getPrimaryUnit() {
        return this.primaryUnit;
    }

    public void setPrimaryUnit(String primaryUnit) {
        this.primaryUnit = primaryUnit;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getLastModifyDate() {
        return this.updateDate;
    }

    public void setLastModifyDate(Date lastModifyDate) {
        this.updateDate = lastModifyDate;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getUpdator() {
        return this.updator;
    }

    public void setUpdator(String updator) {
        this.updator = updator;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getLastAccessToken() {
        return this.lastAccessToken;
    }

    public void setLastAccessToken(String lastAccessToken) {
        this.lastAccessToken = lastAccessToken;
    }

    public void copyFromUserInfo(UserInfo other) {
        if (other.getIsValid() != null) {
            this.isValid = other.getIsValid();
        }
        if (other.getUserType() != null) {
            this.userType = other.getUserType();
        }
        if (other.getPrimaryUnit() != null) {
            this.primaryUnit = other.getPrimaryUnit();
        }
        if (other.getLoginName() != null) {
            this.loginName = other.getLoginName();
        }
        if (other.getUserName() != null) {
            this.userName = other.getUserName();
        }
        if (other.getUserDesc() != null) {
            this.userDesc = other.getUserDesc();
        }
        if (other.getIdCardNo() != null) {
            this.idCardNo = other.getIdCardNo();
        }
        if (other.getRegEmail() != null) {
            this.regEmail = other.getRegEmail();
        }
        if (other.getUserTag() != null) {
            this.userTag = other.getUserTag();
        }
        if (other.getEnglishName() != null) {
            this.englishName = other.getEnglishName();
        }
        if (other.getUserOrder() != null) {
            this.userOrder = other.getUserOrder();
        }
        if (other.getRegCellPhone() != null) {
            this.regCellPhone = other.getRegCellPhone();
        }
    }

    public Long getUserOrder() {
        if (this.userOrder == null) {
            return 1000L;
        }
        return this.userOrder;
    }

    public void setUserOrder(Long userorder) {
        this.userOrder = userorder;
    }

    public List<UserRole> listUserRoles() {
        if (this.userRoles == null) {
            this.userRoles = new ArrayList<UserRole>();
        }
        return this.userRoles;
    }

    public List<UserRole> getUserRoles() {
        if (this.userRoles == null) {
            this.userRoles = new ArrayList<UserRole>();
        }
        return this.userRoles;
    }

    public void setUserRoles(List<UserRole> userRoles) {
        this.userRoles = userRoles;
    }

    private void addUserRole(UserRole userrole) {
        userrole.setUserCode(this.userCode);
        this.getUserRoles().add(userrole);
    }

    private void removeUserRole(UserRole odt) {
        this.getUserRoles().remove(odt);
    }

    public JSONObject toJsonWithoutSensitive() {
        String regEmail;
        String regCellPhone;
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)this);
        for (String pm : new String[]{"userPin", "userPwd"}) {
            jsonObject.remove((Object)pm);
        }
        String idCardNo = jsonObject.getString("idCardNo");
        if (StringUtils.isNotBlank((CharSequence)idCardNo)) {
            jsonObject.put((Object)"idCardNo", (Object)DesensitizeOptUtils.idCardNum((String)idCardNo));
        }
        if (StringUtils.isNotBlank((CharSequence)(regCellPhone = jsonObject.getString("regCellPhone")))) {
            jsonObject.put((Object)"regCellPhone", (Object)DesensitizeOptUtils.phone((String)SecurityOptUtils.decodeSecurityString((String)regCellPhone)));
        }
        if (StringUtils.isNotBlank((CharSequence)(regEmail = jsonObject.getString("regEmail")))) {
            jsonObject.put((Object)"regEmail", (Object)DesensitizeOptUtils.email((String)regEmail));
        }
        return jsonObject;
    }
}

