/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.config;

import com.centit.framework.config.SecurityCasCondition;
import com.centit.framework.config.SpringSecurityBaseConfig;
import com.centit.framework.model.security.CentitUserDetailsService;
import com.centit.support.algorithm.BooleanBaseOpt;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasAuthenticationProvider;
import org.springframework.security.cas.web.CasAuthenticationEntryPoint;
import org.springframework.security.cas.web.CasAuthenticationFilter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.session.ConcurrentSessionControlAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.session.security.web.authentication.SpringSessionRememberMeServices;

@Conditional(value={SecurityCasCondition.class})
public class SpringSecurityCasConfig
extends SpringSecurityBaseConfig {
    @Autowired
    protected CentitUserDetailsService centitUserDetailsService;

    @Override
    protected String[] getAuthenticatedUrl() {
        if (BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("access.resource.notallowed.anonymous"), (Boolean)false).booleanValue()) {
            return new String[]{"/**"};
        }
        return new String[]{"/system/mainframe/logincas"};
    }

    @Override
    protected String[] getPermitAllUrl() {
        return new String[]{"/**/csrf", "/**/doc.html", "/system/exception"};
    }

    @Override
    protected AuthenticationEntryPoint getAuthenticationEntryPoint() {
        ServiceProperties serviceProperties = this.createCasServiceProperties();
        CasAuthenticationEntryPoint casEntryPoint = new CasAuthenticationEntryPoint();
        String loginUrl = this.env.getProperty("login.cas.entryPoint");
        if (StringUtils.isBlank((CharSequence)loginUrl)) {
            loginUrl = this.env.getProperty("login.cas.casHome") + "/login";
        }
        casEntryPoint.setLoginUrl(loginUrl);
        casEntryPoint.setServiceProperties(serviceProperties);
        return casEntryPoint;
    }

    @Override
    protected AbstractAuthenticationProcessingFilter getAuthenticationFilter() {
        CasAuthenticationFilter casFilter = new CasAuthenticationFilter();
        casFilter.setAuthenticationManager(this.createAuthenticationManager());
        casFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.createAjaxFailureHandler());
        casFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.createAjaxSuccessHandler());
        if (this.sessionRegistry != null) {
            casFilter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)new ConcurrentSessionControlAuthenticationStrategy(this.sessionRegistry));
        }
        SpringSessionRememberMeServices rememberMeServices = new SpringSessionRememberMeServices();
        rememberMeServices.setAlwaysRemember(BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("session.always.rememberme"), (Boolean)false).booleanValue());
        casFilter.setRememberMeServices((RememberMeServices)rememberMeServices);
        return casFilter;
    }

    @Override
    protected Filter logoutFilter() {
        return new LogoutFilter(this.env.getProperty("login.cas.casHome") + "/logout", new LogoutHandler[]{new SecurityContextLogoutHandler()});
    }

    @Override
    protected AuthenticationProvider getAuthenticationProvider() {
        CasAuthenticationProvider casAuthenticationProvider = new CasAuthenticationProvider();
        casAuthenticationProvider.setUserDetailsService((UserDetailsService)this.centitUserDetailsService);
        casAuthenticationProvider.setServiceProperties(this.createCasServiceProperties());
        casAuthenticationProvider.setTicketValidator((TicketValidator)new Cas20ServiceTicketValidator(this.env.getProperty("login.cas.casHome")));
        casAuthenticationProvider.setKey(this.env.getProperty("app.key"));
        return casAuthenticationProvider;
    }

    private ServiceProperties createCasServiceProperties() {
        ServiceProperties casServiceProperties = new ServiceProperties();
        casServiceProperties.setService(this.env.getProperty("login.cas.localHome") + "/login/cas");
        casServiceProperties.setSendRenew(false);
        return casServiceProperties;
    }

    @Override
    protected void configure(HttpSecurity http) throws Exception {
        super.configure(http);
        SingleSignOutFilter singleLogoutFilter = new SingleSignOutFilter();
        http.addFilterBefore((Filter)singleLogoutFilter, CasAuthenticationFilter.class);
    }
}

