/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.hibernate.dao;

import com.centit.framework.core.common.ObjectException;
import com.centit.framework.core.dao.PageDesc;
import com.centit.framework.core.po.EntityWithDeleteTag;
import com.centit.framework.core.po.EntityWithTimestamp;
import com.centit.framework.hibernate.dao.DatabaseOptUtils;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.common.KeyValuePair;
import com.centit.support.database.QueryAndNamedParams;
import com.centit.support.database.QueryAndParams;
import com.centit.support.database.QueryUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseDaoImpl<T extends Serializable, PK extends Serializable> {
    @Resource(name="sessionFactory")
    protected SessionFactory sessionFactory;
    protected static Log logger = LogFactory.getLog(BaseDaoImpl.class);
    protected Map<String, String> filterField = null;
    private Class<?> poClass = null;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public Session getCurrentSession() {
        Session s = this.sessionFactory.getCurrentSession();
        if (s == null || !s.isOpen()) {
            s = this.sessionFactory.openSession();
        }
        return s;
    }

    public void setFilterField(Map<String, String> ffd) {
        this.filterField = ffd;
    }

    public Map<String, String> getFilterField() {
        return this.filterField;
    }

    public final Class<?> getPoClass() {
        if (this.poClass == null) {
            ParameterizedType genType = (ParameterizedType)this.getClass().getGenericSuperclass();
            Type[] params = genType.getActualTypeArguments();
            this.poClass = (Class)params[0];
        }
        return this.poClass;
    }

    public final Class<?> getPkClass() {
        ParameterizedType genType = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type[] params = genType.getActualTypeArguments();
        return (Class)params[1];
    }

    public final String getClassTName() {
        return this.getPoClass().getName();
    }

    public final String getClassTShortName() {
        return this.getPoClass().getSimpleName();
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void deleteObject(T o) {
        if (o instanceof EntityWithDeleteTag) {
            ((EntityWithDeleteTag)o).setDeleted(true);
            this.saveObject(o);
        } else {
            try {
                this.sessionFactory.getCurrentSession().delete(o);
            }
            catch (RuntimeException re) {
                logger.error((Object)"delete failed", (Throwable)re);
                throw new ObjectException(6, (Throwable)re);
            }
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void deleteObjectForce(T o) {
        try {
            this.sessionFactory.getCurrentSession().delete(o);
        }
        catch (RuntimeException re) {
            logger.error((Object)"delete failed", (Throwable)re);
            throw new ObjectException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void deleteObjectForceById(PK id) {
        T o = this.getObjectById(id);
        this.deleteObjectForce(o);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void deleteObjectById(PK id) {
        T o = this.getObjectById(id);
        this.deleteObject(o);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public PK saveNewObject(T o) {
        try {
            if (o instanceof EntityWithTimestamp) {
                EntityWithTimestamp ewto = (EntityWithTimestamp)o;
                ewto.setLastModifyDate(DatetimeOpt.currentUtilDate());
            }
            return (PK)this.sessionFactory.getCurrentSession().save(o);
        }
        catch (RuntimeException re) {
            logger.error((Object)"save new object failed", (Throwable)re);
            throw new ObjectException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<PK> saveNewObjects(Collection<T> os) {
        try {
            ArrayList<Serializable> pks = new ArrayList<Serializable>();
            for (Serializable o : os) {
                if (o instanceof EntityWithTimestamp) {
                    EntityWithTimestamp ewto = (EntityWithTimestamp)o;
                    ewto.setLastModifyDate(DatetimeOpt.currentUtilDate());
                }
                pks.add(this.sessionFactory.getCurrentSession().save((Object)o));
            }
            return pks;
        }
        catch (RuntimeException re) {
            logger.error((Object)"save new object failed", (Throwable)re);
            throw new ObjectException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<PK> saveNewObjects(T[] os) {
        try {
            ArrayList<Serializable> pks = new ArrayList<Serializable>();
            for (T o : os) {
                if (o instanceof EntityWithTimestamp) {
                    EntityWithTimestamp ewto = (EntityWithTimestamp)o;
                    ewto.setLastModifyDate(DatetimeOpt.currentUtilDate());
                }
                pks.add(this.sessionFactory.getCurrentSession().save(o));
            }
            return pks;
        }
        catch (RuntimeException re) {
            logger.error((Object)"save new object failed", (Throwable)re);
            throw new ObjectException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void updateRawObject(T o) {
        try {
            this.sessionFactory.getCurrentSession().update(o);
        }
        catch (RuntimeException re) {
            logger.error((Object)"save new object failed", (Throwable)re);
            throw new ObjectException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void updateObject(T o) {
        try {
            if (o instanceof EntityWithTimestamp) {
                ((EntityWithTimestamp)o).setLastModifyDate(DatetimeOpt.currentUtilDate());
            }
            this.sessionFactory.getCurrentSession().update(o);
        }
        catch (RuntimeException re) {
            logger.error((Object)"save new object failed", (Throwable)re);
            throw new ObjectException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void updateObjectProperties(T o, String ... properties) throws NoSuchFieldException {
        try {
            Serializable dbo = (Serializable)this.getCurrentSession().get(o.getClass(), (Serializable)BaseDaoImpl.getPoObjectId(o));
            if (dbo == null) {
                throw new ObjectException(2, "\u88ab\u66f4\u6539\u5bf9\u8c61\u627e\u4e0d\u5230");
            }
            for (String p : properties) {
                ReflectionOpt.forceSetProperty((Object)dbo, (String)p, (Object)ReflectionOpt.forceGetProperty(o, (String)p));
            }
            if (dbo instanceof EntityWithTimestamp) {
                ((EntityWithTimestamp)dbo).setLastModifyDate(DatetimeOpt.currentUtilDate());
            }
            this.sessionFactory.getCurrentSession().update((Object)dbo);
        }
        catch (RuntimeException re) {
            logger.error((Object)"save new object failed", (Throwable)re);
            throw new ObjectException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void updateObjectCheckTimestamp(T o) {
        try {
            if (o instanceof EntityWithTimestamp) {
                Serializable dbo = (Serializable)this.sessionFactory.getCurrentSession().get(o.getClass(), (Serializable)BaseDaoImpl.getPoObjectId(o));
                if (dbo == null) {
                    throw new ObjectException(2, "\u88ab\u66f4\u6539\u5bf9\u8c61\u627e\u4e0d\u5230");
                }
                if (!((EntityWithTimestamp)o).getLastModifyDate().equals(((EntityWithTimestamp)dbo).getLastModifyDate())) {
                    String errorMsg = "save or update object  failed," + this.getClassTName() + ":" + o.toString() + " be modified out-sync.";
                    logger.error((Object)errorMsg);
                    throw new RuntimeException(errorMsg);
                }
                ((EntityWithTimestamp)o).setLastModifyDate(DatetimeOpt.currentUtilDate());
            }
            this.sessionFactory.getCurrentSession().merge(o);
        }
        catch (RuntimeException re) {
            logger.error((Object)"save new object failed", (Throwable)re);
            throw new ObjectException(7, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void updateObjectPropertiesCheckTimestamp(T o, String ... properties) throws NoSuchFieldException {
        try {
            Serializable dbo = (Serializable)this.getCurrentSession().get(o.getClass(), (Serializable)BaseDaoImpl.getPoObjectId(o));
            if (dbo == null) {
                throw new ObjectException(2, "\u88ab\u66f4\u6539\u5bf9\u8c61\u627e\u4e0d\u5230");
            }
            if (o instanceof EntityWithTimestamp && !((EntityWithTimestamp)o).getLastModifyDate().equals(((EntityWithTimestamp)dbo).getLastModifyDate())) {
                String errorMsg = "save or update object failed," + this.getClassTName() + ":" + o.toString() + " be modified out-sync.";
                logger.error((Object)errorMsg);
                throw new RuntimeException(errorMsg);
            }
            for (String p : properties) {
                ReflectionOpt.forceSetProperty((Object)dbo, (String)p, (Object)ReflectionOpt.forceGetProperty(o, (String)p));
            }
            if (dbo instanceof EntityWithTimestamp) {
                ((EntityWithTimestamp)dbo).setLastModifyDate(DatetimeOpt.currentUtilDate());
            }
            this.sessionFactory.getCurrentSession().update((Object)dbo);
        }
        catch (RuntimeException re) {
            logger.error((Object)"save new object failed", (Throwable)re);
            throw new ObjectException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void deleteObjectsAsTabulation(Collection<T> dbObjects) {
        if (dbObjects == null || dbObjects.size() == 0) {
            return;
        }
        Date replaceTime = DatetimeOpt.currentUtilDate();
        Session session = this.getCurrentSession();
        for (Serializable deleteO : dbObjects) {
            if (deleteO instanceof EntityWithDeleteTag) {
                if (((EntityWithDeleteTag)deleteO).isDeleted()) continue;
                ((EntityWithDeleteTag)deleteO).setDeleted(true);
                if (deleteO instanceof EntityWithTimestamp) {
                    ((EntityWithTimestamp)deleteO).setLastModifyDate(replaceTime);
                }
                session.save((Object)deleteO);
                continue;
            }
            session.delete((Object)deleteO);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void deleteObjectsAsTabulation(String propertyName, Object propertyValue) {
        List<T> dbObjects = this.listObjectByProperty(propertyName, propertyValue);
        this.deleteObjectsAsTabulation(dbObjects);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void deleteObjectsAsTabulation(Map<String, Object> properties) {
        List<T> dbObjects = this.listObjectByProperties(properties);
        this.deleteObjectsAsTabulation(dbObjects);
    }

    public static Object getPoObjectId(Object poObj) {
        Field[] objFields;
        for (Field field : objFields = poObj.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Id.class) && !field.isAnnotationPresent(EmbeddedId.class)) continue;
            try {
                return ReflectionOpt.forceGetFieldValue((Object)poObj, (Field)field);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<PK> replaceObjectsAsTabulation(List<T> dbObjects, Collection<T> newObjects, boolean checkTimestamp) {
        if (newObjects == null) {
            throw new ObjectException(2, "\u8bf7\u76f4\u63a5\u8c03\u7528\u5220\u9664\u64cd\u4f5c");
        }
        ArrayList<Serializable> pks = new ArrayList<Serializable>();
        Date replaceTime = DatetimeOpt.currentUtilDate();
        ArrayList<Serializable> deleteObjects = new ArrayList<Serializable>();
        ArrayList<Serializable> insertObjects = new ArrayList<Serializable>();
        ArrayList<Serializable> updateObjects = new ArrayList<Serializable>();
        ArrayList<KeyValuePair> updateObjectPairs = new ArrayList<KeyValuePair>();
        Session session = this.getCurrentSession();
        for (Serializable dbo : dbObjects) {
            boolean found = false;
            for (Serializable no : newObjects) {
                if (!session.getIdentifier((Object)dbo).equals(BaseDaoImpl.getPoObjectId(no))) continue;
                updateObjects.add(no);
                updateObjectPairs.add(new KeyValuePair((Object)no, (Object)dbo));
                found = true;
                break;
            }
            if (found) continue;
            deleteObjects.add(dbo);
        }
        for (Serializable no : newObjects) {
            if (updateObjects.contains(no)) continue;
            insertObjects.add(no);
        }
        for (KeyValuePair updateO : updateObjectPairs) {
            Serializable no = (Serializable)updateO.getKey();
            Serializable dbo = (Serializable)updateO.getValue();
            if (checkTimestamp && no instanceof EntityWithTimestamp && !((EntityWithTimestamp)no).getLastModifyDate().equals(((EntityWithTimestamp)dbo).getLastModifyDate())) {
                String errorMsg = "save or update object failed," + this.getClassTName() + ":" + no.toString() + " be modified out-sync.";
                logger.error((Object)errorMsg);
                throw new RuntimeException(errorMsg);
            }
            BeanUtils.copyProperties((Object)no, (Object)dbo);
            if (no instanceof EntityWithTimestamp) {
                ((EntityWithTimestamp)dbo).setLastModifyDate(replaceTime);
            }
            session.update((Object)dbo);
            pks.add(session.getIdentifier((Object)dbo));
        }
        for (Serializable deleteO : deleteObjects) {
            if (deleteO instanceof EntityWithDeleteTag) {
                if (((EntityWithDeleteTag)deleteO).isDeleted()) continue;
                ((EntityWithDeleteTag)deleteO).setDeleted(true);
                if (deleteO instanceof EntityWithTimestamp) {
                    ((EntityWithTimestamp)deleteO).setLastModifyDate(replaceTime);
                    session.save((Object)deleteO);
                }
                session.save((Object)deleteO);
                continue;
            }
            session.delete((Object)deleteO);
        }
        for (Serializable insretO : insertObjects) {
            if (insretO instanceof EntityWithTimestamp) {
                EntityWithTimestamp ewto = (EntityWithTimestamp)insretO;
                ewto.setLastModifyDate(replaceTime);
            }
            pks.add(session.save((Object)insretO));
        }
        return pks;
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<PK> replaceObjectsAsTabulation(Collection<T> newObjects, String propertyName, Object propertyValue) {
        List<T> dbObjects = this.listObjectByProperty(propertyName, propertyValue);
        return this.replaceObjectsAsTabulation(dbObjects, newObjects, false);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<PK> replaceObjectsAsTabulation(Collection<T> newObjects, Map<String, Object> properties) {
        List<T> dbObjects = this.listObjectByProperties(properties);
        return this.replaceObjectsAsTabulation(dbObjects, newObjects, false);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<PK> replaceObjectsAsTabulationCheckTimestamp(Collection<T> newObjects, String propertyName, Object propertyValue) {
        List<T> dbObjects = this.listObjectByProperty(propertyName, propertyValue);
        return this.replaceObjectsAsTabulation(dbObjects, newObjects, true);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<PK> replaceObjectsAsTabulationCheckTimestamp(Collection<T> newObjects, Map<String, Object> properties) {
        List<T> dbObjects = this.listObjectByProperties(properties);
        return this.replaceObjectsAsTabulation(dbObjects, newObjects, true);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public T mergeObject(T o) {
        try {
            if (o instanceof EntityWithTimestamp) {
                ((EntityWithTimestamp)o).setLastModifyDate(DatetimeOpt.currentUtilDate());
            }
            return (T)((Serializable)this.sessionFactory.getCurrentSession().merge(o));
        }
        catch (RuntimeException re) {
            logger.error((Object)"margin failed", (Throwable)re);
            throw new ObjectException(6, (Throwable)re);
        }
    }

    @Transactional
    public void flush() {
        this.sessionFactory.getCurrentSession().flush();
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void saveRawObject(T o) {
        try {
            this.sessionFactory.getCurrentSession().saveOrUpdate(o);
        }
        catch (RuntimeException re) {
            logger.error((Object)"save or update failed", (Throwable)re);
            throw new ObjectException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void saveObject(T o) {
        try {
            if (o instanceof EntityWithTimestamp) {
                ((EntityWithTimestamp)o).setLastModifyDate(DatetimeOpt.currentUtilDate());
            }
            this.sessionFactory.getCurrentSession().saveOrUpdate(o);
        }
        catch (RuntimeException re) {
            logger.error((Object)"save or update failed", (Throwable)re);
            throw new ObjectException(6, (Throwable)re);
        }
    }

    private String appendOrderBy(String shql) {
        String sOrderby;
        Map<String, String> filterFieldDesc = this.getFilterField();
        if (filterFieldDesc != null && !StringBaseOpt.isNvl((String)(sOrderby = filterFieldDesc.get("ORDER BY")))) {
            return shql + " order by " + sOrderby;
        }
        return shql;
    }

    @Transactional
    public List<T> listObjects() {
        String shql = this.appendOrderBy("From " + this.getClassTShortName());
        try {
            return this.getCurrentSession().createQuery(shql).list();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new ObjectException(6, (Throwable)e);
        }
    }

    @Deprecated
    public QueryAndParams builderHqlAndParams(String shql, Map<String, Object> filterDesc) {
        StringBuffer hql = new StringBuffer(shql);
        ArrayList<Object> params = new ArrayList<Object>();
        Map<String, String> filterFieldDesc = this.getFilterField();
        String sOrderby = null;
        for (Map.Entry<String, Object> ent : filterDesc.entrySet()) {
            String skey = ent.getKey();
            String sSqlFormat = null;
            if (filterFieldDesc != null && (sSqlFormat = filterFieldDesc.get(skey)) == null) {
                sSqlFormat = filterFieldDesc.get(skey.toUpperCase());
            }
            if (sSqlFormat != null) {
                Object sValue = ent.getValue();
                if (null == sValue || sValue instanceof String && !StringUtils.isNotBlank((CharSequence)sValue.toString())) continue;
                if (skey.startsWith("NP_")) {
                    if (!StringRegularOpt.isTrue((String)sValue.toString())) continue;
                    hql.append(" and ").append(sSqlFormat);
                    continue;
                }
                if (sSqlFormat.equalsIgnoreCase("LIKE")) {
                    sValue = QueryUtils.getMatchString((String)sValue.toString());
                    hql.append(String.format(" and %s like ? ", skey));
                } else if (sSqlFormat.equalsIgnoreCase("EQUAL")) {
                    hql.append(String.format(" and %s = ? ", skey));
                } else if (sSqlFormat.equalsIgnoreCase("IN")) {
                    hql.append(String.format(" and %s in ? ", skey));
                } else {
                    hql.append(" and ").append(sSqlFormat);
                }
                params.add(sValue);
                continue;
            }
            if (!"ORDER_BY".equalsIgnoreCase(skey)) continue;
            sOrderby = QueryUtils.trimSqlOrderByField((String)ent.getValue().toString());
        }
        if (sOrderby == null && filterFieldDesc != null) {
            sOrderby = filterFieldDesc.get("ORDER BY");
        }
        if (!StringBaseOpt.isNvl(sOrderby)) {
            hql.append(" order by ").append(sOrderby);
        }
        return new QueryAndParams(hql.toString(), params.toArray());
    }

    public static QueryAndNamedParams builderHqlAndNamedParams(String shql, Map<String, Object> filterDesc, Map<String, String> filterFieldDesc) {
        StringBuffer hql = new StringBuffer(shql);
        HashMap<String, Object> params = new HashMap<String, Object>();
        String sOrderby = null;
        String sOrderFiled = null;
        String sOrder = "asc";
        if (filterDesc != null) {
            for (Map.Entry<String, Object> ent : filterDesc.entrySet()) {
                Object sValue;
                String skey = ent.getKey();
                if ("ORDER_BY".equalsIgnoreCase(skey)) {
                    sOrderby = QueryUtils.trimSqlOrderByField((String)ent.getValue().toString());
                    continue;
                }
                if ("sort".equalsIgnoreCase(skey)) {
                    sOrderFiled = QueryUtils.trimSqlOrderByField((String)ent.getValue().toString());
                    continue;
                }
                if ("order".equalsIgnoreCase(skey)) {
                    String stemp = ent.getValue().toString();
                    if (!"asc".equalsIgnoreCase(stemp) && !"desc".equalsIgnoreCase(stemp)) continue;
                    sOrder = stemp;
                    continue;
                }
                String sSqlFormat = null;
                if (filterFieldDesc != null && (sSqlFormat = filterFieldDesc.get(skey)) == null) {
                    sSqlFormat = filterFieldDesc.get(skey.toUpperCase());
                }
                if (sSqlFormat == null || null == (sValue = ent.getValue()) || sValue instanceof String && !StringUtils.isNotBlank((CharSequence)sValue.toString())) continue;
                if (skey.startsWith("NP_")) {
                    if (!StringRegularOpt.isTrue((String)sValue.toString())) continue;
                    hql.append(" and ").append(sSqlFormat);
                    continue;
                }
                if (sSqlFormat.equalsIgnoreCase("LIKE")) {
                    sValue = QueryUtils.getMatchString((String)sValue.toString());
                    hql.append(" and " + skey + " like :" + skey + " ");
                } else if (sSqlFormat.equalsIgnoreCase("EQUAL")) {
                    hql.append(String.format("  and " + skey + " = :" + skey + " ", new Object[0]));
                } else if (sSqlFormat.equalsIgnoreCase("IN")) {
                    hql.append(String.format("  and " + skey + " in :" + skey + " ", new Object[0]));
                } else {
                    hql.append(" and ").append(sSqlFormat.replace("?", ":" + skey));
                }
                params.put(skey, sValue);
            }
        }
        if (sOrderFiled != null) {
            sOrderby = sOrderFiled + " " + sOrder;
        }
        if (sOrderby == null && filterFieldDesc != null) {
            sOrderby = filterFieldDesc.get("ORDER BY");
        }
        if (!StringBaseOpt.isNvl(sOrderby)) {
            hql.append(" order by ").append(sOrderby);
        }
        return new QueryAndNamedParams(hql.toString(), params);
    }

    public QueryAndNamedParams builderHqlAndNamedParams(String shql, Map<String, Object> filterDesc) {
        return BaseDaoImpl.builderHqlAndNamedParams(shql, filterDesc, this.getFilterField());
    }

    public QueryAndNamedParams builderStatHqlAndNamedParams(String shql, Map<String, Object> filterDesc) {
        StringBuffer hql = new StringBuffer(shql);
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map<String, String> filterFieldDesc = this.getFilterField();
        for (Map.Entry<String, Object> ent : filterDesc.entrySet()) {
            Object sValue;
            String skey = ent.getKey();
            if ("ORDER_BY".equalsIgnoreCase(skey) || "sort".equalsIgnoreCase(skey) || "order".equalsIgnoreCase(skey)) continue;
            String sSqlFormat = null;
            if (filterFieldDesc != null && (sSqlFormat = filterFieldDesc.get(skey)) == null) {
                sSqlFormat = filterFieldDesc.get(skey.toUpperCase());
            }
            if (sSqlFormat == null || null == (sValue = ent.getValue()) || sValue instanceof String && !StringUtils.isNotBlank((CharSequence)sValue.toString())) continue;
            if (skey.startsWith("NP_")) {
                if (!StringRegularOpt.isTrue((String)sValue.toString())) continue;
                hql.append(" and ").append(sSqlFormat);
                continue;
            }
            if (sSqlFormat.equalsIgnoreCase("LIKE")) {
                sValue = QueryUtils.getMatchString((String)sValue.toString());
                hql.append(" and " + skey + " like :" + skey + " ");
            } else if (sSqlFormat.equalsIgnoreCase("EQUAL")) {
                hql.append(String.format("  and " + skey + " = :" + skey + " ", new Object[0]));
            } else if (sSqlFormat.equalsIgnoreCase("IN")) {
                hql.append(String.format("  and " + skey + " in :" + skey + " ", new Object[0]));
            } else {
                hql.append(" and ").append(sSqlFormat.replace("?", ":" + skey));
            }
            params.put(skey, sValue);
        }
        return new QueryAndNamedParams(hql.toString(), params);
    }

    @Deprecated
    public String builderHql(String shql, Map<String, String> filterDesc) {
        StringBuffer hql = new StringBuffer(shql);
        Map<String, String> filterFieldDesc = this.getFilterField();
        String sOrderby = null;
        for (Map.Entry<String, String> ent : filterDesc.entrySet()) {
            String skey = ent.getKey();
            String sSqlFormat = null;
            if (filterFieldDesc != null && (sSqlFormat = filterFieldDesc.get(skey)) == null) {
                sSqlFormat = filterFieldDesc.get(skey.toUpperCase());
            }
            if (sSqlFormat != null) {
                String sValue = ent.getValue();
                if (sValue == null || sValue.equals("")) continue;
                if (sSqlFormat.startsWith("NP_")) {
                    if (!StringRegularOpt.isTrue((String)ent.getValue())) continue;
                    hql.append(" and ").append(sSqlFormat);
                    continue;
                }
                if (sSqlFormat.equalsIgnoreCase("LIKE")) {
                    sValue = QueryUtils.getMatchString((String)sValue);
                    hql.append(String.format(" and %s like %s ", skey, QueryUtils.buildStringForQuery((String)sValue)));
                    continue;
                }
                if (sSqlFormat.equalsIgnoreCase("EQUAL")) {
                    hql.append(String.format(" and %s = %s ", skey, QueryUtils.buildStringForQuery((String)sValue)));
                    continue;
                }
                hql.append(" and ").append(String.format(sSqlFormat, QueryUtils.buildStringForQuery((String)sValue)));
                continue;
            }
            if (!"ORDER_BY".equalsIgnoreCase(skey)) continue;
            if (sOrderby == null) {
                sOrderby = QueryUtils.trimSqlOrderByField((String)ent.getValue().toString());
                continue;
            }
            sOrderby = sOrderby + ", " + ent.getValue();
        }
        if (sOrderby == null && filterFieldDesc != null) {
            sOrderby = filterFieldDesc.get("ORDER BY");
        }
        if (!StringBaseOpt.isNvl(sOrderby)) {
            hql.append(" order by ").append(sOrderby);
        }
        return hql.toString();
    }

    @Transactional
    public List<T> listValidObjects() {
        return this.listObjectByProperty("isvalid", "T");
    }

    @Transactional
    public List<T> listObjects(String hql) {
        try {
            return this.sessionFactory.getCurrentSession().createQuery(hql).list();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new ObjectException(6, (Throwable)e);
        }
    }

    @Transactional
    public List<T> listObjects(String shql, Object[] values, PageDesc pageDesc) {
        List<?> l = DatabaseOptUtils.findObjectsByHql(this, shql, values, pageDesc);
        return l;
    }

    @Transactional
    public List<T> listObjects(String shql, Object value, PageDesc pageDesc) {
        return this.listObjects(shql, new Object[]{value}, pageDesc);
    }

    @Transactional
    public List<T> listObjects(String shql, PageDesc pageDesc) {
        return this.listObjects(shql, (Object[])null, pageDesc);
    }

    @Transactional
    public List<T> listObjects(String shql, Object[] values) {
        try {
            Query q = this.getCurrentSession().createQuery(shql);
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    q.setParameter(i, values[i]);
                }
            }
            List l = q.list();
            return l;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new ObjectException(6, (Throwable)e);
        }
    }

    @Transactional
    public List<T> listObjects(String shql, Object value) {
        try {
            Query q = this.getCurrentSession().createQuery(shql);
            q.setParameter(0, value);
            return q.list();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new ObjectException(6, (Throwable)e);
        }
    }

    @Transactional
    public List<T> listObjects(String shql, Map<String, Object> filterDesc) {
        return this.listObjects(shql, filterDesc, null);
    }

    @Transactional
    public List<T> listObjects(Map<String, Object> filterDesc) {
        String shql = "From " + this.getClassTShortName() + " where 1=1 ";
        return this.listObjects(shql, filterDesc);
    }

    @Transactional
    public List<T> listObjectsByNamedHql(String shql, Map<String, Object> params, int startPos, int maxSize) {
        try {
            Query q = this.getCurrentSession().createQuery(shql);
            DatabaseOptUtils.setQueryParameters(q, params);
            if (maxSize > 0) {
                q.setMaxResults(maxSize);
            }
            if (startPos >= 0) {
                q.setFirstResult(startPos);
            }
            return q.list();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ObjectException(6, (Throwable)e);
        }
    }

    @Transactional
    public List<T> listObjects(String shql, Map<String, Object> filterDesc, PageDesc pageDesc) {
        QueryAndNamedParams hql;
        List<T> listObjs;
        int startPos = 0;
        int maxSize = 0;
        if (pageDesc != null) {
            startPos = pageDesc.getRowStart();
            maxSize = pageDesc.getPageSize();
        }
        if ((listObjs = this.listObjectsByNamedHql((hql = this.builderHqlAndNamedParams(shql, filterDesc)).getHql(), hql.getParams(), startPos, maxSize)) != null && pageDesc != null) {
            if (maxSize > 0) {
                Query q = this.getCurrentSession().createQuery("SELECT COUNT(1) " + QueryUtils.removeOrderBy((String)hql.getHql()));
                Map params = hql.getParams();
                DatabaseOptUtils.setQueryParameters(q, params);
                pageDesc.setTotalRows(Integer.valueOf(q.list().get(0).toString()).intValue());
            } else {
                pageDesc.setTotalRows(listObjs.size());
            }
        }
        return listObjs;
    }

    @Transactional
    public List<T> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        String shql = "From " + this.getClassTShortName() + " where 1=1 ";
        return this.listObjects(shql, filterMap, pageDesc);
    }

    @Transactional
    public T getObjectById(PK id) {
        if (id == null) {
            return null;
        }
        try {
            return (T)((Serializable)this.getCurrentSession().get(this.getPoClass(), id));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    @Transactional
    public List<T> listObjectByProperty(String propertyName, Object propertyValue) {
        try {
            Criteria c = this.sessionFactory.getCurrentSession().createCriteria(this.getPoClass());
            c.add((Criterion)Restrictions.eq((String)propertyName, (Object)propertyValue));
            return c.list();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ObjectException(6, (Throwable)e);
        }
    }

    @Transactional
    public List<T> listObjectByProperties(Map<String, Object> properties) {
        try {
            Criteria c = this.sessionFactory.getCurrentSession().createCriteria(this.getPoClass());
            for (Map.Entry<String, Object> ent : properties.entrySet()) {
                c.add((Criterion)Restrictions.eq((String)ent.getKey(), (Object)ent.getValue()));
            }
            return c.list();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ObjectException(6, (Throwable)e);
        }
    }

    @Transactional
    public T getObjectByProperty(String propertyName, Object propertyValue) {
        List<T> l = this.listObjectByProperty(propertyName, propertyValue);
        if (l == null || l.size() == 0) {
            return null;
        }
        return (T)((Serializable)l.get(0));
    }

    @Transactional
    public T getObjectByProperties(Map<String, Object> properties) {
        List<T> l = this.listObjectByProperties(properties);
        if (l == null || l.size() == 0) {
            return null;
        }
        return (T)((Serializable)l.get(0));
    }
}

