/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.hibernate.dao;

import com.centit.support.algorithm.DatetimeOpt;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.jdbc.Work;

public class FunctionWork
implements Work {
    private String functionName;
    private Object retrunObject = null;
    private List<Object> paramObjs = new ArrayList<Object>();
    private int resultType;
    private boolean isSucceedExecuted = false;

    public FunctionWork(String funcName, int resultType, Object ... params) {
        this.functionName = funcName;
        for (Object obj : params) {
            this.paramObjs.add(obj);
        }
        this.resultType = resultType;
    }

    public boolean hasBeSucceedExecuted() {
        return this.isSucceedExecuted;
    }

    public Object getRetrunObject() {
        return this.retrunObject;
    }

    public void execute(Connection connection) throws SQLException {
        int n = this.paramObjs.size();
        StringBuilder procDesc = new StringBuilder("{?=call ");
        procDesc.append(this.functionName).append("(");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                procDesc.append(",");
            }
            procDesc.append("?");
        }
        procDesc.append(")}");
        CallableStatement stmt = null;
        try {
            stmt = connection.prepareCall(procDesc.toString());
            stmt.registerOutParameter(1, this.resultType);
            for (int i = 0; i < n; ++i) {
                if (this.paramObjs.get(i) == null) {
                    stmt.setNull(i + 2, 0);
                    continue;
                }
                if (this.paramObjs.get(i) instanceof Date) {
                    stmt.setObject(i + 2, (Object)DatetimeOpt.castObjectToDate((Object)this.paramObjs.get(i)));
                    continue;
                }
                stmt.setObject(i + 2, this.paramObjs.get(i));
            }
            stmt.execute();
            this.retrunObject = stmt.getObject(1);
            this.isSucceedExecuted = true;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public int getResultType() {
        return this.resultType;
    }

    public void setResultType(int resultType) {
        this.resultType = resultType;
    }
}

