/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.hibernate.dao;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.dao.DictionaryMap;
import com.centit.framework.core.dao.DictionaryMapColumn;
import com.centit.framework.core.dao.PageDesc;
import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.framework.hibernate.dao.DatabaseOptUtils;
import com.centit.support.common.LeftRightPair;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.transaction.annotation.Transactional;

public class SysDaoOptUtils {
    private SysDaoOptUtils() {
    }

    public static final List<DictionaryMapColumn> getDictionaryMapColumns(Class<?> objType) {
        Field[] objFields = objType.getDeclaredFields();
        ArrayList<DictionaryMapColumn> fieldDictionaryMaps = new ArrayList<DictionaryMapColumn>();
        for (Field field : objFields) {
            DictionaryMap dictionary;
            Map dm;
            if (!field.isAnnotationPresent(DictionaryMap.class) || (dm = CodeRepositoryUtil.getLabelValueMap((String)(dictionary = field.getAnnotation(DictionaryMap.class)).value())) == null) continue;
            fieldDictionaryMaps.add(new DictionaryMapColumn(field.getName(), dictionary.fieldName(), dm));
        }
        return fieldDictionaryMaps;
    }

    public static final JSONObject objectToJSON(Object obj) {
        if (obj == null) {
            return null;
        }
        Object json = JSON.toJSON((Object)obj);
        if (json instanceof JSONObject) {
            List<DictionaryMapColumn> fieldDictionaryMaps = SysDaoOptUtils.getDictionaryMapColumns(obj.getClass());
            if (fieldDictionaryMaps == null || fieldDictionaryMaps.size() == 0) {
                return (JSONObject)json;
            }
            JSONObject jsonObj = (JSONObject)json;
            for (DictionaryMapColumn col : fieldDictionaryMaps) {
                jsonObj.put(col.getMapFieldName(), col.getDictionaryMap().get(jsonObj.get((Object)col.getFieldName())));
            }
            return jsonObj;
        }
        return null;
    }

    public static final JSONArray objectsToJSONArray(Object[] objs) {
        JSONArray ja = new JSONArray();
        if (objs == null || objs.length == 0 || objs[0] == null) {
            return ja;
        }
        List<DictionaryMapColumn> fieldDictionaryMaps = SysDaoOptUtils.getDictionaryMapColumns(objs[0].getClass());
        for (Object obj : objs) {
            Object json = JSON.toJSON((Object)obj);
            if (json instanceof JSONObject && fieldDictionaryMaps != null && fieldDictionaryMaps.size() >= 0) {
                JSONObject jsonObj = (JSONObject)json;
                for (DictionaryMapColumn col : fieldDictionaryMaps) {
                    jsonObj.put(col.getMapFieldName(), col.getDictionaryMap().get(jsonObj.get((Object)col.getFieldName())));
                }
                ja.add((Object)jsonObj);
                continue;
            }
            ja.add(json);
        }
        return ja;
    }

    public static final JSONArray objectsToJSONArray(Collection<? extends Object> objs) {
        JSONArray ja = new JSONArray();
        if (objs == null || objs.isEmpty()) {
            return ja;
        }
        List<DictionaryMapColumn> fieldDictionaryMaps = SysDaoOptUtils.getDictionaryMapColumns(objs.iterator().next().getClass());
        for (Object object : objs) {
            Object json = JSON.toJSON((Object)object);
            if (json instanceof JSONObject && fieldDictionaryMaps != null && fieldDictionaryMaps.size() >= 0) {
                JSONObject jsonObj = (JSONObject)json;
                for (DictionaryMapColumn col : fieldDictionaryMaps) {
                    jsonObj.put(col.getMapFieldName(), col.getDictionaryMap().get(jsonObj.get((Object)col.getFieldName())));
                }
                ja.add((Object)jsonObj);
                continue;
            }
            ja.add(json);
        }
        return ja;
    }

    public static final List<DictionaryMapColumn> makeQueryColumn(String[] fields, Class<?> objType) {
        Field[] objFields = objType.getDeclaredFields();
        ArrayList<DictionaryMapColumn> fieldDictionaryMaps = new ArrayList<DictionaryMapColumn>();
        for (Field field : objFields) {
            if (!field.isAnnotationPresent(Column.class) || fields != null && fields.length != 0 && !ArrayUtils.contains((Object[])fields, (Object)field.getName())) continue;
            if (field.isAnnotationPresent(DictionaryMap.class)) {
                DictionaryMap dictionary = field.getAnnotation(DictionaryMap.class);
                fieldDictionaryMaps.add(new DictionaryMapColumn(field.getName(), dictionary.fieldName(), CodeRepositoryUtil.getLabelValueMap((String)dictionary.value())));
                continue;
            }
            fieldDictionaryMaps.add(new DictionaryMapColumn(field.getName(), null, null));
        }
        return fieldDictionaryMaps;
    }

    private static Object fetchObjectFromList(List<?> dataList, int row, int col, int fieldSize) {
        return fieldSize > 1 ? ((Object[])dataList.get(row))[col] : dataList.get(row);
    }

    @Transactional
    public static JSONArray listObjectsAsJson(BaseDaoImpl<?, ?> baseDao, String[] fields, Class<?> objType, QueryAndNamedParams hqlFromPiece, Map<String, Object> filterMap, PageDesc pageDesc) {
        JSONArray ja = new JSONArray();
        List<DictionaryMapColumn> fieldDictionaryMaps = SysDaoOptUtils.makeQueryColumn(fields, objType);
        if (fieldDictionaryMaps.size() < 1) {
            return ja;
        }
        int fieldCount = 0;
        StringBuilder hqlBuilder = new StringBuilder("Select ");
        for (DictionaryMapColumn field : fieldDictionaryMaps) {
            if (fieldCount > 0) {
                hqlBuilder.append(",");
            }
            hqlBuilder.append(field.getFieldName());
            ++fieldCount;
        }
        hqlBuilder.append(" ").append(hqlFromPiece.getHql());
        QueryAndNamedParams hql = BaseDaoImpl.builderHqlAndNamedParams(hqlBuilder.toString(), filterMap, baseDao.getFilterField());
        hql.addAllParams(hqlFromPiece.getParams());
        List<?> dataList = DatabaseOptUtils.findObjectsByHql(baseDao, hql.getHql(), hql.getParams(), pageDesc);
        if (dataList == null || dataList.isEmpty()) {
            return ja;
        }
        for (int j = 0; j < dataList.size(); ++j) {
            JSONObject jo = new JSONObject();
            for (int i = 0; i < fieldDictionaryMaps.size(); ++i) {
                jo.put(fieldDictionaryMaps.get(i).getFieldName(), SysDaoOptUtils.fetchObjectFromList(dataList, j, i, fieldCount));
                if (fieldDictionaryMaps.get(i).getMapFieldName() == null) continue;
                jo.put(fieldDictionaryMaps.get(i).getMapFieldName(), fieldDictionaryMaps.get(i).getDictionaryMap().get(String.valueOf(((Object[])dataList.get(j))[i])));
            }
            ja.add((Object)jo);
        }
        return ja;
    }

    @Transactional
    public static final JSONArray listObjectsAsJson(BaseDaoImpl<?, ?> baseDao, String[] fields, Class<?> objType, Map<String, Object> filterMap, PageDesc pageDesc) {
        QueryAndNamedParams hqlFromPiece = new QueryAndNamedParams("from " + objType.getSimpleName() + " where 1=1");
        return SysDaoOptUtils.listObjectsAsJson(baseDao, fields, objType, hqlFromPiece, filterMap, pageDesc);
    }

    @Transactional
    public static final JSONObject getObjectAsJson(BaseDaoImpl<?, ?> baseDao, String[] fields, Class<?> objType, Map<String, Object> filterMap) {
        List<DictionaryMapColumn> fieldDictionaryMaps = SysDaoOptUtils.makeQueryColumn(fields, objType);
        if (fieldDictionaryMaps.size() < 1) {
            return null;
        }
        int fieldCount = 0;
        StringBuilder hqlBuilder = new StringBuilder("Select ");
        for (DictionaryMapColumn field : fieldDictionaryMaps) {
            if (fieldCount > 0) {
                hqlBuilder.append(",");
            }
            hqlBuilder.append(field.getFieldName());
            ++fieldCount;
        }
        hqlBuilder.append(" from ").append(objType.getSimpleName()).append(" where 1=1 ");
        QueryAndNamedParams hql = BaseDaoImpl.builderHqlAndNamedParams(hqlBuilder.toString(), filterMap, baseDao.getFilterField());
        List<?> dataList = DatabaseOptUtils.findObjectsByHql(baseDao, hql.getHql(), hql.getParams());
        if (dataList == null || dataList.isEmpty()) {
            return null;
        }
        JSONObject jo = new JSONObject();
        for (int i = 0; i < fieldDictionaryMaps.size(); ++i) {
            jo.put(fieldDictionaryMaps.get(i).getFieldName(), SysDaoOptUtils.fetchObjectFromList(dataList, 0, i, fieldCount));
            if (fieldDictionaryMaps.get(i).getMapFieldName() == null) continue;
            jo.put(fieldDictionaryMaps.get(i).getMapFieldName(), fieldDictionaryMaps.get(i).getDictionaryMap().get(String.valueOf(((Object[])dataList.get(0))[i])));
        }
        return jo;
    }

    @Transactional
    public static final JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String sqlSen, Map<String, Object> paramsMap, Map<String, LeftRightPair<String, String>> dictionaryMap, PageDesc pageDesc) {
        return SysDaoOptUtils.listObjectsBySqlAsJson(baseDao, sqlSen, paramsMap, null, dictionaryMap, pageDesc);
    }

    @Transactional
    public static final JSONArray listObjectsBySqlAsJson(BaseDaoImpl<?, ?> baseDao, String sqlSen, Map<String, Object> paramsMap, String[] fieldNames, Map<String, LeftRightPair<String, String>> dictionaryMap, PageDesc pageDesc) {
        JSONArray ja = new JSONArray();
        List fields = QueryUtils.getSqlFiledNames((String)sqlSen);
        if (fields == null || fields.size() < 1) {
            return ja;
        }
        int fns = fieldNames == null ? 0 : fieldNames.length;
        ArrayList<DictionaryMapColumn> fieldDictionaryMaps = new ArrayList<DictionaryMapColumn>();
        int fi = 0;
        for (String f : fields) {
            String field = null;
            field = fi < fns ? fieldNames[fi] : DatabaseAccess.mapColumnNameToField((String)f);
            ++fi;
            LeftRightPair<String, String> dict = null;
            if (dictionaryMap != null && (dict = dictionaryMap.get(field)) == null) {
                dict = dictionaryMap.get(f);
            }
            if (dict != null) {
                fieldDictionaryMaps.add(new DictionaryMapColumn(field, (String)dict.getLeft(), CodeRepositoryUtil.getLabelValueMap((String)((String)dict.getRight()))));
                continue;
            }
            fieldDictionaryMaps.add(new DictionaryMapColumn(field));
        }
        List<?> dataList = DatabaseOptUtils.findObjectsBySql(baseDao, sqlSen, paramsMap, pageDesc);
        if (dataList == null || dataList.isEmpty()) {
            return ja;
        }
        for (int j = 0; j < dataList.size(); ++j) {
            JSONObject jo = new JSONObject();
            for (int i = 0; i < fieldDictionaryMaps.size(); ++i) {
                jo.put(((DictionaryMapColumn)fieldDictionaryMaps.get(i)).getFieldName(), DatabaseAccess.fetchLobField((Object)SysDaoOptUtils.fetchObjectFromList(dataList, j, i, fi), (boolean)false));
                if (((DictionaryMapColumn)fieldDictionaryMaps.get(i)).getMapFieldName() == null) continue;
                jo.put(((DictionaryMapColumn)fieldDictionaryMaps.get(i)).getMapFieldName(), ((DictionaryMapColumn)fieldDictionaryMaps.get(i)).getDictionaryMap().get(String.valueOf(((Object[])dataList.get(j))[i])));
            }
            ja.add((Object)jo);
        }
        return ja;
    }

    @Transactional
    public static final JSONArray listObjectsByHqlAsJson(BaseDaoImpl<?, ?> baseDao, String hqlSen, Map<String, Object> paramsMap, Map<String, LeftRightPair<String, String>> dictionaryMap, PageDesc pageDesc) {
        JSONArray ja = new JSONArray();
        List fields = QueryUtils.getSqlFiledNames((String)hqlSen);
        if (fields == null || fields.size() < 1) {
            return ja;
        }
        ArrayList<DictionaryMapColumn> fieldDictionaryMaps = new ArrayList<DictionaryMapColumn>();
        for (String field : fields) {
            LeftRightPair<String, String> dict;
            LeftRightPair<String, String> leftRightPair = dict = dictionaryMap == null ? null : dictionaryMap.get(field);
            if (dict != null) {
                fieldDictionaryMaps.add(new DictionaryMapColumn(field, (String)dict.getLeft(), CodeRepositoryUtil.getLabelValueMap((String)((String)dict.getRight()))));
                continue;
            }
            fieldDictionaryMaps.add(new DictionaryMapColumn(field));
        }
        int fi = fields.size();
        List<?> dataList = DatabaseOptUtils.findObjectsByHql(baseDao, hqlSen, paramsMap, pageDesc);
        if (dataList == null || dataList.isEmpty()) {
            return ja;
        }
        for (int j = 0; j < dataList.size(); ++j) {
            JSONObject jo = new JSONObject();
            for (int i = 0; i < fieldDictionaryMaps.size(); ++i) {
                jo.put(((DictionaryMapColumn)fieldDictionaryMaps.get(i)).getFieldName(), DatabaseAccess.fetchLobField((Object)SysDaoOptUtils.fetchObjectFromList(dataList, j, i, fi), (boolean)false));
                if (((DictionaryMapColumn)fieldDictionaryMaps.get(i)).getMapFieldName() == null) continue;
                jo.put(((DictionaryMapColumn)fieldDictionaryMaps.get(i)).getMapFieldName(), ((DictionaryMapColumn)fieldDictionaryMaps.get(i)).getDictionaryMap().get(String.valueOf(((Object[])dataList.get(j))[i])));
            }
            ja.add((Object)jo);
        }
        return ja;
    }

    public static DictionaryMapBuilder createDictionaryMapBuilder(String codeField, String valueField, String dictCatalog) {
        DictionaryMapBuilder builder = new DictionaryMapBuilder();
        return builder.addDictionaryDesc(codeField, valueField, dictCatalog);
    }

    public static class DictionaryMapBuilder {
        private Map<String, LeftRightPair<String, String>> dictionaryMap = new HashMap<String, LeftRightPair<String, String>>();

        private DictionaryMapBuilder() {
        }

        public DictionaryMapBuilder addDictionaryDesc(String codeField, String valueField, String dictCatalog) {
            this.dictionaryMap.put(codeField, (LeftRightPair<String, String>)new LeftRightPair((Object)valueField, (Object)dictCatalog));
            return this;
        }

        public Map<String, LeftRightPair<String, String>> create() {
            return this.dictionaryMap;
        }
    }
}

