/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.security;

import com.centit.framework.common.WebOptUtils;
import com.centit.framework.security.CheckFailLogs;
import com.centit.framework.security.SecurityContextUtils;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.image.CaptchaImageUtil;
import com.centit.support.security.SecurityOptUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.MessageSource;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class PretreatmentAuthenticationProcessingFilter
extends UsernamePasswordAuthenticationFilter {
    private int checkCaptchaTime = 0;
    private int checkCaptchaType = 0;
    protected MessageSource messageSource;

    public void setCheckCaptchaTime(int checkCaptchaTime) {
        this.checkCaptchaTime = checkCaptchaTime;
    }

    public void setCheckCaptchaType(int checkCaptchaType) {
        this.checkCaptchaType = checkCaptchaType;
    }

    public void setRetryMaxTryTimes(int maxTryTimes) {
        CheckFailLogs.setMaxTryTimes(maxTryTimes);
    }

    public void setRetryCheckType(String checkType) {
        CheckFailLogs.setCheckType(checkType);
    }

    public void setRetryLockMinites(int lockMinites) {
        CheckFailLogs.setLockMinites(lockMinites);
    }

    public void setRetryCheckTimeTnterval(int checkTimeTnterval) {
        CheckFailLogs.setCheckTimeTnterval(checkTimeTnterval);
    }

    public PretreatmentAuthenticationProcessingFilter(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (CheckFailLogs.getMaxTryTimes() > 0 && CheckFailLogs.isLocked(request)) {
            throw new AuthenticationServiceException(this.messageSource.getMessage("error.302.user_is_locked", null, "User is locked, please try late!", WebOptUtils.getCurrentLocale((HttpServletRequest)request)));
        }
        int tryTimes = CheckFailLogs.getHasTriedTimes(request);
        if (this.checkCaptchaType != 0 && (this.checkCaptchaTime == 2 || this.checkCaptchaTime == 1 && tryTimes > 0)) {
            if (!BooleanBaseOpt.castObjectToBoolean((Object)request.getSession().getAttribute(SecurityContextUtils.AJAX_CHECK_CAPTCHA_RESULT), (Boolean)false).booleanValue()) {
                String requestCheckcode = request.getParameter("j_checkcode");
                String sessionCheckcode = StringBaseOpt.castObjectToString((Object)request.getSession().getAttribute("session_checkcode"));
                if (!CaptchaImageUtil.checkcodeMatch((String)sessionCheckcode, (String)requestCheckcode)) {
                    CheckFailLogs.plusCheckFail(request);
                    throw new AuthenticationServiceException(this.messageSource.getMessage("error.701.invalid_check_code", null, "Invalid check code.", WebOptUtils.getCurrentLocale((HttpServletRequest)request)));
                }
            }
            request.getSession().setAttribute("session_checkcode", (Object)CaptchaImageUtil.getRandomString((int)6));
            request.getSession().setAttribute(SecurityContextUtils.AJAX_CHECK_CAPTCHA_RESULT, (Object)false);
        }
        try {
            String username = this.obtainUsername(request);
            username = SecurityOptUtils.decodeSecurityString((String)username);
            String password = this.obtainPassword(request);
            password = SecurityOptUtils.decodeSecurityString((String)password);
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
            this.setDetails(request, authRequest);
            Authentication auth = this.getAuthenticationManager().authenticate((Authentication)authRequest);
            CheckFailLogs.removeCheckFail(request);
            return auth;
        }
        catch (AuthenticationException failed) {
            CheckFailLogs.plusCheckFail(request);
            throw failed;
        }
    }
}

