/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.model.basedata.DataCatalog;
import com.centit.support.algorithm.CollectionsOpt;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="dataCatalogDao")
public class DataCatalogDao
extends BaseDaoImpl<DataCatalog, String> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("catalogCode", "LIKE");
        filterField.put("catalogName", "LIKE");
        filterField.put("catalogStyle", "EQUAL");
        filterField.put("catalogType", "EQUAL");
        filterField.put("optId", "EQUAL");
        filterField.put("topUnit", "EQUAL");
        filterField.put("osId", "CATALOG_CODE in (select dictionary_id from m_application_dictionary where os_id = :osId)");
        return filterField;
    }

    @Transactional
    public DataCatalog getObjectById(String catalogCode) {
        return (DataCatalog)super.getObjectById((Object)catalogCode);
    }

    @Transactional
    public void deleteObjectById(String catalogCode) {
        super.deleteObjectById((Object)catalogCode);
    }

    @Transactional
    public List<DataCatalog> listFixCatalog() {
        return this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"catalogStyle", "F"}));
    }

    @Transactional
    public List<DataCatalog> listUserCatalog() {
        return this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"catalogStyle", "U"}));
    }

    @Transactional
    public List<DataCatalog> listSysCatalog() {
        return this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"catalogStyle", "S"}));
    }

    @Transactional
    public void updateCatalog(DataCatalog dataCatalog) {
        super.updateObject((Serializable)dataCatalog);
    }

    @Transactional
    public List<DataCatalog> listDataCatalogByUnit(String topUnit) {
        return super.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"topUnit", topUnit}));
    }
}

