/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.support.algorithm.CollectionsOpt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class OsInfoDao
extends BaseDaoImpl<OsInfo, String> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("osId", "LIKE");
        filterField.put("osName", "LIKE");
        filterField.put("osType", "LIKE");
        filterField.put("topUnit", "LIKE");
        filterField.put("hasInterface", "LIKE");
        filterField.put("interfaceUrl", "LIKE");
        filterField.put("created", "LIKE");
        filterField.put("lastUpdateTime", "LIKE");
        filterField.put("createTime", "LIKE");
        return filterField;
    }

    @Transactional
    public List<OsInfo> listOsInfoByUnit(String topUnit) {
        return super.listObjectsByFilter(" where IS_DELETE = 'F' AND TOP_UNIT = ?", new Object[]{topUnit});
    }

    @Transactional
    public OsInfo getOsInfoByRelOpt(String relOptId) {
        if (StringUtils.isBlank((CharSequence)relOptId)) {
            return null;
        }
        return (OsInfo)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"relOptId", relOptId}));
    }

    public int countOsInfoByTopUnit(String topUnit) {
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            return 0;
        }
        return this.countObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"topUnit", topUnit}));
    }
}

