/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.model.basedata.FVUserOptList;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import com.centit.support.security.SecurityOptUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="userInfoDao")
public class UserInfoDao
extends BaseDaoImpl<UserInfo, String> {
    @Value(value="${userinfo.cellphone.encrypt:none}")
    protected String phoneEncryptType;
    private static String f_v_userroles_sql = "select b.ROLE_CODE, b.ROLE_NAME, b.IS_VALID, 'D' as OBTAIN_TYPE, b.ROLE_TYPE, b.UNIT_CODE,b.ROLE_DESC, b.CREATE_DATE, b.UPDATE_DATE ,a.USER_CODE, null as INHERITED_FROM from F_USERROLE a join F_ROLEINFO b on (a.ROLE_CODE=b.ROLE_CODE) where a.OBTAIN_DATE <= :currentDateTime  and (a.SECEDE_DATE is null or a.SECEDE_DATE > :currentDateTime ) and b.IS_VALID='T' and b.ROLE_CODE = :roleCode union select b.ROLE_CODE, b.ROLE_NAME, b.IS_VALID, 'I' as OBTAIN_TYPE, b.ROLE_TYPE, b.UNIT_CODE, b.ROLE_DESC, b.CREATE_DATE, b.UPDATE_DATE ,c.USER_CODE, a.UNIT_CODE as INHERITED_FROM from F_UNITROLE a join F_ROLEINFO b on (a.ROLE_CODE = b.ROLE_CODE) JOIN F_USERUNIT c on( a.UNIT_CODE = c.UNIT_CODE) where a.OBTAIN_DATE <= :currentDateTime  and (a.SECEDE_DATE is null or a.SECEDE_DATE > :currentDateTime ) and b.IS_VALID='T' and a.ROLE_CODE = :roleCode ";
    private static final String f_v_topunit_user_powers = "select DISTINCT a.USER_CODE, c.OPT_CODE, c.OPT_NAME, c.OPT_ID, c.OPT_METHOD from F_V_USERROLES a JOIN F_ROLEPOWER b ON ( a.Role_Code = b.Role_Code ) JOIN F_OPTDEF c ON ( b.OPT_CODE = c.OPT_CODE ) where USER_CODE= :userCode and OPT_METHOD is not null and a.role_code in ( select b.ROLE_CODE from F_USERROLE a join F_ROLEINFO b on (a.ROLE_CODE=b.ROLE_CODE) where a.USER_CODE = :userCode and a.OBTAIN_DATE <= :currentDateTime and  (a.SECEDE_DATE is null  or a.SECEDE_DATE > :currentDateTime) and b.IS_VALID='T'  and (b.ROLE_TYPE = 'G' or b.UNIT_CODE = :unitCode) )";

    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("userCode", "LIKE");
        filterField.put("USERCODE_EQ", "EQUAL");
        filterField.put("userName", "LIKE");
        filterField.put("isValid", "EQUAL");
        filterField.put("(like)loginName", "LIKE");
        filterField.put("USERSTATE", "EQUAL");
        filterField.put("USERORDER", "EQUAL");
        filterField.put("(like)userTag", "LIKE");
        filterField.put("USERWORD", "EQUAL");
        filterField.put("topUnit", " USER_CODE IN ( SELECT DISTINCT UN.USER_CODE FROM F_USERUNIT UN WHERE UN.TOP_UNIT = :topUnit ) ");
        filterField.put("(like)likeUserOrLoginName", "(User_Name LIKE :likeUserOrLoginName OR LOGIN_NAME LIKE :likeUserOrLoginName or user_code like :likeUserOrLoginName)");
        filterField.put("byUnderUnit", "userCode in (select us.USER_CODE from f_userunit us where us.UNIT_CODE = :byUnderUnit ) ");
        filterField.put("roleCode", "[(isNotEmpty(roleCode))(roleCode, currentDateTime) | and USER_CODE in (select v.USER_CODE from ( " + f_v_userroles_sql + " ) v where v.ROLE_CODE = :roleCode) ]");
        filterField.put("queryByUnit", "userCode in (select us.USER_CODE from f_userunit us where us.UNIT_CODE = :queryByUnit ) ");
        filterField.put("queryByGW", "userCode in (select us.USER_CODE from f_userunit us where us.User_Station = :queryByGW )");
        filterField.put("queryByXZ", "userCode in (select us.USER_CODE from f_userunit us where us.USER_RANK = :queryByXZ )");
        filterField.put("queryByRole", "userCode in (select r.USER_CODE from f_userrole r join f_roleinfo i on r.ROLE_CODE = i.ROLE_CODE where r.ROLE_CODE = :queryByRole and i.IS_VALID = 'T')");
        filterField.put("unitCode", "userCode in (select us.USER_CODE from f_userunit us where us.UNIT_CODE in (select un.UNIT_CODE from f_unitinfo un where un.UNIT_CODE = :unitCode or un.PARENT_UNIT = :unitCode))");
        filterField.put("(STARTWITH)unitPath", "userCode in (select us.USER_CODE from f_userunit us where us.UNIT_CODE in (select un.UNIT_CODE from f_unitinfo un where un.UNIT_PATH like :unitPath))");
        return filterField;
    }

    @Transactional
    public List<UserInfo> listObjects(Map<String, Object> filterMap) {
        String cellPhone;
        if (filterMap.containsKey("regCellPhone") && !"none".equals(this.phoneEncryptType) && StringUtils.isNotBlank((CharSequence)(cellPhone = StringBaseOpt.castObjectToString((Object)filterMap.get("regCellPhone"))))) {
            cellPhone = SecurityOptUtils.decodeSecurityString((String)cellPhone);
            cellPhone = SecurityOptUtils.encodeSecurityString((String)cellPhone, (String)this.phoneEncryptType);
            filterMap.put("regCellPhone", cellPhone);
        }
        filterMap.put("currentDateTime", DatetimeOpt.currentUtilDate());
        return super.listObjectsByProperties(filterMap);
    }

    @Transactional
    public List<FVUserOptList> listUserOptMethods(String userCode) {
        String sql = "select USER_CODE, OPT_CODE, OPT_NAME, OPT_ID, OPT_METHOD from F_V_USEROPTLIST where USER_CODE=? and OPT_METHOD is not null";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)sql, (Object[])new Object[]{userCode}, FVUserOptList.class));
    }

    @Transactional
    public List<FVUserOptList> listUserPowers(String topUnit, String userCode) {
        Map map = CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "currentDateTime", DatetimeOpt.currentUtilDate(), "unitCode", topUnit});
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)f_v_topunit_user_powers, (Map)map, FVUserOptList.class));
    }

    @Transactional
    public List<UserInfo> listUnderUnit(Map<String, Object> filterMap) {
        return this.listObjects(filterMap);
    }

    @Transactional
    public List<UserInfo> listUnderUnit(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.listObjectsByProperties(filterMap, pageDesc);
    }

    @Transactional
    public JSONArray listObjectsByUnit(Map<String, Object> filterMap, PageDesc pageDesc) {
        String querySql = "SELECT a.* FROM F_USERINFO a JOIN (SELECT * FROM f_userunit WHERE 1=1 [:queryByUnit | AND unit_code=:queryByUnit] [:topUnit | AND top_unit=:topUnit] [ :relType | AND REL_TYPE = :relType ] ) b ON a.USER_CODE=b.user_code where 1=1 [:(like)userName | and (User_Name LIKE :userName OR LOGIN_NAME LIKE :userName)]ORDER BY b.user_order";
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, filterMap);
        return DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)qap.getQuery(), (Map)qap.getParams(), (PageDesc)pageDesc);
    }

    @Transactional
    public JSONArray listUsersWithUnit(Map<String, Object> filterMap, PageDesc pageDesc) {
        String querySql = " SELECT A.USER_CODE, A.USER_TYPE, A.LOGIN_NAME, A.USER_NAME, A.USER_TAG, A.ENGLISH_NAME, A.USER_DESC, A.TOP_UNIT, A.REG_EMAIL, A.REG_CELL_PHONE, A.PRIMARY_UNIT, A.USER_WORD, A.USER_ORDER, B.USER_UNIT_ID, B.UNIT_CODE, B.USER_STATION, B.USER_RANK, C.UNIT_NAME  FROM F_USERINFO A JOIN F_USERUNIT B ON A.USER_CODE = B.USER_CODE  LEFT JOIN F_UNITINFO C ON B.UNIT_CODE = C.UNIT_CODE  WHERE 1 = 1 [ :topUnit | AND B.TOP_UNIT = :topUnit ]  [:(like)userName | AND ( A.USER_NAME LIKE :userName OR A.LOGIN_NAME LIKE :userName)]  [:queryByUnit | AND B.UNIT_CODE = :queryByUnit ]  ORDER BY A.USER_ORDER ";
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, filterMap);
        return DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)qap.getQuery(), (Map)qap.getParams(), (PageDesc)pageDesc);
    }

    @Transactional
    public UserInfo getUserByCode(String userCode) {
        return (UserInfo)super.getObjectById((Object)userCode);
    }

    @Transactional
    public UserInfo getUserByLoginName(String loginName) {
        if (StringUtils.isBlank((CharSequence)loginName)) {
            return null;
        }
        return (UserInfo)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"loginName", loginName}));
    }

    @Transactional
    public UserInfo getUserByRegEmail(String regEmail) {
        if (StringUtils.isBlank((CharSequence)regEmail)) {
            return null;
        }
        return (UserInfo)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"regEmail", regEmail}));
    }

    @Transactional
    public UserInfo getUserByRegCellPhone(String regCellPhone) {
        if (StringUtils.isBlank((CharSequence)regCellPhone)) {
            return null;
        }
        if (!"none".equals(this.phoneEncryptType)) {
            regCellPhone = SecurityOptUtils.decodeSecurityString((String)regCellPhone);
            regCellPhone = SecurityOptUtils.encodeSecurityString((String)regCellPhone, (String)this.phoneEncryptType);
        }
        return (UserInfo)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"regCellPhone", regCellPhone}));
    }

    @Transactional
    public UserInfo getUserByTag(String userTag) {
        if (StringUtils.isBlank((CharSequence)userTag)) {
            return null;
        }
        return (UserInfo)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userTag", userTag}));
    }

    @Transactional
    public UserInfo getUserByUserWord(String userWord) {
        if (StringUtils.isBlank((CharSequence)userWord)) {
            return null;
        }
        return (UserInfo)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userWord", userWord}));
    }

    @Transactional
    public UserInfo getUserByIdCardNo(String idCardNo) {
        if (StringUtils.isBlank((CharSequence)idCardNo)) {
            return null;
        }
        return (UserInfo)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"idCardNo", idCardNo}));
    }

    @Transactional
    public void deleteObjectById(String userCode) {
        super.deleteObjectById((Object)userCode);
    }

    public List<UserInfo> listUsersByRoleCode(String roleCode) {
        return super.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"roleCode", roleCode, "currentDateTime", DatetimeOpt.currentUtilDate()}));
    }

    public int isLoginNameExist(String userCode, String loginName) {
        String sql = "select count(*) as usersCount from F_USERINFO t where t.USER_CODE <> ? and t.LOGIN_NAME = ?";
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{userCode, loginName}));
    }

    public int isCellPhoneExist(String userCode, String cellPhone) {
        if (!"none".equals(this.phoneEncryptType)) {
            cellPhone = SecurityOptUtils.decodeSecurityString((String)cellPhone);
            cellPhone = SecurityOptUtils.encodeSecurityString((String)cellPhone, (String)this.phoneEncryptType);
        }
        String sql = "select count(*) as usersCount from F_USERINFO t where t.USER_CODE <> ? and t.REG_CELL_PHONE = ?";
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{userCode, cellPhone}));
    }

    public int isEmailExist(String userCode, String email) {
        String sql = "select count(*) as usersCount from F_USERINFO t where t.USER_CODE <> ? and t.REG_EMAIL = ?";
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{userCode, email}));
    }

    public int isAnyOneExist(String userCode, String loginName, String regPhone, String regEmail) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)userCode)) {
            map.put("USER_CODE", userCode);
        }
        if (StringUtils.isNotBlank((CharSequence)loginName)) {
            map.put("LOGIN_NAME", loginName);
        }
        if (StringUtils.isNotBlank((CharSequence)regPhone)) {
            if (!"none".equals(this.phoneEncryptType)) {
                regPhone = SecurityOptUtils.decodeSecurityString((String)regPhone);
                regPhone = SecurityOptUtils.encodeSecurityString((String)regPhone, (String)this.phoneEncryptType);
            }
            map.put("REG_CELL_PHONE", regPhone);
        }
        if (StringUtils.isNotBlank((CharSequence)regEmail)) {
            map.put("REG_EMAIL", regEmail);
        }
        Object[] params = new String[map.size()];
        StringBuilder stringBuilder = new StringBuilder(" SELECT COUNT(1) AS USERSCOUNT FROM F_USERINFO WHERE ");
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            if (i != 0) {
                stringBuilder.append(" OR ");
            }
            stringBuilder.append((String)entry.getKey()).append(" = ? ");
            params[i] = entry.getValue();
            ++i;
        }
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)stringBuilder.toString(), (Object[])params));
    }

    public void saveUserLoginInfo(UserInfo userInfo) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"update f_userinfo set ACTIVE_TIME=? , LAST_ACCESS_TOKEN = ? where USER_CODE = ?", (Object[])new Object[]{userInfo.getActiveTime(), userInfo.getLastAccessToken(), userInfo.getUserCode()});
    }

    @Transactional
    public void updateUser(UserInfo userInfo) {
        if (!"none".equals(this.phoneEncryptType) && StringUtils.isNotBlank((CharSequence)userInfo.getRegCellPhone())) {
            String cellPhone = SecurityOptUtils.decodeSecurityString((String)userInfo.getRegCellPhone());
            userInfo.setRegCellPhone(SecurityOptUtils.encodeSecurityString((String)cellPhone, (String)this.phoneEncryptType));
        }
        super.updateObject((Serializable)userInfo);
    }

    @Transactional
    public void saveUserInfo(UserInfo userInfo) {
        if (!"none".equals(this.phoneEncryptType) && StringUtils.isNotBlank((CharSequence)userInfo.getRegCellPhone())) {
            String cellPhone = SecurityOptUtils.decodeSecurityString((String)userInfo.getRegCellPhone());
            userInfo.setRegCellPhone(SecurityOptUtils.encodeSecurityString((String)cellPhone, (String)this.phoneEncryptType));
        }
        super.updateObject((Serializable)userInfo);
    }
}

