/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.model.basedata.OptMethod;
import com.centit.framework.model.basedata.OptMethodUrlMap;
import com.centit.framework.model.basedata.RoleInfo;
import com.centit.framework.model.basedata.RolePower;
import com.centit.framework.model.basedata.RolePowerId;
import com.centit.framework.security.CentitSecurityMetadata;
import com.centit.framework.security.SecurityContextUtils;
import com.centit.framework.system.dao.OptInfoDao;
import com.centit.framework.system.dao.OptMethodDao;
import com.centit.framework.system.dao.RoleInfoDao;
import com.centit.framework.system.dao.RolePowerDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.service.SysRoleManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.utils.PageDesc;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysRoleManager")
public class SysRoleManagerImpl
implements SysRoleManager {
    public static Logger logger = LoggerFactory.getLogger(SysRoleManagerImpl.class);
    @Autowired
    @NotNull
    private OptInfoDao optInfoDao;
    @Autowired
    @NotNull
    private OptMethodDao optMethodDao;
    @Autowired
    @NotNull
    private RolePowerDao rolePowerDao;
    @Autowired
    @NotNull
    protected RoleInfoDao roleInfoDao;
    @Autowired
    @NotNull
    private UserRoleDao userRoleDao;
    @Value(value="${framework.roleinfo.id.generator:}")
    protected String roleIdFormat;

    @Override
    @Transactional
    public List<RolePower> getRolePowers(String rolecode) {
        return this.rolePowerDao.listRolePowersByRoleCode(rolecode);
    }

    @Override
    @Transactional
    public List<RolePower> getRolePowersByDefCode(String optCode) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("optCode", optCode);
        return this.rolePowerDao.listObjectsByProperties(filterMap);
    }

    @Override
    @Transactional
    public Serializable saveNewRoleInfo(RoleInfo o) {
        this.roleInfoDao.saveNewObject((Serializable)o);
        CodeRepositoryCache.evictCache((String)"RoleInfo");
        return o.getRoleCode();
    }

    @Override
    @Transactional
    public List<RolePower> listAllRolePowers() {
        return this.rolePowerDao.listObjectsAll();
    }

    @Override
    @Transactional
    public List<OptMethod> listAllOptMethods() {
        return this.optMethodDao.listObjectsAll();
    }

    private List<OptMethodUrlMap> listAllOptMethodUrlMap() {
        return this.optInfoDao.listAllOptMethodUrlMap();
    }

    @Override
    @Transactional
    public void updateRoleInfo(RoleInfo o) {
        if (StringUtils.equalsAny((CharSequence)o.getRoleCode(), (CharSequence[])new CharSequence[]{SecurityContextUtils.ANONYMOUS_ROLE_CODE, SecurityContextUtils.PUBLIC_ROLE_CODE})) {
            return;
        }
        this.roleInfoDao.updateRole(o);
        CodeRepositoryCache.evictCache((String)"RoleInfo");
    }

    @Override
    @Transactional
    public List<RolePower> updateRolePower(RoleInfo o) {
        this.roleInfoDao.updateRole(o);
        List newRPs = o.getRolePowers();
        List<RolePower> rps = this.rolePowerDao.listRolePowersByRoleCode(o.getRoleCode());
        if (newRPs == null || newRPs.size() < 1) {
            this.rolePowerDao.deleteRolePowersByRoleCode(o.getRoleCode());
            return rps;
        }
        this.updateRolePower(o, newRPs, rps);
        CodeRepositoryCache.evictCache((String)"RoleInfo");
        CodeRepositoryCache.evictCache((String)"RolePower");
        return rps;
    }

    @Override
    @Transactional
    public List<RolePower> updateRolePower(RoleInfo roleInfo, String topUnit) {
        List<RolePower> rps;
        boolean isAPCode = StringUtils.equalsAny((CharSequence)roleInfo.getRoleCode(), (CharSequence[])new CharSequence[]{SecurityContextUtils.ANONYMOUS_ROLE_CODE, SecurityContextUtils.PUBLIC_ROLE_CODE});
        ArrayList<RolePower> newRPs = roleInfo.getRolePowers();
        if (!CollectionUtils.sizeIsEmpty((Object)newRPs)) {
            ArrayList<RolePower> filteredRPs = new ArrayList<RolePower>();
            for (RolePower rp2 : newRPs) {
                OptMethod optMethod = this.optMethodDao.getObjectById(rp2.getOptCode());
                if (optMethod == null || optMethod.getOptCode() == null) continue;
                filteredRPs.add(rp2);
            }
            newRPs = filteredRPs;
        }
        List<RolePower> list = rps = isAPCode ? this.rolePowerDao.listRolePowerByTopUnitAndRoleCode(topUnit, roleInfo.getRoleCode()) : this.rolePowerDao.listRolePowersByRoleCode(roleInfo.getRoleCode());
        if (CollectionUtils.sizeIsEmpty((Object)newRPs)) {
            rps.forEach(rp -> this.rolePowerDao.deleteObjectById(rp.getId()));
            return rps;
        }
        this.updateRolePower(roleInfo, newRPs, rps);
        CodeRepositoryCache.evictCache((String)"RoleInfo");
        CodeRepositoryCache.evictCache((String)"RolePower");
        if ("system".equals(topUnit)) {
            CodeRepositoryCache.evictCache((String)"SystemOpt");
        }
        CentitSecurityMetadata.evictCache((int)1);
        return rps;
    }

    private void updateRolePower(RoleInfo roleInfo, List<RolePower> newRPs, List<RolePower> rps) {
        for (RolePower rp : newRPs) {
            rp.setRoleCode(roleInfo.getRoleCode());
        }
        Triple forUpdate = CollectionsOpt.compareTwoList(rps, newRPs, Comparator.comparing(RolePower::getOptCode));
        if (forUpdate.getRight() != null) {
            for (RolePower rp : (List)forUpdate.getRight()) {
                this.rolePowerDao.deleteObjectById(new RolePowerId(rp.getRoleCode(), rp.getOptCode()));
                if (!rp.getRoleCode().startsWith("G$")) continue;
                String optCode = rp.getOptCode();
                String unitCode = rp.getRoleCode().substring(2);
                List roleInfos = this.roleInfoDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"unitCode", unitCode, "roleType", "D"}));
                for (RoleInfo ri : roleInfos) {
                    this.rolePowerDao.deleteObjectById(new RolePowerId(ri.getRoleCode(), optCode));
                }
            }
        }
        if (forUpdate.getLeft() != null) {
            for (RolePower rp : (List)forUpdate.getLeft()) {
                this.rolePowerDao.saveNewRolePower(rp);
            }
        }
        if (forUpdate.getMiddle() != null) {
            for (RolePower rp : (List)forUpdate.getMiddle()) {
                RolePower oldRolePower = (RolePower)rp.getLeft();
                RolePower newRolePower = (RolePower)rp.getRight();
                if (StringUtils.equals((CharSequence)oldRolePower.getOptScopeCodes(), (CharSequence)newRolePower.getOptScopeCodes())) continue;
                this.rolePowerDao.updateObject(CollectionsOpt.createList((Object[])new String[]{"updator", "updateDate"}), (Serializable)newRolePower);
            }
        }
    }

    @Override
    @Transactional
    public void deleteRoleInfo(String roleCode) {
        this.rolePowerDao.deleteRolePowersByRoleCode(roleCode);
        this.roleInfoDao.deleteObjectById(roleCode);
        CodeRepositoryCache.evictCache((String)"RoleInfo");
    }

    @Override
    @Transactional
    public RoleInfo getRoleInfo(String roleCode) {
        RoleInfo rf = this.roleInfoDao.getObjectById(roleCode);
        if (rf != null) {
            rf.addAllRolePowers(this.rolePowerDao.listRolePowersByRoleCode(roleCode));
        }
        return rf;
    }

    @Override
    @Transactional
    public List<RoleInfo> listObjects(Map<String, Object> filterMap) {
        return this.roleInfoDao.listObjectsByProperties(filterMap);
    }

    @Override
    @Transactional
    public List<RoleInfo> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.roleInfoDao.listObjectsByProperties(filterMap, pageDesc);
    }

    @Override
    @Transactional
    public RoleInfo getObjectById(String roleCode) {
        return this.roleInfoDao.getObjectById(roleCode);
    }

    @Override
    @Transactional
    public int countRoleUserSum(String roleCode) {
        return this.userRoleDao.countObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"roleCode", roleCode}));
    }

    @Override
    @Transactional
    public boolean judgeSysRoleNameCanBeUsed(String roleName, String roleCode, String unitCode) {
        HashMap<String, String> filterMap = new HashMap<String, String>(4);
        if (unitCode == null) {
            filterMap.put("NP_ALL", "true");
        } else {
            filterMap.put("NP_OWNER", "D/S");
            filterMap.put("unitCode", unitCode);
        }
        filterMap.put("roleNameEq", roleName);
        List roleInfos = this.roleInfoDao.listObjectsByProperties(filterMap);
        return roleInfos == null || roleInfos.size() == 0 || StringUtils.equals((CharSequence)roleCode, (CharSequence)((RoleInfo)roleInfos.get(0)).getRoleCode());
    }

    @Override
    public List<RoleInfo> listRoleInfoByOptCode(String optCode) {
        return this.roleInfoDao.listRoleInfoByOptCode(optCode);
    }

    @Override
    public JSONArray listRoleInfoAndPowerByOptCode(String optCode) {
        return this.rolePowerDao.listRoleInfoAndPowerByOptCode(optCode);
    }

    @Override
    @Transactional
    public void updateRolePower(String optCode, String roleCode) {
        this.rolePowerDao.deleteRolePowersByOptCode(optCode);
        if (StringUtils.isBlank((CharSequence)roleCode)) {
            CodeRepositoryCache.evictCache((String)"RolePower");
            return;
        }
        Arrays.stream(roleCode.split(",")).forEach(singleRoleCode -> this.rolePowerDao.saveNewRolePower(new RolePower(new RolePowerId(singleRoleCode, optCode))));
        CodeRepositoryCache.evictCache((String)"RolePower");
    }

    @Override
    @Transactional
    public void updateRolePowersByOptCode(String optCode, List<RolePower> rolePowers) {
        if (StringUtils.isBlank((CharSequence)optCode)) {
            return;
        }
        this.rolePowerDao.deleteRolePowersByOptCode(optCode);
        if (CollectionUtils.sizeIsEmpty(rolePowers)) {
            CodeRepositoryCache.evictCache((String)"RolePower");
            return;
        }
        rolePowers.forEach(rolePower -> this.rolePowerDao.saveNewRolePower((RolePower)rolePower));
        CodeRepositoryCache.evictCache((String)"RolePower");
        CentitSecurityMetadata.evictCache((int)1);
    }
}

