/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.model.basedata.FVUserRoles;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.UserRole;
import com.centit.framework.model.basedata.UserRoleId;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.service.SysUserRoleManager;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JSONOpt;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysUserRoleManager")
@Transactional
public class SysUserRoleManagerImpl
implements SysUserRoleManager {
    @Autowired
    @NotNull
    protected UserRoleDao userRoleDao;
    @Autowired
    private UserInfoDao userInfoDao;

    @Override
    public void mergeObject(UserRole dbUserRole, UserRole userRole) {
        this.userRoleDao.deleteObject((Serializable)dbUserRole);
        this.userRoleDao.mergeUserRole(userRole);
    }

    @Override
    public JSONArray listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        List userRolesList = this.userRoleDao.listObjectsByProperties(filterMap, pageDesc);
        JSONArray userRoles = JSONOpt.arrayToJSONArray((Object)userRolesList);
        for (Object a : userRoles) {
            JSONObject aa = (JSONObject)a;
            String userCode = aa.getString("userCode");
            UserInfo userinfo = CodeRepositoryUtil.getUserInfoByCode((String)StringBaseOpt.objectToString((Object)filterMap.get("topUnit")), (String)userCode);
            if (userinfo == null) continue;
            String loginName = userinfo.getLoginName();
            aa.put((Object)"loginName", (Object)loginName);
        }
        return DictionaryMapUtils.mapJsonArray((JSONArray)userRoles, (Class[])new Class[]{UserRole.class});
    }

    @Override
    public UserRole getObjectById(UserRoleId id) {
        return this.userRoleDao.getObjectById(id);
    }

    @Override
    public void mergeObject(UserRole dbUserRole) {
        this.userRoleDao.mergeUserRole(dbUserRole);
    }

    @Override
    public void deleteObjectById(UserRoleId id) {
        this.userRoleDao.deleteObjectById(id);
    }

    @Override
    @Transactional
    public List<UserInfo> listUsersByRole(String roleCode) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("queryByRole", roleCode);
        return this.userInfoDao.listObjects(map);
    }

    @Override
    @Transactional
    public List<FVUserRoles> listUserRolesByUserCode(String userCode) {
        return this.userRoleDao.listUserRolesByUserCode(userCode);
    }

    @Override
    @Transactional
    public List<FVUserRoles> listRoleUsersByRoleCode(String roleCode) {
        return this.userRoleDao.listRoleUsersByRoleCode(roleCode);
    }

    @Override
    @Transactional
    public JSONArray pageQueryUserRole(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.userRoleDao.pageQueryUserRole(filterMap, pageDesc);
    }

    @Override
    @Transactional
    public List<String> listUserCanAccessSystem(String topUnit, String userCode) {
        return this.userRoleDao.listUserCanAccessSystem(topUnit, userCode);
    }

    @Override
    @Transactional
    public boolean checkUserSystemPower(String osId, String userCode) {
        return this.userRoleDao.checkUserSystemPower(osId, userCode);
    }

    @Override
    @Transactional
    public List<UserRole> listUserRoles(String userCode) {
        return this.userRoleDao.listUserRoles(userCode);
    }

    @Override
    @Transactional
    public List<UserRole> listRoleUsers(String roleCode) {
        return this.userRoleDao.listRoleUsers(roleCode);
    }
}

