/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryAndParams;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="unitInfoDao")
public class UnitInfoDao
extends BaseDaoImpl<UnitInfo, String> {
    public static final Logger logger = LoggerFactory.getLogger(UnitInfoDao.class);

    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>(10);
        filterField.put("unitCode", "EQUAL");
        filterField.put("unitName", "LIKE");
        filterField.put("isValid", "EQUAL");
        filterField.put("UNITTAG", "EQUAL");
        filterField.put("unitWord", "EQUAL");
        filterField.put("parentUnit", "EQUAL");
        filterField.put("NP_TOPUnit", "(parentUnit is null or parentUnit='0' or parentUnit='')");
        filterField.put("depNo", "EQUAL");
        filterField.put("ORDER_BY", " UNIT_ORDER, UNIT_CODE ");
        filterField.put("(STARTWITH)unitPath", "LIKE");
        filterField.put("topUnit", "EQUAL");
        return filterField;
    }

    @Transactional
    public List<UserInfo> listUnitUsers(String unitCode) {
        String sql = "select a.* from F_USERINFO a join F_USERUNIT b on(a.USER_CODE=b.USER_CODE) where b.UNIT_CODE =?";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)sql, (Object[])new Object[]{unitCode}, UserInfo.class));
    }

    @Transactional
    public List<UnitInfo> listUserTopUnits(String userCode) {
        String sql = "select a.* from F_UNITINFO a join F_USERUNIT b on (a.UNIT_CODE = b.UNIT_CODE) where b.USER_CODE =? and CONCAT('/',a.UNIT_CODE) = a.UNIT_PATH";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)sql, (Object[])new Object[]{userCode}, UnitInfo.class));
    }

    @Transactional
    public List<UnitInfo> listAllTopUnits() {
        String sql = "select a.* from F_UNITINFO a where CONCAT('/',a.UNIT_CODE) = a.UNIT_PATH";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)sql, null, UnitInfo.class));
    }

    @Transactional
    public UnitInfo getUnitByName(String name) {
        String sql = "select u.UNIT_CODE, u.PARENT_UNIT, u.UNIT_TYPE, u.IS_VALID, u.UNIT_NAME, u.ENGLISH_NAME, u.UNIT_SHORT_NAME, u.UNIT_WORD, u.UNIT_TAG, u.UNIT_DESC, u.UNIT_ORDER, u.UNIT_GRADE, u.DEP_NO, u.UNIT_PATH, u.UNIT_MANAGER, u.CREATE_DATE, u.CREATOR, u.UPDATOR, u.UPDATE_DATE from F_UNITINFO u where u.UNIT_NAME = ? or u.UNIT_SHORT_NAME = ?";
        List unitInfos = (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)sql, (Object[])new Object[]{name, name}, UnitInfo.class));
        if (unitInfos != null && unitInfos.size() > 0) {
            return (UnitInfo)unitInfos.get(0);
        }
        return null;
    }

    @Transactional
    public UnitInfo getUnitByTag(String unitTag) {
        if (StringUtils.isBlank((CharSequence)unitTag)) {
            return null;
        }
        return (UnitInfo)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"unitTag", unitTag}));
    }

    @Transactional
    public UnitInfo getUnitByWord(String unitWord) {
        if (StringUtils.isBlank((CharSequence)unitWord)) {
            return null;
        }
        return (UnitInfo)super.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"unitWord", unitWord}));
    }

    @Transactional
    public List<UnitInfo> listSubUnits(String unitCode) {
        if (StringUtils.isBlank((CharSequence)unitCode)) {
            return null;
        }
        return super.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"parentUnit", unitCode}));
    }

    @Transactional
    public List<UnitInfo> listSubUnitsByUnitPaht(String unitPath) {
        if (StringUtils.isBlank((CharSequence)unitPath)) {
            return null;
        }
        return this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"unitPath", unitPath + "/%"}));
    }

    public List<String> getAllParentUnit() {
        return this.getJdbcTemplate().queryForList("select distinct t.parent_unit from f_unitinfo t ", String.class);
    }

    public UnitInfo getObjectById(String unitCode) {
        return (UnitInfo)super.getObjectById((Object)unitCode);
    }

    @Transactional
    public void deleteObjectById(String unitCode) {
        super.deleteObjectById((Object)unitCode);
    }

    public boolean isUniqueName(String unitName, String parentCode, String unitCode) {
        String sql = "select count(*) as hasSameNameUnit from F_UNITINFO u where  u.UNIT_NAME = :unitName and u.PARENT_UNIT = :parentUnit [ :unitCode | and u.UNIT_CODE <> :unitCode ]";
        Map filerMap = CollectionsOpt.createHashMap((Object[])new Object[]{"unitName", unitName, "parentUnit", parentCode, "unitCode", unitCode});
        QueryAndParams queryAndParams = QueryAndParams.createFromQueryAndNamedParams((QueryAndNamedParams)QueryUtils.translateQuery((String)sql, (Object)filerMap));
        logger.info("sql: {},\u53c2\u6570\uff1aunitName={},parentCode={},unitCode={}", new Object[]{queryAndParams.getQuery(), unitName, parentCode, unitCode});
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)queryAndParams.getQuery(), (Object[])queryAndParams.getParams())) > 0;
    }

    public Integer isExistsUnitByParentAndOrder(String parentUnit, long unitOrder) {
        String sql = "select count(*) as existUnit from F_UNITINFO u where u.UNIT_ORDER = :unitOrder and u.PARENT_UNIT = :parentUnit ";
        Object object = DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)sql, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"unitOrder", unitOrder, "parentUnit", parentUnit}));
        return NumberBaseOpt.castObjectToInteger((Object)object);
    }

    @Transactional
    public void updateUnit(UnitInfo unitInfo) {
        super.updateObject((Serializable)unitInfo);
    }

    public int countUnitByTopUnit(String topUnit) {
        String sql = " SELECT COUNT(1) COUNT FROM F_UNITINFO WHERE 1=1 AND IS_VALID = 'T'  [  :topUnit | AND TOP_UNIT = :topUnit ] ";
        HashMap params = StringUtils.isBlank((CharSequence)topUnit) ? new HashMap() : CollectionsOpt.createHashMap((Object[])new Object[]{"topUnit", topUnit});
        QueryAndParams queryAndParams = QueryAndParams.createFromQueryAndNamedParams((QueryAndNamedParams)QueryUtils.translateQuery((String)sql, params));
        logger.info("sql: {},\u53c2\u6570\uff1a{}", (Object)queryAndParams.getQuery(), (Object)topUnit);
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)queryAndParams.getQuery(), (Object[])queryAndParams.getParams()));
    }
}

