/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.UserRole;
import com.centit.framework.model.basedata.UserRoleId;
import com.centit.framework.model.basedata.UserSyncDirectory;
import com.centit.framework.model.basedata.UserUnit;
import com.centit.framework.model.security.CentitPasswordEncoder;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.service.UserDirectory;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.compiler.Pretreatment;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="activeDirectoryUserDirectory")
public class ActiveDirectoryUserDirectoryImpl
implements UserDirectory {
    private static Logger logger = LoggerFactory.getLogger(ActiveDirectoryUserDirectoryImpl.class);
    @Autowired
    @NotNull
    private UserUnitDao userUnitDao;
    @Autowired
    @NotNull
    private UnitInfoDao unitInfoDao;
    @Autowired
    @NotNull
    private UserRoleDao userRoleDao;
    @Autowired
    @Qualifier(value="userInfoDao")
    private UserInfoDao userInfoDao;
    @Autowired
    @NotNull
    private CentitPasswordEncoder passwordEncoder;
    @Value(value="${framework.password.default.generator:}")
    protected String defaultPasswordFormat;

    public static String getAttributeString(Attribute attr) {
        if (attr == null) {
            return null;
        }
        try {
            return StringBaseOpt.objectToString((Object)attr.get());
        }
        catch (NamingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Map<String, String> fetchAttributeMap(Attributes attr, Map<String, Object> fieldMap) {
        HashMap<String, String> valueMap = new HashMap<String, String>(fieldMap.size() + 1);
        for (Map.Entry<String, Object> ent : fieldMap.entrySet()) {
            valueMap.put(ent.getKey(), ActiveDirectoryUserDirectoryImpl.getAttributeString(attr.get(StringBaseOpt.castObjectToString((Object)ent.getValue()))));
        }
        return valueMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int synchroniseUserDirectory(UserSyncDirectory directory) {
        if (StringUtils.isBlank((CharSequence)directory.getUrl())) {
            return -2;
        }
        JSONObject searchParams = JSON.parseObject((String)directory.getSearchBase());
        String unitSearchBase = StringBaseOpt.castObjectToString((Object)searchParams.getString("unitSearchBase"), (String)"CN=Users,DC=com");
        String unitSearchFilter = StringBaseOpt.castObjectToString((Object)searchParams.getString("unitSearchFilter"), (String)"(objectCategory=group)");
        String userSearchBase = StringBaseOpt.castObjectToString((Object)searchParams.getString("userSearchBase"), (String)"CN=Users,DC=com");
        String userSearchFilter = StringBaseOpt.castObjectToString((Object)searchParams.getString("userSearchFilter"), (String)"(&(objectCategory=person)(objectClass=user))");
        Map userFields = CollectionsOpt.objectToMap((Object)searchParams.get("userFieldMap"));
        String[] userFieldNames = new String[userFields.size()];
        int i = 0;
        for (Object obj : userFields.values()) {
            userFieldNames[i++] = StringBaseOpt.castObjectToString(obj);
        }
        Map unitFields = CollectionsOpt.objectToMap((Object)searchParams.get("unitFieldMap"));
        String[] unitFieldNames = new String[unitFields.size()];
        i = 0;
        for (Object obj : unitFields.values()) {
            unitFieldNames[i++] = StringBaseOpt.castObjectToString(obj);
        }
        String userUnitField = StringBaseOpt.castObjectToString((Object)searchParams.getString("userUnitField"), (String)"memberOf");
        String userURIFormat = searchParams.getString("userURIFormat");
        if (StringUtils.isBlank((CharSequence)userURIFormat)) {
            userURIFormat = "{loginName}";
        }
        String userURI = Pretreatment.mapTemplateString((String)userURIFormat, (Object)CollectionsOpt.createHashMap((Object[])new Object[]{"loginName", directory.getUser(), "topUnit", directory.getTopUnit()}));
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", userURI);
        env.put("java.naming.security.credentials", directory.getClearPassword());
        env.put("java.naming.provider.url", directory.getUrl());
        Date now = DatetimeOpt.currentUtilDate();
        try {
            Attributes attrs;
            SearchResult sr;
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            HashMap<String, UnitInfo> allUnits = new HashMap<String, UnitInfo>();
            searchCtls.setReturningAttributes(unitFieldNames);
            NamingEnumeration<SearchResult> answer = ctx.search(unitSearchBase, unitSearchFilter, searchCtls);
            while (answer.hasMoreElements()) {
                sr = answer.next();
                attrs = sr.getAttributes();
                Map<String, String> unitMap = ActiveDirectoryUserDirectoryImpl.fetchAttributeMap(attrs, unitFields);
                if (StringUtils.isBlank((CharSequence)unitMap.get("unitName")) || StringUtils.isBlank((CharSequence)unitMap.get("unitTag"))) continue;
                UnitInfo unitInfo = this.unitInfoDao.getUnitByTag(unitMap.get("unitTag"));
                if (unitInfo == null) {
                    unitInfo = new UnitInfo();
                    unitInfo.setIsValid("T");
                    unitInfo.setUnitType("A");
                    for (Map.Entry<String, String> ent : unitMap.entrySet()) {
                        ReflectionOpt.setFieldValue((Object)unitInfo, (String)((String)ent.getKey()), (Object)ent.getValue(), String.class);
                    }
                    unitInfo.setTopUnit(directory.getTopUnit());
                    this.unitInfoDao.saveNewObject((Serializable)unitInfo);
                    unitInfo.setUnitPath("/" + unitInfo.getUnitCode());
                    this.unitInfoDao.updateUnit(unitInfo);
                } else if (StringUtils.isNotBlank((CharSequence)unitMap.get("unitName")) && !StringUtils.equals((CharSequence)unitInfo.getUnitName(), (CharSequence)unitMap.get("unitName"))) {
                    for (Map.Entry<String, String> ent : unitMap.entrySet()) {
                        ReflectionOpt.setFieldValue((Object)unitInfo, (String)ent.getKey(), (Object)ent.getValue(), String.class);
                    }
                    this.unitInfoDao.updateUnit(unitInfo);
                }
                allUnits.put(unitMap.get("unitTag"), unitInfo);
            }
            searchCtls.setReturningAttributes(userFieldNames);
            answer = ctx.search(userSearchBase, userSearchFilter, searchCtls);
            while (answer.hasMoreElements()) {
                Attribute members;
                sr = answer.next();
                attrs = sr.getAttributes();
                Map<String, String> userMap = ActiveDirectoryUserDirectoryImpl.fetchAttributeMap(attrs, userFields);
                if (StringUtils.isBlank((CharSequence)userMap.get("userName")) || StringUtils.isBlank((CharSequence)userMap.get("loginName"))) continue;
                boolean createUser = false;
                UserInfo userInfo = this.userInfoDao.getUserByLoginName(userMap.get("loginName"));
                if (userInfo == null) {
                    userInfo = new UserInfo();
                    userInfo.setIsValid("T");
                    userInfo.setLoginName(userMap.get("loginName"));
                    userInfo.setCreateDate(now);
                    userInfo.setUserPin(this.getDefaultPassword());
                    createUser = true;
                }
                for (Map.Entry entry : userMap.entrySet()) {
                    String fieldKey = (String)entry.getKey();
                    if ("loginName".equals(fieldKey)) continue;
                    if ("regEmail".equals(fieldKey)) {
                        String regEmail = (String)entry.getValue();
                        if (!StringUtils.isNotBlank((CharSequence)regEmail) || regEmail.length() >= 60 || regEmail.equals(userInfo.getRegEmail()) || this.userInfoDao.getUserByRegEmail(regEmail) != null) continue;
                        userInfo.setRegEmail(regEmail);
                        continue;
                    }
                    if ("regCellPhone".equals(fieldKey)) {
                        String regCellPhone = (String)entry.getValue();
                        if (!StringUtils.isNotBlank((CharSequence)regCellPhone) || regCellPhone.length() > 15 || regCellPhone.equals(userInfo.getRegCellPhone()) || this.userInfoDao.getUserByRegCellPhone(regCellPhone) != null) continue;
                        userInfo.setRegCellPhone(regCellPhone);
                        continue;
                    }
                    if ("userValid".equals(fieldKey)) {
                        boolean isDisable = StringUtils.equalsAny((CharSequence)((CharSequence)entry.getValue()), (CharSequence[])new CharSequence[]{"F", "false", "514", "546", "66050", "66080", "66082"});
                        userInfo.setIsValid(isDisable ? "F" : "T");
                        continue;
                    }
                    ReflectionOpt.setFieldValue((Object)userInfo, (String)fieldKey, entry.getValue(), String.class);
                }
                userInfo.setUpdateDate(now);
                if (createUser) {
                    this.userInfoDao.saveUserInfo(userInfo);
                } else {
                    this.userInfoDao.updateUser(userInfo);
                }
                if (!"T".equals(userInfo.getIsValid())) continue;
                if (createUser && StringUtils.isNotBlank((CharSequence)directory.getDefaultUserRole())) {
                    UserRole role = new UserRole(new UserRoleId(userInfo.getUserCode(), directory.getDefaultUserRole()));
                    role.setObtainDate(now);
                    role.setCreateDate(now);
                    role.setChangeDesc("LDAP\u540c\u6b65\u65f6\u9ed8\u8ba4\u8bbe\u7f6e\u3002");
                    this.userRoleDao.mergeUserRole(role);
                }
                if ((members = attrs.get(userUnitField)) == null) continue;
                NamingEnumeration<?> namingEnumeration = members.getAll();
                while (namingEnumeration.hasMoreElements()) {
                    List<UserUnit> uus;
                    Object member = namingEnumeration.next();
                    String groupName = StringBaseOpt.objectToString(member);
                    UnitInfo u = (UnitInfo)allUnits.get(groupName);
                    if (u == null || !"T".equals(u.getIsValid())) continue;
                    if (StringUtils.isNotBlank((CharSequence)u.getUnitCode()) && StringUtils.isBlank((CharSequence)userInfo.getPrimaryUnit())) {
                        Object[] unitCodeArray;
                        userInfo.setPrimaryUnit(u.getUnitCode());
                        this.userInfoDao.updateUser(userInfo);
                        UnitInfo unitInfo = this.unitInfoDao.getObjectById(userInfo.getPrimaryUnit());
                        if (null != unitInfo && StringUtils.isNotBlank((CharSequence)unitInfo.getTopUnit())) {
                            userInfo.setTopUnit(unitInfo.getTopUnit());
                        }
                        if (null != unitInfo && StringUtils.isBlank((CharSequence)userInfo.getTopUnit()) && StringUtils.isNotBlank((CharSequence)unitInfo.getUnitPath()) && ArrayUtils.isNotEmpty((Object[])(unitCodeArray = unitInfo.getUnitPath().split("/"))) && unitCodeArray.length > 1) {
                            userInfo.setTopUnit((String)unitCodeArray[1]);
                        }
                        this.userInfoDao.updateUser(userInfo);
                    }
                    if (!CollectionUtils.isEmpty(uus = this.userUnitDao.listObjectByUserUnit(userInfo.getUserCode(), u.getUnitCode()))) continue;
                    UserUnit uu = new UserUnit();
                    uu.setUserUnitId(UuidOpt.getUuidAsString());
                    uu.setUnitCode(u.getUnitCode());
                    uu.setUserCode(userInfo.getUserCode());
                    uu.setCreateDate(now);
                    if (u.getUnitCode().equals(userInfo.getPrimaryUnit())) {
                        uu.setRelType("T");
                    } else {
                        uu.setRelType("F");
                    }
                    uu.setUserRank(directory.getDefaultRank());
                    uu.setUserStation(directory.getDefaultStation());
                    this.userUnitDao.saveNewObject((Serializable)uu);
                }
            }
            ctx.close();
            return 0;
        }
        catch (NamingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    private String getDefaultPassword() {
        String rawPass = UuidOpt.randomString((int)12);
        return this.passwordEncoder.createPassword(rawPass, (Object)"salt");
    }
}

