/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.model.basedata.RolePower;
import com.centit.framework.model.basedata.RolePowerId;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="rolePowerDao")
public class RolePowerDao
extends BaseDaoImpl<RolePower, RolePowerId> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("optCode", "EQUAL");
        filterField.put("roleCode", "EQUAL");
        filterField.put("topUnit", "ROLE_CODE in (select role_code from f_roleinfo us where unit_code = :topUnit)");
        return filterField;
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<RolePower> listObjectsAll() {
        return super.listObjects();
    }

    @Transactional
    public void deleteRolePowersByRoleCode(String roleCode) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"roleCode", roleCode}));
    }

    @Transactional
    public void deleteRolePowersByOptCode(String optCode) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"optCode", optCode}));
    }

    @Transactional
    public List<RolePower> listRolePowersByRoleCode(String rolecode) {
        return this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"roleCode", rolecode}));
    }

    @Transactional
    public void mergeBatchObject(List<RolePower> rolePowers) {
        for (int i = 0; i < rolePowers.size(); ++i) {
            super.mergeObject((Serializable)rolePowers.get(i));
        }
    }

    @Transactional
    public void updateRolePower(RolePower rolePower) {
        super.updateObject((Serializable)rolePower);
    }

    @Transactional
    public void saveNewRolePower(RolePower rolePower) {
        super.saveNewObject((Serializable)rolePower);
    }

    @Transactional
    public void deleteObjectById(RolePowerId id) {
        super.deleteObjectById((Object)id);
    }

    @Transactional
    public List<RolePower> listAllRolePowerByUnit(String topUnit) {
        String sql = "select distinct a.* from F_ROLEPOWER a join F_ROLEINFO b on (a.ROLE_CODE=b.ROLE_CODE) where b.ROLE_TYPE = 'G' or b.UNIT_CODE = ? or b.role_code in ('platadmin','tenantadmin','osmember','orgadmin')";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)sql, (Object[])new Object[]{topUnit}, RolePower.class));
    }

    @Transactional
    public List<RolePower> listSysRolePower() {
        ArrayList<RolePower> rolePowers = new ArrayList<RolePower>();
        String sql = "select distinct a.ROLE_CODE,a.opt_code,a.opt_scope_codes,d.top_opt_id as top_unit from F_ROLEPOWER a join F_ROLEINFO b on a.ROLE_CODE=b.ROLE_CODE join f_optdef c on a.opt_code=c.opt_code join f_optinfo d on c.opt_id=d.opt_id where  d.top_opt_id='system'";
        JSONArray jsonArray = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)sql, (Map)CollectionsOpt.createHashMap((Object[])new Object[0]));
        for (Object jsonObject : jsonArray) {
            rolePowers.add((RolePower)JSON.to(RolePower.class, jsonObject));
        }
        return rolePowers;
    }

    @Transactional
    public List<RolePower> listRolePowerUseApiId(String apiId) {
        ArrayList<RolePower> rolePowers = new ArrayList<RolePower>();
        String sql = "select distinct a.ROLE_CODE,a.opt_code,a.opt_scope_codes,e.top_unit from F_ROLEPOWER a join F_ROLEINFO b on a.ROLE_CODE=b.ROLE_CODE join f_optdef c on a.opt_code=c.opt_code join f_optinfo d on c.opt_id=d.opt_id join f_os_info e on d.top_opt_id=e.os_id where  c.api_id=:apiId";
        JSONArray jsonArray = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)sql, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"apiId", apiId}));
        for (Object jsonObject : jsonArray) {
            rolePowers.add((RolePower)JSON.to(RolePower.class, jsonObject));
        }
        return rolePowers;
    }

    @Transactional
    public List<RolePower> listRolePowerByTopUnitAndRoleCode(String topUnit, String roleCode) {
        String sql = "SELECT DISTINCT  A.ROLE_CODE,  A.OPT_CODE,  A.OPT_SCOPE_CODES,  A.UPDATE_DATE,  A.CREATE_DATE,  A.CREATOR,  A.UPDATOR  FROM F_ROLEPOWER A  JOIN  ( SELECT  DISTINCT C_1.OPT_CODE,A_1.OPT_ID  FROM F_OPTINFO A_1 JOIN F_OS_INFO B_1 ON A_1.TOP_OPT_ID=B_1.REL_OPT_ID   LEFT JOIN F_OPTDEF C_1 ON A_1.OPT_ID = C_1.OPT_ID WHERE B_1.TOP_UNIT = ?  ) C  ON A.OPT_CODE = C.OPT_CODE OR A.OPT_CODE = C.OPT_ID   WHERE  A.ROLE_CODE = ?  ";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)sql, (Object[])new Object[]{topUnit, roleCode}, RolePower.class));
    }

    public JSONArray listRoleInfoAndPowerByOptCode(String optCode) {
        String querySql = "SELECT  A.OPT_CODE, A.OPT_SCOPE_CODES,  B.ROLE_CODE, B.ROLE_NAME, B.ROLE_TYPE,  B.UNIT_CODE, B.ROLE_DESC, B.UPDATE_DATE, B.CREATE_DATE, B.CREATOR, B.UPDATOR  FROM F_ROLEPOWER A JOIN F_ROLEINFO B ON A.ROLE_CODE = B.ROLE_CODE  WHERE  [  :optCode | A.OPT_CODE = :optCode  ] ";
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, (Object)CollectionsOpt.createHashMap((Object[])new Object[]{"optCode", optCode}));
        return DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)qap.getQuery(), (Map)qap.getParams());
    }
}

