/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.DataCatalog;
import com.centit.framework.model.basedata.DataDictionary;
import com.centit.framework.model.basedata.FVUserRoles;
import com.centit.framework.model.basedata.OptDataScope;
import com.centit.framework.model.basedata.OptInfo;
import com.centit.framework.model.basedata.OptMethod;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.framework.model.basedata.RoleInfo;
import com.centit.framework.model.basedata.RolePower;
import com.centit.framework.model.basedata.TenantInfo;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UnitRole;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.UserPlat;
import com.centit.framework.model.basedata.UserRole;
import com.centit.framework.model.basedata.UserSetting;
import com.centit.framework.model.basedata.UserSettingId;
import com.centit.framework.model.basedata.UserUnit;
import com.centit.framework.model.basedata.WorkGroup;
import com.centit.framework.model.security.CentitPasswordEncoder;
import com.centit.framework.model.security.CentitSecurityConfig;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.framework.model.security.OptTreeNode;
import com.centit.framework.security.SecurityContextUtils;
import com.centit.framework.system.dao.DataCatalogDao;
import com.centit.framework.system.dao.DataDictionaryDao;
import com.centit.framework.system.dao.OptDataScopeDao;
import com.centit.framework.system.dao.OptInfoDao;
import com.centit.framework.system.dao.OptMethodDao;
import com.centit.framework.system.dao.OsInfoDao;
import com.centit.framework.system.dao.RoleInfoDao;
import com.centit.framework.system.dao.RolePowerDao;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.dao.UnitRoleDao;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.dao.UserSettingDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.service.OptInfoManager;
import com.centit.framework.system.service.TenantPowerManage;
import com.centit.framework.system.service.TenantService;
import com.centit.framework.system.service.UserPlatService;
import com.centit.framework.system.service.WorkGroupManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="platformEnvironment")
public class DBPlatformEnvironment
implements PlatformEnvironment {
    public static final Logger logger = LoggerFactory.getLogger(DBPlatformEnvironment.class);
    public static final String SYSTEM = "system";
    @Value(value="${userinfo.password.expired_days:183}")
    protected int passwordExpiredDays;
    @Autowired
    private CentitPasswordEncoder passwordEncoder;
    @Autowired
    protected OptDataScopeDao dataScopeDao;
    @Autowired
    private UserSettingDao userSettingDao;
    @Autowired
    private OsInfoDao osInfoDao;
    @Autowired
    private OptInfoDao optInfoDao;
    @Autowired
    private UserInfoDao userInfoDao;
    @Autowired
    private DataDictionaryDao dataDictionaryDao;
    @Autowired
    private DataCatalogDao dataCatalogDao;
    @Autowired
    private UserUnitDao userUnitDao;
    @Autowired
    private UnitInfoDao unitInfoDao;
    @Autowired
    private RoleInfoDao roleInfoDao;
    @Autowired
    private UserRoleDao userRoleDao;
    @Autowired
    private UnitRoleDao unitRoleDao;
    @Autowired
    private OptMethodDao optMethodDao;
    @Autowired
    private RolePowerDao rolePowerDao;
    @Autowired
    private OptInfoManager optInfoManager;
    @Autowired
    private WorkGroupManager workGroupManager;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private TenantPowerManage tenantPowerManage;
    @Autowired
    private UserPlatService userPlatService;

    public List<UserSetting> listUserSettings(String userCode) {
        return this.userSettingDao.getUserSettingsByCode(userCode);
    }

    @Transactional(readOnly=true)
    public UserSetting getUserSetting(String userCode, String paramCode) {
        return this.userSettingDao.getObjectById(new UserSettingId(userCode, paramCode));
    }

    @Transactional
    public void saveUserSetting(UserSetting userSetting) {
        if (StringUtils.equalsAny((CharSequence)userSetting.getParamCode(), (CharSequence[])new CharSequence[]{"regCellPhone", "idCardNo", "regEmail"})) {
            UserInfo ui = this.userInfoDao.getUserByCode(userSetting.getUserCode());
            if (ui == null) {
                return;
            }
            if ("regCellPhone".equals(userSetting.getParamCode())) {
                ui.setRegCellPhone(userSetting.getParamValue());
            } else if ("idCardNo".equals(userSetting.getParamCode())) {
                ui.setIdCardNo(userSetting.getParamValue());
            } else if ("regEmail".equals(userSetting.getParamCode())) {
                ui.setRegEmail(userSetting.getParamValue());
            }
            this.userInfoDao.updateUser(ui);
        } else if (StringUtils.isBlank((CharSequence)userSetting.getParamValue())) {
            this.userSettingDao.deleteObjectById(new UserSettingId(userSetting.getUserCode(), userSetting.getParamCode()));
        } else {
            UserSetting us = this.userSettingDao.getObjectById(new UserSettingId(userSetting.getUserCode(), userSetting.getParamCode()));
            if (us == null) {
                us = new UserSetting();
                us.copyFromUserSetting(userSetting);
                us.setCreateDate(DatetimeOpt.currentUtilDate());
                this.userSettingDao.saveNewUserSetting(us);
            } else {
                us.copyFromUserSetting(userSetting);
                this.userSettingDao.updateUserSetting(us);
            }
        }
    }

    private List<OptInfo> formatMenuTree(List<OptInfo> optInfos) {
        optInfos.sort((a, b) -> a.getOrderInd() == null && b.getOrderInd() == null ? 0 : (a.getOrderInd() == null ? 1 : (b.getOrderInd() == null ? -1 : Long.compare(a.getOrderInd(), b.getOrderInd()))));
        ArrayList<OptInfo> parentMenu = new ArrayList<OptInfo>();
        for (OptInfo optInfo : optInfos) {
            boolean getParent = false;
            for (OptInfo opt : optInfos) {
                if (!opt.getOptId().equals(optInfo.getPreOptId())) continue;
                opt.addChild(optInfo);
                getParent = true;
                break;
            }
            if (getParent) continue;
            parentMenu.add(optInfo);
        }
        return parentMenu;
    }

    private List<OptInfo> formatMenuTree(List<OptInfo> optInfos, String superOptId) {
        if (StringUtils.isEmpty((CharSequence)superOptId)) {
            return Collections.emptyList();
        }
        optInfos.sort((a, b) -> a.getOrderInd() == null && b.getOrderInd() == null ? 0 : (a.getOrderInd() == null ? 1 : (b.getOrderInd() == null ? -1 : Long.compare(a.getOrderInd(), b.getOrderInd()))));
        Iterator<OptInfo> menus = optInfos.iterator();
        OptInfo parentOpt = null;
        while (menus.hasNext()) {
            OptInfo optInfo = menus.next();
            if (StringUtils.equals((CharSequence)superOptId, (CharSequence)optInfo.getOptId())) {
                parentOpt = optInfo;
            }
            for (OptInfo opt : optInfos) {
                if (!opt.getOptId().equals(optInfo.getPreOptId())) continue;
                opt.addChild(optInfo);
            }
        }
        if (parentOpt != null) {
            return parentOpt.getChildren();
        }
        return Collections.emptyList();
    }

    @Transactional(readOnly=true)
    public List<OptInfo> listUserMenuOptInfosUnderSuperOptId(String userCode, String superOptId, boolean asAdmin) {
        OptInfo optInfo = this.optInfoDao.getObjectById(superOptId);
        String topOptId = "";
        if (optInfo != null) {
            topOptId = optInfo.getTopOptId();
        }
        List<OptInfo> preOpts = StringUtils.isNotBlank((CharSequence)topOptId) ? this.optInfoDao.listParentMenuFunc(topOptId) : this.optInfoDao.listParentMenuFunc();
        String optType = asAdmin ? "S" : "O";
        List<OptInfo> ls = this.optInfoDao.getMenuFuncByUserID(userCode, optType, topOptId);
        List<OptInfo> menuFunsByUser = DBPlatformEnvironment.getMenuFuncs(preOpts, ls);
        return this.formatMenuTree(menuFunsByUser, superOptId);
    }

    public List<OptInfo> listMenuOptInfosUnderOsId(String osId) {
        List<OptInfo> allOptsUnderOsId = this.optInfoDao.listAllOptInfoByTopOpt(osId);
        return this.formatMenuTree(allOptsUnderOsId, osId);
    }

    public OptInfo addOptInfo(OptInfo optInfo) {
        this.optInfoManager.saveNewOptInfo(optInfo);
        return optInfo;
    }

    public OptInfo updateOptInfo(OptInfo optInfo) {
        this.optInfoDao.updateOptInfo(optInfo);
        return optInfo;
    }

    @Transactional(readOnly=true)
    public List<UserRole> listUserRoles(String topUnit, String userCode) {
        return FVUserRoles.mapToUserRoles(this.userRoleDao.listUserRolesByTopUnit(topUnit, userCode));
    }

    @Transactional(readOnly=true)
    public List<UserRole> listRoleUsers(String topUnit, String roleCode) {
        return FVUserRoles.mapToUserRoles(this.userRoleDao.listRoleUsersByTopUnit(topUnit, roleCode));
    }

    @Transactional(readOnly=true)
    public List<UnitRole> listUnitRoles(String unitCode) {
        return this.unitRoleDao.listUnitRolesByUnitCode(unitCode);
    }

    @Transactional(readOnly=true)
    public List<UnitRole> listRoleUnits(String roleCode) {
        return this.unitRoleDao.listUnitRolesByRoleCode(roleCode);
    }

    @Transactional
    public void changeUserPassword(String userCode, String userPassword) {
        UserInfo user = this.userInfoDao.getUserByCode(userCode);
        user.setUserPin(this.passwordEncoder.encodePassword(userPassword, (Object)user.getUserCode()));
        user.setPwdExpiredTime(DatetimeOpt.addDays((Date)DatetimeOpt.currentUtilDate(), (int)this.passwordExpiredDays));
        this.userInfoDao.updateUser(user);
    }

    @Transactional(readOnly=true)
    public boolean checkUserPassword(String userCode, String userPassword) {
        UserInfo user = this.userInfoDao.getUserByCode(userCode);
        return this.passwordEncoder.isPasswordValid(user.getUserPin(), userPassword, (Object)user.getUserCode());
    }

    @Transactional(readOnly=true)
    public List<UserInfo> listAllUsers(String topUnit) {
        return this.userInfoDao.listObjects(CollectionsOpt.createHashMap((Object[])new Object[]{"topUnit", topUnit}));
    }

    @Transactional(readOnly=true)
    public List<UnitInfo> listAllUnits(String topUnit) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("topUnit", topUnit);
        return this.unitInfoDao.listObjectsByProperties(filterMap);
    }

    @Transactional(readOnly=true)
    public List<UserUnit> listAllUserUnits(String topUnit) {
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("topUnit", topUnit);
        return this.userUnitDao.listObjectsAll(filterMap);
    }

    public List<UnitInfo> listUserTopUnits(String userCode) {
        return this.unitInfoDao.listUserTopUnits(userCode);
    }

    @Transactional(readOnly=true)
    public List<UserUnit> listUserUnits(String topUnit, String userCode) {
        return this.userUnitDao.listUserUnitsByUserCode(topUnit, userCode);
    }

    @Transactional(readOnly=true)
    public List<UserUnit> listUnitUsers(String unitCode) {
        return this.userUnitDao.listUnitUsersByUnitCode(unitCode);
    }

    @Transactional(readOnly=true)
    public List<RoleInfo> listAllRoleInfo(String topUnit) {
        return this.roleInfoDao.listAllRoleByUnit(topUnit);
    }

    @Transactional(readOnly=true)
    public List<RolePower> listAllRolePower(String topUnit) {
        return this.rolePowerDao.listAllRolePowerByUnit(topUnit);
    }

    @Transactional(readOnly=true)
    public List<OptInfo> listAllOptInfo(String topUnit) {
        return this.optInfoDao.listAllOptInfoByUnit(topUnit);
    }

    public List<OptInfo> listOptInfoByRole(String roleCode) {
        return this.optInfoDao.listOptInfoByRoleCode(roleCode);
    }

    @Transactional(readOnly=true)
    public List<OptMethod> listAllOptMethod(String topUnit) {
        return this.optMethodDao.listAllOptMethodByUnit(topUnit);
    }

    public List<OptMethod> listOptMethodByRoleCode(String roleCode) {
        return this.optMethodDao.listOptMethodByRoleCode(roleCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public OptMethod addOptMethod(OptMethod optMethod) {
        this.optMethodDao.saveNewObject((Serializable)optMethod);
        return optMethod;
    }

    @Transactional(rollbackFor={Exception.class})
    public OptMethod mergeOptMethod(OptMethod optMethod) {
        this.optMethodDao.mergeObject((Serializable)optMethod);
        return optMethod;
    }

    public List<OptDataScope> listAllOptDataScope(String topUnit) {
        return this.dataScopeDao.listAllDataScopeByUnit(topUnit);
    }

    @Transactional(readOnly=true)
    public List<DataCatalog> listAllDataCatalogs(String topUnit) {
        return this.dataCatalogDao.listDataCatalogByUnit(topUnit);
    }

    @Transactional(readOnly=true)
    public List<DataDictionary> listDataDictionaries(String catalogCode) {
        return this.dataDictionaryDao.listDataDictionary(catalogCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteDataDictionary(String catalogCode) {
        this.dataDictionaryDao.deleteDictionary(catalogCode);
        this.dataCatalogDao.deleteObjectById(catalogCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public int[] updateOptIdByOptCodes(String optId, List<String> optCodes) {
        return this.optMethodDao.updateOptIdByOptCodes(optId, optCodes);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteOptInfoByOptId(String optId) {
        if (StringUtils.isBlank((CharSequence)optId)) {
            return false;
        }
        this.optInfoManager.deleteOptInfoById(optId);
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteOptMethod(String optCode) {
        if (StringUtils.isBlank((CharSequence)optCode)) {
            return;
        }
        this.optMethodDao.deleteOptMethodById(optCode);
        this.rolePowerDao.deleteRolePowersByOptCode(optCode);
    }

    private CentitUserDetails fillUserDetailsField(UserInfo userinfo) {
        List<UserUnit> userUnits = this.userUnitDao.listUserUnitsByUserCode(userinfo.getUserCode());
        String currentUnitCode = userinfo.getPrimaryUnit();
        CentitUserDetails userDetails = new CentitUserDetails();
        userDetails.setUserInfo(userinfo);
        userDetails.setUserUnits(userUnits);
        if (StringUtils.isNotBlank((CharSequence)userinfo.getCurrentStationId())) {
            for (UserUnit uu : userUnits) {
                if (!userinfo.getCurrentStationId().equals(uu.getUserUnitId())) continue;
                userDetails.setCurrentStationId(uu.getUserUnitId());
                currentUnitCode = uu.getUnitCode();
                break;
            }
        }
        if (StringUtils.isBlank((CharSequence)userDetails.getCurrentStationId())) {
            for (UserUnit uu : userUnits) {
                if (!"T".equals(uu.getRelType()) || !StringUtils.equals((CharSequence)userinfo.getTopUnit(), (CharSequence)uu.getTopUnit())) continue;
                userDetails.setCurrentStationId(uu.getUserUnitId());
                currentUnitCode = uu.getUnitCode();
                break;
            }
        }
        ArrayList<RoleInfo> roles = new ArrayList<RoleInfo>();
        roles.add(new RoleInfo("publicsystem", "general public", "G", SYSTEM, "T", "general public"));
        roles.add(new RoleInfo("public" + userinfo.getTopUnit(), "topunit public", "G", userinfo.getTopUnit(), "T", "topunit public"));
        List<FVUserRoles> userRolesList = this.userRoleDao.listUserRolesByTopUnit(userinfo.getTopUnit(), userinfo.getUserCode());
        if (userRolesList != null) {
            for (FVUserRoles role : userRolesList) {
                roles.add(role.toRoleInfo());
            }
        }
        this.appendAdminRoles(userinfo, roles);
        userDetails.mapAuthoritiesByRoles(roles);
        List<OptMethod> publicOptMethod = this.optMethodDao.listPublicOptMethodByUnit(userinfo.getTopUnit());
        HashMap<String, String> userOptList = new HashMap<String, String>();
        if (publicOptMethod != null) {
            for (OptMethod opt : publicOptMethod) {
                if (StringUtils.isBlank((CharSequence)opt.getOptMethod())) continue;
                userOptList.put(opt.getOptCode(), opt.getOptName());
            }
        }
        if (userRolesList != null && userRolesList.size() > 0) {
            String[] userRole = new String[userRolesList.size()];
            for (int i = 0; i < userRolesList.size(); ++i) {
                userRole[i] = userRolesList.get(i).getRoleCode();
            }
            List<OptMethod> userOptMethod = this.optMethodDao.listUserOptMethodByRoleCode(userRole);
            if (userOptMethod != null) {
                for (OptMethod opt : userOptMethod) {
                    if (StringUtils.isBlank((CharSequence)opt.getOptMethod())) continue;
                    userOptList.put(opt.getOptCode(), opt.getOptName());
                }
            }
        }
        userDetails.setUserOptList(userOptList);
        List<UserSetting> uss = this.userSettingDao.getUserSettingsByCode(userinfo.getUserCode());
        if (uss != null) {
            for (UserSetting us : uss) {
                userDetails.putUserSettingsParams(us.getParamCode(), us.getParamValue());
            }
        }
        userDetails.setTopUnitCode(userinfo.getTopUnit());
        UnitInfo currentUnit = null;
        if (StringUtils.isNotBlank((CharSequence)currentUnitCode) && null != (currentUnit = this.unitInfoDao.getObjectById(currentUnitCode))) {
            userDetails.setCurrentUnitName(currentUnit.getUnitName());
            userDetails.getUserInfo().setPrimaryUnit(currentUnit.getUnitCode());
        }
        if (StringUtils.isBlank((CharSequence)userDetails.getTopUnitCode())) {
            UnitInfo topUnit;
            if (currentUnit != null) {
                userDetails.setTopUnitCode(currentUnit.getTopUnit());
            }
            if (!StringUtils.isBlank((CharSequence)userDetails.getTopUnitCode()) && null != (topUnit = this.unitInfoDao.getObjectById(userDetails.getTopUnitCode()))) {
                userDetails.setTopUnitName(topUnit.getUnitName());
            }
        } else {
            UnitInfo ui = this.unitInfoDao.getObjectById(userDetails.getTopUnitCode());
            if ("all".equals(userDetails.getTopUnitCode())) {
                ui = this.unitInfoDao.getObjectById(currentUnitCode);
            }
            if (null != ui) {
                userDetails.setTopUnitName(ui.getUnitName());
            }
        }
        return userDetails;
    }

    private void appendAdminRoles(UserInfo userInfo, List<RoleInfo> roles) {
        String topUnit = userInfo.getTopUnit();
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            return;
        }
        if (this.tenantPowerManage.userIsTenantOwner(userInfo.getUserCode(), topUnit)) {
            if (SYSTEM.equals(topUnit)) {
                roles.add(new RoleInfo("platadmin", "\u5e73\u53f0\u7ba1\u7406\u5458", "G", topUnit, "T", "\u5e73\u53f0\u7ba1\u7406\u5458"));
            }
            roles.add(new RoleInfo("tenantadmin", "\u79df\u6237\u7ba1\u7406\u5458", "G", topUnit, "T", "\u79df\u6237\u7ba1\u7406\u5458"));
            return;
        }
        List<WorkGroup> adminRols = this.workGroupManager.listWorkGroup(topUnit, userInfo.getUserCode(), null);
        if (null == adminRols || adminRols.isEmpty()) {
            return;
        }
        int admin = 0;
        for (WorkGroup workGroup : adminRols) {
            if ("ZHGLY".equals(workGroup.getRoleCode())) {
                admin = 2;
                continue;
            }
            if (!"orgadmin".equals(workGroup.getRoleCode())) continue;
            admin = 1;
            topUnit = workGroup.getRunToken();
        }
        if (admin == 2) {
            if (SYSTEM.equals(topUnit)) {
                roles.add(new RoleInfo("platadmin", "\u5e73\u53f0\u7ba1\u7406\u5458", "G", topUnit, "T", "\u5e73\u53f0\u7ba1\u7406\u5458"));
            }
            roles.add(new RoleInfo("tenantadmin", "\u79df\u6237\u7ba1\u7406\u5458", "G", topUnit, "T", "\u79df\u6237\u7ba1\u7406\u5458"));
        } else if (admin == 1) {
            roles.add(new RoleInfo("orgadmin", "\u7ec4\u7ec7\u7ba1\u7406\u5458", "G", topUnit, "T", "\u7ec4\u7ec7\u7ba1\u7406\u5458"));
        }
    }

    @Transactional
    public CentitUserDetails loadUserDetailsByLoginName(String loginName) {
        UserInfo userinfo = this.userInfoDao.getUserByLoginName(loginName);
        if (userinfo == null) {
            return null;
        }
        return this.fillUserDetailsField(userinfo);
    }

    @Transactional
    public CentitUserDetails loadUserDetailsByUserCode(String userCode) {
        UserInfo userinfo = this.userInfoDao.getUserByCode(userCode);
        if (userinfo == null) {
            return null;
        }
        return this.fillUserDetailsField(userinfo);
    }

    public UnitInfo loadUnitInfo(String unitCode) {
        return this.unitInfoDao.getObjectById(unitCode);
    }

    public UserInfo getUserInfoByIdCardNo(String idCardNo) {
        return this.userInfoDao.getUserByIdCardNo(idCardNo);
    }

    public UserInfo getUserInfoByUserWord(String userWord) {
        return this.userInfoDao.getUserByUserWord(userWord);
    }

    @Transactional
    public CentitUserDetails loadUserDetailsByRegEmail(String regEmail) {
        UserInfo userinfo = this.userInfoDao.getUserByRegEmail(regEmail);
        if (userinfo == null) {
            return null;
        }
        return this.fillUserDetailsField(userinfo);
    }

    @Transactional
    public CentitUserDetails loadUserDetailsByRegCellPhone(String regCellPhone) {
        UserInfo userinfo = this.userInfoDao.getUserByRegCellPhone(regCellPhone);
        if (userinfo == null) {
            return null;
        }
        return this.fillUserDetailsField(userinfo);
    }

    @Transactional
    public void updateUserInfo(UserInfo userInfo) {
        UserInfo ui = this.userInfoDao.getUserByCode(userInfo.getUserCode());
        if (ui == null) {
            return;
        }
        ui.copyFromUserInfo(userInfo);
        this.userInfoDao.updateUser(ui);
    }

    @Transactional
    public void saveUserLoginInfo(UserInfo userInfo) {
        this.userInfoDao.saveUserLoginInfo(userInfo);
    }

    public static List<OptInfo> getMenuFuncs(List<OptInfo> preOpts, List<OptInfo> ls) {
        int i;
        boolean[] isNeeds = new boolean[preOpts.size()];
        for (int i2 = 0; i2 < preOpts.size(); ++i2) {
            isNeeds[i2] = false;
        }
        ArrayList<OptInfo> opts = new ArrayList<OptInfo>();
        block1: for (OptInfo opt : ls) {
            opts.add(opt);
            for (i = 0; i < preOpts.size(); ++i) {
                if (opt.getPreOptId() == null || !opt.getPreOptId().equals(preOpts.get(i).getOptId())) continue;
                isNeeds[i] = true;
                continue block1;
            }
        }
        ArrayList<OptInfo> needAdd = new ArrayList<OptInfo>();
        for (int i3 = 0; i3 < preOpts.size(); ++i3) {
            if (!isNeeds[i3]) continue;
            needAdd.add(preOpts.get(i3));
        }
        boolean[] isNeeds2 = new boolean[preOpts.size()];
        block4: while (true) {
            int i4;
            int nestedMenu = 0;
            for (i4 = 0; i4 < preOpts.size(); ++i4) {
                isNeeds2[i4] = false;
            }
            block6: for (i4 = 0; i4 < needAdd.size(); ++i4) {
                for (int j = 0; j < preOpts.size(); ++j) {
                    if (isNeeds[j] || ((OptInfo)needAdd.get(i4)).getPreOptId() == null || !((OptInfo)needAdd.get(i4)).getPreOptId().equals(preOpts.get(j).getOptId())) continue;
                    isNeeds[j] = true;
                    isNeeds2[j] = true;
                    ++nestedMenu;
                    continue block6;
                }
            }
            if (nestedMenu == 0) break;
            needAdd.clear();
            i4 = 0;
            while (true) {
                if (i4 >= preOpts.size()) continue block4;
                if (isNeeds2[i4]) {
                    needAdd.add(preOpts.get(i4));
                }
                ++i4;
            }
            break;
        }
        for (i = 0; i < preOpts.size(); ++i) {
            if (!isNeeds[i]) continue;
            opts.add(preOpts.get(i));
        }
        return opts;
    }

    public static List<OptInfo> getFormatMenuTree(List<OptInfo> optInfos) {
        DBPlatformEnvironment dbPlatformEnvironment = new DBPlatformEnvironment();
        List<OptInfo> opts = dbPlatformEnvironment.formatMenuTree(optInfos);
        return opts;
    }

    public List<OsInfo> listOsInfos(String topUnit) {
        return this.osInfoDao.listOsInfoByUnit(topUnit);
    }

    public OsInfo getOsInfo(String osId) {
        return (OsInfo)this.osInfoDao.getObjectById(osId);
    }

    public OsInfo deleteOsInfo(String osId) {
        OsInfo osInfo = (OsInfo)this.osInfoDao.getObjectById(osId);
        if (osInfo != null) {
            this.osInfoDao.deleteObjectById(osId);
        }
        return osInfo;
    }

    public OsInfo updateOsInfo(OsInfo osInfo) {
        OsInfo osInfo1 = (OsInfo)this.osInfoDao.getObjectById(osInfo.getOsId());
        osInfo.setTopUnit(osInfo1.getTopUnit());
        this.osInfoDao.updateObject((Serializable)osInfo);
        return osInfo;
    }

    @Transactional(rollbackFor={Exception.class})
    public OsInfo addOsInfo(OsInfo osInfo) {
        this.osInfoDao.saveNewObject((Serializable)osInfo);
        return osInfo;
    }

    public List<WorkGroup> listWorkGroup(String groupId, String userCode, String roleCode) {
        return this.workGroupManager.listWorkGroup(groupId, userCode, roleCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchSaveWorkGroup(List<WorkGroup> workGroups) {
        this.workGroupManager.batchWorkGroup(workGroups);
    }

    public List<ConfigAttribute> getRolesWithApiId(String apiId) {
        List<RolePower> rolePowers = this.rolePowerDao.listRolePowerUseApiId(apiId);
        ArrayList<ConfigAttribute> roles = new ArrayList<ConfigAttribute>();
        for (RolePower rp : rolePowers) {
            this.dealRolePower(roles, rp);
        }
        Collections.sort(roles, Comparator.comparing(ConfigAttribute::getAttribute));
        return roles;
    }

    public OptTreeNode getSysOptTree() {
        HashMap<String, ArrayList<ConfigAttribute>> optMethodRoleMap = new HashMap<String, ArrayList<ConfigAttribute>>(100);
        List<RolePower> rolePowers = this.rolePowerDao.listSysRolePower();
        if (rolePowers == null || rolePowers.size() == 0) {
            return null;
        }
        for (RolePower rp : rolePowers) {
            ArrayList<ConfigAttribute> roles = (ArrayList<ConfigAttribute>)optMethodRoleMap.get(rp.getOptCode());
            if (roles == null) {
                roles = new ArrayList<ConfigAttribute>();
            }
            this.dealRolePower(roles, rp);
            optMethodRoleMap.put(rp.getOptCode(), roles);
        }
        OptTreeNode optTreeNode = new OptTreeNode();
        List<OptMethod> OptMethods = this.optMethodDao.listAllOptMethodByUnit(SYSTEM);
        for (OptMethod ou : OptMethods) {
            if (ou == null || !StringUtils.isNotBlank((CharSequence)ou.getOptUrl()) || !StringUtils.isNotBlank((CharSequence)ou.getOptReq())) continue;
            List sOpt = optTreeNode.parsePowerDefineUrl(ou.getOptUrl(), ou.getOptReq());
            for (List surls : sOpt) {
                OptTreeNode opt = optTreeNode;
                for (String surl : surls) {
                    opt = opt.setChildPath(surl);
                }
                List roles = (List)optMethodRoleMap.get(ou.getOptCode());
                opt.addRoleList(roles);
            }
        }
        return optTreeNode;
    }

    private void dealRolePower(List<ConfigAttribute> roles, RolePower rp) {
        if (SecurityContextUtils.PUBLIC_ROLE_CODE.equalsIgnoreCase(rp.getRoleCode())) {
            roles.add((ConfigAttribute)new CentitSecurityConfig("R_" + StringUtils.trim((String)rp.getRoleCode()) + rp.getTopUnit()));
        } else if (SecurityContextUtils.ANONYMOUS_ROLE_CODE.equalsIgnoreCase(rp.getRoleCode())) {
            roles.add((ConfigAttribute)new CentitSecurityConfig(SecurityContextUtils.SPRING_ANONYMOUS_ROLE_CODE));
        } else {
            roles.add((ConfigAttribute)new CentitSecurityConfig("R_" + StringUtils.trim((String)rp.getRoleCode())));
        }
    }

    public JSONObject getTenantInfoByTopUnit(String topUnit) {
        TenantInfo tenantInfo = this.tenantService.getTenantInfo(topUnit);
        if (null == tenantInfo) {
            return null;
        }
        String ownUserName = CodeRepositoryUtil.getUserName((String)topUnit, (String)tenantInfo.getOwnUser());
        JSONObject jsonObject = JSONObject.from((Object)tenantInfo);
        jsonObject.put((Object)"ownUserName", (Object)ownUserName);
        int unitCount = this.unitInfoDao.countUnitByTopUnit(topUnit);
        int userCount = this.userUnitDao.countUserByTopUnit(topUnit);
        int osCount = this.osInfoDao.countOsInfoByTopUnit(topUnit);
        jsonObject.put((Object)"unitCount", (Object)unitCount);
        jsonObject.put((Object)"userCount", (Object)userCount);
        jsonObject.put((Object)"osCount", (Object)osCount);
        return jsonObject;
    }

    public JSONObject fetchUserTenantGroupInfo(String userCode, String topUnit) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"tenantRole", (Object)this.tenantPowerManage.userTenantRole(userCode, topUnit));
        JSONArray userTenants = this.tenantService.userTenants(userCode);
        jsonObj.put((Object)"userTenants", (Object)userTenants);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("userCode", userCode);
        List<UserPlat> userPlats = this.userPlatService.listObjects(paramsMap, null);
        jsonObj.put((Object)"userPlats", userPlats != null && !userPlats.isEmpty() ? userPlats : new ArrayList());
        return jsonObj;
    }
}

