/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.model.basedata.DataCatalog;
import com.centit.framework.model.basedata.DataDictionary;
import com.centit.framework.model.basedata.DataDictionaryId;
import com.centit.framework.system.dao.DataCatalogDao;
import com.centit.framework.system.dao.DataDictionaryDao;
import com.centit.framework.system.service.DataDictionaryManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.utils.PageDesc;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dataDictionaryManager")
public class DataDictionaryManagerImpl
implements DataDictionaryManager {
    protected Logger logger = LoggerFactory.getLogger(DataDictionaryManagerImpl.class);
    @Autowired
    @NotNull
    private DataDictionaryDao dictionaryDao;
    @Autowired
    @NotNull
    protected DataCatalogDao dataCatalogDao;

    @Override
    @Transactional
    public List<DataDictionary> getDataDictionary(String catalogCode) {
        this.logger.info("\u7f13\u5b58\u6570\u636e\u5b57\u5178  DataDictionary \uff1a" + catalogCode + " ......");
        return this.dictionaryDao.listDataDictionary(catalogCode);
    }

    @Override
    @Transactional
    public DataCatalog getCatalogIncludeDataPiece(String catalogCode) {
        DataCatalog dc = this.dataCatalogDao.getObjectById(catalogCode);
        dc.addAllDataPiece(this.dictionaryDao.listDataDictionary(catalogCode));
        return dc;
    }

    @Override
    @Transactional
    public List<DataDictionary> saveCatalogIncludeDataPiece(DataCatalog dataCatalog) {
        List newData;
        List<DataDictionary> oldData = this.dictionaryDao.listDataDictionary(dataCatalog.getCatalogCode());
        Triple dbOptList = CollectionsOpt.compareTwoList(oldData, (List)(newData = dataCatalog.getDataDictionaries()), Comparator.comparing(DataDictionary::getDataCode));
        if (dbOptList.getRight() != null) {
            for (DataDictionary dp : (List)dbOptList.getRight()) {
                this.dictionaryDao.deleteObject((Serializable)dp);
            }
        }
        if (dbOptList.getLeft() != null) {
            for (DataDictionary dp : (List)dbOptList.getLeft()) {
                this.dictionaryDao.saveNewObject((Serializable)dp);
            }
        }
        if (null != dbOptList.getMiddle()) {
            for (Pair updateDp : (List)dbOptList.getMiddle()) {
                DataDictionary oldD = (DataDictionary)updateDp.getLeft();
                DataDictionary newD = (DataDictionary)updateDp.getRight();
                this.dictionaryDao.updateDictionary(newD);
            }
        }
        CodeRepositoryCache.evictCache((String)"DataCatalog");
        CodeRepositoryCache.evictCache((String)"DataDictionary", (String)dataCatalog.getCatalogCode());
        return oldData;
    }

    @Override
    @Transactional
    public void deleteDataDictionary(String catalogCode) {
        this.dictionaryDao.deleteDictionary(catalogCode);
        this.dataCatalogDao.deleteObjectById(catalogCode);
        CodeRepositoryCache.evictCache((String)"DataDictionary", (String)catalogCode);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteDataDictionaryPiece(DataDictionaryId dd) {
        this.dictionaryDao.deleteObjectById(dd);
        CodeRepositoryCache.evictCache((String)"DataDictionary", (String)dd.getCatalogCode());
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void saveDataDictionaryPiece(DataDictionary dd) {
        this.dictionaryDao.mergeObject((Serializable)dd);
        CodeRepositoryCache.evictCache((String)"DataDictionary", (String)dd.getCatalogCode());
    }

    @Override
    public String[] getFieldsDesc(String sDesc, String sType) {
        String[] nRes = new String[]{"\u6570\u636e\u4ee3\u7801", "\u6269\u5c55\u4ee3\u7801(\u7236\u4ee3\u7801)", "\u6269\u5c55\u4ee3\u78012(\u81ea\u5b9a\u4e49)", "\u6807\u8bb0", "\u6570\u503c", "\u7c7b\u578b", "\u6570\u636e\u63cf\u8ff0"};
        if ("T".equals(sType)) {
            nRes[1] = "\u4e0a\u7ea7\u4ee3\u7801";
        }
        if (sDesc == null || "".equals(sDesc)) {
            return nRes;
        }
        String[] s = StringUtils.split((String)sDesc, (char)';');
        if (s == null) {
            return nRes;
        }
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            int p = s[i].indexOf(58);
            nRes[i] = p > 1 ? s[i].substring(0, p) : s[i];
        }
        return nRes;
    }

    @Override
    @Transactional
    public DataDictionary getDataDictionaryPiece(DataDictionaryId id) {
        return this.dictionaryDao.getObjectById(id);
    }

    @Override
    @Transactional
    public List<DataCatalog> listFixDataCatalog() {
        return this.dataCatalogDao.listFixCatalog();
    }

    @Override
    @Transactional
    @Deprecated
    public List<DataCatalog> listSysDataCatalog() {
        return this.dataCatalogDao.listSysCatalog();
    }

    @Override
    @Transactional
    public List<DataCatalog> listUserDataCatalog() {
        return this.dataCatalogDao.listUserCatalog();
    }

    @Override
    @Transactional
    public List<DataCatalog> listAllDataCatalog(Map<String, Object> filterMap) {
        return this.dataCatalogDao.listObjectsByProperties(filterMap);
    }

    @Override
    @Transactional
    public List<DataDictionary> listDataDictionarys(Map<String, Object> filterDescMap) {
        return this.dictionaryDao.listObjectsByProperties(filterDescMap);
    }

    @Override
    @Transactional
    public List<DataDictionary> getWholeDictionary(Collection<String> catalogCodes) {
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("catalogcodes", CollectionsOpt.listToArray(catalogCodes));
        return this.dictionaryDao.getWholeDictionary(filterMap);
    }

    @Override
    @Transactional
    public DataCatalog getObjectById(String catalogCode) {
        return this.dataCatalogDao.getObjectById(catalogCode);
    }

    @Override
    @Transactional
    public int existCatalogName(String catalogName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("catalogName", catalogName);
        return this.dataCatalogDao.countObjectByProperties(map);
    }

    @Override
    @Transactional
    public void updateCatalog(DataCatalog dataCatalog) {
        this.dataCatalogDao.updateCatalog(dataCatalog);
    }

    @Override
    @Transactional
    public void saveNewObject(DataCatalog dataCatalog) {
        this.dataCatalogDao.saveNewObject((Serializable)dataCatalog);
    }

    @Override
    @Transactional
    public List<DataCatalog> listObjects(Map<String, Object> filterDescMap, PageDesc pageDesc) {
        return this.dataCatalogDao.listObjectsByProperties(filterDescMap, pageDesc);
    }

    @Override
    @Transactional
    public JSONArray appendRelativeOsInfo(List<DataCatalog> catalogList) {
        if (catalogList == null || catalogList.size() == 0) {
            return null;
        }
        JSONArray jsonArray = JSONArray.from(catalogList);
        for (Object obj : jsonArray) {
            JSONObject jsonObject;
            String catalogId;
            String sqlSen;
            JSONArray osList;
            if (!(obj instanceof JSONObject) || (osList = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.dataCatalogDao, (String)(sqlSen = "select a.OS_ID, a.OS_NAME from m_application_dictionary b join F_OS_INFO a on (b.os_id = a.os_id) where b.dictionary_id = ?"), (Object[])new Object[]{catalogId = (jsonObject = (JSONObject)obj).getString("catalogCode")})) == null) continue;
            jsonObject.put((Object)"relativeOs", (Object)osList);
        }
        return jsonArray;
    }
}

