/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.model.basedata.OptDataScope;
import com.centit.framework.model.basedata.OptInfo;
import com.centit.framework.model.basedata.OptMethod;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.framework.system.dao.OptDataScopeDao;
import com.centit.framework.system.dao.OptInfoDao;
import com.centit.framework.system.dao.OptMethodDao;
import com.centit.framework.system.dao.OsInfoDao;
import com.centit.framework.system.dao.RolePowerDao;
import com.centit.framework.system.service.OptInfoManager;
import com.centit.framework.system.service.impl.DBPlatformEnvironment;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.common.ObjectException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="functionManager")
public class OptInfoManagerImpl
implements OptInfoManager {
    @Autowired
    private OptInfoDao optInfoDao;
    @Autowired
    private OptMethodDao optMethodDao;
    @Autowired
    private OptDataScopeDao dataScopeDao;
    @Autowired
    private OsInfoDao osInfoDao;
    @Autowired
    private RolePowerDao rolePowerDao;

    @Override
    @Transactional
    public boolean hasChildren(String optId) {
        return this.optInfoDao.countObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"preOptId", optId})) > 0;
    }

    @Override
    @Transactional
    public List<OptDataScope> listAllDataScope() {
        return this.dataScopeDao.listAllDataScope();
    }

    private void checkOptInfoProperties(OptInfo optInfo, boolean checkDown) {
        boolean needUpdate;
        if (optInfo.getPreOptId() == null) {
            optInfo.setPreOptId("0");
        }
        if (StringUtils.isBlank((CharSequence)optInfo.getIsInToolbar())) {
            optInfo.setIsInToolbar("Y");
        }
        if (checkDown) {
            List<OptInfo> allSubOpts = this.findSubOptInfo(optInfo.getOptId());
            for (OptInfo o : allSubOpts) {
                needUpdate = false;
                if ("N".equals(optInfo.getIsInToolbar()) && !"N".equals(o.getIsInToolbar())) {
                    o.setIsInToolbar("N");
                    needUpdate = true;
                }
                if (!needUpdate) continue;
                this.optInfoDao.updateObject(new String[]{"isInToolbar"}, (Serializable)o);
            }
        }
        List<OptInfo> allPreOpts = this.findPreOptInfo(optInfo.getPreOptId());
        for (OptInfo o : allPreOpts) {
            needUpdate = false;
            if ("Y".equals(optInfo.getIsInToolbar()) && !"Y".equals(o.getIsInToolbar())) {
                o.setIsInToolbar("Y");
                needUpdate = true;
            }
            if (!needUpdate) continue;
            this.optInfoDao.updateObject(new String[]{"isInToolbar"}, (Serializable)o);
        }
        if (StringUtils.isBlank((CharSequence)optInfo.getPreOptId()) || "0".equalsIgnoreCase(optInfo.getPreOptId())) {
            optInfo.setPreOptId("0");
        } else {
            OptInfo parentOpt = this.optInfoDao.getObjectById(optInfo.getPreOptId());
            if (parentOpt == null) {
                optInfo.setPreOptId("0");
            } else {
                optInfo.setTopOptId(parentOpt.getTopOptId());
                if (StringUtils.isBlank((CharSequence)optInfo.getOsId())) {
                    optInfo.setOsId(parentOpt.getOsId());
                }
            }
        }
        OsInfo osInfo = null;
        if (StringUtils.isNotBlank((CharSequence)optInfo.getTopOptId())) {
            osInfo = this.osInfoDao.getOsInfoByRelOpt(optInfo.getTopOptId());
        }
        if (osInfo == null && StringUtils.isNotBlank((CharSequence)optInfo.getOsId())) {
            osInfo = (OsInfo)this.osInfoDao.getObjectById(optInfo.getOsId());
        }
        if (osInfo == null && StringUtils.isNotBlank((CharSequence)optInfo.getTopOptId())) {
            osInfo = (OsInfo)this.osInfoDao.getObjectById(optInfo.getTopOptId());
        }
        if (osInfo == null) {
            throw new ObjectException(604, "Data invalid, OSInfo is not found. TopOptId=" + optInfo.getTopOptId() + "\uff0cOS_ID=" + optInfo.getOsId());
        }
        optInfo.setTopOptId(StringUtils.isBlank((CharSequence)osInfo.getRelOptId()) ? osInfo.getOsId() : osInfo.getRelOptId());
        optInfo.setOsId(osInfo.getOsId());
    }

    @Override
    @Transactional
    public void saveNewOptInfo(OptInfo optInfo) {
        this.checkOptInfoProperties(optInfo, false);
        this.optInfoDao.saveNewObject((Serializable)optInfo);
        if (optInfo.getOptMethods() != null && optInfo.getOptMethods().size() > 0) {
            for (OptMethod o : optInfo.getOptMethods()) {
                o.setOptCode(this.optMethodDao.getNextOptCode());
                o.setOptId(optInfo.getOptId());
                this.optMethodDao.saveNewObject((Serializable)o);
            }
        }
        CodeRepositoryCache.evictCache((String)"OptInfo");
        CodeRepositoryCache.evictCache((String)"OptMethod");
    }

    @Override
    @Transactional
    public void updateOptInfo(OptInfo optInfo) {
        OptInfo dbOptInfo = this.optInfoDao.getObjectById(optInfo.getOptId());
        if (dbOptInfo == null) {
            return;
        }
        this.checkOptInfoProperties(optInfo, true);
        this.optInfoDao.updateOptInfo(optInfo);
        CodeRepositoryCache.evictCache((String)"OptInfo");
    }

    @Override
    @Transactional
    public void updateOperationPower(OptInfo optInfo) {
        List list;
        Triple compareMethod;
        this.optInfoDao.updateObject(new String[]{"formCode", "optRoute", "optUrl", "pageType"}, (Serializable)optInfo);
        List newOptMethods = optInfo.getOptMethods();
        List<OptMethod> oldOptMethods = this.optMethodDao.listOptMethodByOptID(optInfo.getOptId());
        if (newOptMethods == null || newOptMethods.size() < 1) {
            this.optMethodDao.deleteOptMethodsByOptID(optInfo.getOptId());
            if (CollectionUtils.isNotEmpty(oldOptMethods)) {
                for (OptMethod optMethod : oldOptMethods) {
                    this.rolePowerDao.deleteRolePowersByOptCode(optMethod.getOptCode());
                }
            }
        }
        if ((compareMethod = CollectionsOpt.compareTwoList(oldOptMethods, (List)newOptMethods, Comparator.comparing(OptMethod::getOptCode))).getRight() != null) {
            for (OptMethod optMethod : (List)compareMethod.getRight()) {
                this.optMethodDao.deleteObject((Serializable)optMethod);
                this.rolePowerDao.deleteRolePowersByOptCode(optMethod.getOptCode());
            }
        }
        if (compareMethod.getLeft() != null) {
            for (OptMethod optMethod : (List)compareMethod.getLeft()) {
                optMethod.setOptCode(this.optMethodDao.getNextOptCode());
                optMethod.setOptId(optInfo.getOptId());
                this.optMethodDao.saveNewObject((Serializable)optMethod);
            }
        }
        if (compareMethod.getMiddle() != null) {
            for (Pair pair : (List)compareMethod.getMiddle()) {
                this.optMethodDao.updateOptMethod((OptMethod)pair.getRight());
            }
        }
        if ((list = optInfo.getDataScopes()) == null || list.size() < 1) {
            this.dataScopeDao.deleteDataScopeOfOptID(optInfo.getOptId());
        } else {
            list.forEach(dataScope -> {
                if (StringUtils.isBlank((CharSequence)dataScope.getOptScopeCode())) {
                    dataScope.setOptScopeCode(this.dataScopeDao.getNextOptCode());
                }
            });
        }
        List<OptDataScope> oldDataScopes = this.dataScopeDao.getDataScopeByOptID(optInfo.getOptId());
        Triple compareScope = CollectionsOpt.compareTwoList(oldDataScopes, (List)list, Comparator.comparing(OptDataScope::getOptScopeCode));
        if (compareScope.getRight() != null) {
            for (OptDataScope optDataScope : (List)compareScope.getRight()) {
                this.dataScopeDao.deleteObject((Serializable)optDataScope);
            }
        }
        if (compareScope.getLeft() != null) {
            for (OptDataScope optDataScope : (List)compareScope.getLeft()) {
                optDataScope.setOptId(optInfo.getOptId());
                this.dataScopeDao.saveNewOPtDataScope(optDataScope);
            }
        }
        if (compareScope.getMiddle() != null) {
            for (Pair pair : (List)compareScope.getMiddle()) {
                this.dataScopeDao.updateOptDataScope((OptDataScope)pair.getRight());
            }
        }
        CodeRepositoryCache.evictCache((String)"OptInfo");
        CodeRepositoryCache.evictCache((String)"OptMethod");
    }

    @Override
    @Transactional
    public OptInfo getOptInfoById(String optId) {
        OptInfo oinfo = this.optInfoDao.getObjectById(optId);
        if (oinfo != null) {
            oinfo.addAllOptMethods(this.optMethodDao.listOptMethodByOptID(optId));
            oinfo.addAllDataScopes(this.dataScopeDao.getDataScopeByOptID(optId));
        }
        return oinfo;
    }

    @Override
    @Transactional
    public void deleteOptInfoById(String optId) {
        this.dataScopeDao.deleteDataScopeOfOptID(optId);
        this.optMethodDao.deleteOptMethodsByOptID(optId);
        this.optInfoDao.deleteObjectById(optId);
        String sql = "DELETE FROM f_rolepower WHERE OPT_CODE IN (SELECT OPT_CODE FROM f_optdef WHERE OPT_ID =?)";
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.optInfoDao, (String)sql, (Object[])new Object[]{optId});
        CodeRepositoryCache.evictCache((String)"RoleInfo");
        CodeRepositoryCache.evictCache((String)"RolePower");
        CodeRepositoryCache.evictCache((String)"OptInfo");
    }

    @Override
    @Transactional
    public int countSubOptInfo(String optId) {
        return this.optInfoDao.countObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"preOptId", optId}));
    }

    @Override
    @Transactional
    public List<OptInfo> listSysAndOptPowerOpts() {
        return this.optInfoDao.listMenuByTypes("S", "O");
    }

    @Override
    @Transactional
    public List<OptInfo> listItemPowerOpts() {
        return this.optInfoDao.listMenuByTypes("I");
    }

    @Override
    @Transactional
    public List<String> listUserDataFiltersByOptIdAndMethod(String sUserCode, String sOptId, String sOptMethod) {
        List<String> dataScopes = this.optInfoDao.listUserDataPowerByOptMethod(sUserCode, sOptId, sOptMethod);
        if (dataScopes == null || dataScopes.size() == 0) {
            return null;
        }
        HashSet<String> scopeCodes = new HashSet<String>();
        for (String scopes : dataScopes) {
            String[] codes;
            if (scopes == null || "null".equalsIgnoreCase(scopes) || "all".equalsIgnoreCase(scopes)) {
                return null;
            }
            for (String code : codes = scopes.split(",")) {
                if (code == null || "".equals(code.trim())) continue;
                scopeCodes.add(code.trim());
            }
        }
        if (scopeCodes.size() == 0) {
            return null;
        }
        return this.dataScopeDao.listDataFiltersByIds(scopeCodes);
    }

    @Override
    @Transactional
    public List<OptInfo> listObjectFormatTree(List<OptInfo> optInfos, boolean fillDefAndScope) {
        Iterator<OptInfo> menus = optInfos.iterator();
        ArrayList<OptInfo> parentMenu = new ArrayList<OptInfo>();
        while (menus.hasNext()) {
            OptInfo optInfo = menus.next();
            if (fillDefAndScope) {
                optInfo.addAllOptMethods(this.optMethodDao.listOptMethodByOptID(optInfo.getOptId()));
                optInfo.addAllDataScopes(this.dataScopeDao.getDataScopeByOptID(optInfo.getOptId()));
            }
            boolean getParent = false;
            for (OptInfo opt : optInfos) {
                if (!opt.getOptId().equals(optInfo.getPreOptId())) continue;
                opt.addChild(optInfo);
                getParent = true;
                break;
            }
            if (getParent) continue;
            parentMenu.add(optInfo);
        }
        return parentMenu;
    }

    @Override
    @Transactional
    public List<OptInfo> listOptWithPowerUnderUnit(String sUnitCode) {
        List<OptInfo> allOpts = this.optInfoDao.listMenuByTypes("S", "O");
        List<OptMethod> optDefs = this.optMethodDao.listOptMethodByRoleCode("G$" + sUnitCode);
        HashSet<OptInfo> roleOpts = new HashSet<OptInfo>();
        for (OptInfo optInfo : allOpts) {
            for (OptMethod def : optDefs) {
                if (!optInfo.getOptId().equals(def.getOptId())) continue;
                optInfo.addOptMethod(def);
            }
            if (optInfo.getOptMethods().size() <= 0) continue;
            optInfo.addAllDataScopes(this.dataScopeDao.getDataScopeByOptID(optInfo.getOptId()));
            roleOpts.add(optInfo);
        }
        HashSet<OptInfo> preParents = new HashSet<OptInfo>();
        preParents.addAll(roleOpts);
        while (true) {
            int parents = 0;
            HashSet<OptInfo> parentMenu = new HashSet<OptInfo>();
            block3: for (OptInfo optInfo : preParents) {
                for (OptInfo opt : allOpts) {
                    if (!opt.getOptId().equals(optInfo.getPreOptId())) continue;
                    parentMenu.add(opt);
                    roleOpts.add(opt);
                    ++parents;
                    continue block3;
                }
            }
            if (parents == 0) break;
            preParents = parentMenu;
        }
        ArrayList<OptInfo> roleOptInfos = new ArrayList<OptInfo>();
        roleOptInfos.addAll(roleOpts);
        return roleOptInfos;
    }

    @Override
    public List<OptInfo> listObjects() {
        return this.optInfoDao.listObjectsAll();
    }

    @Override
    public List<OptInfo> listObjects(Map<String, Object> filterMap) {
        return this.optInfoDao.listObjectsByProperties(filterMap);
    }

    @Override
    public OptInfo getObjectById(String optId) {
        return this.optInfoDao.getObjectById(optId);
    }

    private List<OptInfo> findSubOptInfo(String optId) {
        ArrayList<OptInfo> result = new ArrayList<OptInfo>();
        List<OptInfo> optInfos = this.optInfoDao.listObjectByParentOptid(optId);
        if (optInfos != null && optInfos.size() > 0) {
            result.addAll(optInfos);
            for (OptInfo o : optInfos) {
                result.addAll(this.findSubOptInfo(o.getOptId()));
            }
        }
        return result;
    }

    private List<OptInfo> findPreOptInfo(String preId) {
        ArrayList<OptInfo> result = new ArrayList<OptInfo>();
        OptInfo optInfo = this.optInfoDao.getObjectById(preId);
        if (optInfo != null) {
            result.add(optInfo);
            result.addAll(this.findPreOptInfo(optInfo.getPreOptId()));
        }
        return result;
    }

    @Override
    @Transactional
    public List<OptInfo> listUserAllPower(String userCode, boolean asAdmin) {
        List<OptInfo> preOpts = this.optInfoDao.listParentMenuFunc();
        String optType = asAdmin ? "S" : "O";
        List<OptInfo> ls = this.optInfoDao.listUserAllSubMenu(userCode, optType);
        List<OptInfo> menuFunsByUser = DBPlatformEnvironment.getMenuFuncs(preOpts, ls);
        return menuFunsByUser;
    }

    @Override
    public List<OptInfo> listFromParent(Map<String, Object> filterMap) {
        return this.optInfoDao.listFromParent(filterMap);
    }

    @Override
    public List<OptInfo> listAllOptInfoByUnit(String topUnit) {
        return this.optInfoDao.listAllOptInfoByUnit(topUnit);
    }

    @Override
    public List<OptInfo> listUserOptinfos(String topUnit, String userCode) {
        List<OptInfo> preOpts = this.optInfoDao.listParentMenuFunc();
        List<OptInfo> ls = StringUtils.isBlank((CharSequence)topUnit) || "all".equals(topUnit) ? this.optInfoDao.listUserAllSubMenu(userCode, "o") : this.optInfoDao.listUserOptinfos(topUnit, userCode);
        List<OptInfo> menuFunsByUser = DBPlatformEnvironment.getMenuFuncs(preOpts, ls);
        return DBPlatformEnvironment.getFormatMenuTree(menuFunsByUser);
    }
}

