/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.model.basedata.DataDictionary;
import com.centit.framework.model.basedata.UserSetting;
import com.centit.framework.model.basedata.UserSettingId;
import com.centit.framework.system.dao.DataDictionaryDao;
import com.centit.framework.system.dao.UserSettingDao;
import com.centit.framework.system.service.UserSettingManager;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserSettingManagerImpl
implements UserSettingManager {
    public static final Logger logger = LoggerFactory.getLogger(UserSettingManager.class);
    @Autowired
    private UserSettingDao userSettingDao;
    @Autowired
    private DataDictionaryDao dataDictionaryDao;

    @Override
    public List<UserSetting> getUserSettings(String userCode) {
        return this.userSettingDao.getUserSettingsByCode(userCode);
    }

    @Override
    public List<UserSetting> getUserSettings(String userCode, String optID) {
        return this.userSettingDao.getUserSettings(userCode, optID);
    }

    @Override
    public UserSetting getUserSetting(String userCode, String paramCode) {
        return this.userSettingDao.getObjectById(new UserSettingId(userCode, paramCode));
    }

    @Override
    @Transactional
    public void saveNewUserSetting(UserSetting userSetting) {
        userSetting.setCreateDate(new Date());
        this.userSettingDao.saveNewUserSetting(userSetting);
    }

    @Override
    @Transactional
    public void updateUserSetting(UserSetting userSetting) {
        this.userSettingDao.updateUserSetting(userSetting);
    }

    @Override
    @Transactional
    public void saveUserSetting(String userCode, String paramCode, String paramName, String paramValue, String optId) {
        UserSetting userSetting = new UserSetting(userCode, paramCode, paramValue, optId, paramName);
        this.userSettingDao.saveNewUserSetting(userSetting);
    }

    @Override
    public List<UserSetting> getAllSettings() {
        return this.userSettingDao.getAllSettings();
    }

    @Override
    public JSONArray listObjects(Map<String, Object> searchColumn, PageDesc pageDesc) {
        searchColumn.put("catalogCode", "userSettingKey");
        List dataDictionaries = this.dataDictionaryDao.listObjectsByProperties(searchColumn, pageDesc);
        JSONArray userSettings = new JSONArray(10);
        for (DataDictionary d : dataDictionaries) {
            JSONObject userSetting = new JSONObject();
            userSetting.put((Object)"paramCode", (Object)d.getDataCode());
            String value = this.userSettingDao.getValue(String.valueOf(searchColumn.get("userCode")), d.getDataCode());
            if ("".equals(value) || value == null) {
                userSetting.put((Object)"defaultValue", (Object)true);
                userSetting.put((Object)"paramValue", (Object)this.userSettingDao.getValue("default", d.getDataCode()));
            } else {
                userSetting.put((Object)"paramValue", (Object)value);
            }
            userSetting.put((Object)"userCode", (Object)StringBaseOpt.castObjectToString((Object)searchColumn.get("userCode")));
            userSetting.put((Object)"optId", (Object)d.getExtraCode2());
            userSetting.put((Object)"paramName", (Object)d.getDataValue());
            userSetting.put((Object)"showType", (Object)d.getDataTag());
            userSetting.put((Object)"typeValue", (Object)d.getExtraCode());
            userSetting.put((Object)"paramDesc", (Object)d.getDataDesc());
            userSettings.add((Object)userSetting);
        }
        return userSettings;
    }

    @Override
    @Transactional
    public List<UserSetting> listDefaultSettings(Map<String, Object> map, PageDesc pageDesc) {
        ArrayList<UserSetting> userSettings = new ArrayList<UserSetting>();
        map.put("catalogCode", "userSettingKey");
        List dataDictionaries = this.dataDictionaryDao.listObjectsByProperties(map, pageDesc);
        for (DataDictionary d : dataDictionaries) {
            UserSetting userSetting = new UserSetting(new UserSettingId("default", d.getDataCode()));
            userSetting.setParamValue(this.userSettingDao.getValue("default", d.getDataCode()));
            userSetting.setOptId(d.getExtraCode());
            userSetting.setParamName(d.getDataDesc());
            userSetting.setDefaultValue(true);
            userSettings.add(userSetting);
        }
        return userSettings;
    }

    @Override
    public List<UserSetting> listObjects(Map<String, Object> searchColumn) {
        return null;
    }

    @Override
    public UserSetting getObjectById(UserSettingId userSettingid) {
        return this.userSettingDao.getObjectById(userSettingid);
    }

    @Override
    public void deleteObject(UserSetting userSetting) {
        this.userSettingDao.deleteObject((Serializable)userSetting);
    }
}

