/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.model.basedata.OptDataScope;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.database.orm.OrmDaoUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="optDataScopeDao")
public class OptDataScopeDao
extends BaseDaoImpl<OptDataScope, String> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("optId", "EQUAL");
        filterField.put("optScopeCode", "EQUAL");
        filterField.put("scopeName", "LIKE");
        return filterField;
    }

    @Transactional
    public List<OptDataScope> listAllDataScope() {
        return this.listObjects();
    }

    @Transactional
    public List<OptDataScope> getDataScopeByOptID(String sOptID) {
        return this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", sOptID}));
    }

    @Transactional
    public void deleteDataScopeOfOptID(String sOptID) {
        this.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", sOptID}));
    }

    @Transactional
    public String getNextOptCode() {
        return UuidOpt.getUuidAsString22();
    }

    @Transactional
    public List<String> listDataFiltersByIds(Collection<String> scopeCodes) {
        List objs = this.listObjectsByFilter("WHERE OPT_SCOPE_CODE in (:optScopeCode)", CollectionsOpt.createHashMap((Object[])new Object[]{"optScopeCode", scopeCodes}));
        if (objs == null) {
            return null;
        }
        ArrayList<String> filters = new ArrayList<String>();
        for (OptDataScope scope : objs) {
            filters.add(scope.getFilterCondition());
        }
        return filters;
    }

    @Transactional
    public List<OptDataScope> listAllDataScopeByUnit(String topUnit) {
        String sql = "select o.* from F_OPTDATASCOPE o join F_OPTINFO a on ( o.OPT_ID = a.OPT_ID ) join F_OS_INFO b on(a.TOP_OPT_ID=b.REL_OPT_ID) where b.TOP_UNIT = ?";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)sql, (Object[])new Object[]{topUnit}, OptDataScope.class));
    }

    @Transactional
    public void updateOptDataScope(OptDataScope optDataScope) {
        super.updateObject((Serializable)optDataScope);
    }

    @Transactional
    public void saveNewOPtDataScope(OptDataScope optDataScope) {
        super.saveNewObject((Serializable)optDataScope);
    }
}

