/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.model.basedata.DataDictionary;
import com.centit.framework.model.basedata.FVUserRoles;
import com.centit.framework.model.basedata.RoleInfo;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.UserRole;
import com.centit.framework.model.basedata.UserRoleId;
import com.centit.framework.model.basedata.UserUnit;
import com.centit.framework.system.dao.RoleInfoDao;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.service.SysUserUnitManager;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.database.utils.PageDesc;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysUserUnitManager")
@Transactional
public class SysUserUnitManagerImpl
implements SysUserUnitManager {
    public static final Logger logger = LoggerFactory.getLogger(SysUserUnitManagerImpl.class);
    @Autowired
    @NotNull
    protected UserUnitDao userUnitDao;
    @Autowired
    private UnitInfoDao unitInfoDao;
    @Autowired
    @NotNull
    private UserInfoDao userInfoDao;
    @Autowired
    private UserRoleDao userRoleDao;
    @Autowired
    private RoleInfoDao roleInfoDao;

    @Override
    @Transactional(readOnly=true)
    public List<UserUnit> listObjectByUserUnit(String userCode, String unitCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", userCode);
        map.put("unitCode", unitCode);
        return this.userUnitDao.listObjectByUserUnit(userCode, unitCode);
    }

    private static boolean isMultiToMulti() {
        DataDictionary agencyMode = CodeRepositoryUtil.getDataPiece((String)"SYSPARAM", (String)"userUnitMode", null);
        if (agencyMode != null) {
            return "M".equalsIgnoreCase(agencyMode.getDataValue());
        }
        return true;
    }

    private void addUserRoleWhenNotExist(String userCode, String roleCodeOrName, List<FVUserRoles> userRoles) {
        if (StringUtils.isNotBlank((CharSequence)roleCodeOrName)) {
            RoleInfo roleInfo;
            boolean hasRole = false;
            for (FVUserRoles userRole : userRoles) {
                if (!userRole.getRoleCode().equals(roleCodeOrName) && (!"G".equals(userRole.getRoleType()) && !"P".equals(userRole.getRoleType()) || !userRole.getRoleName().equals(roleCodeOrName))) continue;
                hasRole = true;
            }
            if (!hasRole && (roleInfo = this.roleInfoDao.getRoleByCodeOrName(roleCodeOrName)) != null) {
                UserRole newUserRole = new UserRole(new UserRoleId(userCode, roleInfo.getRoleCode()), DatetimeOpt.currentUtilDate(), "\u6839\u636e\u7528\u6237\u5c97\u4f4d\u81ea\u52a8\u6388\u4e88");
                this.userRoleDao.saveNewObject((Serializable)newUserRole);
                FVUserRoles fvUserRoles = new FVUserRoles(userCode, roleInfo.getRoleCode());
                fvUserRoles.setRoleName(roleInfo.getRoleName());
                fvUserRoles.setRoleType(roleInfo.getRoleType());
                userRoles.add(fvUserRoles);
            }
        }
    }

    @Override
    public String saveNewUserUnit(UserUnit userunit) {
        UserUnit pUserUnit;
        if (!SysUserUnitManagerImpl.isMultiToMulti() && null != (pUserUnit = this.userUnitDao.getPrimaryUnitByUserId(userunit.getUserCode(), userunit.getTopUnit()))) {
            this.userUnitDao.deleteObjectById(pUserUnit.getUserUnitId());
        }
        if (StringBaseOpt.isNvl((String)userunit.getUserUnitId())) {
            userunit.setUserUnitId(UuidOpt.getUuidAsString22());
        }
        if ("T".equals(userunit.getRelType())) {
            UserInfo user;
            UserUnit origPrimUnit = this.userUnitDao.getPrimaryUnitByUserId(userunit.getUserCode(), userunit.getTopUnit());
            if (origPrimUnit != null) {
                origPrimUnit.setRelType("F");
                this.userUnitDao.updateUserUnit(origPrimUnit);
            }
            if ((user = this.userInfoDao.getUserByCode(userunit.getUserCode())) != null) {
                user.setPrimaryUnit(userunit.getUnitCode());
                user.setTopUnit(userunit.getTopUnit());
                user.setUserOrder(userunit.getUserOrder());
                this.userInfoDao.updateUser(user);
            }
        }
        if (StringUtils.isBlank((CharSequence)userunit.getTopUnit())) {
            Object[] unitCodeArray;
            UnitInfo unitInfo = this.unitInfoDao.getObjectById(userunit.getUnitCode());
            if (null != unitInfo && StringUtils.isNotBlank((CharSequence)unitInfo.getTopUnit())) {
                userunit.setTopUnit(unitInfo.getTopUnit());
            }
            if (null != unitInfo && StringUtils.isBlank((CharSequence)userunit.getTopUnit()) && StringUtils.isNotBlank((CharSequence)unitInfo.getUnitPath()) && ArrayUtils.isNotEmpty((Object[])(unitCodeArray = unitInfo.getUnitPath().split("/"))) && unitCodeArray.length > 1) {
                userunit.setTopUnit((String)unitCodeArray[1]);
            }
        }
        this.userUnitDao.saveNewObject((Serializable)userunit);
        List<FVUserRoles> userRoles = this.userRoleDao.listUserRolesByUserCode(userunit.getUserCode());
        DataDictionary dd = CodeRepositoryUtil.getDataPiece((String)"StationType", (String)userunit.getUserStation(), (String)userunit.getTopUnit());
        if (null != dd) {
            this.addUserRoleWhenNotExist(userunit.getUserCode(), dd.getExtraCode2(), userRoles);
        }
        if (null != (dd = CodeRepositoryUtil.getDataPiece((String)"RankType", (String)userunit.getUserRank(), (String)userunit.getTopUnit()))) {
            this.addUserRoleWhenNotExist(userunit.getUserCode(), dd.getExtraCode2(), userRoles);
        }
        CodeRepositoryCache.evictCache((String)"UserUnit");
        return userunit.getUserUnitId();
    }

    @Override
    public UserUnit getPrimaryUnitByUserCode(String userCode, String topUnit) {
        return this.userUnitDao.getPrimaryUnitByUserId(userCode, topUnit);
    }

    @Override
    public boolean hasUserStation(String stationCode, String userCode) {
        HashMap<String, String> filterDesc = new HashMap<String, String>();
        filterDesc.put("userStation", stationCode);
        filterDesc.put("userCode", userCode);
        return this.userUnitDao.countObjectByProperties(filterDesc) > 0;
    }

    @Override
    public void updateUserUnit(UserUnit userunit) {
        UserUnit origPrimUnit = this.userUnitDao.getPrimaryUnitByUserId(userunit.getUserCode(), userunit.getTopUnit());
        String relType = userunit.getRelType();
        if ("T".equals(relType)) {
            UserInfo user;
            if (origPrimUnit != null && !origPrimUnit.getUserUnitId().equals(userunit.getUserUnitId())) {
                origPrimUnit.setRelType("F");
                this.userUnitDao.updateUserUnit(origPrimUnit);
            }
            if ((user = this.userInfoDao.getUserByCode(userunit.getUserCode())) != null) {
                user.setPrimaryUnit(userunit.getUnitCode());
                user.setTopUnit(userunit.getTopUnit());
                user.setUserOrder(userunit.getUserOrder());
                this.userInfoDao.updateUser(user);
            }
        } else if (origPrimUnit != null && origPrimUnit.getUserUnitId().equals(userunit.getUserUnitId())) {
            userunit.setRelType("T");
        }
        this.userUnitDao.updateUserUnit(userunit);
        CodeRepositoryCache.evictCache((String)"UserUnit");
    }

    @Override
    public UserUnit getObjectById(String userUnitId) {
        return this.userUnitDao.getObjectById(userUnitId);
    }

    @Override
    public void deleteObject(UserUnit userUnit) {
        boolean canUpdate;
        this.userUnitDao.deleteObject((Serializable)userUnit);
        UserInfo user = this.userInfoDao.getUserByCode(userUnit.getUserCode());
        boolean bl = canUpdate = user != null && user.getCurrentStationId() != null && user.getCurrentStationId().equals(userUnit.getUserUnitId());
        if (canUpdate) {
            user.setPrimaryUnit("");
            user.setCurrentStationId("");
            this.userInfoDao.updateUser(user);
        }
        CodeRepositoryCache.evictCache((String)"UserUnit");
    }

    @Override
    public List<UserUnit> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.userUnitDao.listObjectsByProperties(filterMap, pageDesc);
    }

    @Override
    @Transactional
    public List<UserUnit> listUnitUsersByUnitCode(String unitCode) {
        return this.userUnitDao.listUnitUsersByUnitCode(unitCode);
    }

    @Override
    @Transactional
    public List<UserUnit> listUserUnitssByUserCode(String userCode) {
        return this.userUnitDao.listUserUnitsByUserCode(userCode);
    }

    @Override
    @Transactional
    public void deletePrimaryUnitByUserCode(String userCode, String topUnit) {
        UserUnit userUnit = this.userUnitDao.getPrimaryUnitByUserId(userCode, topUnit);
        if (userUnit != null) {
            this.userUnitDao.deleteObject((Serializable)userUnit);
        }
    }

    @Override
    @Transactional
    public List<UserUnit> listSubUsersByUnitCode(String unitCode, Map<String, Object> map, PageDesc pageDesc) {
        UnitInfo unitInfo = this.unitInfoDao.getObjectById(unitCode);
        if (unitInfo != null) {
            map.put("unitPath", unitInfo.getUnitPath());
            return this.userUnitDao.querySubUserUnits(map, pageDesc);
        }
        return null;
    }

    @Override
    public List<UserUnit> listUserUnitsUnderUnitByUserCode(String userCode, String unitCode, PageDesc pageDesc) {
        UnitInfo unitInfo = this.unitInfoDao.getObjectById(unitCode);
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("userCode", userCode);
        map.put("unitPath", unitInfo.getUnitPath());
        map.put("unitIsValid", "T");
        return this.userUnitDao.querySubUserUnits(map, pageDesc);
    }
}

