/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.model.basedata.UserRole;
import com.centit.framework.model.basedata.WorkGroup;
import com.centit.framework.model.basedata.WorkGroupParameter;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.dao.WorkGroupDao;
import com.centit.framework.system.service.WorkGroupManager;
import com.centit.framework.system.vo.WorkGroupParames;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.utils.PageDesc;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class WorkGroupManagerImpl
implements WorkGroupManager {
    @Autowired
    @NotNull
    private WorkGroupDao workGroupDao;
    @Autowired
    private UserRoleDao userRoleDao;

    @Override
    public void updateWorkGroup(WorkGroup workGroup) {
        if (StringUtils.isNotBlank((CharSequence)workGroup.getRoleCode())) {
            WorkGroup work = this.getWorkGroup(workGroup.getWorkGroupParameter().getGroupId(), workGroup.getWorkGroupParameter().getUserCode(), workGroup.getWorkGroupParameter().getRoleCode());
            if (work != null) {
                this.workGroupDao.deleteObject((Serializable)work);
                workGroup.getWorkGroupParameter().setRoleCode(workGroup.getRoleCode());
                this.workGroupDao.saveNewObject((Serializable)workGroup);
            }
        } else {
            this.workGroupDao.updateObject((Serializable)workGroup);
        }
    }

    @Override
    public void deleteWorkGroup(String groupId, String userCode, String roleCode) {
        this.workGroupDao.deleteObjectForceById(new WorkGroupParameter(groupId, userCode, roleCode));
        this.userRoleDao.deleteByRoleCodeAndUserCode("osmember", userCode);
    }

    @Override
    public WorkGroup getWorkGroup(String groupId, String userCode, String roleCode) {
        return (WorkGroup)this.workGroupDao.getObjectById(new WorkGroupParameter(groupId, userCode, roleCode));
    }

    @Override
    public void createWorkGroup(WorkGroup workGroup) {
        this.workGroupDao.saveNewObject((Serializable)workGroup);
        UserRole userRole = this.getUserRole(workGroup);
        this.userRoleDao.mergeUserRole(userRole);
    }

    @Override
    public void batchWorkGroup(List<WorkGroup> workGroups) {
        for (WorkGroup workGroup : workGroups) {
            this.workGroupDao.saveNewObject((Serializable)workGroup);
            UserRole userRole = this.getUserRole(workGroup);
            this.userRoleDao.mergeUserRole(userRole);
        }
    }

    @Override
    public List<WorkGroup> listWorkGroup(String groupId, String userCode, String roleCode) {
        HashMap<String, String> param = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)groupId)) {
            param.put("groupId", groupId);
        }
        if (StringUtils.isNotBlank((CharSequence)userCode)) {
            param.put("userCode", userCode);
        }
        if (StringUtils.isNotBlank((CharSequence)roleCode)) {
            param.put("roleCode", roleCode);
        }
        if (param.isEmpty()) {
            return Collections.emptyList();
        }
        return this.workGroupDao.listObjectsByProperties(param);
    }

    @Override
    public List<WorkGroup> listWorkGroup(Map<String, Object> param, PageDesc pageDesc) {
        return this.workGroupDao.listObjectsByProperties(param, pageDesc);
    }

    @Override
    public int countWorkGroup(Map<String, Object> param) {
        return this.workGroupDao.countObjectByProperties(param);
    }

    @Override
    public boolean loginUserIsExistWorkGroup(String osId, String userCode) {
        if (StringUtils.isBlank((CharSequence)osId) || StringUtils.isBlank((CharSequence)userCode)) {
            return false;
        }
        String[] osids = osId.split(",");
        HashMap<String, String[]> param = new HashMap<String, String[]>();
        param.put("groupId_in", osids);
        List workGroups = this.workGroupDao.listObjectsByProperties(param);
        for (WorkGroup workGroup : workGroups) {
            if (!workGroup.getWorkGroupParameter().getUserCode().equals(userCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean loginUserIsWorkGroupLeader(String osId, String userCode) {
        if (StringUtils.isBlank((CharSequence)osId) || StringUtils.isBlank((CharSequence)userCode)) {
            return false;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("groupId", osId);
        param.put("userCode", userCode);
        param.put("roleCode", "\u7ec4\u957f");
        List workGroups = this.workGroupDao.listObjectsByProperties(param);
        return workGroups.size() > 0;
    }

    @Override
    @Transactional
    public void leaderHandOver(WorkGroupParames workGroupParames) {
        String sql = "UPDATE  work_group  SET ROLE_CODE ='\u7ec4\u5458'  WHERE group_id=? and role_code=?  ";
        this.workGroupDao.getJdbcTemplate().update(sql, new Object[]{workGroupParames.getGroupId(), "\u7ec4\u957f"});
        WorkGroup delWorkGroup = new WorkGroup();
        WorkGroupParameter delWorkGroupParameter = new WorkGroupParameter();
        delWorkGroupParameter.setGroupId(workGroupParames.getGroupId());
        delWorkGroupParameter.setRoleCode("\u7ec4\u5458");
        delWorkGroupParameter.setUserCode(workGroupParames.getNewUserCode());
        delWorkGroup.setWorkGroupParameter(delWorkGroupParameter);
        this.workGroupDao.deleteObject((Serializable)delWorkGroup);
        WorkGroup workGroup = new WorkGroup();
        WorkGroupParameter workGroupParameter = new WorkGroupParameter();
        workGroupParameter.setGroupId(workGroupParames.getGroupId());
        workGroupParameter.setRoleCode("\u7ec4\u957f");
        workGroupParameter.setUserCode(workGroupParames.getNewUserCode());
        workGroup.setWorkGroupParameter(workGroupParameter);
        this.workGroupDao.saveNewObject((Serializable)workGroup);
        UserRole userRole = this.getUserRole(workGroup);
        this.userRoleDao.mergeUserRole(userRole);
    }

    private UserRole getUserRole(WorkGroup workGroup) {
        UserRole userRole = new UserRole();
        userRole.setUserCode(workGroup.getWorkGroupParameter().getUserCode());
        userRole.setObtainDate(DatetimeOpt.addDays((Date)DatetimeOpt.currentUtilDate(), (int)-1));
        userRole.setChangeDesc("\u5de5\u4f5c\u7ec4\u81ea\u52a8\u5206\u914d");
        userRole.setRoleCode("osmember");
        return userRole;
    }
}

