/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.model.basedata.Platform;
import com.centit.framework.system.dao.PlatformDao;
import com.centit.framework.system.service.PlatformService;
import com.centit.support.database.utils.PageDesc;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="platformService")
@Transactional
public class PlatformServiceImpl
implements PlatformService {
    @Autowired
    private PlatformDao platformDao;

    @Override
    public List<Platform> listObjects(Map<String, Object> filterMap) {
        return this.platformDao.listObjectsByProperties(filterMap);
    }

    @Override
    public List<Platform> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.platformDao.listObjectsByProperties(filterMap, pageDesc);
    }

    @Override
    public Platform getObjectById(String platId) {
        return (Platform)this.platformDao.getObjectById(platId);
    }

    @Override
    public Platform getPlatformByProperties(Map<String, Object> paramsMap) {
        return (Platform)this.platformDao.getObjectByProperties(paramsMap);
    }

    @Override
    public boolean hasSamePlat(Platform platform) {
        return this.platformDao.isUniquePlat(platform.getPlatSourceCode(), platform.getPlatId());
    }

    @Override
    public void savePlatform(Platform platform) {
        this.platformDao.saveNewObject((Serializable)platform);
    }

    @Override
    public void updatePlatform(Platform platform) {
        this.platformDao.updateObject((Serializable)platform);
    }

    @Override
    public void deletePlatform(Platform platform) {
        this.platformDao.deleteObjectById(platform.getPlatId());
    }
}

