/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.UserSyncDirectory;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserSyncDirectoryDao;
import com.centit.framework.system.service.UserSyncDirectoryManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.utils.PageDesc;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userSyncDirectoryManager")
public class UserSyncDirectoryManagerImpl
implements UserSyncDirectoryManager {
    @Autowired
    private UserSyncDirectoryDao userSyncDirectoryDao;
    @Autowired
    private UnitInfoDao unitInfoDao;
    @Autowired
    private UserInfoDao userInfoDao;

    @Override
    public List<UserSyncDirectory> listObjects() {
        return this.userSyncDirectoryDao.listObjectsAll();
    }

    @Override
    public List<UserSyncDirectory> listLdapDirectory() {
        return this.userSyncDirectoryDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"type", "LDAP"}));
    }

    @Override
    public List<UserSyncDirectory> listObjects(Map<String, Object> filterMap, PageDesc pageDesc, String userCode) {
        Object[] unitCodeArray;
        UserInfo userInfo = this.userInfoDao.getUserByCode(userCode);
        UnitInfo unitInfo = this.unitInfoDao.getObjectById(userInfo.getPrimaryUnit());
        Object topUnit = "";
        if (null != unitInfo && StringUtils.isNotBlank((CharSequence)unitInfo.getTopUnit())) {
            topUnit = unitInfo.getTopUnit();
        }
        if (null != unitInfo && StringUtils.isBlank((CharSequence)userInfo.getTopUnit()) && StringUtils.isNotBlank((CharSequence)unitInfo.getUnitPath()) && ArrayUtils.isNotEmpty((Object[])(unitCodeArray = unitInfo.getUnitPath().split("/"))) && unitCodeArray.length > 1) {
            topUnit = unitCodeArray[1];
        }
        filterMap.put("topUnit", topUnit);
        return this.userSyncDirectoryDao.listObjectsByProperties(filterMap, pageDesc);
    }

    @Override
    public UserSyncDirectory getObjectById(String id) {
        return (UserSyncDirectory)this.userSyncDirectoryDao.getObjectById(id);
    }

    @Override
    public void saveUserSyncDirectory(UserSyncDirectory userSyncDirectory, String userCode) {
        Object[] unitCodeArray;
        UserInfo userInfo = this.userInfoDao.getUserByCode(userCode);
        UnitInfo unitInfo = this.unitInfoDao.getObjectById(userInfo.getPrimaryUnit());
        if (null != unitInfo && StringUtils.isNotBlank((CharSequence)unitInfo.getTopUnit())) {
            userSyncDirectory.setTopUnit(unitInfo.getTopUnit());
        }
        if (null != unitInfo && StringUtils.isBlank((CharSequence)userInfo.getTopUnit()) && StringUtils.isNotBlank((CharSequence)unitInfo.getUnitPath()) && ArrayUtils.isNotEmpty((Object[])(unitCodeArray = unitInfo.getUnitPath().split("/"))) && unitCodeArray.length > 1) {
            userSyncDirectory.setTopUnit((String)unitCodeArray[1]);
        }
        this.userSyncDirectoryDao.saveNewObject((Serializable)userSyncDirectory);
    }

    @Override
    public void updateUserSyncDirectory(UserSyncDirectory userSyncDirectory) {
        this.userSyncDirectoryDao.updateObject((Serializable)userSyncDirectory);
    }

    @Override
    public void deleteUserSyncDirectoryById(String id) {
        this.userSyncDirectoryDao.deleteObjectById(id);
    }
}

