/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.model.basedata.TenantInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.WorkGroup;
import com.centit.framework.system.dao.TenantInfoDao;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.dao.WorkGroupDao;
import com.centit.framework.system.service.TenantPowerManage;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.common.ObjectException;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantPowerManageImpl
implements TenantPowerManage {
    protected Logger logger = LoggerFactory.getLogger(TenantPowerManage.class);
    @Autowired
    private TenantInfoDao tenantInfoDao;
    @Autowired
    private WorkGroupDao workGroupDao;
    @Autowired
    private UserUnitDao userUnitDao;
    @Autowired
    private UnitInfoDao unitInfoDao;

    @Override
    public boolean userIsTenantOwner(String userCode, String topUnit) {
        return this.tenantInfoDao.userIsOwner(topUnit, userCode);
    }

    @Override
    public boolean userIsTenantAdmin(String userCode, String topUnit) {
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", topUnit, "userCode", userCode, "roleCode", "ZHGLY"});
        return this.workGroupDao.countObjectByProperties(filterMap) > 0;
    }

    @Override
    public String userTenantRole(String userCode, String topUnit) {
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException(302, "topUnit\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.userIsTenantOwner(userCode, topUnit)) {
            return "OWN";
        }
        WorkGroup workGroup = (WorkGroup)this.workGroupDao.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", topUnit, "userCode", userCode}));
        if (workGroup == null) {
            return "";
        }
        if ("orgadmin".equals(workGroup.getRoleCode())) {
            return "orgadmin:" + workGroup.getRunToken();
        }
        return workGroup.getRoleCode();
    }

    @Override
    public JSONArray listTenantAdmin(String topUnit) {
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", topUnit, "roleCode", "ZHGLY"});
        List works = this.workGroupDao.listObjectsByProperties(filterMap);
        if (works == null || works.isEmpty()) {
            return null;
        }
        JSONArray users = new JSONArray();
        for (WorkGroup work : works) {
            JSONObject user = new JSONObject();
            user.put((Object)"userCode", (Object)work.getUserCode());
            UserInfo ui = CodeRepositoryUtil.getUserInfoByCode((String)topUnit, (String)work.getUserCode());
            if (ui != null) {
                user.put((Object)"userName", (Object)ui.getUserName());
                user.put((Object)"loginName", (Object)ui.getLoginName());
            }
            users.add((Object)user);
        }
        return users;
    }

    @Override
    public boolean userIsTenantMember(String userCode, String topUnit) {
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "topUnit", topUnit});
        return this.userUnitDao.countObjectByProperties(filterMap) > 0;
    }

    @Override
    public boolean userIsApplicationAdmin(String userCode, String osId) {
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", osId, "userCode", userCode, "roleCode", "OSZZ"});
        return this.workGroupDao.countObjectByProperties(filterMap) > 0;
    }

    @Override
    public boolean userIsApplicationMember(String userCode, String osId) throws ObjectException {
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", osId, "userCode", userCode});
        return this.workGroupDao.countObjectByProperties(filterMap) > 0;
    }

    @Override
    public boolean userIsSystemMember(String userCode) {
        return this.userIsTenantMember(userCode, "system");
    }

    @Override
    public boolean userIsSystemAdmin(String userCode) {
        return !CollectionUtils.sizeIsEmpty(this.userUnitDao.listUserUnitsByUserCode("system", userCode));
    }

    @Override
    public boolean userNumberLimitIsOver(String topUnit) {
        TenantInfo tenantInfo = (TenantInfo)this.tenantInfoDao.getObjectById(topUnit);
        if (null == tenantInfo || null == tenantInfo.getUserNumberLimit()) {
            return true;
        }
        return this.userUnitDao.countUserByTopUnit(topUnit) >= tenantInfo.getUserNumberLimit();
    }

    @Override
    public boolean unitNumberLimitIsOver(String topUnit) {
        TenantInfo tenantInfo = (TenantInfo)this.tenantInfoDao.getObjectById(topUnit);
        if (null == tenantInfo || null == tenantInfo.getUnitNumberLimit()) {
            return true;
        }
        return this.unitInfoDao.countUnitByTopUnit(topUnit) >= tenantInfo.getUnitNumberLimit();
    }
}

