/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.staticsystem.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.model.basedata.DataCatalog;
import com.centit.framework.model.basedata.DataDictionary;
import com.centit.framework.model.basedata.OptDataScope;
import com.centit.framework.model.basedata.OptInfo;
import com.centit.framework.model.basedata.OptMethod;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.framework.model.basedata.RoleInfo;
import com.centit.framework.model.basedata.RolePower;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.UserRole;
import com.centit.framework.model.basedata.UserUnit;
import com.centit.framework.staticsystem.service.impl.AbstractStaticPlatformEnvironment;
import com.centit.support.common.ListAppendMap;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileSystemOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;

public class JsonPlatformEnvironment
extends AbstractStaticPlatformEnvironment {
    private static Log logger = LogFactory.getLog(JsonPlatformEnvironment.class);
    protected String appHome;

    public void setAppHome(String appHome) {
        this.appHome = appHome;
    }

    private void loadConfigFromJSONString(String jsonStr) {
        JSONObject json = JSON.parseObject((String)jsonStr);
        JSONArray tempJa = json.getJSONArray("userInfos");
        if (tempJa != null) {
            List userinfos = tempJa.toJavaList(UserInfo.class, new JSONReader.Feature[0]);
            CodeRepositoryCache.userInfoRepo.setFreshData((Object)"all", (Object)new ListAppendMap(userinfos, UserInfo::getUserCode));
        }
        if ((tempJa = json.getJSONArray("optInfos")) != null) {
            List optinfos = tempJa.toJavaList(OptInfo.class, new JSONReader.Feature[0]);
            CodeRepositoryCache.optInfoRepo.setFreshData((Object)"all", (Object)optinfos);
        }
        if ((tempJa = json.getJSONArray("optMethods")) != null) {
            List optmethods = tempJa.toJavaList(OptMethod.class, new JSONReader.Feature[0]);
            this.allOptMethod.setFreshData((Object)optmethods);
        }
        if ((tempJa = json.getJSONArray("optDataScopes")) != null) {
            List dataScopes = tempJa.toJavaList(OptDataScope.class, new JSONReader.Feature[0]);
            this.optDataScopes.setFreshData((Object)dataScopes);
        }
        if ((tempJa = json.getJSONArray("roleInfos")) != null) {
            List roleinfos = tempJa.toJavaList(RoleInfo.class, new JSONReader.Feature[0]);
            CodeRepositoryCache.roleInfoRepo.setFreshData((Object)"all", (Object)roleinfos);
        }
        if ((tempJa = json.getJSONArray("rolePowers")) != null) {
            List rolepowers = tempJa.toJavaList(RolePower.class, new JSONReader.Feature[0]);
            this.allRolePower.setFreshData((Object)rolepowers);
        }
        if ((tempJa = json.getJSONArray("userRoles")) != null) {
            List userroles = tempJa.toJavaList(UserRole.class, new JSONReader.Feature[0]);
            this.allUserRoleRepo.setFreshData((Object)userroles);
        }
        if ((tempJa = json.getJSONArray("unitInfos")) != null) {
            List unitinfos = tempJa.toJavaList(UnitInfo.class, new JSONReader.Feature[0]);
            CodeRepositoryCache.unitInfoRepo.setFreshData((Object)"all", (Object)new ListAppendMap(unitinfos, UnitInfo::getUnitCode));
        }
        if ((tempJa = json.getJSONArray("userUnits")) != null) {
            List userunits = tempJa.toJavaList(UserUnit.class, new JSONReader.Feature[0]);
            this.allUserUnitRepo.setFreshData((Object)userunits);
        }
        if ((tempJa = json.getJSONArray("osInfos")) != null) {
            List osInfos = tempJa.toJavaList(OsInfo.class, new JSONReader.Feature[0]);
            CodeRepositoryCache.osInfoCache.setFreshData((Object)"all", (Object)osInfos);
        }
    }

    public String loadJsonStringFormConfigFile(String fileName) throws IOException {
        String jsonFile = this.appHome + File.separator + "config" + File.separator + fileName;
        if (FileSystemOpt.existFile((String)jsonFile)) {
            return FileIOOpt.readStringFromFile((String)jsonFile, (String)"UTF-8");
        }
        return FileIOOpt.readStringFromInputStream((InputStream)new ClassPathResource("config" + File.separator + fileName).getInputStream(), (String)"UTF-8");
    }

    protected void reloadDictionaryData() {
        String dictionaryDir = this.appHome + File.separator + "config" + File.separator + "dictionary";
        List files = FileSystemOpt.findFiles((String)dictionaryDir, (String)"*.json");
        ArrayList<DataCatalog> dataCatalogs = new ArrayList<DataCatalog>(32);
        if (files != null) {
            for (File f : files) {
                try {
                    JSONObject catalogJson = JSON.parseObject((InputStream)new FileInputStream(f), (JSONReader.Feature[])new JSONReader.Feature[0]);
                    DataCatalog dataCatalog = (DataCatalog)catalogJson.toJavaObject(DataCatalog.class, new JSONReader.Feature[0]);
                    Object josnArray = catalogJson.get("details");
                    if (josnArray instanceof JSONArray) {
                        JSONArray details = (JSONArray)josnArray;
                        List dictionaries = details.toJavaList(DataDictionary.class, new JSONReader.Feature[0]);
                        dataCatalog.setDataDictionaries(dictionaries);
                    }
                    dataCatalogs.add(dataCatalog);
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
        this.catalogRepo.setFreshData(dataCatalogs);
    }

    @Override
    protected synchronized void reloadPlatformData() {
        try {
            String jsonstr = this.loadJsonStringFormConfigFile("static_system_config.json");
            this.loadConfigFromJSONString(jsonstr);
        }
        catch (IOException e) {
            logger.error((Object)e.getLocalizedMessage());
        }
        this.reloadDictionaryData();
        this.organizePlatformData();
        try {
            String jsonStr = this.loadJsonStringFormConfigFile("static_system_user_pwd.json");
            JSONObject json = JSON.parseObject((String)jsonStr);
            for (UserInfo u : ((ListAppendMap)CodeRepositoryCache.userInfoRepo.getCachedValue((Object)"all")).getListData()) {
                String spwd = json.getString(u.getUserCode());
                if (!StringUtils.isNotBlank((CharSequence)spwd)) continue;
                u.setUserPin(spwd);
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void changeUserPassword(String userCode, String userPassword) {
        UserInfo ui = (UserInfo)((ListAppendMap)CodeRepositoryCache.userInfoRepo.getCachedValue((Object)"all")).getAppendMap().get(userCode);
        if (ui == null) {
            return;
        }
        JSONObject json = null;
        String jsonFile = "static_system_user_pwd.json";
        try {
            String jsonstr = this.loadJsonStringFormConfigFile(jsonFile);
            json = JSON.parseObject((String)jsonstr);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (json == null) {
            json = new JSONObject();
        }
        try {
            ui.setUserPin(this.passwordEncoder.encodePassword(userPassword, (Object)userCode));
            json.put((Object)userCode, (Object)ui.getUserPin());
            FileIOOpt.writeStringToFile((String)json.toJSONString(new JSONWriter.Feature[0]), (String)(this.appHome + File.separator + "config" + File.separator + jsonFile));
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

