/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson2.JSONArray;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.basedata.DataCatalog;
import com.centit.framework.model.basedata.DataDictionary;
import com.centit.framework.model.basedata.DataDictionaryId;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.service.DataDictionaryManager;
import com.centit.framework.system.service.WorkGroupManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.JavaBeanMetaData;
import com.centit.support.common.ObjectException;
import com.centit.support.common.ParamName;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.report.ExcelExportUtil;
import com.centit.support.report.ExcelImportUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dictionary"})
@Api(tags={"\u6846\u67b6\u6570\u636e\u5b57\u5178\u64cd\u4f5c\u63a5\u53e3"}, value="\u6846\u67b6\u6570\u636e\u5b57\u5178\u63a5\u53e3")
public class DataDictionaryController
extends BaseController {
    public static final String F = "F";
    public static final String S = "S";
    public static final String U = "U";
    public static final String T = "T";
    @Value(value="${app.local.multiLang:false}")
    private boolean multiLang;
    @Autowired
    private WorkGroupManager workGroupManager;
    @Autowired
    private DataDictionaryManager dataDictionaryManager;

    public String getOptId() {
        return "DICTIONARY";
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u76ee\u5f55\u5217\u8868", notes="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u76ee\u5f55\u5217\u8868\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="field", value="\u6307\u9700\u8981\u663e\u793a\u7684\u5c5e\u6027\u540d", allowMultiple=true, paramType="query", dataType="array"), @ApiImplicitParam(name="pageDesc", value="\u5206\u9875\u5bf9\u8c61", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Object> list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        searchColumn.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        List listObjects = this.dataDictionaryManager.listObjects(searchColumn, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)this.dataDictionaryManager.appendRelativeOsInfo(listObjects), (PageDesc)pageDesc, (String[])field);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5b57\u5178\u76ee\u5f55", notes="\u6839\u636e\u6570\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u67e5\u8be2\u5355\u4e2a\u5b57\u5178\u76ee\u5f55\u3002")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{catalogCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public DataCatalog getCatalog(@PathVariable String catalogCode) {
        return this.dataDictionaryManager.getCatalogIncludeDataPiece(catalogCode);
    }

    @ApiOperation(value="\u6839\u636e\u6570\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u67e5\u8be2\u5b57\u5178\u662f\u5426\u4e0d\u5b58\u5728", notes="\u6839\u636e\u6570\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u67e5\u8be2\u5b57\u5178\u662f\u5426\u4e0d\u5b58\u5728\u3002")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/notexists/{catalogCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public boolean isNotExistsCatalogCode(@PathVariable String catalogCode) {
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        return null == dbDataCatalog;
    }

    @ApiOperation(value="\u6839\u636e\u6570\u636e\u5b57\u5178\u540d\u5b57\u4ee3\u7801\u67e5\u8be2\u5b57\u5178\u662f\u5426\u5b58\u5728", notes="\u6839\u636e\u6570\u636e\u5b57\u5178\u540d\u5b57\u4ee3\u7801\u67e5\u8be2\u5b57\u5178\u662f\u5426\u5b58\u5728\u3002")
    @ApiImplicitParam(name="catalogName", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u540d\u5b57", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/existcatalogname/{catalogName}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public int isExistsCatalogName(@PathVariable String catalogName) {
        return this.dataDictionaryManager.existCatalogName(catalogName);
    }

    @ApiOperation(value="\u6821\u9a8c\u6570\u636e\u4ee3\u7801\u662f\u5426\u5b58\u5728", notes="\u6839\u636e\u6570\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u548c\u6570\u636e\u4ee3\u7801\u5224\u65ad\u5b57\u5178\u662f\u5426\u5b58\u5728")
    @ApiImplicitParams(value={@ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="dataCode", value="\u6570\u636e\u5b57\u5178\u7684\u6570\u636e\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/notexists/dictionary/{catalogCode}/{dataCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public boolean isNotExistsDataCode(@PathVariable String catalogCode, @PathVariable String dataCode) {
        DataDictionary dbDataDictionary = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(catalogCode, dataCode));
        return null == dbDataDictionary;
    }

    @ApiOperation(value="\u65b0\u589e\u5b57\u5178\u7c7b\u522b", notes="\u65b0\u589e\u5b57\u5178\u7c7b\u522b")
    @ApiParam(name="dataCatalog", value="\u65b0\u589e\u5b57\u5178\u7c7b\u522b,\u8f93\u5165\u6846\u6709\u63d0\u793a\u7684\u90fd\u662f\u5fc5\u586b\u9879", required=true)
    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u5b57\u5178\u7c7b\u522b", tag="{loginUser.userCode}")
    @WrapUpResponseBody
    public void createCatalog(@Valid DataCatalog dataCatalog, HttpServletRequest request, HttpServletResponse response) {
        boolean isAdmin = this.isLoginAsAdmin(request);
        if (isAdmin) {
            dataCatalog.setCatalogStyle(S);
        } else {
            dataCatalog.setCatalogStyle(U);
        }
        this.dataDictionaryManager.saveNewObject(dataCatalog);
        if (dataCatalog.getDataDictionaries() != null && dataCatalog.getDataDictionaries().size() > 0) {
            for (DataDictionary d : dataCatalog.getDataDictionaries()) {
                d.setDataValue(StringEscapeUtils.unescapeHtml4((String)d.getDataValue()));
                d.setDataDesc(StringEscapeUtils.unescapeHtml4((String)d.getDataDesc()));
                if (StringUtils.isBlank((CharSequence)d.getDataStyle())) {
                    d.setDataStyle(isAdmin ? S : U);
                }
                d.setCatalogCode(dataCatalog.getCatalogCode());
            }
            this.dataDictionaryManager.saveCatalogIncludeDataPiece(dataCatalog);
        }
        JsonResultUtils.writeSingleDataJson((Object)dataCatalog.getCatalogCode(), (HttpServletResponse)response);
    }

    @ApiOperation(value="\u66f4\u65b0\u5b57\u5178\u7c7b\u522b", notes="\u66f4\u65b0\u5b57\u5178\u7c7b\u522b\u4fe1\u606f")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @ApiParam(name="dataCatalog", value="\u66f4\u65b0\u5b57\u5178\u7c7b\u522b\u65b0\u7684\u5bf9\u8c61\u4fe1\u606f", required=true)
    @RequestMapping(value={"/{catalogCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u5b57\u5178\u7c7b\u522b", tag="{catalogCode}")
    @WrapUpResponseBody
    public ResponseData updateCatalog(@ParamName(value="catalogCode") @PathVariable String catalogCode, @Valid DataCatalog dataCatalog, HttpServletRequest request) {
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        if (null == dbDataCatalog) {
            return ResponseData.makeErrorMessage((int)604, (String)this.getI18nMessage("error.604.object_not_found", request, new Object[]{"DataCatalog", catalogCode}));
        }
        DataCatalog oldValue = new DataCatalog();
        BeanUtils.copyProperties((Object)dbDataCatalog, (Object)oldValue);
        BeanUtils.copyProperties((Object)dataCatalog, (Object)dbDataCatalog, (String[])new String[]{"catalogStyle", "catalogCode", "dataDictionaries"});
        this.dataDictionaryManager.updateCatalog(dbDataCatalog);
        return ResponseData.successResponse;
    }

    private boolean isLoginAsAdmin(HttpServletRequest request) {
        return WebOptUtils.getCurrentTopUnit((HttpServletRequest)request).equals("system");
    }

    @ApiOperation(value="\u66f4\u65b0\u5b57\u5178\u76ee\u5f55\u660e\u7ec6", notes="\u66f4\u65b0\u5b57\u5178\u76ee\u5f55\u660e\u7ec6\uff0c\u76ee\u5f55\u660e\u663e\u5bf9\u8c61\u5c31\u662fdataDictionaries[]\u91cc\u9762\u7684\u5c5e\u6027\u7ec4\u6210")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @ApiParam(name="dataCatalog", value="\u66f4\u65b0\u5b57\u5178\u7c7b\u522b\u65b0\u7684\u5bf9\u8c61\u4fe1\u606f", required=true)
    @RequestMapping(value={"/update/{catalogCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u5b57\u5178\u76ee\u5f55\u660e\u7ec6", tag="{catalogCode}")
    @WrapUpResponseBody
    public ResponseData updateDictionary(@ParamName(value="catalogCode") @PathVariable String catalogCode, @Valid DataCatalog dataCatalog, HttpServletRequest request) {
        String osId;
        CentitUserDetails ud = WebOptUtils.assertUserDetails((HttpServletRequest)request);
        if (!(ud.checkUserRole("platadmin") || ud.checkUserRole("tenantadmin") || !StringUtils.isBlank((CharSequence)(osId = request.getParameter("osId"))) && this.workGroupManager.loginUserIsExistWorkGroup(osId, ud.getUserCode()))) {
            throw new ObjectException(401, "\u60a8\u6ca1\u6709\u6743\u9650\u66f4\u65b0\u6570\u636e\u5b57\u5178!");
        }
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        if (null == dbDataCatalog) {
            return ResponseData.makeErrorMessage((int)604, (String)this.getI18nMessage("error.604.object_not_found", request, new Object[]{"DataCatalog", catalogCode}));
        }
        boolean isAdmin = this.isLoginAsAdmin(request);
        String dataStyle = isAdmin ? S : U;
        for (DataDictionary d : dataCatalog.getDataDictionaries()) {
            d.setDataValue(StringEscapeUtils.unescapeHtml4((String)d.getDataValue()));
            d.setDataDesc(StringEscapeUtils.unescapeHtml4((String)d.getDataDesc()));
            if (!StringUtils.isBlank((CharSequence)d.getDataStyle())) continue;
            d.setDataStyle(dataStyle);
        }
        dbDataCatalog.addAllDataPiece(dataCatalog.getDataDictionaries());
        this.dataDictionaryManager.updateCatalog(dataCatalog);
        this.dataDictionaryManager.saveCatalogIncludeDataPiece(dbDataCatalog);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u65b0\u589e\u67d0\u4e2a\u5b57\u5178\u76ee\u5f55\u91cc\u7684\u5b57\u5178\u660e\u7ec6", notes="\u65b0\u589e\u67d0\u4e2a\u5b57\u5178\u76ee\u5f55\u91cc\u7684\u5b57\u5178\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="dataCode", value="\u6570\u636e\u5b57\u5178\u7684\u660e\u7ec6\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @ApiParam(name="dataDictionary", value="\u5b57\u5178\u660e\u7ec6\u7684\u5bf9\u8c61\u4fe1\u606f", required=true)
    @RequestMapping(value={"/dictionaryPiece/{catalogCode}/{dataCode}"}, method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u6570\u636e\u5b57\u5178", tag="{catalogCode}:{dataCode}")
    @WrapUpResponseBody
    public DataDictionary createDictionary(@ParamName(value="catalogCode") @PathVariable String catalogCode, @PathVariable String dataCode, @Valid DataDictionary dataDictionary, HttpServletRequest request) {
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        dataDictionary.setCatalogCode(catalogCode);
        dataDictionary.setDataCode(dataCode);
        dataDictionary.setDataValue(StringEscapeUtils.unescapeHtml4((String)dataDictionary.getDataValue()));
        dataDictionary.setDataDesc(StringEscapeUtils.unescapeHtml4((String)dataDictionary.getDataDesc()));
        this.dictionaryPreHandler(dbDataCatalog, dataDictionary, request);
        this.dictionaryPreInsertHandler(dbDataCatalog, dataDictionary, request);
        this.dataDictionaryManager.saveDataDictionaryPiece(dataDictionary);
        return dataDictionary;
    }

    @ApiOperation(value="\u66f4\u65b0\u67d0\u4e2a\u5b57\u5178\u76ee\u5f55\u91cc\u7684\u5b57\u5178\u660e\u7ec6", notes="\u66f4\u65b0\u67d0\u4e2a\u5b57\u5178\u76ee\u5f55\u91cc\u7684\u5b57\u5178\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="dataCode", value="\u6570\u636e\u5b57\u5178\u7684\u660e\u7ec6\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @ApiParam(name="dataDictionary", value="\u5b57\u5178\u660e\u7ec6\u7684\u5bf9\u8c61\u4fe1\u606f", required=true)
    @RequestMapping(value={"/dictionaryPiece/{catalogCode}/{dataCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u6570\u636e\u5b57\u5178", tag="{catalogCode}:{dataCode}")
    @WrapUpResponseBody
    public DataDictionary editDictionary(@ParamName(value="catalogCode") @PathVariable String catalogCode, @PathVariable String dataCode, @Valid DataDictionary dataDictionary, HttpServletRequest request) {
        DataDictionary dbDataDictionary = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(catalogCode, dataCode));
        DataCatalog dbDataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        dataDictionary.setDataCode(dataCode);
        dataDictionary.setCatalogCode(catalogCode);
        dataDictionary.setDataValue(StringEscapeUtils.unescapeHtml4((String)dataDictionary.getDataValue()));
        dataDictionary.setDataDesc(StringEscapeUtils.unescapeHtml4((String)dataDictionary.getDataDesc()));
        this.dictionaryPreHandler(dbDataCatalog, dataDictionary, request);
        this.dictionaryPreUpdateHandler(dbDataCatalog, dbDataDictionary, request);
        BeanUtils.copyProperties((Object)dataDictionary, (Object)dbDataDictionary, (String[])new String[]{"id", "dataStyle"});
        this.dictionaryPreUpdateHandler(dbDataCatalog, dbDataDictionary, request);
        this.dataDictionaryManager.saveDataDictionaryPiece(dbDataDictionary);
        return dbDataDictionary;
    }

    private void dictionaryPreHandler(DataCatalog dataCatalog, DataDictionary dataDictionary, HttpServletRequest request) {
        if (T.equalsIgnoreCase(dataCatalog.getCatalogType()) && !StringBaseOpt.isNvl((String)dataDictionary.getExtraCode())) {
            String extraCode = dataDictionary.getExtraCode();
            if (dataDictionary.getDataCode().equals(extraCode)) {
                throw new ObjectException((Object)dataDictionary, 701, this.getI18nMessage("error.701.cycle_in_tree", request, new Object[0]));
            }
            DataDictionary dd = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(dataDictionary.getCatalogCode(), extraCode));
            if (null == dd) {
                throw new ObjectException((Object)dataDictionary, 604, this.getI18nMessage("error.604.object_not_found", request, new Object[]{"DataDictionary", dd.getDataCode()}));
            }
        }
    }

    private void dictionaryPreInsertHandler(DataCatalog dataCatalog, DataDictionary dataDictionary, HttpServletRequest request) {
        if (this.isLoginAsAdmin(request)) {
            dataDictionary.setDataStyle(S);
        } else {
            if (!S.equalsIgnoreCase(dataCatalog.getCatalogStyle()) && !U.equalsIgnoreCase(dataCatalog.getCatalogStyle())) {
                throw new ObjectException((Object)dataCatalog, 701, this.getI18nMessage("error.701.field_must_be", request, new Object[]{"catalogStyle", "[SU]"}));
            }
            dataDictionary.setDataStyle(U);
        }
    }

    private void dictionaryPreDeleteHandler(DataDictionary dataDictionary, HttpServletRequest request) {
        if (this.isLoginAsAdmin(request)) {
            if (!S.equalsIgnoreCase(dataDictionary.getDataStyle()) && !U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException((Object)dataDictionary, 701, this.getI18nMessage("error.701.field_must_be", request, new Object[]{"catalogStyle", "[SU]"}));
            }
        } else if (!U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
            throw new ObjectException((Object)dataDictionary, 701, this.getI18nMessage("error.701.field_must_be", request, new Object[]{"dataStyle", U}));
        }
    }

    protected void dictionaryPreUpdateHandler(DataCatalog dataCatalog, DataDictionary dataDictionary, HttpServletRequest request) {
        if (this.isLoginAsAdmin(request)) {
            if (F.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException((Object)dataDictionary, 701, this.getI18nMessage("error.701.field_must_be", request, new Object[]{"dataStyle", "[SU]"}));
            }
            if (F.equalsIgnoreCase(dataCatalog.getCatalogStyle()) && !S.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException((Object)dataDictionary, 701, this.getI18nMessage("error.701.field_must_be", request, new Object[]{"dataStyle", U}));
            }
            if (!S.equalsIgnoreCase(dataCatalog.getCatalogStyle()) && !U.equalsIgnoreCase(dataCatalog.getCatalogStyle())) {
                throw new ObjectException((Object)dataCatalog, 701, this.getI18nMessage("error.701.field_must_be", request, new Object[]{"catalogStyle", "[SU]"}));
            }
            if (!S.equalsIgnoreCase(dataDictionary.getDataStyle()) && !U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
                throw new ObjectException((Object)dataDictionary, 701, this.getI18nMessage("error.701.field_must_be", request, new Object[]{"dataStyle", "[SU]"}));
            }
        } else if (!U.equalsIgnoreCase(dataDictionary.getDataStyle())) {
            throw new ObjectException((Object)dataDictionary, 701, this.getI18nMessage("error.701.field_must_be", request, new Object[]{"dataStyle", U}));
        }
    }

    private void catalogPrDeleteHandler(DataCatalog dataCatalog, HttpServletRequest request) {
        if (this.isLoginAsAdmin(request)) {
            if (!S.equalsIgnoreCase(dataCatalog.getCatalogStyle()) && !U.equalsIgnoreCase(dataCatalog.getCatalogStyle())) {
                throw new ObjectException((Object)dataCatalog, 701, this.getI18nMessage("error.701.field_must_be", request, new Object[]{"catalogStyle", "[SU]"}));
            }
        } else if (!U.equalsIgnoreCase(dataCatalog.getCatalogStyle())) {
            throw new ObjectException((Object)dataCatalog, 701, this.getI18nMessage("error.701.field_must_be", request, new Object[]{"catalogStyle", U}));
        }
    }

    @ApiOperation(value="\u6839\u636e\u6570\u636e\u5b57\u5178\u76ee\u5f55\u4ee3\u7801\u5220\u9664\u5b57\u5178\u76ee\u5f55", notes="\u6839\u636e\u6570\u636e\u5b57\u5178\u76ee\u5f55\u4ee3\u7801\u5220\u9664\u5b57\u5178\u76ee\u5f55\u3002")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u76ee\u5f55\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{catalogCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u5b57\u5178\u76ee\u5f55", tag="{catalogCode}")
    @WrapUpResponseBody
    public ResponseData deleteCatalog(@ParamName(value="catalogCode") @PathVariable String catalogCode, HttpServletRequest request) {
        DataCatalog dataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
        this.catalogPrDeleteHandler(dataCatalog, request);
        this.dataDictionaryManager.deleteDataDictionary(catalogCode);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u5220\u9664\u5b57\u5178\u660e\u7ec6", notes="\u6839\u636e\u5b57\u5178\u7c7b\u522b\u548c\u5b57\u5178\u660e\u7ec6\u4ee3\u7801\u5220\u9664\u5b57\u5178\u660e\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="dataCode", value="\u6570\u636e\u5b57\u5178\u7684\u660e\u7ec6\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/dictionaryPiece/{catalogCode}/{dataCode}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u6570\u636e\u5b57\u5178", tag="{catalogCode}:{dataCode}")
    @WrapUpResponseBody
    public ResponseData deleteDictionary(@ParamName(value="catalogCode") @PathVariable String catalogCode, @ParamName(value="dataCode") @PathVariable String dataCode, HttpServletRequest request) {
        DataDictionary dataDictionary = this.dataDictionaryManager.getDataDictionaryPiece(new DataDictionaryId(catalogCode, dataCode));
        this.dictionaryPreDeleteHandler(dataDictionary, request);
        this.dataDictionaryManager.deleteDataDictionaryPiece(dataDictionary.getId());
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u7684\u6240\u6709\u660e\u7ec6\u4fe1\u606f", notes="\u6839\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u83b7\u53d6\u5b57\u5178\u7684\u6240\u6709\u660e\u7ec6\u4fe1\u606f")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/dictionaryPiece/{catalogCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getDataDictionary(@PathVariable String catalogCode) {
        List datas = this.dataDictionaryManager.getDataDictionary(catalogCode);
        return ResponseData.makeResponseData((Object)datas);
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u7684\u8be6\u7ec6\u4fe1\u606f", notes="\u6839\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u83b7\u53d6\u5b57\u5178\u7684\u8be6\u7ec6\u4fe1\u606f")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/editDictionary/{catalogCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getDataDictionaryDetail(@PathVariable String catalogCode, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        searchColumn.put("catalogCode", catalogCode);
        List datas = this.dataDictionaryManager.listDataDictionarys(searchColumn);
        DataCatalog catalog = this.dataDictionaryManager.getObjectById(catalogCode);
        if (T.equals(catalog.getCatalogType())) {
            CollectionsOpt.sortAsTree((List)datas, (p, c) -> StringUtils.equals((CharSequence)p.getDataCode(), (CharSequence)c.getExtraCode()));
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("dataDictionary", (Object)datas);
        resData.addResponseData("multiLang", (Object)this.multiLang);
        resData.addResponseData("langs", (Object)CodeRepositoryUtil.getLabelValueMap((String)"SUPPORT_LANG"));
        return resData;
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u7684\u8be6\u7ec6\u4fe1\u606f", notes="\u6839\u636e\u5b57\u5178\u7c7b\u522b\u4ee3\u7801\u83b7\u53d6\u5b57\u5178\u7684\u8be6\u7ec6\u4fe1\u606f")
    @ApiImplicitParam(name="catalogCode", value="\u6570\u636e\u5b57\u5178\u7684\u7c7b\u522b\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/dictionarys"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getDataDictionarys(HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        List datas = this.dataDictionaryManager.listDataDictionarys(searchColumn);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("dataDictionary", (Object)datas);
        resData.addResponseData("multiLang", (Object)this.multiLang);
        resData.addResponseData("langs", (Object)CodeRepositoryUtil.getLabelValueMap((String)"SUPPORT_LANG"));
        return resData;
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u76ee\u5f55\u4fe1\u606f", notes="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u76ee\u5f55\u4fe1\u606f")
    @RequestMapping(value={"/allCatalog"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getAllCatalog(HttpServletRequest request) {
        HashMap<String, String> searchColumn = new HashMap<String, String>();
        searchColumn.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        List catalogs = this.dataDictionaryManager.listAllDataCatalog(searchColumn);
        return ResponseData.makeResponseData((Object)catalogs);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u76ee\u5f55\u4fe1\u606f\u53ca\u5bf9\u5e94\u7684\u6240\u6709\u5b57\u5178\u660e\u7ec6\u4fe1\u606f", notes="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u76ee\u5f55\u4fe1\u606f\u53ca\u5bf9\u5e94\u7684\u6240\u6709\u5b57\u5178\u660e\u7ec6\u4fe1\u606f")
    @RequestMapping(value={"/wholeDictionary"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getWholeDictionary(HttpServletRequest request) {
        HashMap<String, String> searchColumn = new HashMap<String, String>();
        searchColumn.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        List catalogs = this.dataDictionaryManager.listAllDataCatalog(searchColumn);
        ArrayList catalogCodes = new ArrayList();
        catalogs.forEach(ca -> catalogCodes.add(ca.getCatalogCode()));
        List dictionarys = this.dataDictionaryManager.getWholeDictionary(catalogCodes);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("catalog", (Object)catalogs);
        resData.addResponseData("dictionary", (Object)dictionarys);
        return resData;
    }

    @ApiOperation(value="\u5c06\u5b57\u5178\u660e\u7ec6\u4fe1\u606f\u5bfc\u5165\u5230Properties\u6587\u4ef6", notes="\u5c06\u5b57\u5178\u660e\u7ec6\u4fe1\u606f\u5bfc\u5165\u5230Properties\u6587\u4ef6")
    @GetMapping(value={"/dictionaryprop"})
    @ResponseBody
    public ResponseEntity<byte[]> downloadProperties(HttpServletRequest request) throws IOException {
        HashMap<String, String> searchColumn = new HashMap<String, String>();
        searchColumn.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        List catalogs = this.dataDictionaryManager.listAllDataCatalog(searchColumn);
        ArrayList catalogCodes = new ArrayList();
        catalogs.forEach(ca -> catalogCodes.add(ca.getCatalogCode()));
        List dictionarys = this.dataDictionaryManager.getWholeDictionary(catalogCodes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write("#dictionaryprop_zh_CN.Properties\r\n".getBytes());
        for (DataDictionary dict : dictionarys) {
            out.write((dict.getCatalogCode() + "." + dict.getDataCode() + "=" + dict.getDataValue() + "\r\n").getBytes());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDispositionFormData("attachment", "dictionaryprop_zh_CN.Properties");
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        return new ResponseEntity((Object)out.toByteArray(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @ApiOperation(value="\u5bfc\u5165excel\u5230\u6570\u636e\u5b57\u5178\u660e\u7ec6")
    @CrossOrigin(origins={"*"}, allowCredentials="true", maxAge=86400L, methods={RequestMethod.POST})
    @RequestMapping(value={"/excelData/{catalogCode}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public DataCatalog importDataFromExcel(@PathVariable String catalogCode, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            InputStream fileInfo = (InputStream)UploadDownloadUtils.fetchInputStreamFromMultipartResolver((HttpServletRequest)request).getRight();
            List excelList = ExcelImportUtil.loadMapFromExcelSheet((InputStream)fileInfo, (int)0);
            ArrayList<DataDictionary> object = new ArrayList<DataDictionary>();
            JavaBeanMetaData javaBeanMetaData = JavaBeanMetaData.createBeanMetaDataFromType(DataDictionary.class);
            for (Map map : excelList) {
                DataDictionary dataDictionary = (DataDictionary)javaBeanMetaData.createBeanObjectFromMap(map);
                dataDictionary.setCatalogCode(catalogCode);
                dataDictionary.setDataStyle(U);
                dataDictionary.setDataTag(T);
                dataDictionary.setCreateDate(new Date());
                object.add(dataDictionary);
            }
            DataCatalog dataCatalog = this.dataDictionaryManager.getObjectById(catalogCode);
            if (dataCatalog == null) {
                return null;
            }
            dataCatalog.getDataDictionaries().addAll(object);
            this.dataDictionaryManager.saveCatalogIncludeDataPiece(dataCatalog);
            return dataCatalog;
        }
        catch (ObjectException | IllegalAccessException | InstantiationException e) {
            JsonResultUtils.writeMessageJson((String)e.getMessage(), (HttpServletResponse)response);
            return null;
        }
    }

    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u5b57\u5178\u660e\u7ec6", notes="\u5bfc\u51fa\u6570\u636e\u5b57\u5178\u660e\u7ec6")
    @ApiImplicitParam(name="catalogCode", type="path", value="\u5b57\u5178code")
    @GetMapping(value={"/export/{catalogCode}"})
    public void exportDictionary(@PathVariable String catalogCode, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, String> searchColumn = new HashMap<String, String>();
        searchColumn.put("catalogCode", catalogCode);
        List data = this.dataDictionaryManager.listDataDictionarys(searchColumn);
        InputStream inputStream = ExcelExportUtil.generateExcelStream((List)data, DataDictionary.class);
        UploadDownloadUtils.downloadFile((InputStream)inputStream, (String)(catalogCode + "\u6570\u636e\u5b57\u5178\u660e\u7ec6.xlsx"), (HttpServletRequest)request, (HttpServletResponse)response);
    }
}

