/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.UserRole;
import com.centit.framework.model.basedata.UserUnit;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.service.SysUserManager;
import com.centit.framework.system.service.SysUserUnitManager;
import com.centit.framework.system.service.WorkGroupManager;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.common.CachedMap;
import com.centit.support.common.ObjectException;
import com.centit.support.common.ParamName;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JsonPropertyUtils;
import com.centit.support.network.HtmlFormUtils;
import com.centit.support.security.SecurityOptUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="\u6846\u67b6\u4e2d\u7528\u6237\u7ba1\u7406\u63a5\u53e3\uff0c\u5305\u62ec\u7528\u6237\u7684\u589e\u5220\u6539\u67e5", tags={"\u7528\u6237\u7ba1\u7406\u64cd\u4f5c\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/userinfo"})
public class UserInfoController
extends BaseController {
    @Autowired
    @NotNull
    private SysUserManager sysUserManager;
    @Autowired
    @NotNull
    private SysUserUnitManager sysUserUnitManager;
    @Autowired
    private WorkGroupManager workGroupManager;

    public String getOptId() {
        return "USERMAG";
    }

    @ApiOperation(value="\u7528\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2", notes="\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="filterMap", value="\u8fc7\u6ee4\u6761\u4ef6", paramType="query", dataType="Map"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class), @ApiImplicitParam(name="_search", value="\u5f3a\u5236\u5173\u95ed\u5206\u9875\u67e5\u8be2", paramType="query", dataType="Boolean"), @ApiImplicitParam(name="all", value="\u5e73\u53f0\u7ba1\u7406\u5458\u6839\u636e\u5177\u4f53\u7684topUnit\u67e5\u8be2", paramType="query", dataType="Boolean"), @ApiImplicitParam(name="field", value="\u8fc7\u6ee4\u8fd4\u56de\u7684\u5b57\u6bb5\u4fe1\u606f", allowMultiple=true, paramType="query", dataType="String")})
    @RequestMapping(method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<UserInfo> list(String[] field, PageDesc pageDesc, String _search, HttpServletRequest request) {
        WebOptUtils.assertUserLogin((HttpServletRequest)request);
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        if (searchColumn.get("userName") != null) {
            searchColumn.put("likeUserOrLoginName", StringEscapeUtils.escapeHtml4((String)searchColumn.get("userName").toString()));
            searchColumn.remove("userName");
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (MapUtils.getBoolean((Map)searchColumn, (Object)"all", (Boolean)false).booleanValue() && this.userIsSystemMember(request)) {
            List listObjects = this.sysUserManager.listObjects(searchColumn);
            return PageQueryResult.createResultMapDict((Collection)listObjects, (PageDesc)pageDesc, (String[])field);
        }
        searchColumn.put("topUnit", topUnit);
        List listObjects = BooleanBaseOpt.castObjectToBoolean((Object)_search, (Boolean)false) != false ? this.sysUserManager.listObjects(searchColumn) : this.sysUserManager.listObjects(searchColumn, pageDesc);
        if (listObjects != null) {
            for (UserInfo userInfo : listObjects) {
                UserUnit uu = CodeRepositoryUtil.getUserPrimaryUnit((String)topUnit, (String)userInfo.getUserCode());
                if (uu != null) {
                    userInfo.setPrimaryUnit(uu.getUnitCode());
                }
                userInfo.setIdCardNo("");
                userInfo.setUserPwd("");
                userInfo.setUserPin("");
                userInfo.setRegCellPhone(SecurityOptUtils.decodeSecurityString((String)userInfo.getRegCellPhone()));
            }
        }
        return PageQueryResult.createResultMapDict((Collection)listObjects, (PageDesc)pageDesc, (String[])field);
    }

    @ApiOperation(value="\u7528\u6237\u4fe1\u606f\u6309\u673a\u6784\u5206\u9875\u67e5\u8be2", notes="\u7528\u6237\u4fe1\u606f\u6309\u673a\u6784\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"/querybyunit"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Object> listQueryByUnit(PageDesc pageDesc, HttpServletRequest request) {
        WebOptUtils.assertUserLogin((HttpServletRequest)request);
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        searchColumn.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        JSONArray jsonArray = this.sysUserManager.listObjectsByUnit(searchColumn, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)jsonArray, (PageDesc)pageDesc, (Class[])new Class[]{UserInfo.class});
    }

    @ApiOperation(value="\u65b0\u589e\u7528\u6237", notes="\u65b0\u589e\u7528\u6237\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userInfo", value="json\u683c\u5f0f\uff0c\u7528\u6237\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=UserInfo.class), @ApiImplicitParam(name="userUnit", value="json\u683c\u5f0f\uff0c\u7528\u6237\u673a\u6784\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=UserUnit.class)})
    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u7528\u6237", tag="{us.userCode}")
    @WrapUpResponseBody
    public ResponseData create(@ParamName(value="us") @Valid UserInfo userInfo, UserUnit userUnit, HttpServletRequest request) {
        WebOptUtils.assertUserLogin((HttpServletRequest)request);
        UserInfo dbuserinfo = this.sysUserManager.loadUserByLoginname(userInfo.getLoginName());
        if (null != dbuserinfo) {
            return ResponseData.makeErrorMessage((int)702, (String)this.getI18nMessage("error.702.userinfo_conflict", request, new Object[0]));
        }
        if (null != userInfo.getUserRoles()) {
            for (UserRole ur : userInfo.getUserRoles()) {
                ur.setUserCode(userInfo.getUserCode());
            }
        }
        userUnit.setCreator(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        userUnit.setUserCode(userInfo.getUserCode());
        userUnit.setUserOrder(userInfo.getUserOrder());
        this.sysUserManager.saveNewUserInfo(userInfo, userUnit);
        return ResponseData.makeResponseData((Object)userInfo);
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u4fe1\u606f", notes="\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="userInfo", value="json\u683c\u5f0f\uff0c\u7528\u6237\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=UserInfo.class), @ApiImplicitParam(name="userUnit", value="json\u683c\u5f0f\uff0c\u7528\u6237\u673a\u6784\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=UserUnit.class)})
    @RequestMapping(value={"/{userCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u7528\u6237\u4fe1\u606f", tag="{userCode}")
    @WrapUpResponseBody
    public ResponseData updateUserInfo(@ParamName(value="userCode") @PathVariable String userCode, @Valid UserInfo userInfo, UserUnit userUnit, HttpServletRequest request) {
        UserInfo dbUserInfo = this.sysUserManager.getObjectById(userCode);
        if (null == dbUserInfo) {
            return ResponseData.makeErrorMessage((int)604, (String)this.getI18nMessage("error.604.user_not_found", request, new Object[]{userCode}));
        }
        if (!StringUtils.equals((CharSequence)userInfo.getLoginName(), (CharSequence)dbUserInfo.getLoginName()) && this.sysUserManager.isLoginNameExist(userInfo.getUserCode(), userInfo.getLoginName())) {
            throw new ObjectException(611, this.getI18nMessage("error.611.loginname_already_exists", request, new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)userInfo.getRegCellPhone()) && !StringUtils.equals((CharSequence)userInfo.getRegCellPhone(), (CharSequence)dbUserInfo.getRegCellPhone()) && this.sysUserManager.isCellPhoneExist(userInfo.getUserCode(), userInfo.getRegCellPhone())) {
            throw new ObjectException(611, this.getI18nMessage("error.611.phone_already_exists", request, new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)userInfo.getRegEmail()) && !StringUtils.equals((CharSequence)userInfo.getRegEmail(), (CharSequence)dbUserInfo.getRegEmail()) && this.sysUserManager.isEmailExist(userInfo.getUserCode(), userInfo.getRegEmail())) {
            throw new ObjectException(611, this.getI18nMessage("error.611.email_already_exists", request, new Object[0]));
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        this.sysUserUnitManager.deletePrimaryUnitByUserCode(userCode, topUnit);
        userUnit.setTopUnit(topUnit);
        userUnit.setUserCode(userInfo.getUserCode());
        userUnit.setUnitCode(userInfo.getPrimaryUnit());
        userUnit.setRelType("T");
        userUnit.setCreator(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        userUnit.setUserOrder(userInfo.getUserOrder());
        this.sysUserUnitManager.saveNewUserUnit(userUnit);
        userInfo.setUserPin(dbUserInfo.getUserPin());
        CodeRepositoryCache.evictCache((String)"UnitUser", (String)userInfo.getPrimaryUnit());
        userInfo.setPrimaryUnit(dbUserInfo.getPrimaryUnit());
        userInfo.setTopUnit(dbUserInfo.getTopUnit());
        userInfo.setUserType(userInfo.getUserType());
        this.sysUserManager.updateUserInfo(userInfo);
        CodeRepositoryCache.evictCache((String)"UserInfo", (String)topUnit);
        ((CachedMap)CodeRepositoryCache.userUnitsMap.getCachedValue((Object)topUnit)).evictIdentifiedCache((Object)userCode);
        CodeRepositoryCache.evictCache((String)"UnitUser", (String)userInfo.getPrimaryUnit());
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f", notes="\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u3002")
    @RequestMapping(value={"/current"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public UserInfo getCurrentUserInfo(HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return null;
        }
        return this.sysUserManager.getObjectById(userCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u4e2a\u7528\u6237\u4fe1\u606f", notes="\u6839\u636e\u7528\u6237\u4ee3\u7801\u83b7\u53d6\u5355\u4e2a\u7528\u6237\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", paramType="path", dataType="String")
    @RequestMapping(value={"/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseMapData getUserInfo(@PathVariable String userCode, HttpServletRequest request) {
        WebOptUtils.assertUserLogin((HttpServletRequest)request);
        UserInfo userInfo = this.sysUserManager.getObjectById(userCode);
        if (userInfo == null) {
            throw new ObjectException(710, "user not found--" + userCode);
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        UserUnit userUnit = this.sysUserUnitManager.getPrimaryUnitByUserCode(userCode, topUnit);
        userInfo.setUserCode(HtmlFormUtils.htmlString((String)userInfo.getUserCode()));
        userInfo.setLoginName(HtmlFormUtils.htmlString((String)userInfo.getLoginName()));
        userInfo.setUserWord(HtmlFormUtils.htmlString((String)userInfo.getUserWord()));
        userInfo.setEnglishName(HtmlFormUtils.htmlString((String)userInfo.getEnglishName()));
        userInfo.setUserName(HtmlFormUtils.htmlString((String)userInfo.getUserName()));
        userInfo.setUserDesc(HtmlFormUtils.htmlString((String)userInfo.getUserDesc()));
        userInfo.setRegCellPhone(SecurityOptUtils.decodeSecurityString((String)userInfo.getRegCellPhone()));
        Object userJson = DictionaryMapUtils.objectToJSON((Object)userInfo);
        Object userUnitJson = DictionaryMapUtils.objectToJSON((Object)userUnit);
        ResponseMapData responseData = new ResponseMapData();
        responseData.addResponseData("userInfo", userJson);
        responseData.addResponseData("userUnit", userUnitJson);
        HashMap<Class, String[]> excludes = new HashMap<Class, String[]>();
        excludes.put(UserUnit.class, new String[]{"userInfo"});
        excludes.put(UserRole.class, new String[]{"userInfo"});
        responseData.toJSONString(JsonPropertyUtils.getExcludePropPreFilter(excludes));
        return responseData;
    }

    @ApiOperation(value="\u5f53\u524d\u767b\u5f55\u540d\u662f\u5426\u5df2\u5b58\u5728", notes="\u5f53\u524d\u767b\u5f55\u540d\u662f\u5426\u5df2\u5b58\u5728\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="loginName", value="\u767b\u5f55\u540d", paramType="query", dataType="String"), @ApiImplicitParam(name="regPhone", value="\u624b\u673a\u53f7", paramType="query", dataType="String"), @ApiImplicitParam(name="regEmail", value="\u90ae\u7bb1", paramType="query", dataType="String")})
    @RequestMapping(value={"/exists"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public boolean isAnyExist(HttpServletRequest request) {
        String userCode = request.getParameter("userCode");
        String loginName = request.getParameter("loginName");
        String regPhone = request.getParameter("regPhone");
        String regEmail = request.getParameter("regEmail");
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{userCode, loginName, regPhone, regEmail})) {
            throw new ObjectException(701, this.getI18nMessage("error.701.field_is_blank", request, new Object[]{"userCode/loginName/regPhone/regEmail"}));
        }
        return this.sysUserManager.isAnyOneExist(userCode, loginName, regPhone, regEmail);
    }

    @ApiOperation(value="\u5f53\u524d\u767b\u5f55\u540d\u662f\u5426\u5df2\u5b58\u5728", notes="\u5f53\u524d\u767b\u5f55\u540d\u662f\u5426\u5df2\u5b58\u5728\u3002")
    @ApiImplicitParam(name="loginName", value="\u767b\u5f55\u540d", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/exists/{loginName}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public boolean isExists(@PathVariable String loginName) throws IOException {
        UserInfo userInfo = this.sysUserManager.loadUserByLoginname(loginName);
        return null != userInfo;
    }

    @ApiOperation(value="\u5f3a\u5236\u66f4\u65b0\u7528\u6237\u5bc6\u7801", notes="\u5f3a\u5236\u66f4\u65b0\u7528\u6237\u5bc6\u7801\u3002")
    @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/changePwd/{userCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5f3a\u5236\u66f4\u65b0\u7528\u6237\u5bc6\u7801", tag="{userCode}")
    @WrapUpResponseBody
    public void forceChangePwd(@ParamName(value="userCode") @PathVariable String userCode, @RequestBody String jsonBody, HttpServletRequest request) {
        String currentUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)currentUser)) {
            throw new ObjectException(709, "\u60a8\u6ca1\u6709\u6743\u9650\u5f3a\u5236\u8bbe\u7f6e\u5bc6\u7801\u3002");
        }
        JSONObject objBody = JSONObject.parseObject((String)jsonBody);
        String newPassword = SecurityOptUtils.decodeSecurityString((String)objBody.getString("newPassword"));
        if (StringUtils.isBlank((CharSequence)newPassword)) {
            throw new ObjectException(701, this.getI18nMessage("error.701.field_is_blank", request, new Object[]{"newPassword"}));
        }
        this.sysUserManager.forceSetPassword(userCode, newPassword);
    }

    @ApiOperation(value="\u68c0\u67e5\u7528\u6237\u5bc6\u7801\u662f\u5426\u53ef\u4ee5\u4fee\u6539", notes="\u68c0\u67e5\u7528\u6237\u5bc6\u7801\u662f\u5426\u53ef\u4ee5\u4fee\u6539\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="oldPassword", value="\u65e7\u5bc6\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/canchange/{userCode}/{oldPassword}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData canChangePwd(@PathVariable String userCode, @PathVariable String oldPassword) {
        oldPassword = SecurityOptUtils.decodeSecurityString((String)oldPassword);
        boolean bo = this.sysUserManager.checkUserPassword(userCode, oldPassword);
        return ResponseData.makeResponseData((Object)bo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7528\u6237", notes="\u6279\u91cf\u5220\u9664\u7528\u6237\u3002")
    @ApiImplicitParam(name="userCodes", value="\u7528\u6237\u4ee3\u7801\u96c6\u5408(\u6570\u7ec4)", allowMultiple=true, required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{userCodes}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u7528\u6237", tag="{userCodes}")
    @WrapUpResponseBody
    public ResponseData deleteUser(@ParamName(value="userCodes") @PathVariable String[] userCodes, HttpServletRequest request) {
        for (String userCode : userCodes) {
            UserInfo userInfo = this.sysUserManager.getObjectById(userCode);
            if (null == userInfo) continue;
            this.sysUserManager.deleteUserInfo(userCode);
        }
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u4e2a\u7528\u6237\u6307\u5b9a\u7684\u654f\u611f\u4fe1\u606f", notes="\u83b7\u53d6\u5355\u4e2a\u7528\u6237\u6307\u5b9a\u7684\u654f\u611f\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", paramType="path", dataType="String")
    @RequestMapping(value={"/{userCode}/{name}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getUserInfo(@PathVariable String userCode, @PathVariable String name) {
        UserInfo userInfo = this.sysUserManager.getObjectById(userCode);
        HashMap<String, String> result = new HashMap<String, String>();
        if ("idCardNo".equals(name)) {
            result.put(name, userInfo.getIdCardNo());
        } else if ("regCellPhone".equals(name)) {
            result.put(name, userInfo.getRegCellPhone());
        } else if ("regEmail".equals(name)) {
            result.put(name, userInfo.getRegEmail());
        }
        return ResponseData.makeResponseData(result);
    }

    private boolean userIsSystemMember(HttpServletRequest request) {
        String currentUserCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (!"system".equals(topUnit) || StringUtils.isBlank((CharSequence)currentUserCode)) {
            return false;
        }
        return this.workGroupManager.loginUserIsExistWorkGroup("system", currentUserCode);
    }
}

