/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.ViewDataTransform;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.model.basedata.OptInfo;
import com.centit.framework.model.basedata.OptMethod;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.service.OptInfoManager;
import com.centit.framework.system.service.OptMethodManager;
import com.centit.framework.system.service.OsInfoManager;
import com.centit.framework.system.service.WorkGroupManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.common.ParamName;
import com.centit.support.network.HtmlFormUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/optinfo"})
@Api(value="\u7cfb\u7edf\u4e1a\u52a1\u83dc\u5355\u7ef4\u62a4\u63a5\u53e3", tags={"\u7cfb\u7edf\u4e1a\u52a1\u83dc\u5355\u64cd\u4f5c\u63a5\u53e3"})
public class OptInfoController
extends BaseController {
    @Autowired
    private OptInfoManager optInfoManager;
    @Autowired
    private OptMethodManager optMethodManager;
    @Autowired
    private OsInfoManager osInfoMag;
    @Autowired
    private WorkGroupManager workGroupManager;

    public String getOptId() {
        return "OPTINFO";
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7cfb\u7edf\u4e1a\u52a1", notes="\u6839\u636e\u67d0\u4e2a\u7236\u7ea7\u7cfb\u7edf\u4e1a\u52a1id\u67e5\u8be2\u4e0b\u9762\u7684\u6240\u6709\u7cfb\u7edf\u4e1a\u52a1\u3002")
    @ApiImplicitParam(name="id", value="\u7236\u7ea7\u7cfb\u7edf\u4e1a\u52a1id", paramType="query", dataType="String")
    @RequestMapping(value={"/sub"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listFromParent(String id, HttpServletRequest request) {
        WebOptUtils.assertUserLogin((HttpServletRequest)request);
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            searchColumn.put("preOptId", id);
        } else {
            searchColumn.put("NP_TOPOPT", "true");
        }
        searchColumn.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        List listObjects = this.optInfoManager.listFromParent(searchColumn);
        Iterator iterator = listObjects.iterator();
        while (iterator.hasNext()) {
            OptInfo opt;
            opt.setState(this.optInfoManager.hasChildren((opt = (OptInfo)iterator.next()).getOptId()) ? "closed" : "open");
        }
        return ResponseData.makeResponseData((Object)this.makeMenuFuncsJson(listObjects));
    }

    private JSONArray makeMenuFuncsJson(List<OptInfo> menuFunsByUser) {
        return ViewDataTransform.makeTreeViewJson(menuFunsByUser, (Map)ViewDataTransform.createStringHashMap((String[])new String[]{"id", "optId", "optId", "optId", "optCode", "optId", "pid", "preOptId", "text", "localOptName", "url", "optRoute", "icon", "icon", "children", "children", "isInToolbar", "isInToolbar", "state", "state", "optMethods", "optMethods", "topOptId", "topOptId"}), (jsonObject, obj) -> jsonObject.put((Object)"external", (Object)(!"D".equals(obj.getPageType()) ? 1 : 0)));
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u9700\u8981\u901a\u8fc7\u6743\u9650\u7ba1\u7406\u7684\u4e1a\u52a1", notes="\u67e5\u8be2\u6240\u6709\u9700\u8981\u901a\u8fc7\u6743\u9650\u7ba1\u7406\u7684\u4e1a\u52a1\u3002")
    @RequestMapping(value={"/poweropts"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public JSONArray listPowerOpts(HttpServletRequest request) {
        List listObjects = this.optInfoManager.listFromParent(CollectionsOpt.createHashMap((Object[])new Object[]{"topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request)}));
        listObjects = this.optInfoManager.listObjectFormatTree(listObjects, true);
        return this.makeMenuFuncsJson(listObjects);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u9879\u76ee\u6743\u9650\u7ba1\u7406\u7684\u4e1a\u52a1", notes="\u67e5\u8be2\u6240\u6709\u9879\u76ee\u6743\u9650\u7ba1\u7406\u7684\u4e1a\u52a1\u3002")
    @ApiImplicitParam(name="field", value="\u9700\u8981\u663e\u793a\u7684\u5b57\u6bb5", allowMultiple=true, paramType="query", dataType="String")
    @RequestMapping(value={"/itempoweropts"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public JSONArray listItemPowerOpts(String[] field) {
        List listObjects = this.optInfoManager.listItemPowerOpts();
        listObjects = this.optInfoManager.listObjectFormatTree(listObjects, true);
        return DictionaryMapUtils.objectsToJSONArray((Collection)listObjects, (String[])field);
    }

    @ApiOperation(value="\u67e5\u8be2\u67d0\u4e2a\u90e8\u95e8\u6743\u9650\u7684\u4e1a\u52a1", notes="\u67e5\u8be2\u67d0\u4e2a\u90e8\u95e8\u6743\u9650\u7684\u4e1a\u52a1\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitCode", value="\u673a\u6784\u7f16\u7801", required=true, paramType="query", dataType="String"), @ApiImplicitParam(name="field", value="\u9700\u8981\u663e\u793a\u7684\u5b57\u6bb5", allowMultiple=true, paramType="query", dataType="String")})
    @RequestMapping(value={"/unitpoweropts/{unitCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listUnitPowerOpts(@PathVariable String unitCode, String[] field) {
        List listObjects = this.optInfoManager.listOptWithPowerUnderUnit(unitCode);
        listObjects = this.optInfoManager.listObjectFormatTree(listObjects, false);
        return ResponseData.makeResponseData((Object)this.makeMenuFuncsJson(listObjects));
    }

    private void judgePower(String osId, HttpServletRequest request) {
        CentitUserDetails userDetails = WebOptUtils.assertUserDetails((HttpServletRequest)request);
        OsInfo osInfo = (OsInfo)this.osInfoMag.getObjectById((Serializable)((Object)osId));
        if (osInfo == null) {
            throw new ObjectException("\u4e1a\u52a1\u7cfb\u7edf\u4e0d\u5b58\u5728");
        }
        if (!StringUtils.equals((CharSequence)osInfo.getTopUnit(), (CharSequence)userDetails.getTopUnitCode())) {
            throw new ObjectException(401, this.getI18nMessage("error.401.unauthorized", request, new Object[0]));
        }
        if (!(userDetails.checkUserRole("platadmin") || userDetails.checkUserRole("tenantadmin") || this.workGroupManager.loginUserIsExistWorkGroup(osId, userDetails.getUserCode()))) {
            throw new ObjectException(401, "\u60a8\u6ca1\u6709\u6743\u9650\u66f4\u65b0\u83dc\u5355!");
        }
    }

    @ApiOperation(value="\u65b0\u5efa\u7cfb\u7edf\u4e1a\u52a1\u83dc\u5355", notes="\u65b0\u5efa\u7cfb\u7edf\u4e1a\u52a1\u83dc\u5355\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="optInfo", value="\u4e1a\u52a1\u83dc\u7cfb\u4fe1\u606f", required=true, paramType="body", dataTypeClass=OptInfo.class)})
    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e{optInfo.optName}\u83dc\u5355", tag="{optInfo.optId}:{optInfo.optName}")
    @WrapUpResponseBody
    public OptInfo createOptInfo(@Valid OptInfo optInfo, HttpServletRequest request) {
        String optOsId = optInfo.getOsId();
        if (StringUtils.isBlank((CharSequence)optOsId)) {
            optOsId = optInfo.getTopOptId();
        }
        this.judgePower(optOsId, request);
        optInfo.setOptName(HtmlFormUtils.htmlString((String)optInfo.getOptName()));
        if (StringBaseOpt.isNvl((String)optInfo.getOptType())) {
            optInfo.setOptType("O");
        }
        this.optInfoManager.saveNewOptInfo(optInfo);
        return optInfo;
    }

    @ApiOperation(value="\u68c0\u67e5\u4e1a\u52a1\u83dc\u5355\u662f\u5426\u5b58\u5728", notes="\u6839\u636e\u83dc\u5355id\u68c0\u67e5\u4e1a\u52a1\u83dc\u5355\u662f\u5426\u5b58\u5728\u3002")
    @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u83dc\u5355id", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/notexists/{optId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public boolean isNotExists(@PathVariable String optId) throws IOException {
        OptInfo optInfo = this.optInfoManager.getObjectById(optId);
        return null == optInfo;
    }

    @ApiOperation(value="\u67e5\u8be2\u67d0\u4e2a\u90e8\u95e8\u6743\u9650\u7684\u4e1a\u52a1", notes="\u67e5\u8be2\u67d0\u4e2a\u90e8\u95e8\u6743\u9650\u7684\u4e1a\u52a1\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="optId", value="\u83dc\u5355id", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="optInfo", value="\u66f4\u65b0\u7684\u83dc\u5355\u5bf9\u8c61", required=true, paramType="body", dataTypeClass=OptInfo.class)})
    @RequestMapping(value={"/{optId}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u83dc\u5355", tag="{optId}")
    @WrapUpResponseBody
    public ResponseData edit(@ParamName(value="optId") @PathVariable String optId, @Valid OptInfo optInfo, HttpServletRequest request) {
        String optOsId = optInfo.getOsId();
        if (StringUtils.isBlank((CharSequence)optOsId)) {
            optOsId = optInfo.getTopOptId();
        }
        this.judgePower(optOsId, request);
        optInfo.setOptName(HtmlFormUtils.htmlString((String)optInfo.getOptName()));
        OptInfo dbOptInfo = this.optInfoManager.getObjectById(optId);
        if (null == dbOptInfo) {
            return ResponseData.makeErrorMessage((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        if (!StringUtils.equals((CharSequence)dbOptInfo.getPreOptId(), (CharSequence)optInfo.getPreOptId())) {
            OptInfo parentOpt;
            if (optInfo.getPreOptId() == null) {
                optInfo.setPreOptId("0");
            }
            if ((parentOpt = this.optInfoManager.getOptInfoById(optInfo.getPreOptId())) == null) {
                optInfo.setPreOptId(dbOptInfo.getPreOptId());
            }
        }
        if (StringBaseOpt.isNvl((String)optInfo.getOptType())) {
            optInfo.setOptType("O");
        }
        this.optInfoManager.updateOptInfo(optInfo);
        return ResponseData.makeResponseData((Object)optInfo);
    }

    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u64cd\u4f5c\u6743\u9650", notes="\u6279\u91cf\u66f4\u65b0\u64cd\u4f5c\u6743\u9650\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="optId", value="\u83dc\u5355id", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="optInfo", value="\u66f4\u65b0\u7684\u83dc\u5355\u5bf9\u8c61", required=true, paramType="body", dataTypeClass=OptInfo.class)})
    @RequestMapping(value={"/editpower/{optId}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u64cd\u4f5c\u6743\u9650", tag="{optId}")
    @WrapUpResponseBody
    public ResponseData editPower(@ParamName(value="optId") @PathVariable String optId, @Valid OptInfo optInfo, HttpServletRequest request) {
        OptInfo parentOpt;
        optInfo.setOptName(HtmlFormUtils.htmlString((String)optInfo.getOptName()));
        OptInfo dbOptInfo = this.optInfoManager.getObjectById(optId);
        if (null == dbOptInfo) {
            return ResponseData.makeErrorMessage((int)604, (String)this.getI18nMessage("error.604.object_not_found", request, new Object[]{"OptInfo", optId}));
        }
        if (!StringUtils.equals((CharSequence)dbOptInfo.getPreOptId(), (CharSequence)optInfo.getPreOptId()) && (parentOpt = this.optInfoManager.getOptInfoById(optInfo.getPreOptId())) == null) {
            optInfo.setPreOptId(dbOptInfo.getPreOptId());
        }
        for (OptMethod optDef : optInfo.getOptMethods()) {
            optDef.setOptId(optId);
            if (!StringUtils.isBlank((CharSequence)optDef.getOptCode())) continue;
            optDef.setOptCode(this.optMethodManager.getNextOptCode());
        }
        for (OptMethod optDef : optInfo.getDataScopes()) {
            optDef.setFilterCondition(HtmlFormUtils.htmlString((String)optDef.getFilterCondition()));
        }
        this.optInfoManager.updateOperationPower(optInfo);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u5220\u9664\u83dc\u5355", notes="\u5220\u9664\u83dc\u5355\u3002")
    @ApiImplicitParam(name="optId", value="\u83dc\u5355id", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{optId}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u83dc\u5355", tag="{optId}")
    @WrapUpResponseBody
    public ResponseData delete(@ParamName(value="optId") @PathVariable String optId, HttpServletRequest request) {
        int hasChild = this.optInfoManager.countSubOptInfo(optId);
        if (hasChild > 0) {
            throw new ObjectException((Object)optId, 610, this.getI18nMessage("error.610.cannot_delete_parent", request, new Object[]{"Children-" + optId}));
        }
        this.optInfoManager.deleteOptInfoById(optId);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u6761\u6570\u636e", notes="\u6839\u636e\u83dc\u5355id\u67e5\u8be2\u5355\u6761\u6570\u636e\u3002")
    @ApiImplicitParam(name="optId", value="\u83dc\u5355id", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{optId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getOptInfoById(@PathVariable String optId) {
        OptInfo dbOptInfo = this.optInfoManager.getOptInfoById(optId);
        return ResponseData.makeResponseData((Object)dbOptInfo);
    }

    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u7684\u4e0b\u4e2a\u4e3b\u952e", notes="\u83b7\u53d6\u83dc\u5355\u7684\u4e0b\u4e2a\u4e3b\u952e\u3002")
    @RequestMapping(value={"/nextOptCode"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getNextOptCode() {
        String optCode = this.optMethodManager.getNextOptCode();
        ResponseMapData responseData = new ResponseMapData();
        responseData.addResponseData("optCode", (Object)optCode);
        return responseData;
    }

    @ApiOperation(value="\u65b0\u5efa\u4e1a\u52a1\u64cd\u4f5c", notes="\u65b0\u5efa\u4e1a\u52a1\u64cd\u4f5c\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="optId", value="\u83dc\u5355id", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="optDef", value="\u66f4\u65b0\u7684\u83dc\u5355\u64cd\u4f5c\u65b9\u6cd5\u5bf9\u8c61", required=true, paramType="body", dataTypeClass=OptMethod.class)})
    @RequestMapping(value={"/{optId}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData optDefSave(@PathVariable String optId, @Valid OptMethod optDef, HttpServletRequest request) {
        OptInfo optInfo = this.optInfoManager.getObjectById(optId);
        if (null == optInfo) {
            return ResponseData.makeErrorMessage((int)610, (String)this.getI18nMessage("error.604.object_not_found", request, new Object[]{"OptInfo", optId}));
        }
        this.optMethodManager.saveNewObject(optDef);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u66f4\u65b0\u4e1a\u52a1\u64cd\u4f5c", notes="\u66f4\u65b0\u4e1a\u52a1\u64cd\u4f5c\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="optId", value="\u83dc\u5355id", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="optCode", value="\u83dc\u5355\u82f1\u6587\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="optDef", value="\u66f4\u65b0\u7684\u83dc\u5355\u64cd\u4f5c\u65b9\u6cd5\u5bf9\u8c61", required=true, paramType="body", dataTypeClass=OptMethod.class)})
    @RequestMapping(value={"/{optId}/{optCode}"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData optDefEdit(@PathVariable String optId, @PathVariable String optCode, @Valid OptMethod optDef, HttpServletRequest request) {
        OptInfo optInfo = this.optInfoManager.getObjectById(optId);
        if (null == optInfo) {
            return ResponseData.makeErrorMessage((int)610, (String)this.getI18nMessage("error.604.object_not_found", request, new Object[]{"OptInfo", optId}));
        }
        optDef.setOptCode(optCode);
        this.optMethodManager.updateOptMethod(optDef);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u4e1a\u52a1\u83dc\u5355", notes="\u83b7\u53d6\u6240\u6709\u7684\u4e1a\u52a1\u83dc\u5355\u3002")
    @RequestMapping(value={"/allOptInfo"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData loadAllOptInfo(HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        List optInfos = this.optInfoManager.listAllOptInfoByUnit(topUnit);
        return ResponseData.makeResponseData((Object)optInfos);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u64cd\u4f5c\u65b9\u6cd5", notes="\u83b7\u53d6\u6240\u6709\u7684\u64cd\u4f5c\u65b9\u6cd5\u3002")
    @RequestMapping(value={"/allOptMethod"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData loadAllOptMethod(HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        List optDefs = this.optMethodManager.listAllOptMethodByUnit(topUnit);
        return ResponseData.makeResponseData((Object)optDefs);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u6761\u6570\u636e", notes="\u6839\u636e\u83dc\u5355id\u67e5\u8be2\u5355\u6761\u6570\u636e\u3002")
    @ApiImplicitParam(name="userCode", value="\u7528\u6237id", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/userpoweropts/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listUserOpts(@PathVariable String userCode) {
        List optInfos = this.optInfoManager.listUserAllPower(userCode, false);
        optInfos = this.optInfoManager.listObjectFormatTree(optInfos, true);
        return ResponseData.makeResponseData((Object)this.makeMenuFuncsJson(optInfos));
    }
}

