/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponseBody;
import com.aliyun.teaopenapi.models.Config;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.model.adapter.NotificationCenter;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.NoticeMessage;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.utils.VotaCode;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.security.SecurityOptUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/vateCode"})
@Api(value="\u90ae\u7bb1\u3001\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u63a5\u53e3", tags={"\u90ae\u7bb1\u3001\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u63a5\u53e3"})
public class VateCodeController
extends BaseController {
    @Value(value="${third.services.aliyun.access.key:}")
    private String accessKeyId;
    @Value(value="${third.services.aliyun.access.secret:}")
    private String accessKeySecret;
    @Autowired
    private NotificationCenter notificationCenter;
    @Autowired
    private UserInfoDao userInfoDao;
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired(required=false)
    private RedisTemplate<String, JSONObject> redisTemplate;
    private static Pattern pattern = Pattern.compile("[0-9]*");
    private ConcurrentHashMap<String, VotaCode> votaCodeMap = new ConcurrentHashMap();

    private VotaCode fetchVotaCode(String key) {
        if (this.redisTemplate == null) {
            return this.votaCodeMap.get(key);
        }
        JSONObject jsonObject = (JSONObject)this.redisTemplate.boundValueOps((Object)key).get();
        return (VotaCode)jsonObject.toJavaObject(VotaCode.class, new JSONReader.Feature[0]);
    }

    private void saveVotaCode(String key, VotaCode votaCode) {
        if (this.redisTemplate == null) {
            this.votaCodeMap.put(key, votaCode);
        } else {
            this.redisTemplate.boundValueOps((Object)key).set((Object)JSONObject.from((Object)votaCode));
        }
    }

    private void deleteVotaCode(String key) {
        if (this.redisTemplate == null) {
            this.votaCodeMap.remove(key);
        } else {
            this.redisTemplate.delete((Object)key);
        }
    }

    @ApiOperation(value="\u9a8c\u8bc1\u552f\u4e00\u6027", notes="\u9a8c\u8bc1\u552f\u4e00\u6027")
    @RequestMapping(value={"/checkOnly"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData checkOnly(@RequestParam(value="loginname") String loginname, HttpServletRequest request) throws Exception {
        UserInfo userInfo;
        String msg;
        Matcher isNum = pattern.matcher(loginname);
        if (loginname.indexOf(64) > 0) {
            msg = "\u90ae\u4ef6/Email";
            userInfo = this.userInfoDao.getUserByRegEmail(loginname);
        } else if (loginname.length() == 11 && isNum.matches()) {
            msg = "\u624b\u673a\u53f7/phone";
            userInfo = this.userInfoDao.getUserByRegCellPhone(loginname);
        } else {
            msg = "\u767b\u5f55\u540d/login name";
            userInfo = this.userInfoDao.getUserByLoginName(loginname);
        }
        if (userInfo != null) {
            return ResponseData.makeErrorMessage((int)702, (String)this.getI18nMessage("error.702.field_conflict", request, new Object[]{"UserInfo", msg}));
        }
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u83b7\u53d6Email\u9a8c\u8bc1\u7801", notes="\u83b7\u53d6Email\u9a8c\u8bc1\u7801")
    @RequestMapping(value={"/getEmailCode"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData getEmailCode(@RequestParam(value="email") String email, @RequestParam(value="userCode") String userCode, HttpServletRequest request) {
        UserInfo userInfo;
        VotaCode votaCode = this.fetchVotaCode(email);
        if (votaCode != null) {
            if (System.currentTimeMillis() - votaCode.getCreateTime() < 60000L) {
                return ResponseData.makeErrorMessage((int)611, (String)this.getI18nMessage("error.611.send_code_time_limit", request, new Object[0]));
            }
            this.deleteVotaCode(email);
        }
        if ((userInfo = this.userInfoDao.getUserByRegEmail(email)) != null) {
            return ResponseData.makeErrorMessage((int)702, (String)this.getI18nMessage("error.702.field_conflict", request, new Object[]{"UserInfo", "\u90ae\u4ef6/Email"}));
        }
        return this.sendEmail(userCode, email);
    }

    @ApiOperation(value="\u83b7\u53d6\u624b\u673a\u9a8c\u8bc1\u7801", notes="\u83b7\u53d6\u624b\u673a\u9a8c\u8bc1\u7801")
    @RequestMapping(value={"/getPhoneCode"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData getPhoneCode(@RequestParam(value="userCode", required=false) String userCode, @RequestParam(value="phone") String phone, HttpServletRequest request) throws Exception {
        UserInfo userInfo;
        VotaCode votaCode = this.fetchVotaCode(phone);
        if (votaCode != null) {
            if (System.currentTimeMillis() - votaCode.getCreateTime() < 60000L) {
                return ResponseData.makeErrorMessage((int)611, (String)this.getI18nMessage("error.611.send_code_time_limit", request, new Object[0]));
            }
            this.deleteVotaCode(phone);
        }
        if (phone != null && !phone.equals("") && (userInfo = this.userInfoDao.getUserByRegCellPhone(phone)) != null) {
            return ResponseData.makeErrorMessage((int)702, (String)this.getI18nMessage("error.702.field_conflict", request, new Object[]{"UserInfo", "\u624b\u673a\u53f7/phone"}));
        }
        SendSmsResponseBody s = this.sendPhone(phone, userCode, request);
        if (s != null && s.getCode() != null && s.getCode().equals("OK")) {
            s.setCode("0");
        }
        ResponseMapData result = ResponseData.makeResponseData((Map)CollectionsOpt.createHashMap((Object[])new Object[]{"x-auth-token", request.getSession().getId()}));
        result.setCode(NumberBaseOpt.castObjectToInteger((Object)s.getCode(), (Integer)500).intValue());
        result.setMessage(s.getMessage());
        return result;
    }

    @ApiOperation(value="\u6821\u9a8c\u548c\u66f4\u65b0", notes="\u6821\u9a8c\u548c\u66f4\u65b0")
    @RequestMapping(value={"/checkCode"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData checkCode(@RequestParam(value="userCode", required=false) String userCode, @RequestParam(value="key") String key, @RequestParam(value="code") String code, HttpServletRequest request) {
        try {
            UserInfo user;
            if (code == null) {
                return ResponseData.makeErrorMessage((int)611, (String)this.getI18nMessage("error.611.verify_code_is_blank", request, new Object[0]));
            }
            VotaCode votaCode = this.fetchVotaCode(key);
            if (votaCode == null) {
                return ResponseData.makeErrorMessage((int)611, (String)this.getI18nMessage("error.611.verify_code_not_create", request, new Object[0]));
            }
            if (!StringUtils.equals((CharSequence)votaCode.getVerifyCode(), (CharSequence)code)) {
                return ResponseData.makeErrorMessage((int)611, (String)this.getI18nMessage("error.611.verify_code_not_correct", request, new Object[0]));
            }
            if (System.currentTimeMillis() - votaCode.getCreateTime() > 300000L) {
                return ResponseData.makeErrorMessage((int)611, (String)this.getI18nMessage("error.611.verify_code_is_expired", request, new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)userCode) && (user = this.userInfoDao.getUserByCode(userCode)) != null) {
                if (StringUtils.isNotBlank((CharSequence)votaCode.getEmail())) {
                    user.setRegEmail(votaCode.getEmail());
                    this.logger.info("\u7528\u6237:{}\u4fee\u6539\u7528\u6237\u4fe1\u606f\u90ae\u7bb1", (Object)userCode);
                } else if (StringUtils.isNotBlank((CharSequence)votaCode.getPhone())) {
                    user.setRegCellPhone(votaCode.getPhone());
                    this.logger.info("\u7528\u6237:{}\u4fee\u6539\u7528\u6237\u4fe1\u606f\u624b\u673a", (Object)userCode);
                }
                this.userInfoDao.updateUser(user);
                this.reloadAuthentication(user.getUserCode(), request);
                CodeRepositoryCache.evictCache((String)"UserInfo");
            }
            this.deleteVotaCode(key);
            return ResponseData.makeSuccessResponse();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseData.errorResponse;
        }
    }

    @ApiOperation(value="\u627e\u56de\u5bc6\u7801(\u53d1\u9001\u9a8c\u8bc1\u7801 \u624b\u673a/\u90ae\u7bb1)", notes="\u627e\u56de\u5bc6\u7801(\u53d1\u9001\u9a8c\u8bc1\u7801 \u624b\u673a/\u90ae\u7bb1)")
    @RequestMapping(value={"/findPwd"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData findPwd(@RequestParam(value="loginname") String loginname, HttpServletRequest request) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            if (loginname.indexOf(64) > 0) {
                UserInfo userInfo = this.userInfoDao.getUserByRegEmail(loginname);
                if (userInfo == null) {
                    return ResponseData.makeErrorMessage((int)604, (String)this.getI18nMessage("error.604.user_not_found", request, new Object[0]));
                }
                this.sendEmail(userInfo.getUserCode(), loginname);
            } else {
                UserInfo userInfo = this.userInfoDao.getUserByRegCellPhone(loginname);
                if (userInfo == null) {
                    return ResponseData.makeErrorMessage((int)604, (String)this.getI18nMessage("error.604.user_not_found", request, new Object[0]));
                }
                this.sendPhone(loginname, "", request);
            }
            result.put("x-auth-token", request.getSession().getId());
            return ResponseData.makeResponseData(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseData.errorResponse;
        }
    }

    @ApiOperation(value="\u6821\u9a8c\u5e76\u8fd4\u56de\u7528\u6237\u4fe1\u606f", notes="\u6821\u9a8c\u5e76\u8fd4\u56de\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/checkCodeUser"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData checkCodeUser(@RequestParam(value="key") String key, @RequestParam(value="code") String code, HttpServletRequest request) {
        try {
            if (code == null) {
                return ResponseData.makeErrorMessage((int)611, (String)this.getI18nMessage("error.611.verify_code_is_blank", request, new Object[0]));
            }
            VotaCode votaCode = this.fetchVotaCode(key);
            if (votaCode == null) {
                return ResponseData.makeErrorMessage((int)611, (String)this.getI18nMessage("error.611.verify_code_not_create", request, new Object[0]));
            }
            if (!StringUtils.equals((CharSequence)votaCode.getVerifyCode(), (CharSequence)code)) {
                return ResponseData.makeErrorMessage((int)611, (String)this.getI18nMessage("error.611.verify_code_not_correct", request, new Object[0]));
            }
            if (System.currentTimeMillis() - votaCode.getCreateTime() > 300000L) {
                return ResponseData.makeErrorMessage((int)611, (String)this.getI18nMessage("error.611.verify_code_is_expired", request, new Object[0]));
            }
            UserInfo userInfo = new UserInfo();
            if (StringUtils.isNotBlank((CharSequence)votaCode.getEmail())) {
                userInfo = this.userInfoDao.getUserByRegEmail(votaCode.getEmail());
            } else if (StringUtils.isNotBlank((CharSequence)votaCode.getPhone())) {
                userInfo = this.userInfoDao.getUserByRegCellPhone(votaCode.getPhone());
            }
            this.deleteVotaCode(key);
            return ResponseData.makeResponseData((Object)userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseData.errorResponse;
        }
    }

    public ResponseData sendEmail(String userCode, String email) {
        String verifyCode = String.valueOf(new Random().nextInt(899999) + 100000);
        String message = "\u60a8\u7684\u9a8c\u8bc1\u7801\u4e3a:" + verifyCode + "\uff0c\u8be5\u7801\u6709\u6548\u671f\u4e3a5\u5206\u949f\uff0c\u8be5\u7801\u53ea\u80fd\u4f7f\u7528\u4e00\u6b21!\nYour verify code is :" + verifyCode + ", validity period is 5 minutes, and the code can only be used once!";
        ResponseData result = this.notificationCenter.sendMessageAppointedType("email", "system", email, NoticeMessage.create().operation("system").method("post").subject("Locode verify code/\u5e73\u53f0\u9a8c\u8bc1\u7801").content(message));
        if (result.getCode() == 0) {
            VotaCode votaCode = new VotaCode();
            votaCode.setVerifyCode(verifyCode);
            votaCode.setEmail(email);
            votaCode.setCreateTime(System.currentTimeMillis());
            this.saveVotaCode(email, votaCode);
        }
        return result;
    }

    public SendSmsResponseBody sendPhone(String phone, String userCode, HttpServletRequest request) {
        String verifyCode = String.valueOf(new Random().nextInt(899999) + 100000);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"code", (Object)verifyCode);
        if (StringUtils.isNotBlank((CharSequence)userCode)) {
            UserInfo userInfo = this.userInfoDao.getUserByCode(userCode);
            if (userInfo != null) {
                jSONObject.put((Object)"product", (Object)("\u7528\u6237" + userInfo.getUserName()));
            } else {
                jSONObject.put((Object)"product", (Object)"\u7528\u6237");
            }
        } else {
            jSONObject.put((Object)"product", (Object)"\u7528\u6237");
        }
        try {
            Client client = this.createClient();
            SendSmsRequest sendSmsRequest = new SendSmsRequest().setSignName("\u8eab\u4efd\u9a8c\u8bc1").setTemplateCode("SMS_65920066").setPhoneNumbers(phone).setTemplateParam(jSONObject.toString());
            SendSmsResponseBody result = client.sendSms(sendSmsRequest).getBody();
            if (result.getCode().equals("OK")) {
                VotaCode votaCode = new VotaCode();
                votaCode.setVerifyCode(verifyCode);
                votaCode.setPhone(phone);
                votaCode.setCreateTime(System.currentTimeMillis());
                this.saveVotaCode(phone, votaCode);
            }
            return result;
        }
        catch (Exception e) {
            throw new ObjectException(704, this.getI18nMessage("error.704.sms_send_fail", request, new Object[0]));
        }
    }

    private Client createClient() throws Exception {
        Config config = new Config().setAccessKeyId(SecurityOptUtils.decodeSecurityString((String)this.accessKeyId)).setAccessKeySecret(SecurityOptUtils.decodeSecurityString((String)this.accessKeySecret));
        config.endpoint = "dysmsapi.aliyuncs.com";
        return new Client(config);
    }

    private void reloadAuthentication(String userCode, HttpServletRequest request) {
        CentitUserDetails centitUserDetails = this.platformEnvironment.loadUserDetailsByUserCode(userCode);
        centitUserDetails.setLoginIp(WebOptUtils.getRequestAddr((HttpServletRequest)request));
        SecurityContextHolder.getContext().setAuthentication((Authentication)centitUserDetails);
    }
}

