/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jtt.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.jtt.config.JsmotSyncConfig;
import com.centit.framework.jtt.dto.JsmotUnitDTO;
import com.centit.framework.jtt.dto.JsmotUserDTO;
import com.centit.framework.jtt.dto.SmsDTO;
import com.centit.framework.jtt.service.JsmotSyncService;
import com.centit.framework.jtt.service.JttAccessTokenService;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.security.model.JsonCentitUserDetails;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.po.UserInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/jsmot"})
@Api(value="\u4ea4\u901a\u4e91\u5bf9\u63a5\u76f8\u5173\u63a5\u53e3", tags={"\u4ea4\u901a\u4e91\u5bf9\u63a5\u76f8\u5173\u63a5\u53e3"})
public class JsmotSyncController
extends BaseController {
    @Autowired
    private JsmotSyncConfig jsmotSyncConfig;
    @Autowired
    private JttAccessTokenService jttAccessTokenService;
    @Autowired
    private JsmotSyncService jsmotSyncService;
    @Autowired
    private UserInfoDao userInfoDao;
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired(required=false)
    private RedisTemplate<String, JSONObject> redisTemplate;

    private String getAccessToken() {
        String accessToken = "";
        ResponseData accessTokenData = this.jttAccessTokenService.getJsmotAccessToken();
        if (accessTokenData.getCode() != 0) {
            return "";
        }
        accessToken = accessTokenData.getData().toString();
        return accessToken;
    }

    @ApiOperation(value="\u4ea4\u901a\u4e91\u65b0\u589e\u4ece\u4e1a\u4eba\u5458", notes="\u4ea4\u901a\u4e91\u65b0\u589e\u4ece\u4e1a\u4eba\u5458")
    @PostMapping(value={"/usercreate"})
    @WrapUpResponseBody
    public ResponseData userCreate(@RequestBody JsmotUserDTO userInfo) {
        String accessToken = this.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u4ea4\u901a\u4e91accessToken\u5931\u8d25");
        }
        return this.jsmotSyncService.userCreate(accessToken, userInfo);
    }

    @ApiOperation(value="\u4ea4\u901a\u4e91\u65b0\u589e\u4ece\u4e1a\u4f01\u4e1a", notes="\u4ea4\u901a\u4e91\u65b0\u589e\u4ece\u4e1a\u4f01\u4e1a")
    @PostMapping(value={"/unitcreate"})
    @WrapUpResponseBody
    public ResponseData unitCreate(@RequestBody JsmotUnitDTO unitInfo) {
        String accessToken = this.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u4ea4\u901a\u4e91accessToken\u5931\u8d25");
        }
        return this.jsmotSyncService.unitCreate(accessToken, unitInfo);
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237userCode\u83b7\u53d6\u4ece\u4e1a\u4eba\u5458\u8be6\u60c5", notes="\u6839\u636e\u7528\u6237userCode\u83b7\u53d6\u4ece\u4e1a\u4eba\u5458\u8be6\u60c5\u3002")
    @GetMapping(value={"/{userCode}/{flag}"})
    @WrapUpResponseBody
    public ResponseData getCYUserDetail(@PathVariable String userCode, @PathVariable String flag) {
        String accessToken = this.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u4ea4\u901a\u4e91accessToken\u5931\u8d25");
        }
        return this.jsmotSyncService.getCYUserDetail(accessToken, userCode, flag);
    }

    @ApiOperation(value="\u6839\u636e\u4f01\u4e1aid\u83b7\u53d6\u4ece\u4e1a\u4f01\u4e1a\u8be6\u60c5", notes="\u6839\u636e\u4f01\u4e1aid\u83b7\u53d6\u4ece\u4e1a\u4f01\u4e1a\u8be6\u60c5\u3002")
    @GetMapping(value={"/{id}/{flag}"})
    @WrapUpResponseBody
    public ResponseData getUnitInfo(@PathVariable String id, @PathVariable String flag) {
        String accessToken = this.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u4ea4\u901a\u4e91accessToken\u5931\u8d25");
        }
        return this.jsmotSyncService.getCYCorpInfo(accessToken, id, flag);
    }

    private String getSmsAccessToken() {
        String accessToken = "";
        ResponseData accessTokenData = this.jttAccessTokenService.getSmsAccessToken();
        if (accessTokenData.getCode() != 0) {
            return "";
        }
        accessToken = accessTokenData.getData().toString();
        return accessToken;
    }

    @ApiOperation(value="\u4ea4\u901a\u5385\u77ed\u4fe1\u53d1\u9001", notes="\u4ea4\u901a\u5385\u77ed\u4fe1\u53d1\u9001")
    @PostMapping(value={"/sendsms"})
    @WrapUpResponseBody
    public ResponseData sendSms(@RequestBody SmsDTO smsDTO, HttpServletRequest request) {
        String accessToken = this.getSmsAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u77ed\u4fe1\u5e73\u53f0accessToken\u5931\u8d25");
        }
        return this.jsmotSyncService.sendSms(accessToken, smsDTO);
    }

    @ApiOperation(value="\u6ce8\u518c\u83b7\u53d6\u624b\u673a\u9a8c\u8bc1\u7801", notes="\u6ce8\u518c\u83b7\u53d6\u624b\u673a\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/getphonecode"})
    @ResponseBody
    public Map<String, Object> getPhoneCode(@RequestParam(value="userCode", required=false) String userCode, @RequestParam(value="phone") String phone, HttpServletRequest request, HttpServletResponse response) {
        UserInfo userInfo;
        JSONObject jsonObject = (JSONObject)this.redisTemplate.boundValueOps((Object)phone).get();
        HashMap<String, HashMap<String, Object>> map = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        if (jsonObject != null) {
            Long createTime = jsonObject.getLong("createTime");
            if (System.currentTimeMillis() - createTime < 60000L) {
                bodyMap.put("Message", "\u9a8c\u8bc1\u7801\u53d1\u9001\u65f6\u95f4\u5c0f\u4e8e1\u5206\u949f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
                bodyMap.put("Code", 500);
                map.put("body", bodyMap);
                return bodyMap;
            }
            this.redisTemplate.delete((Object)phone);
        }
        if (StringUtils.isNotBlank((CharSequence)phone) && (userInfo = this.userInfoDao.getUserByRegCellPhone(phone)) != null) {
            bodyMap.put("Message", "\u6b64\u624b\u673a\u53f7\u5df2\u88ab\u4f7f\u7528");
            bodyMap.put("Code", 500);
            map.put("body", bodyMap);
            return bodyMap;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String accessToken = this.getSmsAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            result.put("code", "-1");
            result.put("message", "\u83b7\u53d6\u77ed\u4fe1\u5e73\u53f0accessToken\u5931\u8d25");
            return result;
        }
        ResponseData sendData = this.sendPhone(accessToken, phone, userCode, request);
        if (sendData.getCode() != 0) {
            result.put("code", "-1");
            result.put("message", sendData.getMessage());
            return result;
        }
        result.put("code", sendData.getCode());
        result.put("message", sendData.getMessage());
        result.put("data", sendData.getData());
        result.put("x-auth-token", request.getSession().getId());
        return result;
    }

    @ApiOperation(value="\u9a8c\u8bc1\u7801\u6821\u9a8c\u548c\u7528\u6237\u4fe1\u606f\u66f4\u65b0", notes="\u9a8c\u8bc1\u7801\u6821\u9a8c\u548c\u7528\u6237\u4fe1\u606f\u66f4\u65b0")
    @PostMapping(value={"/checkcode"})
    @WrapUpResponseBody
    public ResponseData checkCode(@RequestParam(value="userCode", required=false) String userCode, @RequestParam(value="key") String key, @RequestParam(value="code") String code, HttpServletRequest request) {
        try {
            UserInfo user;
            if (StringUtils.isBlank((CharSequence)code)) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801\uff01");
            }
            JSONObject json = (JSONObject)this.redisTemplate.boundValueOps((Object)key).get();
            if (json == null) {
                json = JSON.parseObject((String)request.getHeader("verifyCode"));
            }
            if (json == null) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u672a\u53d1\u9001\u9a8c\u8bc1\u7801\uff01");
            }
            String verifyCode = json.getString("verifyCode");
            Long createTime = json.getLong("createTime");
            String email = json.getString("email");
            String phone = json.getString("phone");
            if (!verifyCode.equals(code)) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
            }
            if (System.currentTimeMillis() - createTime > 300000L) {
                return ResponseData.makeErrorMessage((int)500, (String)"\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff01");
            }
            if (StringUtils.isNotBlank((CharSequence)userCode) && null != (user = this.userInfoDao.getUserByCode(userCode))) {
                if (StringUtils.isNotBlank((CharSequence)email)) {
                    user.setRegEmail(email);
                    this.logger.info("\u7528\u6237:{}\u4fee\u6539\u7528\u6237\u4fe1\u606f\u90ae\u7bb1", (Object)userCode);
                } else if (StringUtils.isNotBlank((CharSequence)phone)) {
                    user.setRegCellPhone(phone);
                    this.logger.info("\u7528\u6237:{}\u4fee\u6539\u7528\u6237\u4fe1\u606f\u624b\u673a", (Object)userCode);
                }
                this.userInfoDao.updateUser(user);
                this.reloadAuthentication(user.getUserCode());
                CodeRepositoryCache.evictCache((String)"UserInfo");
            }
            request.getSession().removeAttribute(key);
            this.redisTemplate.delete((Object)key);
            return ResponseData.makeSuccessResponse();
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u8bc1\u7801\u6821\u9a8c\u548c\u7528\u6237\u4fe1\u606f\u66f4\u65b0\u5f02\u5e38:{}", (Object)e.getMessage());
            return ResponseData.errorResponse;
        }
    }

    private ResponseData sendPhone(String accessToken, String phone, String userCode, HttpServletRequest request) {
        String verifyCode = String.valueOf(new Random().nextInt(899999) + 100000);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("code", (Object)verifyCode);
        if (StringUtils.isNotBlank((CharSequence)userCode)) {
            UserInfo userInfo = this.userInfoDao.getUserByCode(userCode);
            if (null != userInfo) {
                jSONObject.put("product", (Object)("\u7528\u6237" + userInfo.getUserName()));
            } else {
                jSONObject.put("product", (Object)"\u7528\u6237");
            }
        } else {
            jSONObject.put("product", (Object)"\u7528\u6237");
        }
        SmsDTO smsDTO = new SmsDTO();
        JSONObject json = new JSONObject();
        json.put("phone", (Object)phone);
        json.put("verifyCode", (Object)verifyCode);
        json.put("createTime", (Object)System.currentTimeMillis());
        String conten = "\u3010\u6c5f\u82cf\u4ea4\u901a\u3011\u9a8c\u8bc1\u7801" + verifyCode + "\uff0c\u6709\u6548\u671f5\u5206\u949f";
        smsDTO.setContent(conten);
        smsDTO.setMobile(phone);
        ResponseData result = this.jsmotSyncService.sendSms(accessToken, smsDTO);
        if (result.getCode() == 0) {
            request.getSession().setAttribute(phone, (Object)json);
            this.redisTemplate.boundValueOps((Object)phone).set((Object)json);
        }
        return result;
    }

    private void reloadAuthentication(String userCode) {
        CentitUserDetails centitUserDetails = this.platformEnvironment.loadUserDetailsByUserCode(userCode);
        centitUserDetails.setLoginIp(this.getUserIp());
        SecurityContextHolder.getContext().setAuthentication((Authentication)centitUserDetails);
    }

    private String getUserIp() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal instanceof JsonCentitUserDetails) {
            JsonCentitUserDetails userDetails = (JsonCentitUserDetails)principal;
            return userDetails.getLoginIp();
        }
        return "";
    }
}

