/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jtt.utils;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);
    private static final int TIMEOUT = 20000;
    private static final String CHARSET_UTF_8 = "UTF-8";

    public static String httpGetRequest(String getUrl) {
        StringBuffer buffer = new StringBuffer();
        try {
            URL url = new URL(getUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            try (InputStream inputStream = connection.getInputStream();
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(inputStreamReader);){
                String line;
                while ((line = br.readLine()) != null) {
                    buffer.append(line);
                }
            }
            connection.disconnect();
        }
        catch (Exception e) {
            logger.error("GET\u8bf7\u6c42\u5931\u8d25!\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)getUrl);
            return null;
        }
        return buffer.toString();
    }

    public static String httpPostRequest(String postUrl, String contentType, String accessToken, String params) {
        StringBuffer buffer = new StringBuffer();
        try {
            Throwable throwable;
            Throwable throwable2;
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
            URL url = new URL(postUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            if ("json".equals(contentType)) {
                connection.setRequestProperty("Content-Type", "application/json;charset=utf-8");
            } else if ("form".equals(contentType)) {
                connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            }
            if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                connection.setRequestProperty("Authorization", "Bearer " + accessToken);
            }
            if (StringUtils.isNotBlank((CharSequence)params)) {
                try {
                    throwable2 = null;
                    try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);){
                        throwable = null;
                        try (BufferedWriter writer = new BufferedWriter(outputStreamWriter);){
                            writer.write(params);
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Throwable writer) {
                        throwable2 = writer;
                        throw writer;
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            connection.connect();
            try {
                throwable2 = null;
                try (InputStream inputStream = connection.getInputStream();){
                    throwable = null;
                    try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                         BufferedReader bf = new BufferedReader(inputStreamReader);){
                        String line;
                        while ((line = bf.readLine()) != null) {
                            buffer.append(line);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
            connection.disconnect();
        }
        catch (Exception e) {
            logger.error("POST\u8bf7\u6c42\u5931\u8d25,this error", (Throwable)e);
            logger.error("POST\u8bf7\u6c42\u5931\u8d25!\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)postUrl);
            return null;
        }
        return buffer.toString();
    }

    public static String postJsonData(String url, Map<String, String> params) {
        return HttpUtil.httpPost(url, null, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, Map<String, String> headers, Object params) {
        String result = "";
        CloseableHttpClient httpClient = HttpUtil.createSSLInsecureClient();
        HttpPost post = new HttpPost(url);
        post.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        post.addHeader("Connection", "Close");
        try {
            RequestConfig requestConfig = HttpUtil.getRequestConfig();
            post.setConfig(requestConfig);
            if (headers != null) {
                for (Map.Entry<String, String> e : headers.entrySet()) {
                    post.setHeader(e.getKey(), e.getValue());
                }
            }
            UrlEncodedFormEntity entity = null;
            if (params instanceof String) {
                String jsonStr = (String)params;
                post.setHeader("Content-Type", "application/json");
                entity = new StringEntity(jsonStr, CHARSET_UTF_8);
            } else if (params instanceof Map) {
                Map formParam = (Map)params;
                entity = HttpUtil.buildFormEntity(formParam);
            }
            if (entity != null) {
                post.setEntity(entity);
            }
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            result = HttpUtil.getResponseResult((HttpResponse)response);
            if (null != response) {
                response.close();
            }
        }
        catch (IOException e) {
            result = "";
            logger.error("\u3010postJsonData\u3011\u8bf7\u6c42\u5931\u8d25,error ", (Throwable)e);
            logger.error("\u3010postJsonData\u3011\u8bf7\u6c42\u5931\u8d25,\u8bf7\u6c42\u5730\u5740\uff1a{} ", (Object)url);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private static RequestConfig getRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(20000).setConnectionRequestTimeout(20000).setSocketTimeout(20000).setRedirectsEnabled(true).build();
    }

    private static String getResponseResult(HttpResponse response) {
        HttpEntity resEntity;
        int statusCode;
        String result = "";
        if (response != null && (statusCode = response.getStatusLine().getStatusCode()) == 200 && (resEntity = response.getEntity()) != null) {
            try {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)CHARSET_UTF_8);
                EntityUtils.consume((HttpEntity)resEntity);
            }
            catch (IOException | ParseException e) {
                logger.error(e.getMessage(), e);
            }
        }
        return result;
    }

    private static UrlEncodedFormEntity buildFormEntity(Map<String, String> formParam) {
        UrlEncodedFormEntity formEntity = null;
        try {
            if (formParam != null) {
                ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : formParam.entrySet()) {
                    nameValuePairList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                formEntity = new UrlEncodedFormEntity(nameValuePairList, CHARSET_UTF_8);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return formEntity;
    }

    public static JSONObject convertResponseBytes2JsonObj(HttpResponse response) {
        JSONObject jsonObject = null;
        try {
            InputStream inputStream = response.getEntity().getContent();
            byte[] respBytes = IOUtils.toByteArray((InputStream)inputStream);
            String result = new String(respBytes, StandardCharsets.UTF_8);
            if (StringUtils.isBlank((CharSequence)result)) {
                logger.info("\u8bf7\u6c42\u65e0\u54cd\u5e94==============================");
            } else if (result.startsWith("{") && result.endsWith("}")) {
                jsonObject = JSON.parseObject((String)result);
            } else {
                logger.info("\u8bf7\u6c42\u4e0d\u80fd\u8f6c\u6210JSON\u5bf9\u8c61==============================");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return jsonObject;
    }

    public static CloseableHttpClient createSSLInsecureClient() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return HttpClients.custom().setMaxConnTotal(100).setMaxConnPerRoute(40).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return HttpClients.createDefault();
        }
    }
}

