package com.centit.framework.jtt.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.security.core.context.SecurityContextHolder;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class test {
    public static void main(String[] args) {

//        Map<String, Object> filterMap = collectRequestParameters(request);
//        logger.info("南通政务单点登陆,参数：{}", filterMap);
        String ticket = "65f20cf29979c298b6a45a3b9c42acb7";
        String returnUrl = "aHR0cHM6Ly9udHMuanN6d2Z3Lmdvdi5jbjo5MDg3L250endkdC8/YXBwaWQ9ZWZmY2IxN2ItYmEyNC00MzYyLWI1OTktYTM0MWEzMDE5Nzgz";
//        logger.info("returnUrl值:{}", returnUrl);
        //ticket = ticket.replace(" ", "+");
        String errorMsg = "";
        String accessToken = "";
        try {
//            logger.info("ticket值：{}", ticket);
            JSONObject params = new JSONObject();
            params.put("appid", "effcb17b-ba24-4362-b599-a341a3019783");
            params.put("ticket", ticket);
            // params.put("token", URLEncoder.encode(ticket, "utf-8"));
            if (StringUtils.isBlank(accessToken) && StringUtils.isNotBlank(ticket)) {
                //验证ticket是否有效
                Boolean useSSL = BooleanBaseOpt.castObjectToBoolean("ntzwConfig.getNtSSL()", false);
                HttpClientContext context = HttpClientContext.create();
                CloseableHttpClient httpClient = null;
                if (useSSL) {
                    httpClient = HttpExecutor.createKeepSessionHttpsClient();
                } else {
                    httpClient = HttpExecutor.createKeepSessionHttpClient();
                }
                HttpExecutorContext executorContext = HttpExecutorContext.create(httpClient).context(context);
                String ticketResult = HttpExecutor.jsonPost(executorContext, "https://nts.jszwfw.gov.cn:9087/ntzwdt/rest/dhloginauth/ticketValidate", params.toJSONString());
//                logger.info("调用验证ticket:{},接口返回信息：{}", params, ticketResult);
                if (StringUtils.isNotEmpty(ticketResult)) {
                    JSONObject ticketJson = JSON.parseObject(ticketResult);
                    if (null != ticketJson) {
                        //获取token信息
                        String tockenObject = ticketJson.getString("token");
                        params.remove("ticket");
                        params.put("token",tockenObject);
                        String loginUser = HttpExecutor.jsonPost(executorContext, "https://nts.jszwfw.gov.cn:9087/ntzwdt/rest/dhloginauth/findUserByToken", params.toJSONString());
//                        logger.info("调用获取用户:{},接口返回信息：{}", params, loginUser);
                        JSONObject loginUserJson = JSON.parseObject(loginUser);
                        if (null != loginUserJson && StringUtils.isBlank(loginUserJson.getString("errormsg"))) {
                            String loginName = loginUserJson.getString("loginname");
//                            logger.info("loginName:{}", loginName);
                            CentitUserDetails ud = null;
//                            CentitUserDetails ud = platformEnvironment.loadUserDetailsByLoginName(loginName);
                            if (null != ud) {
                                SecurityContextHolder.getContext().setAuthentication(ud);
//                                accessToken = request.getSession().getId();
//                                logger.info("用户名：{}登录成功", loginName);
                            } else {
                                errorMsg = "登录名" + loginName + "不存在！";
                            }
                        } else {
                            if (null != loginUserJson) {
                                errorMsg = ticketJson.getString("errormsg");
                            } else {
                                errorMsg = "获取用户接口返回为空！";
                            }
                        }
                    } else {
                        if (null != ticketJson) {
                            errorMsg = ticketJson.getString("errormsg");
                        } else {
                            errorMsg = "南通政务ticket验证接口返回为空！";
                        }
                    }
                } else {
                    errorMsg = "南通政务ticket验证接口返回为空！";
                }
            } else {
                errorMsg = "南通政务ticket为空！";
            }
        } catch (Exception e) {
//            logger.error("南通政务单点登录异常：{}", e.getMessage());
            errorMsg = "南通政务单点登录异常:" + e.getMessage();
        }
        if (StringUtils.isNotBlank(errorMsg)) {
            String errorUrl = "redirect:redirecterror";
            try {
                errorUrl = errorUrl + "?msg=" + URLEncoder.encode(errorMsg, "UTF-8");
            } catch (UnsupportedEncodingException e) {
//                logger.error("URLEncoder异常", e);
            }
            System.out.println(errorUrl);
        } else {
            if (StringUtils.isNotBlank(returnUrl) && returnUrl.contains("?")) {
                returnUrl = returnUrl + "&accessToken=" + accessToken;
            } else {
                returnUrl = returnUrl + "?accessToken=" + accessToken;
            }
            //占位符 替换成/#/(特殊字符)
            if (StringUtils.isNotBlank(returnUrl) && returnUrl.indexOf("/A/") > -1) {
                returnUrl = returnUrl.replace("/A/", "/#/");
            }
        }
        System.out.println(returnUrl);
    }
}
