/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jtt.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.centit.framework.common.ResponseData;
import com.centit.framework.jtt.config.JsmotSyncConfig;
import com.centit.framework.jtt.dto.JsmotUnitDTO;
import com.centit.framework.jtt.dto.JsmotUserDTO;
import com.centit.framework.jtt.dto.SmsDTO;
import com.centit.framework.jtt.service.JsmotSyncService;
import com.centit.framework.jtt.utils.HttpUtil;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JsmotSyncServiceImpl
implements JsmotSyncService {
    private static final Logger logger = LoggerFactory.getLogger(JsmotSyncServiceImpl.class);
    @Autowired
    private JsmotSyncConfig jsmotSyncConfig;

    @Override
    public ResponseData userCreate(String accessToken, JsmotUserDTO userInfo) {
        String retMsg = "";
        String userCode = "";
        long retCode = 1L;
        try {
            String uri = this.jsmotSyncConfig.getJsmotHost() + "/organizeuser/dataSync/g/createCY" + "?accessToken=" + accessToken;
            String result = HttpExecutor.jsonPost((HttpExecutorContext)HttpExecutorContext.create(), (String)uri, (Object)JSON.parseObject((String)JSON.toJSONString((Object)userInfo)));
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (null != jsonObject) {
                retCode = jsonObject.getLong("retCode");
                retMsg = jsonObject.getString("retMsg");
                if (retCode != 0L) {
                    return ResponseData.makeErrorMessage((int)Integer.valueOf(String.valueOf(retCode)), (String)retMsg);
                }
            } else {
                return ResponseData.makeErrorMessage((int)1, (String)"\u8c03\u7528\u65b0\u589e\u4ece\u4e1a\u4eba\u5458\u8fd4\u56de\u4e3a\u7a7a");
            }
            userCode = jsonObject.getJSONObject("bizData").getString("userCode");
        }
        catch (Exception e) {
            logger.error("Failed to {}", (Object)"/organizeuser/dataSync/g/createCY", (Object)e);
            return ResponseData.makeErrorMessage((String)("Failed to userCreate: " + e.getMessage()));
        }
        return ResponseData.makeResponseData((Object)userCode);
    }

    @Override
    public ResponseData unitCreate(String accessToken, JsmotUnitDTO unitInfo) {
        String retMsg = "";
        String id = "";
        long retCode = 1L;
        try {
            String uri = this.jsmotSyncConfig.getJsmotHost() + "/organizeuser/dataSync/c/corpRegist" + "?accessToken=" + accessToken;
            String result = HttpExecutor.jsonPost((HttpExecutorContext)HttpExecutorContext.create(), (String)uri, (Object)JSON.parseObject((String)JSON.toJSONString((Object)unitInfo)));
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (null != jsonObject) {
                retCode = jsonObject.getLong("retCode");
                retMsg = jsonObject.getString("retMsg");
                if (retCode != 0L) {
                    return ResponseData.makeErrorMessage((int)Integer.valueOf(String.valueOf(retCode)), (String)retMsg);
                }
            } else {
                return ResponseData.makeErrorMessage((int)1, (String)"\u8c03\u7528\u65b0\u589e\u4ece\u4e1a\u4f01\u4e1a\u8fd4\u56de\u4e3a\u7a7a");
            }
            id = jsonObject.getJSONObject("bizData").getString("id");
        }
        catch (Exception e) {
            logger.error("Failed to {}", (Object)"/organizeuser/dataSync/c/corpRegist", (Object)e);
            return ResponseData.makeErrorMessage((String)("Failed to unitCreate: " + e.getMessage()));
        }
        return ResponseData.makeResponseData((Object)id);
    }

    @Override
    public ResponseData getCYUserDetail(String accessToken, String userCode, String flag) {
        String retMsg = "";
        long retCode = 1L;
        JSONObject bizData = new JSONObject();
        try {
            String uri = this.jsmotSyncConfig.getJsmotHost() + "/organizeuser/dataSync/g/getCYUserDetail" + "/" + userCode + "/" + flag + "?accessToken=" + accessToken;
            String result = HttpExecutor.simpleGet((HttpExecutorContext)HttpExecutorContext.create(), (String)uri);
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (null != jsonObject) {
                retCode = jsonObject.getLong("retCode");
                retMsg = jsonObject.getString("retMsg");
                if (retCode != 0L) {
                    return ResponseData.makeErrorMessage((int)Integer.valueOf(String.valueOf(retCode)), (String)retMsg);
                }
            } else {
                return ResponseData.makeErrorMessage((int)1, (String)"\u8c03\u7528\u83b7\u53d6\u4ece\u4e1a\u4eba\u5458\u8be6\u60c5\u8fd4\u56de\u4e3a\u7a7a");
            }
            bizData = jsonObject.getJSONObject("bizData");
        }
        catch (Exception e) {
            logger.error("Failed to {}", (Object)"/organizeuser/dataSync/g/getCYUserDetail", (Object)e);
            return ResponseData.makeErrorMessage((String)("Failed to getCYUserDetail: " + e.getMessage()));
        }
        return ResponseData.makeResponseData((Map)bizData);
    }

    @Override
    public ResponseData getCYCorpInfo(String accessToken, String id, String flag) {
        String retMsg = "";
        long retCode = 1L;
        JSONObject bizData = new JSONObject();
        try {
            String uri = this.jsmotSyncConfig.getJsmotHost() + "/organizeuser/dataSync/c/getCYCorpInfo" + "/" + id + "/" + flag + "?accessToken=" + accessToken;
            String result = HttpExecutor.simpleGet((HttpExecutorContext)HttpExecutorContext.create(), (String)uri);
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (null != jsonObject) {
                retCode = jsonObject.getLong("retCode");
                retMsg = jsonObject.getString("retMsg");
                if (retCode != 0L) {
                    return ResponseData.makeErrorMessage((int)Integer.valueOf(String.valueOf(retCode)), (String)retMsg);
                }
            } else {
                return ResponseData.makeErrorMessage((int)1, (String)"\u8c03\u7528\u83b7\u53d6\u4ece\u4e1a\u4f01\u4e1a\u8be6\u60c5\u8fd4\u56de\u4e3a\u7a7a");
            }
            bizData = jsonObject.getJSONObject("bizData");
        }
        catch (Exception e) {
            logger.error("Failed to {}", (Object)"/organizeuser/dataSync/c/getCYCorpInfo", (Object)e);
            return ResponseData.makeErrorMessage((String)("Failed to getCYUserDetail: " + e.getMessage()));
        }
        return ResponseData.makeResponseData((Map)bizData);
    }

    @Override
    public ResponseData sendSms(String accessToken, SmsDTO smsDTO) {
        String sendType;
        JSONArray bizArray;
        JSONObject bizData;
        block9: {
            String retCode = "";
            String data = "";
            String uri = "";
            bizData = new JSONObject();
            bizArray = new JSONArray();
            sendType = "0";
            try {
                JSONObject param = new JSONObject();
                param.put((Object)"content", (Object)smsDTO.getContent());
                if (CollectionUtils.isNotEmpty(smsDTO.getMobiles())) {
                    uri = this.jsmotSyncConfig.getSmsHost() + "/ttworksheet/sendEmayBatchonlysms";
                    param.put((Object)"mobiles", smsDTO.getMobiles());
                    sendType = "1";
                } else {
                    uri = this.jsmotSyncConfig.getSmsHost() + "/ttworksheet/sendEmaySinglesms";
                    param.put((Object)"mobile", (Object)smsDTO.getMobile());
                }
                String result = HttpUtil.httpPostRequest(uri, "json", accessToken, param.toJSONString(new JSONWriter.Feature[0]));
                JSONObject jsonObject = JSON.parseObject((String)result);
                if (null != jsonObject) {
                    retCode = jsonObject.getString("code");
                    if ("SUCCESS".equals(retCode)) {
                        data = jsonObject.getString("result");
                        if ("0".equals(sendType)) {
                            bizData = JSON.parseObject((String)data);
                        } else {
                            bizArray = JSON.parseArray((String)data);
                        }
                        break block9;
                    }
                    return ResponseData.makeErrorMessage((String)retCode);
                }
                return ResponseData.makeErrorMessage((int)1, (String)"\u8c03\u7528\u77ed\u4fe1\u5e73\u53f0\u53d1\u9001\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            catch (Exception e) {
                logger.error("Failed to {}", (Object)uri, (Object)e);
                return ResponseData.makeErrorMessage((String)("Failed to sendSms: " + e.getMessage()));
            }
        }
        if ("0".equals(sendType)) {
            return ResponseData.makeResponseData((Map)bizData);
        }
        return ResponseData.makeResponseData((Object)bizArray);
    }
}

