package com.centit.framework.jlwater.controller;

import cn.com.syan.jce.provider.SyanSDFProvider;
import cn.com.syan.sdfapi.DCUtil;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.appclient.HttpReceiveJSON;
import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.jlwater.service.SignAppSession;
import com.centit.framework.jlwater.service.VerSignAppSession;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.redshield.ebl.EblHsmEx;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpResponseException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.*;
import java.util.Base64;


@Controller
@RequestMapping("/jlwaterca")
@Api(value = "水务相关接口", tags = "水务相关接口")
public class JlwaterCaPlugin extends BaseController {
    public static final String IV = "BD613820D53BCD45D8FB033EB44A63D4";
    public static final String KEY = "7380B7786502DA610DB49E0E28F6161C";
    protected static final Logger logger = LoggerFactory.getLogger(JlwaterCaPlugin.class);
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired
    private SignAppSession signAppSession;
    @Autowired
    private VerSignAppSession verSignAppSession;

    @ApiOperation(value = "水务集团单点登陆", notes = "水务集团单点登陆")
    @GetMapping(value = "/login")
    public String waterLogin(HttpServletRequest request, HttpServletResponse response) {
        String returnUrl = request.getParameter("returnUrl");
        String loginName = request.getHeader("oam_remote_user");
        // 打印所有请求头
//        Enumeration<String> headerNames = request.getHeaderNames();
//        while (headerNames.hasMoreElements()) {
//            String headerName = headerNames.nextElement();
//            String headerValue = request.getHeader(headerName);
//            System.out.println("登录头："+headerName + "值为: " + headerValue);
//        }
//        if (null == loginName) {
//            loginName = request.getHeader("Oam_remote_user");
//        }
        if (null == loginName) {
            loginName = request.getParameter("testLoginName");
        }
        String errorMsg = "";
        if (StringUtils.isBlank(loginName)) {
            errorMsg = "oam_remote_user" + loginName + "不存在！";
        } else {
            CentitUserDetails ud = platformEnvironment.loadUserDetailsByLoginName(loginName);
            if (null != ud) {
                SecurityContextHolder.getContext().setAuthentication(ud);
            } else {
                errorMsg = "登录名" + loginName + "不存在！";
            }
        }
        if (StringUtils.isNotBlank(errorMsg)) {
            String errorUrl = "redirect:redirecterror";
            try {
                errorUrl = errorUrl + "?msg=" + URLEncoder.encode(errorMsg, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                logger.error("URLEncoder异常", e);
            }
            return errorUrl;
        }
        String accessToken = request.getSession().getId();
        if (StringUtils.isNotBlank(returnUrl)) {
            if (returnUrl.contains("/A/")) {
                returnUrl = returnUrl.replace("/A/", "/#/");
            }
            if (returnUrl.contains("?")) {
                returnUrl = returnUrl + "&accessToken=" + accessToken;
            } else {
                returnUrl = returnUrl + "?accessToken=" + accessToken;
            }
        }
        response.setHeader("x-auth-token", accessToken);
        return "redirect:" + returnUrl;
    }

    @ApiOperation(value = "sm4加密", notes = "sm4加密")
    @GetMapping(value = "/sm4encrypt")
    @WrapUpResponseBody
    public String sm4encrypt(String data) {
        if (data == null || data.isEmpty()) {
            return "";
        }
        EblHsmEx eblHsmEx = null;
        try {
            eblHsmEx = EblHsmEx.getHardInstance();
            byte[] dataByte = data.getBytes(StandardCharsets.UTF_8);
            return eblHsmEx.encrypt(100, "SM4/CBC/PKCS5Padding", DCUtil.hexStr2Bytes(IV), dataByte);
        } catch (Exception e) {
            logger.error("SM4加密失败: {}", data, e);
            throw new RuntimeException("加密失败",e);
        } finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
    }


    @ApiOperation(value = "sm4解密", notes = "sm4解密")
    @GetMapping(value = "/sm4decrypt")
    @WrapUpResponseBody
    public String sm4decrypt(String sm4ecb) {
        if (sm4ecb == null || sm4ecb.isEmpty()) {
            throw new IllegalArgumentException("输入数据不能为空");
        }
        EblHsmEx eblHsmEx = null;
        try {
            eblHsmEx = EblHsmEx.getHardInstance();
            byte[] decryptedBytes = eblHsmEx.decrypt(100, "SM4/CBC/PKCS5Padding", DCUtil.hexStr2Bytes(IV), sm4ecb);
            return new String(decryptedBytes, StandardCharsets.UTF_8);
        } catch (Exception e) {
            logger.error("SM4 解密失败: {}", e.getMessage(), e);
            throw new RuntimeException("解密失败",e);
        } finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
    }


    @ApiOperation(value = "外部密钥hmac", notes = "外部密钥hmac")
    @GetMapping(value = "/sm3encrypt")
    @WrapUpResponseBody
    public String sm3encrypt(String data) {
        if (data == null || data.isEmpty()) {
            return "";
        }
        EblHsmEx eblHsmEx = null;
        try {
            eblHsmEx = EblHsmEx.getHardInstance();
            byte[] dataByte = data.getBytes(StandardCharsets.UTF_8);
            byte[] mac = eblHsmEx.hmacBytes(DCUtil.hexStr2Bytes(KEY),"HmacSM3", dataByte);
            return Base64.getEncoder().encodeToString(mac);
        } catch (Exception e) {
            logger.error("SM3加密失败: {}", data, e);
            throw new RuntimeException("SM3加密失败", e);
        } finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
    }


    @ApiOperation(value = "数据加密处理", notes = "提供数据机密性保护的加密接口")
    @GetMapping(value = "/encryptAndMac")
    @WrapUpResponseBody
    public JSONObject encryptAndMac(String data) {
        JSONObject result = new JSONObject();
        if (data == null || data.isEmpty()) {
            result.put("sm4ecb", "");
            result.put("sm3Str", "");
            return result;
        }
        EblHsmEx eblHsmEx = null;
        try {
            eblHsmEx = EblHsmEx.getHardInstance();
            byte[] dataByte = data.getBytes(StandardCharsets.UTF_8);
            String sm4ecb = eblHsmEx.encrypt(100, "SM4/CBC/PKCS5Padding", DCUtil.hexStr2Bytes(IV), dataByte);
            if (sm4ecb == null) {
                throw new IllegalStateException("加密失败，返回结果为空");
            }
            byte[] mac = eblHsmEx.hmacBytes(DCUtil.hexStr2Bytes(KEY),"HmacSM3", dataByte);
            if (mac == null || mac.length == 0) {
                throw new IllegalStateException("MAC 生成失败");
            }
            String sm3Str = Base64.getEncoder().encodeToString(mac);
            result.put("sm4ecb", sm4ecb);
            result.put("sm3Str", sm3Str);
        } catch (Exception e) {
            logger.error("加密过程发生异常", e);
            throw new RuntimeException("加密过程发生异常",e);
        } finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
        return result;
    }

    @ApiOperation(value = "数据解密与完整性校验", notes = "解密SM4加密数据并验证HmacSM3完整性")
    @GetMapping(value = "/decryptAndVerify")
    @WrapUpResponseBody
    public JSONObject decryptAndVerify(String sm4ecb, String sm3Str) {
        if (sm4ecb == null || sm4ecb.isEmpty() || sm3Str == null || sm3Str.isEmpty()) {
            throw new IllegalArgumentException("输入数据不能为空");
        }
        EblHsmEx eblHsmEx = null;
        JSONObject jsonObject = new JSONObject();
        try {
            eblHsmEx = EblHsmEx.getHardInstance();
            byte[] decryptedBytes = eblHsmEx.decrypt(100, "SM4/CBC/PKCS5Padding", DCUtil.hexStr2Bytes(IV), sm4ecb);
            if (decryptedBytes == null || decryptedBytes.length == 0) {
                throw new IllegalArgumentException("解密结果为空");
            }
            byte[] mac = eblHsmEx.hmacBytes(DCUtil.hexStr2Bytes(KEY),"HmacSM3", decryptedBytes);
            String dataSm3Str = Base64.getEncoder().encodeToString(mac);
            String data = new String(decryptedBytes, StandardCharsets.UTF_8);
            jsonObject.put("data", data);
            jsonObject.put("isTampered", !dataSm3Str.equals(sm3Str));
        } catch (Exception e) {
            logger.error("解密或校验过程中发生异常", e);
            throw new RuntimeException("解密或校验过程中发生异常",e);
        } finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
        return jsonObject;
    }
    @ApiOperation(value = "获取随机数", notes = "获取随机数")
    @GetMapping(value = "/genrand")
    @WrapUpResponseBody
    public String genrand(){
        CloseableHttpClient httpClient = null;
        try {
            httpClient = signAppSession.allocHttpClient();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("length", 16);
            return signAppSession.formPost(httpClient,"/genrand", jsonObject);
        }catch (Exception e) {
            logger.error("访问：签名服务报错："+ e.getLocalizedMessage(), e);
            return null;
        } finally {
            if(httpClient!=null) {
                signAppSession.releaseHttpClient(httpClient);
            }
        }
    }
    @ApiOperation(value = "验签", notes = "验签")
    @PostMapping(value = "/verSign")
    @WrapUpResponseBody
    public ResponseData verSign(@RequestBody JSONObject jsonObject, HttpServletResponse response){
        CloseableHttpClient httpClient = null;
        try {
            httpClient = verSignAppSession.allocHttpClient();
            String data=jsonObject.getString("data");
            data=Base64.getEncoder().encodeToString(data.getBytes(StandardCharsets.UTF_8));
            jsonObject.put("data",data);
            verSignAppSession.formPost(httpClient,"/vp1", jsonObject);
            return ResponseData.makeSuccessResponse("验签成功");
        }catch (HttpResponseException e) {
            return ResponseData.makeErrorMessage(e.getStatusCode(),e.getReasonPhrase());
        } catch (Exception e) {
            return ResponseData.makeErrorMessage(ObjectException.UNKNOWN_EXCEPTION,e.getMessage());
        } finally {
            if(httpClient!=null) {
                verSignAppSession.releaseHttpClient(httpClient);
            }
        }
    }

}
