/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jlwater.controller;

import cn.com.syan.jce.provider.SyanSDFProvider;
import cn.com.syan.sdfapi.DCUtil;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseSingleData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.jlwater.service.SignAppSession;
import com.centit.framework.jlwater.service.VerSignAppSession;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.security.CentitUserDetails;
import com.redshield.ebl.EblHsmEx;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpResponseException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/jlwaterca"})
@Api(value="\u6c34\u52a1\u76f8\u5173\u63a5\u53e3", tags={"\u6c34\u52a1\u76f8\u5173\u63a5\u53e3"})
public class JlwaterCaPlugin
extends BaseController {
    public static final String IV = "BD613820D53BCD45D8FB033EB44A63D4";
    protected static final Logger logger = LoggerFactory.getLogger(JlwaterCaPlugin.class);
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired
    private SignAppSession signAppSession;
    @Autowired
    private VerSignAppSession verSignAppSession;

    @ApiOperation(value="\u6c34\u52a1\u96c6\u56e2\u5355\u70b9\u767b\u9646", notes="\u6c34\u52a1\u96c6\u56e2\u5355\u70b9\u767b\u9646")
    @GetMapping(value={"/login"})
    public String waterLogin(HttpServletRequest request, HttpServletResponse response) {
        String returnUrl = request.getParameter("returnUrl");
        String loginName = request.getHeader("oam_remote_user");
        if (null == loginName) {
            loginName = request.getParameter("testLoginName");
        }
        String errorMsg = "";
        if (StringUtils.isBlank((CharSequence)loginName)) {
            errorMsg = "oam_remote_user" + loginName + "\u4e0d\u5b58\u5728\uff01";
        } else {
            CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByLoginName(loginName);
            if (null != ud) {
                SecurityContextHolder.getContext().setAuthentication((Authentication)ud);
            } else {
                errorMsg = "\u767b\u5f55\u540d" + loginName + "\u4e0d\u5b58\u5728\uff01";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            String errorUrl = "redirect:redirecterror";
            try {
                errorUrl = errorUrl + "?msg=" + URLEncoder.encode(errorMsg, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("URLEncoder\u5f02\u5e38", (Throwable)e);
            }
            return errorUrl;
        }
        String accessToken = request.getSession().getId();
        if (StringUtils.isNotBlank((CharSequence)returnUrl)) {
            if (returnUrl.contains("/A/")) {
                returnUrl = returnUrl.replace("/A/", "/#/");
            }
            returnUrl = returnUrl.contains("?") ? returnUrl + "&accessToken=" + accessToken : returnUrl + "?accessToken=" + accessToken;
        }
        response.setHeader("x-auth-token", accessToken);
        return "redirect:" + returnUrl;
    }

    @ApiOperation(value="sm4\u52a0\u5bc6", notes="sm4\u52a0\u5bc6")
    @GetMapping(value={"/sm4encrypt"})
    @WrapUpResponseBody
    public JSONObject sm4encrypt(String data) {
        JSONObject result = new JSONObject();
        if (data == null || data.isEmpty()) {
            result.put((Object)"sm4ecb", (Object)"");
            result.put((Object)"random", (Object)"");
            return result;
        }
        EblHsmEx eblHsmEx = null;
        try {
            String random = JlwaterCaPlugin.genRandom(16);
            eblHsmEx = EblHsmEx.getHardInstance();
            byte[] dataByte = data.getBytes(StandardCharsets.UTF_8);
            result.put((Object)"random", (Object)random);
            result.put((Object)"sm4ecb", (Object)eblHsmEx.encrypt(100, "SM4/CBC/PKCS5Padding", DCUtil.hexStr2Bytes((String)random), dataByte));
            JSONObject jSONObject = result;
            return jSONObject;
        }
        catch (Exception e) {
            logger.error("SM4\u52a0\u5bc6\u5931\u8d25: {}", (Object)data, (Object)e);
            throw new RuntimeException("\u52a0\u5bc6\u5931\u8d25", e);
        }
        finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
    }

    @ApiOperation(value="sm4\u89e3\u5bc6", notes="sm4\u89e3\u5bc6")
    @GetMapping(value={"/sm4decrypt"})
    @WrapUpResponseBody
    public String sm4decrypt(String sm4ecb, String random) {
        if (sm4ecb == null || sm4ecb.isEmpty()) {
            return "";
        }
        EblHsmEx eblHsmEx = null;
        try {
            eblHsmEx = EblHsmEx.getHardInstance();
            byte[] decryptedBytes = eblHsmEx.decrypt(100, "SM4/CBC/PKCS5Padding", DCUtil.hexStr2Bytes((String)random), sm4ecb);
            String string = new String(decryptedBytes, StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            logger.error("SM4 \u89e3\u5bc6\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("\u89e3\u5bc6\u5931\u8d25", e);
        }
        finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
    }

    @ApiOperation(value="\u5916\u90e8\u5bc6\u94a5hmac", notes="\u5916\u90e8\u5bc6\u94a5hmac")
    @GetMapping(value={"/sm3encrypt"})
    @WrapUpResponseBody
    public JSONObject sm3encrypt(String data) {
        JSONObject result = new JSONObject();
        if (data == null || data.isEmpty()) {
            result.put((Object)"sm3Str", (Object)"");
            result.put((Object)"random", (Object)"");
            return result;
        }
        EblHsmEx eblHsmEx = null;
        try {
            String random = JlwaterCaPlugin.genRandom(16);
            eblHsmEx = EblHsmEx.getHardInstance();
            byte[] dataByte = data.getBytes(StandardCharsets.UTF_8);
            byte[] mac = eblHsmEx.hmacBytes(DCUtil.hexStr2Bytes((String)random), "HmacSM3", dataByte);
            result.put((Object)"sm3Str", (Object)Base64.getEncoder().encodeToString(mac));
            result.put((Object)"random", (Object)random);
            JSONObject jSONObject = result;
            return jSONObject;
        }
        catch (Exception e) {
            logger.error("SM3\u52a0\u5bc6\u5931\u8d25: {}", (Object)data, (Object)e);
            throw new RuntimeException("SM3\u52a0\u5bc6\u5931\u8d25", e);
        }
        finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
    }

    @ApiOperation(value="\u6570\u636e\u52a0\u5bc6\u5904\u7406", notes="\u63d0\u4f9b\u6570\u636e\u673a\u5bc6\u6027\u4fdd\u62a4\u7684\u52a0\u5bc6\u63a5\u53e3")
    @GetMapping(value={"/encryptAndMac"})
    @WrapUpResponseBody
    public JSONObject encryptAndMac(String data) {
        JSONObject result = new JSONObject();
        if (data == null || data.isEmpty() || "".equals(data.trim())) {
            result.put((Object)"sm4ecb", (Object)"");
            result.put((Object)"sm3Str", (Object)"");
            return result;
        }
        EblHsmEx eblHsmEx = null;
        try {
            String random = JlwaterCaPlugin.genRandom(16);
            result.put((Object)"random", (Object)random);
            eblHsmEx = EblHsmEx.getHardInstance();
            byte[] dataByte = data.getBytes(StandardCharsets.UTF_8);
            String sm4ecb = eblHsmEx.encrypt(100, "SM4/CBC/PKCS5Padding", DCUtil.hexStr2Bytes((String)random), dataByte);
            System.out.println(random);
            if (sm4ecb == null) {
                throw new IllegalStateException("\u52a0\u5bc6\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            }
            byte[] mac = eblHsmEx.hmacBytes(DCUtil.hexStr2Bytes((String)random), "HmacSM3", dataByte);
            if (mac == null || mac.length == 0) {
                throw new IllegalStateException("MAC \u751f\u6210\u5931\u8d25");
            }
            String sm3Str = Base64.getEncoder().encodeToString(mac);
            result.put((Object)"sm4ecb", (Object)sm4ecb);
            result.put((Object)"sm3Str", (Object)sm3Str);
        }
        catch (Exception e) {
            logger.error("\u52a0\u5bc6\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u52a0\u5bc6\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38", e);
        }
        finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
        return result;
    }

    @ApiOperation(value="\u6570\u636e\u89e3\u5bc6\u4e0e\u5b8c\u6574\u6027\u6821\u9a8c", notes="\u89e3\u5bc6SM4\u52a0\u5bc6\u6570\u636e\u5e76\u9a8c\u8bc1HmacSM3\u5b8c\u6574\u6027")
    @GetMapping(value={"/decryptAndVerify"})
    @WrapUpResponseBody
    public JSONObject decryptAndVerify(String sm4ecb, String sm3Str, String random) {
        String data = "";
        String dataSm3Str = "";
        JSONObject jsonObject = new JSONObject();
        if (sm4ecb == null || sm4ecb.isEmpty()) {
            jsonObject.put((Object)"data", (Object)data);
            if (sm3Str == null || sm3Str.isEmpty()) {
                jsonObject.put((Object)"isTampered", (Object)true);
            } else {
                jsonObject.put((Object)"isTampered", (Object)false);
            }
            return jsonObject;
        }
        EblHsmEx eblHsmEx = null;
        try {
            eblHsmEx = EblHsmEx.getHardInstance();
            byte[] decryptedBytes = eblHsmEx.decrypt(100, "SM4/CBC/PKCS5Padding", DCUtil.hexStr2Bytes((String)random), sm4ecb);
            if (decryptedBytes == null || decryptedBytes.length == 0) {
                throw new IllegalArgumentException("\u89e3\u5bc6\u7ed3\u679c\u4e3a\u7a7a");
            }
            byte[] mac = eblHsmEx.hmacBytes(DCUtil.hexStr2Bytes((String)random), "HmacSM3", decryptedBytes);
            dataSm3Str = Base64.getEncoder().encodeToString(mac);
            data = new String(decryptedBytes, StandardCharsets.UTF_8);
            jsonObject.put((Object)"data", (Object)data);
            jsonObject.put((Object)"isTampered", (Object)(!dataSm3Str.equals(sm3Str) ? 1 : 0));
        }
        catch (Exception e) {
            logger.error("\u89e3\u5bc6\u6216\u6821\u9a8c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u89e3\u5bc6\u6216\u6821\u9a8c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", e);
        }
        finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
        return jsonObject;
    }

    @ApiOperation(value="\u5b8c\u6574\u6027\u6821\u9a8c", notes="true\u5df2\u7be1\u6539")
    @GetMapping(value={"/verify"})
    @WrapUpResponseBody
    public boolean verify(String data, String sm3Str, String random) {
        if (data == null || data.isEmpty()) {
            return sm3Str == null || sm3Str.isEmpty();
        }
        EblHsmEx eblHsmEx = null;
        try {
            eblHsmEx = EblHsmEx.getHardInstance();
            byte[] dataByte = data.getBytes(StandardCharsets.UTF_8);
            byte[] mac = eblHsmEx.hmacBytes(DCUtil.hexStr2Bytes((String)random), "HmacSM3", dataByte);
            if (mac == null || mac.length == 0) {
                throw new IllegalStateException("MAC \u751f\u6210\u5931\u8d25");
            }
            String dataSm3Str = Base64.getEncoder().encodeToString(mac);
            boolean bl = !dataSm3Str.equals(sm3Str);
            return bl;
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u6821\u9a8c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", e);
        }
        finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
    }

    private static String genRandom(int count) {
        SecureRandom random = null;
        try {
            Security.addProvider((Provider)new SyanSDFProvider());
            random = SecureRandom.getInstance("SDF", "SyanSDFProvider");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        if (random == null) {
            return IV;
        }
        byte[] result = random.generateSeed(count);
        return DCUtil.bytes2HexStr((byte[])result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u83b7\u53d6\u968f\u673a\u6570", notes="\u83b7\u53d6\u968f\u673a\u6570")
    @GetMapping(value={"/genrand"})
    @WrapUpResponseBody
    public String genrand() {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.signAppSession.allocHttpClient();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"length", (Object)16);
            String string = this.signAppSession.formPost(httpClient, "/genrand", jsonObject);
            return string;
        }
        catch (Exception e) {
            logger.error("\u8bbf\u95ee\uff1a\u7b7e\u540d\u670d\u52a1\u62a5\u9519\uff1a" + e.getLocalizedMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                this.signAppSession.releaseHttpClient(httpClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u9a8c\u7b7e", notes="\u9a8c\u7b7e")
    @PostMapping(value={"/verSign"})
    @WrapUpResponseBody
    public ResponseData verSign(@RequestBody JSONObject jsonObject, HttpServletResponse response) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.verSignAppSession.allocHttpClient();
            String data = jsonObject.getString("data");
            data = Base64.getEncoder().encodeToString(data.getBytes(StandardCharsets.UTF_8));
            jsonObject.put((Object)"data", (Object)data);
            this.verSignAppSession.formPost(httpClient, "/vp1", jsonObject);
            ResponseSingleData responseSingleData = ResponseData.makeSuccessResponse((String)"\u9a8c\u7b7e\u6210\u529f");
            return responseSingleData;
        }
        catch (HttpResponseException e) {
            ResponseSingleData responseSingleData = ResponseData.makeErrorMessage((int)e.getStatusCode(), (String)e.getReasonPhrase());
            return responseSingleData;
        }
        catch (Exception e) {
            ResponseSingleData responseSingleData = ResponseData.makeErrorMessage((int)601, (String)e.getMessage());
            return responseSingleData;
        }
        finally {
            if (httpClient != null) {
                this.verSignAppSession.releaseHttpClient(httpClient);
            }
        }
    }
}

