/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.locode.platform.po.AppInfo;
import com.centit.locode.platform.service.AppInfoService;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/appInfo"})
@Api(tags={"\u79fb\u52a8\u7aef\u7248\u672c\u7ba1\u7406\u63a5\u53e3"}, value="\u79fb\u52a8\u7aef\u7248\u672c\u7ba1\u7406\u63a5\u53e3")
public class AppInfoController
extends BaseController {
    @Autowired
    private AppInfoService appInfoService;
    private String optId = "APPINFO";
    @Value(value="${app.key}")
    private String appKey;
    private String displayImageUrl = "/api/fileserver/fileserver/download/pfile/displayImageUrl.png";
    private String fullImageUrl = "/api/fileserver/fileserver/download/pfile/fullImageUrl.png";

    @ApiOperation(value="\u79fb\u52a8\u7aef\u7248\u672c\u5217\u8868", notes="\u79fb\u52a8\u7aef\u7248\u672c\u5217\u8868")
    @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)
    @RequestMapping(method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public PageQueryResult<Object> list(PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        searchColumn.put("topUnit", topUnit);
        JSONArray listObjects = this.appInfoService.listObjectsAsJson(searchColumn, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc, (Class[])new Class[]{AppInfo.class});
    }

    @ApiOperation(value="\u65b0\u589e\u79fb\u52a8\u7aef\u7248\u672c\u4fe1\u606f", notes="\u65b0\u589e\u79fb\u52a8\u7aef\u7248\u672c\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="appInfo", value="json\u683c\u5f0f\uff0c\u79fb\u52a8\u7aef\u7248\u672c\u4fe1\u606f", required=true, paramType="body", dataTypeClass=AppInfo.class)
    @RequestMapping(method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData saveAppInfo(@RequestBody AppInfo appInfo, HttpServletRequest request) {
        appInfo.setCreator(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        appInfo.setTopUnit(topUnit);
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("versionId", appInfo.getVersionId());
        filter.put("appType", appInfo.getAppType());
        filter.put("topUnit", appInfo.getTopUnit());
        filter.put("ownApp", appInfo.getOwnApp());
        List appInfoList = this.appInfoService.listObjectsByProperties(filter);
        if (appInfoList != null && appInfoList.size() > 0) {
            return ResponseData.makeErrorMessage((String)"\u7248\u672c\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u4fdd\u5b58!");
        }
        if (StringUtils.isNotBlank((CharSequence)appInfo.getFileId())) {
            String fileUrl = "api/fileserver/fileserver/download/pfile/" + appInfo.getFileId();
            appInfo.setFileUrl(fileUrl);
        }
        this.appInfoService.saveNewObject(appInfo);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)appInfo.getId(), (String)"create", (String)"\u65b0\u589e\u79fb\u52a8\u7aef\u7248\u672c\u4fe1\u606f", (Object)appInfo);
        return ResponseData.makeResponseData((Object)appInfo.getId());
    }

    @ApiOperation(value="\u4fee\u6539\u79fb\u52a8\u7aef\u7248\u672c\u4fe1\u606f", notes="\u4fee\u6539\u79fb\u52a8\u7aef\u7248\u672c\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appId", value="\u4e3b\u952eId", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="appInfo", value="json\u683c\u5f0f\uff0c\u79fb\u52a8\u7aef\u7248\u672c\u4fe1\u606f", required=true, paramType="body", dataTypeClass=AppInfo.class)})
    @RequestMapping(value={"/{appId}"}, method={RequestMethod.PUT})
    public void updateAppInfoById(@PathVariable String appId, @RequestBody AppInfo appInfo, HttpServletRequest request, HttpServletResponse response) {
        AppInfo temp = (AppInfo)this.appInfoService.getObjectById((Serializable)((Object)appId));
        AppInfo oldApp = new AppInfo();
        BeanUtils.copyProperties((Object)temp, (Object)oldApp);
        if (StringUtils.isNotBlank((CharSequence)appInfo.getFileId())) {
            String fileUrl = "api/fileserver/fileserver/download/pfile/" + appInfo.getFileId();
            appInfo.setFileUrl(fileUrl);
        }
        this.appInfoService.updateObject(appInfo);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logUpdateObject((HttpServletRequest)request, (String)this.optId, (String)appId, (String)"update", (String)"\u4fee\u6539\u79fb\u52a8\u7aef\u7248\u672c\u4fe1\u606f", (Object)appInfo, (Object)oldApp);
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u4e2a\u79fb\u52a8\u7aef\u7248\u672c\u4fe1\u606f", notes="\u83b7\u53d6\u5355\u4e2a\u79fb\u52a8\u7aef\u7248\u672c\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="appId", value="\u79fb\u52a8\u7aef\u7248\u672c\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{appId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public AppInfo getAppInfoById(@PathVariable String appId) {
        return (AppInfo)this.appInfoService.getObjectById((Serializable)((Object)appId));
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u79fb\u52a8\u7aef\u7248\u672c\u4fe1\u606f", notes="\u5220\u9664\u5355\u4e2a\u79fb\u52a8\u7aef\u7248\u672c\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="appId", value="\u79fb\u52a8\u7aef\u7248\u672c\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{appId}"}, method={RequestMethod.DELETE})
    public void deleteAppInfo(@PathVariable String appId, HttpServletRequest request, HttpServletResponse response) {
        AppInfo appInfo = (AppInfo)this.appInfoService.getObjectById((Serializable)((Object)appId));
        this.appInfoService.deleteObjectById((Serializable)((Object)appId));
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)this.optId, (String)appId, (String)"delete", (String)"\u5220\u9664\u79fb\u52a8\u7aef\u7248\u672c\u4fe1\u606f", (Object)appInfo);
    }

    @ApiOperation(value="\u83b7\u53d6\u6700\u65b0\u7248\u7684\u79fb\u52a8\u7aef\u7248\u672c", notes="\u83b7\u53d6\u6700\u65b0\u7248\u7684\u79fb\u52a8\u7aef\u7248\u672c\u3002")
    @RequestMapping(value={"/getLastAppInfo/{appType}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public JSONObject getLastAppInfo(@PathVariable String appType, HttpServletRequest request) {
        String ownApp = request.getParameter("ownApp");
        if (StringUtils.isBlank((CharSequence)ownApp)) {
            ownApp = "system";
        }
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("appType", appType);
        filter.put("ownApp", ownApp);
        List appInfoList = this.appInfoService.listObjectsByProperties(filter);
        if (appInfoList == null || appInfoList.size() == 0) {
            throw new ObjectException("\u672a\u83b7\u53d6\u5230\u7248\u672c\u53f7!");
        }
        AppInfo appInfo = new AppInfo();
        if (appInfoList != null && appInfoList.size() > 0) {
            appInfo = (AppInfo)appInfoList.get(0);
            if (appInfoList.size() > 1) {
                for (int i = 1; i < appInfoList.size(); ++i) {
                    AppInfo appNext = (AppInfo)appInfoList.get(i);
                    if (this.compareAppVersion(appInfo.getVersionId(), appNext.getVersionId()) >= 0) continue;
                    appInfo = appNext;
                }
            }
        }
        if (appType.equals("IOS")) {
            String serverName = "https://" + request.getServerName() + "/" + this.appKey;
            String url = "itms-services://?action=download-manifest&url=" + serverName + "/api/framework/system/appInfo/manifest.plist";
            appInfo.setFileUrl(url);
        }
        JSONObject params = JSONObject.parseObject((String)JSONObject.toJSONString((Object)appInfo, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        return params;
    }

    @ApiOperation(value="\u83b7\u53d6\u6700\u65b0\u7248\u7684\u79fb\u52a8\u7aef\u4e0b\u8f7d\u5730\u5740", notes="\u83b7\u53d6\u6700\u65b0\u7248\u7684\u79fb\u52a8\u7aef\u4e0b\u8f7d\u5730\u5740\u3002")
    @RequestMapping(value={"/getLastAppUrl"}, method={RequestMethod.GET})
    public void getLastAppUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String ownApp = request.getParameter("ownApp");
        if (StringUtils.isBlank((CharSequence)ownApp)) {
            ownApp = "system";
        }
        String serverName = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + "/" + this.appKey;
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("appType", "Android");
        filter.put("ownApp", ownApp);
        List appInfoList = this.appInfoService.listObjectsByProperties(filter);
        if (appInfoList == null || appInfoList.size() == 0) {
            throw new ObjectException("\u672a\u83b7\u53d6\u5230\u7248\u672c\u53f7!");
        }
        AppInfo appInfo = new AppInfo();
        if (appInfoList != null && appInfoList.size() > 0) {
            appInfo = (AppInfo)appInfoList.get(0);
            if (appInfoList.size() > 1) {
                for (int i = 1; i < appInfoList.size(); ++i) {
                    AppInfo appNext = (AppInfo)appInfoList.get(i);
                    if (this.compareAppVersion(appInfo.getVersionId(), appNext.getVersionId()) >= 0) continue;
                    appInfo = appNext;
                }
            }
        }
        String url = serverName + "/" + appInfo.getFileUrl();
        response.sendRedirect(url);
    }

    @ApiOperation(value="\u83b7\u53d6\u6700\u65b0\u7248\u7684IOS\u4e0b\u8f7d\u5730\u5740", notes="\u83b7\u53d6\u6700\u65b0\u7248\u7684IOS\u4e0b\u8f7d\u5730\u5740\u3002")
    @RequestMapping(value={"/manifest.plist"}, method={RequestMethod.GET})
    public void getLastIOSUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String ownApp = request.getParameter("ownApp");
        if (StringUtils.isBlank((CharSequence)ownApp)) {
            ownApp = "system";
        }
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("appType", "IOS");
        filter.put("ownApp", ownApp);
        List appInfoList = this.appInfoService.listObjectsByProperties(filter);
        if (appInfoList == null || appInfoList.size() == 0) {
            throw new ObjectException("\u672a\u83b7\u53d6\u5230\u7248\u672c\u53f7!");
        }
        AppInfo appInfo = new AppInfo();
        if (appInfoList != null && appInfoList.size() > 0) {
            appInfo = (AppInfo)appInfoList.get(0);
            if (appInfoList.size() > 1) {
                for (int i = 1; i < appInfoList.size(); ++i) {
                    AppInfo appNext = (AppInfo)appInfoList.get(i);
                    if (this.compareAppVersion(appInfo.getVersionId(), appNext.getVersionId()) >= 0) continue;
                    appInfo = appNext;
                }
            }
        }
        String serverName = "https://" + request.getServerName() + "/" + this.appKey;
        String plist = this.creatPlist(appInfo, serverName);
        response.reset();
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Disposition", "inline;fileName=ios.plist");
        response.setContentType("application/xml");
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write(plist.getBytes("UTF-8"));
        outputStream.close();
    }

    private Integer compareAppVersion(String version1, String version2) {
        if (version1 == null || version2 == null) {
            throw new RuntimeException("\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] versionArray1 = version1.split("\\.");
        String[] versionArray2 = version2.split("\\.");
        int minLength = Math.min(versionArray1.length, versionArray2.length);
        int diff = 0;
        for (int idx = 0; idx < minLength && (diff = versionArray1[idx].length() - versionArray2[idx].length()) == 0 && (diff = versionArray1[idx].compareTo(versionArray2[idx])) == 0; ++idx) {
        }
        diff = diff != 0 ? diff : versionArray1.length - versionArray2.length;
        return diff;
    }

    private String creatPlist(AppInfo appInfo, String serverName) {
        String pList = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n<dict>\n<key>items</key>\n<array>\n<dict>\n<key>assets</key>\n<array>\n<dict>\n<key>kind</key>\n<string>software-package</string>\n<key>url</key>\n<string>" + serverName + "/" + appInfo.getFileUrl() + "</string>\n</dict>\n<dict>\n<key>kind</key>\n<string>display-image</string>\n<key>url</key>\n<string>" + serverName + this.displayImageUrl + "</string>\n</dict>\n<dict>\n<key>kind</key>\n<string>full-size-image</string>\n<key>url</key>\n<string>" + serverName + this.fullImageUrl + "</string>\n</dict>\n</array>\n<key>metadata</key>\n<dict>\n<key>bundle-identifier</key>\n<string>com.centit.checkWorkApp</string>\n<key>bundle-version</key>\n<string>" + appInfo.getVersionId() + "</string>\n<key>kind</key>\n<string>software</string>\n<key>platform-identifier</key>\n<string>com.apple.platform.iphoneos</string>\n<key>title</key>\n<string>\u4e50\u6263\u5f00\u53d1\u5e73\u53f0</string>\n</dict>\n</dict>\n</array>\n</dict>\n</plist>";
        return pList;
    }
}

