/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.vo;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.dde.adapter.DdeDubboTaskRun;
import com.centit.dde.adapter.po.DataPacket;
import com.centit.dde.adapter.po.DataPacketDraft;
import com.centit.dde.adapter.po.DataPacketParam;
import com.centit.dde.adapter.po.DataPacketParamDraft;
import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileInfoOpt;
import com.centit.fileserver.po.FileInfo;
import com.centit.framework.model.basedata.DataCatalog;
import com.centit.framework.model.basedata.DataDictionary;
import com.centit.framework.model.basedata.OptInfo;
import com.centit.framework.model.basedata.OptMethod;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.locode.platform.po.ApplicationDictionary;
import com.centit.locode.platform.vo.AppTableNames;
import com.centit.metaform.po.MetaFormModel;
import com.centit.metaform.po.MetaFormModelDraft;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaOptRelation;
import com.centit.product.metadata.po.MetaRelDetail;
import com.centit.product.metadata.po.MetaRelation;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.po.PendingMetaColumn;
import com.centit.product.metadata.po.PendingMetaTable;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.algorithm.ZipCompressor;
import com.centit.support.common.JavaBeanMetaData;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileSystemOpt;
import com.centit.workflow.po.FlowInfo;
import com.centit.workflow.po.FlowTransition;
import com.centit.workflow.po.NodeInfo;
import com.centit.workflow.po.OptTeamRole;
import com.centit.workflow.po.OptVariableDefine;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonAppVo {
    protected static final Logger logger = LoggerFactory.getLogger(JsonAppVo.class);
    private static final String OS_ID = "osId";
    private static final String PAGE_FLOW = "pageFlow";
    private static final String DATABASE_CODE = "databaseCode";
    private static final String TABLE_ID = "tableId";
    private static final String REFERENCE_DATA = "referenceData";
    private static final String RELATION_ID = "relationId";
    private static final String PARENT_TABLE_ID = "parentTableId";
    private static final String OPT_ID = "optId";
    private static final String NODE_TYPE = "nodeType";
    private static final String ID = "id";
    private static final String PACKET_ID = "packetId";
    private static final String DATA_OPT_DESC_JSON = "dataOptDescJson";
    private static final String FLOW_XML_DESC = "flowXmlDesc";
    private static final String MODEL_ID = "modelId";
    private static final String FORM_TEMPLATE = "formTemplate";
    private static final String OPT_TEAM_ROLE_ID = "optTeamRoleId";
    private static final String OPT_VARIABLE_ID = "optVariableId";
    private static final String OPT_CODE = "optCode";
    private static final String CHILD_TABLE_ID = "childTableId";
    private static final String VERSION = "version";
    private static final String FLOW_CODE = "flowCode";
    private static final String SUB_FLOW_CODE = "subFlowCode";
    private static final String NODE_ID = "nodeId";
    private static final String TRANS_ID = "transId";
    private static final String START_NODE_ID = "startNodeId";
    private static final String END_NODE_ID = "endNodeId";
    private static final String TOP_UNIT = "topUnit";
    private static final String NO_PUBLISH = "W";
    private static final String MAX_LENGTH = "maxLength";
    private static final String COLUMN_LENGTH = "columnLength";
    private static final String LIBRARY_ID = "libraryId";
    private static final String TOP_OPT_ID = "topOptId";
    private static final String PRE_OPT_ID = "preOptId";
    private static final String UPDATE_DATE = "updateDate";
    private static final String CREATE_TIME = "createTime";
    private static final String LAST_MODIFY_DATE = "lastModifyDate";
    private static final String UPDATE_TIME = "updateTime";
    private static final String RECORD_DATE = "recordDate";
    private static final String PUBLISH_DATE = "publishDate";
    private static final String MODIFY_TIME = "modifyTime";
    private static final String FLOW_PUBLISH_DATE = "flowPublishDate";
    private static final String REL_OPT_ID = "relOptId";
    private static final String CREATED = "created";
    private static final String CREATE_USER = "createUser";
    private static final String OWN_USER = "ownUser";
    private static final String RECORDER = "recorder";
    private static final String UPDATOR = "updator";
    private static final String CREATOR = "creator";
    private static final String CREATE_DATE = "createDate";
    private static final String TABLE_TYPE = "T";
    private static final String DEFAULT_DATABASE = "defaultDatabase";
    private static final String TABLE_NAME = "tableName";
    private static final String SOURCE_ID = "sourceId";
    private static final String DOC_ID = "docId";
    private static final String ROLE_CODE = "roleCode";
    private static final String VARIABLE_NAME = "variableName";
    private static final String OS_NAME = "osName";
    private static final String LIBRARY_NAME = "libraryName";
    private static final String FORM_CODE = "formCode";
    private static final String MOBILE_FORM_TEMPLATE = "mobileFormTemplate";
    private static final String STRUCTURE_FUNCTION = "structureFunction";
    private static final String DATABASE_ID = "databaseId";
    private static final String DICTIONARY_ID = "dictionaryId";
    private static final String DATABASE_ID_CLASS = "dataBaseId";
    private static final String PUSH_USER = "pushUser";
    private static final String PUSH_TIME = "pushTime";
    private static final String OPT_ROUTE = "optRoute";
    private static final String OPT_URL = "optUrl";
    private static final String API_ID = "apiId";
    private static final String DDE_RUN = "/dde/run/";
    private static final String CATALOG_CODE = "catalogCode";
    private static final String FIRST_NODE_ID = "firstNodeId";
    private static final String TASK_TYPE = "taskType";
    private static final String IS_VALID = "isValid";
    private static final String TASK_CRON = "taskCron";
    private static final String MAP_DATA_CODE = "mapDataCode";
    private static final String LOGO_FILE_ID = "logoFileId";
    private static final String PIC_ID = "picId";
    private final Date now;
    private JSONObject oldAppObject;
    private Map<String, List<Map<String, Object>>> mapJsonObject = new HashMap<String, List<Map<String, Object>>>();
    private final String zipFilePath;
    private final String appHome;
    private final FileInfoOpt fileInfoOpt;
    private String userCode;
    private final String topUnit;
    private String osId;
    private List<Object> appList = new ArrayList<Object>();
    private List<Object> metaObject = new ArrayList<Object>();
    private boolean uploadFiles;
    private boolean runMetaData;
    private boolean runDictionary;
    private final Map<String, String> databaseDiffMap = new HashMap<String, String>();
    private final Map<String, String> mdTableDiffMap = new HashMap<String, String>();
    private final Map<String, String> relationDiffMap = new HashMap<String, String>();
    private final Map<String, String> dataPacketDiffMap = new HashMap<String, String>();
    private final Map<String, String> metaFormDiffMap = new HashMap<String, String>();
    private final Map<String, String> flowDefineDiffMap = new HashMap<String, String>();
    private final Map<String, String> optInfoDiffMap = new HashMap<String, String>();
    private final Map<String, String> wfNodeDiffMap = new HashMap<String, String>();
    private final Map<String, String> dictionaryDiffMap = new HashMap<String, String>();
    private final Map<String, String> fileDiffMap = new HashMap<String, String>();

    public JsonAppVo(JSONObject jsonObject, JSONObject oldObject, String osId, CentitUserDetails userDetails, String appHome, FileInfoOpt fileInfoOpt, String zipFilePath) {
        this.createMapJsonObject(jsonObject);
        this.zipFilePath = zipFilePath;
        this.oldAppObject = oldObject;
        this.userCode = userDetails == null ? "" : userDetails.getUserCode();
        this.topUnit = userDetails == null ? "" : userDetails.getTopUnitCode();
        this.appHome = appHome;
        this.fileInfoOpt = fileInfoOpt;
        this.runMetaData = true;
        this.runDictionary = true;
        this.uploadFiles = true;
        this.osId = osId;
        this.now = new Date();
    }

    public JSONArray getDiffIds() {
        JSONArray jsonArray = new JSONArray();
        this.addDiffEntry(jsonArray, "\u63a5\u53e3\u4e3b\u952e\u53d8\u5316", this.dataPacketDiffMap);
        this.addDiffEntry(jsonArray, "\u9875\u9762\u4e3b\u952e\u53d8\u5316", this.metaFormDiffMap);
        this.addDiffEntry(jsonArray, "\u6d41\u7a0b\u4e3b\u952e\u53d8\u5316", this.flowDefineDiffMap);
        this.addDiffEntry(jsonArray, "\u6570\u636e\u5b57\u5178\u4e3b\u952e\u53d8\u5316", this.dictionaryDiffMap);
        this.addDiffEntry(jsonArray, "\u83dc\u5355\u4e3b\u952e\u53d8\u5316", this.optInfoDiffMap);
        this.addDiffEntry(jsonArray, "\u8868\u4e3b\u952e\u53d8\u5316", this.mdTableDiffMap);
        return jsonArray;
    }

    private void addDiffEntry(JSONArray array, String keyName, Object value) {
        if (value == null) {
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)keyName, value);
        array.add((Object)jsonObject);
    }

    public void prepareApp() throws ObjectException {
        try {
            logger.info("\u5f00\u59cb\u66f4\u65b0\u4e3b\u914d\u7f6e...");
            this.updatePrimary();
            logger.info("\u4e3b\u914d\u7f6e\u66f4\u65b0\u5b8c\u6210");
            logger.info("\u5f00\u59cb\u521b\u5efa\u5e94\u7528\u7a0b\u5e8f\u5bf9\u8c61...");
            this.createAppObject();
            logger.info("\u5e94\u7528\u7a0b\u5e8f\u5bf9\u8c61\u521b\u5efa\u5b8c\u6210");
        }
        catch (Exception e) {
            logger.error("\u5e94\u7528\u7a0b\u5e8f\u521d\u59cb\u5316\u5931\u8d25: " + e.getMessage());
            throw new ObjectException((Object)"Prepare app failed", (Throwable)e);
        }
    }

    public void refreshCache(DdeDubboTaskRun ddeDubboTaskRun) {
        if (this.appList == null) {
            return;
        }
        for (Object object : this.appList) {
            String packetId;
            if (!(object instanceof DataPacket) || (packetId = ((DataPacket)object).getPacketId()) == null) continue;
            ddeDubboTaskRun.refreshCache(packetId);
        }
    }

    private void createMapJsonObject(JSONObject jsonObject) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof List)) continue;
            List list = (List)value;
            this.mapJsonObject.put((String)entry.getKey(), list);
        }
    }

    public void updatePrimary() {
        this.updateOsInfo();
        this.setDatabaseDiffMap();
        this.updateDataCatalog();
        this.updateDataDictionaryUseCatalog();
        this.updateApplicationDictionary();
        this.updateMdTable();
        this.updateMdColumn();
        this.updateMdRelation();
        this.updateRelationDetail();
        this.updateOptInfo();
        this.updateOptDef();
        this.updateTableRelation();
        this.uploadFiles();
        this.updatePacket();
        this.updateOptDefUsePacket();
        this.updatePacketParams();
        this.updateMetaForm();
        this.updateOptInfoUseMetaForm();
        this.updateWfOptTeamRole();
        this.updateWfOptVariable();
        this.updateWfDefine();
        this.updateWfNode();
        this.updateWfDefineUseDiffMap();
        this.updateWfTransition();
        this.updatePacketUseDiffMap();
        this.updateMetaFormUseDiffMap();
    }

    public void createAppObject() {
        this.appList.clear();
        this.createOsInfo().createDataCatalog().createDataDictionary().createApplicationDictionary().createMdTableWithColumnObject().createMdRelationWithDetailObject().createMetaFormObject().createDataPacketAndParamsObject().createWfOptTeamRole().createWfOptVariable().createOptInfo().createOptDef().createWfDefine().createWfNode().createWfTransition().createTableRelation();
    }

    public List<String> getPublishDatabaseCode() {
        ArrayList<String> publishDatabaseCode = new ArrayList<String>();
        List<SourceInfo> oldList = this.convertJavaList(SourceInfo.class, AppTableNames.F_DATABASE_INFO.name());
        if (oldList == null) {
            return publishDatabaseCode;
        }
        for (SourceInfo map : oldList) {
            String sourceType = map.getSourceType();
            if (!"D".equals(sourceType)) continue;
            publishDatabaseCode.add(map.getDatabaseCode());
        }
        return publishDatabaseCode;
    }

    private void updateOsInfo() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.F_OS_INFO.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        for (Map<String, Object> map : list) {
            Object pageFlow = map.get(PAGE_FLOW);
            map.clear();
            map.put(OS_ID, this.osId);
            map.put(PAGE_FLOW, pageFlow);
        }
    }

    private void setDatabaseDiffMap() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.F_DATABASE_INFO.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        for (Map<String, Object> map : list) {
            String mapDataCode = StringBaseOpt.objectToString((Object)map.get(MAP_DATA_CODE));
            String databaseCode = StringBaseOpt.objectToString((Object)map.get(DATABASE_CODE));
            if (StringBaseOpt.isNvl((String)mapDataCode)) {
                throw new ObjectException(610, map.get("databaseName") + ":\u6ca1\u6709\u6307\u5b9a\u8d44\u6e90");
            }
            String uuid = mapDataCode;
            if (uuid.equals(databaseCode)) continue;
            this.databaseDiffMap.put(databaseCode, uuid);
            map.put(DATABASE_CODE, uuid);
        }
    }

    private void updateDataCatalog() {
        String sourceKey;
        boolean hasOldData;
        List<Map<String, Object>> dataCatalogObj = this.mapJsonObject.get(AppTableNames.F_DATACATALOG.name());
        if (dataCatalogObj == null) {
            return;
        }
        List<Map<String, Object>> list = dataCatalogObj;
        List<DataCatalog> oldList = this.convertJavaList(DataCatalog.class, AppTableNames.F_DATACATALOG.name());
        HashMap<String, DataCatalog> catalogCodeMap = new HashMap<String, DataCatalog>();
        HashMap<String, DataCatalog> catalogSourceMap = new HashMap<String, DataCatalog>();
        boolean bl = hasOldData = oldList != null && !oldList.isEmpty();
        if (hasOldData) {
            for (DataCatalog dataCatalog : oldList) {
                String sourceId = dataCatalog.getSourceId();
                String catalogCode = dataCatalog.getCatalogCode();
                String catalogTopUnit = dataCatalog.getTopUnit();
                sourceKey = !StringBaseOpt.isNvl((String)sourceId) ? sourceId + ":" + catalogTopUnit : catalogCode + ":" + catalogTopUnit;
                catalogCodeMap.put(catalogCode, dataCatalog);
                catalogSourceMap.put(sourceKey, dataCatalog);
            }
        }
        for (Map map : list) {
            String catalogCode = StringBaseOpt.objectToString(map.get(CATALOG_CODE));
            String sourceId = StringBaseOpt.objectToString(map.get(SOURCE_ID));
            String uuid = "";
            if (hasOldData) {
                DataCatalog matchedBySourceId;
                if (!StringBaseOpt.isNvl((String)sourceId) && (matchedBySourceId = (DataCatalog)catalogSourceMap.get(sourceKey = sourceId + ":" + this.topUnit)) != null) {
                    uuid = matchedBySourceId.getCatalogCode();
                }
                if (StringUtils.isBlank((CharSequence)uuid)) {
                    DataCatalog matchedByCatalogCode = (DataCatalog)catalogCodeMap.get(catalogCode);
                    if (matchedByCatalogCode != null) {
                        boolean sameTopUnit = this.topUnit.equals(matchedByCatalogCode.getTopUnit());
                        if (sameTopUnit) {
                            uuid = catalogCode;
                        } else {
                            uuid = UuidOpt.getUuidAsString();
                            this.dictionaryDiffMap.put(catalogCode, uuid);
                        }
                    } else {
                        uuid = catalogCode;
                    }
                }
            } else {
                uuid = catalogCode;
            }
            map.put(CATALOG_CODE, uuid);
            map.put(OS_ID, this.osId);
            map.put(CREATOR, this.userCode);
            map.put(CREATE_DATE, this.now);
            map.put(UPDATOR, this.userCode);
            map.put(UPDATE_DATE, this.now);
            map.put(TOP_UNIT, this.topUnit);
            if (!StringBaseOpt.isNvl((String)sourceId)) continue;
            map.put(SOURCE_ID, catalogCode);
        }
    }

    private void updateDataDictionaryUseCatalog() {
        if (this.dictionaryDiffMap.isEmpty()) {
            return;
        }
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.F_DATADICTIONARY.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        for (Map<String, Object> map : list) {
            this.updateIfMapped(map, CATALOG_CODE, this.dictionaryDiffMap);
        }
    }

    private void updateApplicationDictionary() {
        boolean hasOldData;
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.M_APPLICATION_DICTIONARY.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        List<ApplicationDictionary> oldList = this.convertJavaList(ApplicationDictionary.class, AppTableNames.M_APPLICATION_DICTIONARY.name());
        HashMap<String, ApplicationDictionary> oldDictionaryToOsMap = new HashMap<String, ApplicationDictionary>();
        boolean bl = hasOldData = oldList != null && !oldList.isEmpty();
        if (hasOldData) {
            for (ApplicationDictionary applicationDictionary : oldList) {
                String key = applicationDictionary.getDictionaryId() + ":" + applicationDictionary.getOsId();
                oldDictionaryToOsMap.put(key, applicationDictionary);
            }
        }
        for (Map map : list) {
            ApplicationDictionary appDict;
            String dictionaryId = StringBaseOpt.objectToString(map.get(DICTIONARY_ID));
            String id = StringBaseOpt.objectToString(map.get(ID));
            String newDictionaryId = this.dictionaryDiffMap.get(dictionaryId);
            if (!StringBaseOpt.isNvl((String)newDictionaryId)) {
                map.put(DICTIONARY_ID, newDictionaryId);
                dictionaryId = newDictionaryId;
            }
            String uuid = "";
            uuid = oldList != null ? ((appDict = (ApplicationDictionary)oldDictionaryToOsMap.get(dictionaryId + ":" + this.osId)) != null ? appDict.getId() : UuidOpt.getUuidAsString()) : id;
            map.put(ID, uuid);
            map.put(OS_ID, this.osId);
            map.put(PUSH_USER, this.userCode);
            map.put(PUSH_TIME, this.now);
        }
    }

    private void updateMdTable() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.F_MD_TABLE.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        List<MetaTable> oldList = this.convertJavaList(MetaTable.class, AppTableNames.F_MD_TABLE.name());
        boolean hasOldData = oldList != null && !oldList.isEmpty();
        HashMap<String, MetaTable> oldMetaTableMap = new HashMap<String, MetaTable>();
        if (hasOldData) {
            for (MetaTable metaTable : oldList) {
                String key = StringUtils.lowerCase((String)metaTable.getTableName()) + ":" + metaTable.getDatabaseCode();
                oldMetaTableMap.put(key, metaTable);
            }
        }
        for (Map map : list) {
            String oldTableId;
            String key;
            MetaTable metaTable;
            String uuid;
            String tableName = StringUtils.lowerCase((String)StringBaseOpt.objectToString(map.get(TABLE_NAME)));
            String databaseCode = StringBaseOpt.objectToString(map.get(DATABASE_CODE));
            String newDbCode = this.databaseDiffMap.get(databaseCode);
            if (newDbCode != null) {
                map.put(DATABASE_CODE, newDbCode);
                databaseCode = newDbCode;
            }
            if ((uuid = (metaTable = (MetaTable)oldMetaTableMap.get(key = tableName + ":" + databaseCode)) != null ? metaTable.getTableId() : UuidOpt.getUuidAsString()).equals(oldTableId = StringBaseOpt.objectToString(map.get(TABLE_ID)))) continue;
            this.mdTableDiffMap.put(oldTableId, uuid);
            map.put(TABLE_ID, uuid);
            map.put(RECORDER, this.userCode);
            map.put(RECORD_DATE, this.now);
        }
    }

    private void updateMdColumn() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.F_MD_COLUMN.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        for (Map<String, Object> map : list) {
            map.put(RECORDER, this.userCode);
            map.put(LAST_MODIFY_DATE, this.now);
            this.updateIfMapped(map, TABLE_ID, this.mdTableDiffMap);
            this.updateIfMapped(map, REFERENCE_DATA, this.dictionaryDiffMap);
        }
    }

    private void updateMdRelation() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.F_MD_RELATION.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        List<MetaRelation> finalOldList = this.convertJavaList(MetaRelation.class, AppTableNames.F_MD_RELATION.name());
        for (Map<String, Object> map : list) {
            String newChildId;
            String parentTableId = StringBaseOpt.objectToString((Object)map.get(PARENT_TABLE_ID));
            String childTableId = StringBaseOpt.objectToString((Object)map.get(CHILD_TABLE_ID));
            String relationId = StringBaseOpt.objectToString((Object)map.get(RELATION_ID));
            String newParentId = this.mdTableDiffMap.get(parentTableId);
            if (newParentId != null) {
                map.put(PARENT_TABLE_ID, newParentId);
                parentTableId = newParentId;
            }
            if ((newChildId = this.mdTableDiffMap.get(childTableId)) != null) {
                map.put(CHILD_TABLE_ID, newChildId);
                childTableId = newChildId;
            }
            String uuid = "";
            if (finalOldList != null) {
                for (MetaRelation oldMap : finalOldList) {
                    if (!parentTableId.equals(oldMap.getParentTableId()) || !childTableId.equals(oldMap.getChildTableId())) continue;
                    uuid = oldMap.getRelationId();
                    break;
                }
                if (StringBaseOpt.isNvl((String)uuid)) {
                    uuid = UuidOpt.getUuidAsString();
                }
            } else {
                uuid = relationId;
            }
            if (!uuid.equals(relationId)) {
                this.relationDiffMap.put(relationId, uuid);
            }
            map.put(RELATION_ID, uuid);
            map.put(RECORDER, this.userCode);
            map.put(LAST_MODIFY_DATE, this.now);
        }
    }

    private void updateRelationDetail() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.F_MD_REL_DETAIL.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        for (Map<String, Object> map : list) {
            this.updateIfMapped(map, RELATION_ID, this.relationDiffMap);
        }
    }

    private void updateOptInfo() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.F_OPTINFO.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        List<OptInfo> finalOldList = this.convertJavaList(OptInfo.class, AppTableNames.F_OPTINFO.name());
        HashMap<String, String> commonOptMap = new HashMap<String, String>();
        HashMap<String, OptInfo> optIdMap = new HashMap<String, OptInfo>();
        HashMap<String, String> sourceIdMap = new HashMap<String, String>();
        if (finalOldList != null) {
            for (OptInfo optInfo : finalOldList) {
                boolean isCommonOrPageEnter;
                String formCode = optInfo.getFormCode();
                String oldTopOptId = optInfo.getTopOptId();
                String optId = optInfo.getOptId();
                String preOptId = optInfo.getPreOptId();
                boolean bl = isCommonOrPageEnter = "C".equals(formCode) || "A".equals(formCode);
                if (isCommonOrPageEnter && this.osId.equals(oldTopOptId)) {
                    commonOptMap.put(formCode, optInfo.getOptId());
                }
                if (optId.equals(oldTopOptId) && "0".equals(preOptId) || isCommonOrPageEnter) continue;
                optIdMap.put(optId, optInfo);
                String sourceId = optInfo.getSourceId();
                String key = !StringBaseOpt.isNvl((String)sourceId) ? sourceId + ":" + oldTopOptId : optId + ":" + oldTopOptId;
                sourceIdMap.put(key, optId);
            }
        }
        for (Map map : list) {
            boolean isCommonOrPageEnter;
            String optId = StringBaseOpt.objectToString(map.get(OPT_ID));
            String sourceId = StringBaseOpt.objectToString(map.get(SOURCE_ID));
            String topOptId = StringBaseOpt.objectToString(map.get(TOP_OPT_ID));
            String formCode = StringBaseOpt.objectToString(map.get(FORM_CODE));
            String preOptId = StringBaseOpt.objectToString(map.get(PRE_OPT_ID));
            if (optId.equals(topOptId) && "0".equals(preOptId)) {
                map.clear();
                if (topOptId.equals(this.osId)) continue;
                this.optInfoDiffMap.put(optId, this.osId);
                continue;
            }
            boolean bl = isCommonOrPageEnter = "C".equals(formCode) || "A".equals(formCode);
            if (isCommonOrPageEnter) {
                map.remove(OS_ID);
                map.remove(TOP_OPT_ID);
                map.remove(PRE_OPT_ID);
                map.remove(FORM_CODE);
                map.remove(SOURCE_ID);
                String oldOptId = (String)commonOptMap.get(formCode);
                if (!optId.equals(oldOptId)) {
                    this.optInfoDiffMap.put(optId, oldOptId);
                }
                map.put(OPT_ID, oldOptId);
                continue;
            }
            String uuid = "";
            if (finalOldList != null) {
                String sourceKey;
                String oldOptId;
                if (!StringBaseOpt.isNvl((String)sourceId) && !StringBaseOpt.isNvl((String)(oldOptId = (String)sourceIdMap.get(sourceKey = sourceId + ":" + this.osId)))) {
                    uuid = oldOptId;
                }
                if (StringBaseOpt.isNvl((String)uuid)) {
                    OptInfo matchOptInfo = (OptInfo)optIdMap.get(optId);
                    uuid = matchOptInfo != null ? (matchOptInfo.getTopOptId().equals(this.osId) ? matchOptInfo.getOptId() : UuidOpt.getUuidAsString()) : optId;
                }
            } else {
                uuid = optId;
            }
            if (!uuid.equals(optId)) {
                this.optInfoDiffMap.put(optId, uuid);
            }
            map.put(OPT_ID, uuid);
            map.put(TOP_OPT_ID, this.osId);
            map.put(OS_ID, this.osId);
            map.put(UPDATOR, this.userCode);
            map.put(UPDATE_DATE, this.now);
            map.put(CREATOR, this.userCode);
            map.put(CREATE_DATE, this.now);
            map.put(DOC_ID, uuid);
            if (!StringBaseOpt.isNvl((String)sourceId)) continue;
            map.put(SOURCE_ID, optId);
        }
        for (Map map : list) {
            this.updateIfMapped(map, PRE_OPT_ID, this.optInfoDiffMap);
        }
    }

    private void updateOptDef() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.F_OPTDEF.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        List<OptMethod> finalOldList = this.convertJavaList(OptMethod.class, AppTableNames.F_OPTDEF.name());
        HashMap<String, OptMethod> optCodeMap = new HashMap<String, OptMethod>();
        HashMap<String, String> sourceIdMap = new HashMap<String, String>();
        if (finalOldList != null) {
            for (OptMethod optMethod : finalOldList) {
                String optCode = optMethod.getOptCode();
                String sourceId = optMethod.getSourceId();
                String topOptId = optMethod.getTopOptId();
                optCodeMap.put(optCode, optMethod);
                String key = !StringBaseOpt.isNvl((String)sourceId) ? sourceId + ":" + topOptId : optCode + ":" + topOptId;
                sourceIdMap.put(key, optCode);
            }
        }
        for (Map map : list) {
            String uuid = "";
            String optCode = StringBaseOpt.objectToString(map.get(OPT_CODE));
            String sourceId = StringBaseOpt.objectToString(map.get(SOURCE_ID));
            if (finalOldList != null) {
                String sourceKey;
                String oldOptMethod;
                if (!StringBaseOpt.isNvl((String)sourceId) && !StringBaseOpt.isNvl((String)(oldOptMethod = (String)sourceIdMap.get(sourceKey = sourceId + ":" + this.osId)))) {
                    uuid = oldOptMethod;
                    map.put(API_ID, uuid);
                    map.put(OPT_URL, DDE_RUN + uuid);
                }
                if (StringBaseOpt.isNvl((String)uuid)) {
                    OptMethod matchOptMethod = (OptMethod)optCodeMap.get(optCode);
                    if (matchOptMethod != null) {
                        String matchTopOptId = matchOptMethod.getTopOptId();
                        if (matchTopOptId != null && matchTopOptId.equals(this.osId)) {
                            uuid = optCode;
                            map.put(API_ID, uuid);
                            map.put(OPT_URL, DDE_RUN + uuid);
                        } else {
                            uuid = UuidOpt.getUuidAsString();
                            map.remove(OPT_URL);
                        }
                    } else {
                        uuid = optCode;
                    }
                }
            } else {
                uuid = optCode;
            }
            map.put(OPT_CODE, uuid);
            map.put(UPDATOR, this.userCode);
            map.put(UPDATE_DATE, this.now);
            map.put(CREATOR, this.userCode);
            map.put(CREATE_DATE, this.now);
            this.updateIfMapped(map, OPT_ID, this.optInfoDiffMap);
            if (!StringBaseOpt.isNvl((String)sourceId)) continue;
            map.put(SOURCE_ID, optCode);
        }
    }

    private void updateTableRelation() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.F_TABLE_OPT_RELATION.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        List<MetaOptRelation> finalOldList = this.convertJavaList(MetaOptRelation.class, AppTableNames.F_TABLE_OPT_RELATION.name());
        HashMap<String, String> idMap = new HashMap<String, String>();
        HashMap<String, String> sourceIdMap = new HashMap<String, String>();
        if (finalOldList != null) {
            for (MetaOptRelation metaOptRelation : finalOldList) {
                String id = metaOptRelation.getId();
                String tableId = metaOptRelation.getTableId();
                String optId = metaOptRelation.getOptId();
                String osId = metaOptRelation.getOsId();
                idMap.put(id, osId);
                if (StringBaseOpt.isNvl((String)tableId) || StringBaseOpt.isNvl((String)optId)) continue;
                String sourceKey = tableId + ":" + optId;
                sourceIdMap.put(sourceKey, id);
            }
        }
        for (Map map : list) {
            String matchOsId;
            String sourceKey;
            String oldId;
            String changeOptId;
            String tableId = StringBaseOpt.objectToString(map.get(TABLE_ID));
            String optId = StringBaseOpt.objectToString(map.get(OPT_ID));
            String id = StringBaseOpt.objectToString(map.get(ID));
            String changeTableId = this.mdTableDiffMap.get(tableId);
            if (changeTableId != null) {
                map.put(TABLE_ID, changeTableId);
                tableId = changeTableId;
            }
            if ((changeOptId = this.optInfoDiffMap.get(optId)) != null) {
                map.put(OPT_ID, changeOptId);
                optId = changeOptId;
            }
            String uuid = "";
            uuid = finalOldList != null ? (!StringBaseOpt.isNvl((String)(oldId = (String)sourceIdMap.get(sourceKey = tableId + ":" + optId))) ? oldId : ((matchOsId = (String)idMap.get(id)) != null ? (matchOsId.equals(this.osId) ? id : UuidOpt.getUuidAsString()) : id)) : id;
            map.put(ID, uuid);
            map.put(OS_ID, this.osId);
        }
    }

    private void uploadFiles() {
        if (!this.uploadFiles || StringUtils.isBlank((CharSequence)this.zipFilePath)) {
            return;
        }
        List zipArchives = FileSystemOpt.findFiles((String)this.zipFilePath, (String)"file.zip");
        if (zipArchives == null || zipArchives.isEmpty()) {
            logger.warn("No file.zip found in path: {}", (Object)this.zipFilePath);
            return;
        }
        String timestamp = DatetimeOpt.convertDateToString((Date)DatetimeOpt.currentUtilDate(), (String)"YYYYMMddHHmmss");
        String tempDirPath = Paths.get(this.appHome, "u" + timestamp).toString();
        try {
            Files.createDirectories(Paths.get(tempDirPath, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error("Failed to create temporary directory: {}", (Object)tempDirPath, (Object)e);
            return;
        }
        File zipFile = (File)zipArchives.get(0);
        try {
            ZipCompressor.release((File)zipFile, (String)tempDirPath);
        }
        catch (Exception e) {
            logger.error("Failed to extract ZIP file: {}", (Object)zipFile.getAbsolutePath(), (Object)e);
            return;
        }
        List extractedFiles = FileSystemOpt.findFiles((String)tempDirPath, (String)"*");
        if (extractedFiles == null) {
            return;
        }
        for (File file : extractedFiles) {
            this.processAndUploadFile(file);
        }
        try {
            FileSystemOpt.deleteDirect((String)tempDirPath);
        }
        catch (Exception e) {
            logger.warn("Failed to delete temporary directory: {}", (Object)tempDirPath, (Object)e);
        }
    }

    private void processAndUploadFile(File file) {
        String fileId;
        String fileName = FileSystemOpt.extractFullFileName((String)file.getPath());
        String oldFileId = this.extractOldFileIdFromName(fileName);
        if (oldFileId == null) {
            logger.warn("Invalid file name format, no fileId found in '{}'", (Object)fileName);
            return;
        }
        FileInfo fileInfo = new FileInfo();
        String cleanFileName = fileName.replaceFirst("\\(" + Pattern.quote(oldFileId) + "\\)", "").trim();
        fileInfo.setFileName(cleanFileName);
        fileInfo.setFileShowPath("/-1");
        fileInfo.setLibraryId(this.osId);
        fileInfo.setFileCatalog("A");
        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            fileId = this.fileInfoOpt.saveFile((FileBaseInfo)fileInfo, -1L, inputStream);
        }
        catch (IOException e) {
            logger.error("Failed to read or save file: {}", (Object)fileName, (Object)e);
            return;
        }
        if (fileId != null && !fileId.equals(oldFileId)) {
            this.fileDiffMap.put(oldFileId, fileId);
        }
    }

    private String extractOldFileIdFromName(String fileName) {
        int startIdx = fileName.indexOf(40);
        int endIdx = fileName.indexOf(41);
        if (startIdx != -1 && endIdx != -1 && startIdx < endIdx) {
            return fileName.substring(startIdx + 1, endIdx);
        }
        return null;
    }

    private void updatePacket() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.Q_DATA_PACKET.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        List<DataPacket> finalOldList = this.convertJavaList(DataPacket.class, AppTableNames.Q_DATA_PACKET.name());
        HashMap<String, DataPacket> idMap = new HashMap<String, DataPacket>();
        HashMap<String, DataPacket> sourceIdMap = new HashMap<String, DataPacket>();
        if (finalOldList != null) {
            for (DataPacket dataPacket : finalOldList) {
                String packetId = dataPacket.getPacketId();
                String sourceId = dataPacket.getSourceId();
                String oldOsId = dataPacket.getOsId();
                idMap.put(packetId, dataPacket);
                String key = !StringBaseOpt.isNvl((String)sourceId) ? sourceId + ":" + oldOsId : packetId + ":" + oldOsId;
                sourceIdMap.put(key, dataPacket);
            }
        }
        for (Map map : list) {
            String uuid = "";
            String packetId = StringBaseOpt.objectToString(map.get(PACKET_ID));
            String taskType = StringBaseOpt.objectToString(map.get(TASK_TYPE));
            String sourceId = StringBaseOpt.objectToString(map.get(SOURCE_ID));
            if (finalOldList != null) {
                String sourceKey;
                DataPacket matchSourcePacket;
                if (!StringBaseOpt.isNvl((String)packetId) && (matchSourcePacket = (DataPacket)sourceIdMap.get(sourceKey = sourceId + ":" + this.osId)) != null) {
                    uuid = matchSourcePacket.getPacketId();
                    if ("2".equals(taskType)) {
                        map.put(TASK_CRON, matchSourcePacket.getTaskCron());
                        map.put(IS_VALID, matchSourcePacket.getIsValid());
                    }
                }
                if (StringBaseOpt.isNvl((String)uuid)) {
                    DataPacket matchPacket = (DataPacket)idMap.get(packetId);
                    if (matchPacket != null) {
                        String matchOsId = matchPacket.getOsId();
                        if (matchOsId != null && matchOsId.equals(this.osId)) {
                            uuid = packetId;
                            if ("2".equals(taskType)) {
                                map.put(TASK_CRON, matchPacket.getTaskCron());
                                map.put(IS_VALID, matchPacket.getIsValid());
                            }
                        } else {
                            uuid = UuidOpt.getUuidAsString();
                            if ("2".equals(taskType)) {
                                map.put(IS_VALID, false);
                            }
                        }
                    } else {
                        uuid = packetId;
                        if ("2".equals(taskType)) {
                            map.put(IS_VALID, false);
                        }
                    }
                }
            }
            if (!uuid.equals(packetId)) {
                this.dataPacketDiffMap.put(packetId, uuid);
            }
            map.put(PACKET_ID, uuid);
            map.put(OS_ID, this.osId);
            map.put(UPDATE_DATE, this.now);
            map.put(PUBLISH_DATE, this.now);
            map.put(RECORDER, this.userCode);
            map.put(OPT_CODE, uuid);
            this.updateIfMapped(map, OPT_ID, this.optInfoDiffMap);
            if (!StringBaseOpt.isNvl((String)sourceId)) continue;
            map.put(SOURCE_ID, packetId);
        }
    }

    private void updateOptDefUsePacket() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.F_OPTDEF.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        for (Map<String, Object> map : list) {
            String changeId;
            String apiId = StringBaseOpt.objectToString((Object)map.get(API_ID));
            if (StringBaseOpt.isNvl((String)apiId) || (changeId = this.dataPacketDiffMap.get(apiId)) == null) continue;
            map.put(API_ID, changeId);
            map.put(OPT_URL, DDE_RUN + changeId);
            map.put(OPT_CODE, changeId);
        }
        for (Map<String, Object> map : list) {
            String optUrl = StringBaseOpt.objectToString((Object)map.get(OPT_URL));
            if (!StringBaseOpt.isNvl((String)optUrl)) continue;
            map.clear();
        }
    }

    private void updatePacketParams() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.Q_DATA_PACKET_PARAM.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        for (Map<String, Object> map : list) {
            this.updateIfMapped(map, PACKET_ID, this.dataPacketDiffMap);
        }
    }

    private void updateMetaForm() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.M_META_FORM_MODEL.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        List<MetaFormModel> finalOldList = this.convertJavaList(MetaFormModel.class, AppTableNames.M_META_FORM_MODEL.name());
        HashMap<String, MetaFormModel> idMap = new HashMap<String, MetaFormModel>();
        HashMap<String, MetaFormModel> sourceIdMap = new HashMap<String, MetaFormModel>();
        if (finalOldList != null) {
            for (MetaFormModel metaFormModel : finalOldList) {
                String modelId = metaFormModel.getModelId();
                String sourceId = metaFormModel.getSourceId();
                String oldOsId = metaFormModel.getOsId();
                idMap.put(modelId, metaFormModel);
                String key = !StringBaseOpt.isNvl((String)sourceId) ? sourceId + ":" + oldOsId : modelId + ":" + oldOsId;
                sourceIdMap.put(key, metaFormModel);
            }
        }
        for (Map map : list) {
            String uuid = "";
            String modelId = StringBaseOpt.objectToString(map.get(MODEL_ID));
            String sourceId = StringBaseOpt.objectToString(map.get(SOURCE_ID));
            if (finalOldList != null) {
                String sourceKey;
                MetaFormModel matchSource;
                if (!StringBaseOpt.isNvl((String)modelId) && (matchSource = (MetaFormModel)sourceIdMap.get(sourceKey = sourceId + ":" + this.osId)) != null) {
                    uuid = matchSource.getModelId();
                }
                if (StringBaseOpt.isNvl((String)uuid)) {
                    String matchOsId;
                    MetaFormModel matchId = (MetaFormModel)idMap.get(modelId);
                    uuid = matchId != null ? ((matchOsId = matchId.getOsId()) != null && matchOsId.equals(this.osId) ? modelId : UuidOpt.getUuidAsString()) : modelId;
                }
            } else {
                uuid = modelId;
            }
            if (!uuid.equals(modelId)) {
                this.metaFormDiffMap.put(modelId, uuid);
            }
            map.put(MODEL_ID, uuid);
            map.put(OS_ID, this.osId);
            map.put(PUBLISH_DATE, this.now);
            map.put(RECORDER, this.userCode);
            if (StringBaseOpt.isNvl((String)sourceId)) {
                map.put(SOURCE_ID, modelId);
            }
            this.updateIfMapped(map, OPT_ID, this.optInfoDiffMap);
        }
    }

    private void updateOptInfoUseMetaForm() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.F_OPTINFO.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        for (Map<String, Object> map : list) {
            String modelId;
            String changeModelId;
            String prefix;
            this.updateIfMapped(map, OPT_ROUTE, this.metaFormDiffMap);
            String originalOptUrl = StringBaseOpt.objectToString((Object)map.get(OPT_URL));
            if (originalOptUrl == null || !originalOptUrl.startsWith(prefix = "./page/#/models/") || StringBaseOpt.isNvl((String)(changeModelId = this.metaFormDiffMap.get(modelId = originalOptUrl.substring(prefix.length()))))) continue;
            String updatedOptUrl = prefix + changeModelId;
            map.put(OPT_URL, updatedOptUrl);
        }
    }

    private void updateWfOptTeamRole() {
        String roleCode;
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.WF_OPT_TEAM_ROLE.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        List<OptTeamRole> finalOldList = this.convertJavaList(OptTeamRole.class, AppTableNames.WF_OPT_TEAM_ROLE.name());
        HashMap<String, OptTeamRole> sourceIdMap = new HashMap<String, OptTeamRole>();
        if (finalOldList != null) {
            for (OptTeamRole optTeamRole : finalOldList) {
                roleCode = optTeamRole.getRoleCode();
                String optId = optTeamRole.getOptId();
                sourceIdMap.put(roleCode + ":" + optId, optTeamRole);
            }
        }
        for (Map map : list) {
            OptTeamRole changeTeamRole;
            roleCode = StringBaseOpt.objectToString(map.get(ROLE_CODE));
            String teamRoleId = StringBaseOpt.objectToString(map.get(OPT_TEAM_ROLE_ID));
            this.updateIfMapped(map, OPT_ID, this.optInfoDiffMap);
            String optId = StringBaseOpt.objectToString(map.get(OPT_ID));
            String uuid = "";
            uuid = finalOldList != null ? ((changeTeamRole = (OptTeamRole)sourceIdMap.get(roleCode + ":" + optId)) != null ? changeTeamRole.getOptTeamRoleId() : UuidOpt.getUuidAsString()) : teamRoleId;
            map.put(OPT_TEAM_ROLE_ID, uuid);
            map.put(MODIFY_TIME, this.now);
        }
    }

    private void updateWfOptVariable() {
        String variableName;
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.WF_OPT_VARIABLE_DEFINE.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        List<OptVariableDefine> finalOldList = this.convertJavaList(OptVariableDefine.class, AppTableNames.WF_OPT_VARIABLE_DEFINE.name());
        HashMap<String, OptVariableDefine> sourceIdMap = new HashMap<String, OptVariableDefine>();
        if (finalOldList != null) {
            for (OptVariableDefine optVariableDefine : finalOldList) {
                variableName = optVariableDefine.getVariableName();
                String optId = optVariableDefine.getOptId();
                sourceIdMap.put(variableName + ":" + optId, optVariableDefine);
            }
        }
        for (Map map : list) {
            OptVariableDefine changeVariable;
            variableName = StringBaseOpt.objectToString(map.get(VARIABLE_NAME));
            String variableId = StringBaseOpt.objectToString(map.get(OPT_VARIABLE_ID));
            this.updateIfMapped(map, OPT_ID, this.optInfoDiffMap);
            String optId = StringBaseOpt.objectToString(map.get(OPT_ID));
            String uuid = "";
            uuid = finalOldList != null ? ((changeVariable = (OptVariableDefine)sourceIdMap.get(variableName + ":" + optId)) != null ? changeVariable.getOptVariableId() : UuidOpt.getUuidAsString()) : variableId;
            map.put(OPT_VARIABLE_ID, uuid);
            map.put(MODIFY_TIME, this.now);
        }
    }

    private void updateWfDefine() {
        String flowCode;
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.WF_FLOW_DEFINE.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        list.sort((o1, o2) -> GeneralAlgorithm.compareTwoObject(o1.get(VERSION), o2.get(VERSION)));
        List<FlowInfo> finalOldList = this.convertJavaList(FlowInfo.class, AppTableNames.WF_FLOW_DEFINE.name());
        HashMap<String, FlowInfo> idMap = new HashMap<String, FlowInfo>();
        HashMap<String, FlowInfo> sourceIdMap = new HashMap<String, FlowInfo>();
        if (finalOldList != null) {
            for (FlowInfo flowInfo : finalOldList) {
                flowCode = flowInfo.getFlowCode();
                String sourceId = flowInfo.getSourceId();
                String oldOsId = flowInfo.getOsId();
                idMap.put(flowCode, flowInfo);
                String key = !StringBaseOpt.isNvl((String)sourceId) ? sourceId + ":" + oldOsId : flowCode + ":" + oldOsId;
                sourceIdMap.put(key + ":" + oldOsId, flowInfo);
            }
        }
        for (Map map : list) {
            flowCode = StringBaseOpt.objectToString(map.get(FLOW_CODE));
            int version = NumberBaseOpt.castObjectToInteger(map.get(VERSION), (Integer)-1);
            String sourceId = StringBaseOpt.objectToString(map.get(SOURCE_ID));
            if (version == 0) {
                String uuid = "";
                if (finalOldList != null) {
                    String sourceKey = sourceId + ":" + this.osId;
                    FlowInfo matchSource = (FlowInfo)sourceIdMap.get(sourceKey);
                    if (matchSource != null) {
                        uuid = matchSource.getFlowCode();
                    }
                    if (StringBaseOpt.isNvl((String)uuid)) {
                        String matchOsId;
                        FlowInfo matchId = (FlowInfo)idMap.get(flowCode);
                        uuid = matchId != null ? ((matchOsId = matchId.getOsId()) != null && matchOsId.equals(this.osId) ? flowCode : UuidOpt.getUuidAsString()) : flowCode;
                    }
                } else {
                    uuid = flowCode;
                }
                if (!uuid.equals(flowCode)) {
                    this.flowDefineDiffMap.put(flowCode, uuid);
                }
            }
            map.put(FLOW_PUBLISH_DATE, this.now);
            map.put(OS_ID, this.osId);
        }
    }

    private void updateWfNode() {
        String sourceId;
        String nodeId;
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.WF_NODE.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        List<NodeInfo> finalOldList = this.convertJavaList(NodeInfo.class, AppTableNames.WF_NODE.name());
        HashMap<String, NodeInfo> idMap = new HashMap<String, NodeInfo>();
        HashMap<String, NodeInfo> sourceIdMap = new HashMap<String, NodeInfo>();
        if (finalOldList != null) {
            for (NodeInfo nodeInfo : finalOldList) {
                nodeId = nodeInfo.getNodeId();
                sourceId = nodeInfo.getSourceId();
                String oldOsId = nodeInfo.getOsId();
                idMap.put(nodeId, nodeInfo);
                String key = !StringBaseOpt.isNvl((String)sourceId) ? sourceId + ":" + oldOsId : nodeId + ":" + oldOsId;
                sourceIdMap.put(key, nodeInfo);
            }
        }
        for (Map map : list) {
            nodeId = StringBaseOpt.objectToString(map.get(NODE_ID));
            sourceId = StringBaseOpt.objectToString(map.get(SOURCE_ID));
            String uuid = "";
            if (finalOldList != null) {
                String sourceKey = sourceId + ":" + this.osId;
                NodeInfo matchSource = (NodeInfo)sourceIdMap.get(sourceKey);
                if (matchSource != null) {
                    uuid = matchSource.getNodeId();
                }
                if (StringBaseOpt.isNvl((String)uuid)) {
                    String matchOsId;
                    NodeInfo matchId = (NodeInfo)idMap.get(nodeId);
                    uuid = matchId != null ? ((matchOsId = matchId.getOsId()) != null && matchOsId.equals(this.osId) ? nodeId : UuidOpt.getUuidAsString()) : nodeId;
                }
            } else {
                uuid = nodeId;
            }
            if (!uuid.equals(nodeId)) {
                this.wfNodeDiffMap.put(nodeId, uuid);
            }
            map.put(NODE_ID, uuid);
            map.put(OS_ID, this.osId);
            this.updateIfMapped(map, FLOW_CODE, this.flowDefineDiffMap);
            this.updateIfMapped(map, SUB_FLOW_CODE, this.flowDefineDiffMap);
            this.updateIfMapped(map, OPT_ID, this.optInfoDiffMap);
            String optCode = StringBaseOpt.objectToString(map.get(OPT_CODE));
            String nodeType = StringBaseOpt.objectToString(map.get(NODE_TYPE));
            boolean isAutoNodeType = "D".equals(nodeType);
            String changeOptCode = isAutoNodeType ? this.dataPacketDiffMap.get(optCode) : this.metaFormDiffMap.get(optCode);
            if (StringBaseOpt.isNvl((String)changeOptCode)) continue;
            map.put(OPT_CODE, changeOptCode);
        }
    }

    private void updateWfDefineUseDiffMap() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.WF_FLOW_DEFINE.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        HashMap<String, String> allReplacements = new HashMap<String, String>();
        allReplacements.putAll(this.metaFormDiffMap);
        allReplacements.putAll(this.dataPacketDiffMap);
        allReplacements.putAll(this.optInfoDiffMap);
        for (Map<String, Object> map : list) {
            this.updateIfMapped(map, FIRST_NODE_ID, this.wfNodeDiffMap);
            this.updateIfMapped(map, OPT_ID, this.optInfoDiffMap);
            this.updateIfMapped(map, FLOW_CODE, this.flowDefineDiffMap);
            this.replaceTemplateFields(map, FLOW_XML_DESC, allReplacements);
        }
    }

    private void updateWfTransition() {
        String endNodeId;
        String startNodeId;
        String flowCode;
        String transId;
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.WF_TRANSITION.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        List<FlowTransition> finalOldList = this.convertJavaList(FlowTransition.class, AppTableNames.WF_TRANSITION.name());
        HashSet<String> idSet = new HashSet<String>();
        HashMap<String, String> sourceIdMap = new HashMap<String, String>();
        if (finalOldList != null) {
            for (FlowTransition flowTransition : finalOldList) {
                transId = flowTransition.getTransId();
                flowCode = flowTransition.getFlowCode();
                startNodeId = flowTransition.getStartNodeId();
                endNodeId = flowTransition.getEndNodeId();
                idSet.add(transId);
                if (StringBaseOpt.isNvl((String)flowCode) || StringBaseOpt.isNvl((String)startNodeId) || StringBaseOpt.isNvl((String)endNodeId)) continue;
                sourceIdMap.put(flowCode + ":" + startNodeId + ":" + endNodeId, transId);
            }
        }
        for (Map map : list) {
            this.updateIfMapped(map, FLOW_CODE, this.flowDefineDiffMap);
            this.updateIfMapped(map, START_NODE_ID, this.wfNodeDiffMap);
            this.updateIfMapped(map, END_NODE_ID, this.wfNodeDiffMap);
            transId = StringBaseOpt.objectToString(map.get(TRANS_ID));
            flowCode = StringBaseOpt.objectToString(map.get(FLOW_CODE));
            startNodeId = StringBaseOpt.objectToString(map.get(START_NODE_ID));
            endNodeId = StringBaseOpt.objectToString(map.get(END_NODE_ID));
            String uuid = "";
            if (finalOldList != null) {
                String sourceKey = flowCode + ":" + startNodeId + ":" + endNodeId;
                String matchSource = (String)sourceIdMap.get(sourceKey);
                if (!StringBaseOpt.isNvl((String)matchSource)) {
                    uuid = matchSource;
                }
                if (StringBaseOpt.isNvl((String)uuid)) {
                    uuid = idSet.contains(transId) ? UuidOpt.getUuidAsString() : transId;
                }
            } else {
                uuid = transId;
            }
            map.put(TRANS_ID, uuid);
        }
    }

    private void updatePacketUseDiffMap() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.Q_DATA_PACKET.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        replacementMap.putAll(this.mdTableDiffMap);
        replacementMap.putAll(this.databaseDiffMap);
        replacementMap.putAll(this.dataPacketDiffMap);
        replacementMap.putAll(this.dictionaryDiffMap);
        replacementMap.putAll(this.fileDiffMap);
        replacementMap.putAll(this.flowDefineDiffMap);
        for (Map<String, Object> map : list) {
            this.replaceTemplateFields(map, DATA_OPT_DESC_JSON, replacementMap);
        }
    }

    private void updateMetaFormUseDiffMap() {
        List<Map<String, Object>> mapJsonObject = this.mapJsonObject.get(AppTableNames.M_META_FORM_MODEL.name());
        if (mapJsonObject == null) {
            return;
        }
        List<Map<String, Object>> list = mapJsonObject;
        HashMap<String, String> allReplacements = new HashMap<String, String>();
        allReplacements.putAll(this.metaFormDiffMap);
        allReplacements.putAll(this.dataPacketDiffMap);
        allReplacements.putAll(this.dictionaryDiffMap);
        allReplacements.putAll(this.fileDiffMap);
        allReplacements.putAll(this.flowDefineDiffMap);
        for (Map<String, Object> map : list) {
            this.replaceTemplateFields(map, FORM_TEMPLATE, allReplacements);
            this.replaceTemplateFields(map, MOBILE_FORM_TEMPLATE, allReplacements);
            this.replaceTemplateFields(map, STRUCTURE_FUNCTION, allReplacements);
        }
    }

    private void replaceTemplateFields(Map<String, Object> map, String fieldKey, Map<String, String> allReplacements) {
        Object templateObj = map.get(fieldKey);
        if (templateObj == null) {
            return;
        }
        String form = templateObj.toString();
        for (Map.Entry<String, String> entry : allReplacements.entrySet()) {
            form = StringUtils.replace((String)form, (String)entry.getKey(), (String)entry.getValue());
        }
        map.put(fieldKey, form);
    }

    private void updateIfMapped(Map<String, Object> map, String key, Map<String, String> diffMap) {
        String value = StringBaseOpt.objectToString((Object)map.get(key));
        String newValue = diffMap.get(value);
        if (!StringBaseOpt.isNvl((String)newValue)) {
            map.put(key, newValue);
        }
    }

    private <T> List<T> convertJavaList(Class<T> type, String className) {
        if (this.notHaveOldData(className)) {
            return null;
        }
        return this.oldAppObject.getJSONArray(className).toJavaList(type, new JSONReader.Feature[0]);
    }

    private boolean notHaveOldData(String dataName) {
        return this.oldAppObject.get(dataName) == null || this.oldAppObject.getJSONArray(dataName).isEmpty();
    }

    private JsonAppVo createOsInfo() {
        if (this.mapJsonObject == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_OS_INFO.name());
        if (list == null) {
            return this;
        }
        if (this.appList == null) {
            this.appList = new ArrayList<Object>();
        }
        try {
            List<Object> convertedList = this.convertMap(OsInfo.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 OsInfo \u51fa\u9519", (Throwable)e);
        }
        return this;
    }

    private JsonAppVo createDataCatalog() {
        if (!this.runDictionary) {
            return this;
        }
        if (this.mapJsonObject == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_DATACATALOG.name());
        if (list == null) {
            return this;
        }
        if (this.appList == null) {
            this.appList = new ArrayList<Object>();
        }
        try {
            List<Object> convertedList = this.convertMap(DataCatalog.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 DataCatalog \u51fa\u9519", (Throwable)e);
        }
        return this;
    }

    private JsonAppVo createDataDictionary() {
        if (!this.runDictionary) {
            return this;
        }
        if (this.mapJsonObject == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_DATADICTIONARY.name());
        if (list == null) {
            return this;
        }
        if (this.appList == null) {
            this.appList = new ArrayList<Object>();
        }
        try {
            List<Object> convertedList = this.convertMap(DataDictionary.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 DataDictionary \u51fa\u9519", (Throwable)e);
        }
        return this;
    }

    private JsonAppVo createApplicationDictionary() {
        if (!this.runDictionary) {
            return this;
        }
        if (this.mapJsonObject == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.M_APPLICATION_DICTIONARY.name());
        if (list == null) {
            return this;
        }
        if (this.appList == null) {
            this.appList = new ArrayList<Object>();
        }
        try {
            List<Object> convertedList = this.convertMap(ApplicationDictionary.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 ApplicationDictionary \u51fa\u9519", (Throwable)e);
        }
        return this;
    }

    private JsonAppVo createMdTableWithColumnObject() {
        if (!this.runMetaData) {
            return this;
        }
        List<Map<String, Object>> tableList = this.mapJsonObject.get(AppTableNames.F_MD_TABLE.name());
        if (tableList == null) {
            return this;
        }
        this.metaObject.addAll(this.convertMap(MetaTable.class, tableList));
        List<Object> pendingTableList = this.convertMap(PendingMetaTable.class, tableList);
        pendingTableList.forEach(map -> this.handlePendingMetaTable((PendingMetaTable)map));
        List<Map<String, Object>> columnList = this.mapJsonObject.get(AppTableNames.F_MD_COLUMN.name());
        if (columnList == null) {
            return this;
        }
        this.metaObject.addAll(this.convertMap(MetaColumn.class, columnList));
        columnList.forEach(map -> map.put(MAX_LENGTH, map.get(COLUMN_LENGTH)));
        this.appList.addAll(this.convertMap(PendingMetaColumn.class, columnList));
        return this;
    }

    private void handlePendingMetaTable(PendingMetaTable pendingMetaTable) {
        if (TABLE_TYPE.equals(pendingMetaTable.getTableType())) {
            pendingMetaTable.setTableState(NO_PUBLISH);
            this.appList.add(pendingMetaTable);
        }
    }

    private JsonAppVo createMdRelationWithDetailObject() {
        List<Map<String, Object>> detailList;
        if (!this.runMetaData) {
            return this;
        }
        List<Map<String, Object>> relationList = this.mapJsonObject.get(AppTableNames.F_MD_RELATION.name());
        if (relationList != null) {
            try {
                List<Object> convertedList = this.convertMap(MetaRelation.class, relationList);
                if (convertedList != null) {
                    this.metaObject.addAll(convertedList);
                }
            }
            catch (Exception e) {
                logger.error("\u8f6c\u6362 MetaRelation \u51fa\u9519", (Throwable)e);
            }
        }
        if ((detailList = this.mapJsonObject.get(AppTableNames.F_MD_REL_DETAIL.name())) != null) {
            try {
                List<Object> convertedList = this.convertMap(MetaRelDetail.class, detailList);
                if (convertedList != null) {
                    this.metaObject.addAll(convertedList);
                }
            }
            catch (Exception e) {
                logger.error("\u8f6c\u6362 MetaRelDetail \u51fa\u9519", (Throwable)e);
            }
        }
        return this;
    }

    private JsonAppVo createMetaFormObject() {
        List<Object> convertedList;
        if (this.mapJsonObject == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.M_META_FORM_MODEL.name());
        if (list == null) {
            return this;
        }
        if (this.appList == null) {
            this.appList = new ArrayList<Object>();
        }
        try {
            convertedList = this.convertMap(MetaFormModel.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 MetaFormModel \u51fa\u9519", (Throwable)e);
        }
        try {
            convertedList = this.convertMap(MetaFormModelDraft.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 MetaFormModelDraft \u51fa\u9519", (Throwable)e);
        }
        return this;
    }

    private JsonAppVo createDataPacketAndParamsObject() {
        List<Object> convertedList;
        if (this.mapJsonObject == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.Q_DATA_PACKET.name());
        if (list == null) {
            return this;
        }
        if (this.appList == null) {
            this.appList = new ArrayList<Object>();
        }
        try {
            convertedList = this.convertMap(DataPacket.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 DataPacket \u51fa\u9519", (Throwable)e);
        }
        try {
            convertedList = this.convertMap(DataPacketDraft.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 DataPacketDraft \u51fa\u9519", (Throwable)e);
        }
        list = this.mapJsonObject.get(AppTableNames.Q_DATA_PACKET_PARAM.name());
        if (list == null) {
            return this;
        }
        try {
            convertedList = this.convertMap(DataPacketParam.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 DataPacketParam \u51fa\u9519", (Throwable)e);
        }
        try {
            convertedList = this.convertMap(DataPacketParamDraft.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 DataPacketParamDraft \u51fa\u9519", (Throwable)e);
        }
        return this;
    }

    private JsonAppVo createWfOptTeamRole() {
        if (this.mapJsonObject == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_OPT_TEAM_ROLE.name());
        if (list == null) {
            return this;
        }
        if (this.appList == null) {
            this.appList = new ArrayList<Object>();
        }
        try {
            List<Object> convertedList = this.convertMap(OptTeamRole.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 OptTeamRole \u51fa\u9519", (Throwable)e);
        }
        return this;
    }

    private JsonAppVo createWfOptVariable() {
        if (this.mapJsonObject == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_OPT_VARIABLE_DEFINE.name());
        if (list == null) {
            return this;
        }
        if (this.appList == null) {
            this.appList = new ArrayList<Object>();
        }
        try {
            List<Object> convertedList = this.convertMap(OptVariableDefine.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 OptVariableDefine \u51fa\u9519", (Throwable)e);
        }
        return this;
    }

    private JsonAppVo createOptInfo() {
        if (this.mapJsonObject == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_OPTINFO.name());
        if (list == null) {
            return this;
        }
        if (this.appList == null) {
            this.appList = new ArrayList<Object>();
        }
        try {
            List<Object> convertedList = this.convertMap(OptInfo.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 OptInfo \u51fa\u9519", (Throwable)e);
        }
        return this;
    }

    private JsonAppVo createOptDef() {
        if (this.mapJsonObject == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_OPTDEF.name());
        if (list == null) {
            return this;
        }
        if (this.appList == null) {
            this.appList = new ArrayList<Object>();
        }
        try {
            List<Object> convertedList = this.convertMap(OptMethod.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 OptMethod \u51fa\u9519", (Throwable)e);
        }
        return this;
    }

    private JsonAppVo createWfDefine() {
        if (this.mapJsonObject == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_FLOW_DEFINE.name());
        if (list == null) {
            return this;
        }
        if (this.appList == null) {
            this.appList = new ArrayList<Object>();
        }
        try {
            List<Object> convertedList = this.convertMap(FlowInfo.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 FlowInfo \u51fa\u9519", (Throwable)e);
        }
        return this;
    }

    private JsonAppVo createWfNode() {
        if (this.mapJsonObject == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_NODE.name());
        if (list == null) {
            return this;
        }
        if (this.appList == null) {
            this.appList = new ArrayList<Object>();
        }
        try {
            List<Object> convertedList = this.convertMap(NodeInfo.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 NodeInfo \u51fa\u9519", (Throwable)e);
        }
        return this;
    }

    private JsonAppVo createWfTransition() {
        if (this.mapJsonObject == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.WF_TRANSITION.name());
        if (list == null) {
            return this;
        }
        if (this.appList == null) {
            this.appList = new ArrayList<Object>();
        }
        try {
            List<Object> convertedList = this.convertMap(FlowTransition.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 FlowTransition \u51fa\u9519", (Throwable)e);
        }
        return this;
    }

    private JsonAppVo createTableRelation() {
        if (this.mapJsonObject == null) {
            return this;
        }
        List<Map<String, Object>> list = this.mapJsonObject.get(AppTableNames.F_TABLE_OPT_RELATION.name());
        if (list == null) {
            return this;
        }
        if (this.appList == null) {
            this.appList = new ArrayList<Object>();
        }
        try {
            List<Object> convertedList = this.convertMap(MetaOptRelation.class, list);
            if (convertedList != null) {
                this.appList.addAll(convertedList);
            }
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362 MetaOptRelation \u51fa\u9519", (Throwable)e);
        }
        return this;
    }

    private List<Object> convertMap(Class<?> type, List<Map<String, Object>> list) {
        ArrayList<Object> object = new ArrayList<Object>();
        try {
            JavaBeanMetaData javaBeanMetaData = JavaBeanMetaData.createBeanMetaDataFromType(type);
            for (Map<String, Object> map : list) {
                if (map == null || map.isEmpty()) continue;
                object.add(javaBeanMetaData.createBeanObjectFromMap(map));
            }
            return object;
        }
        catch (Exception e) {
            return object;
        }
    }

    public JSONObject getOldAppObject() {
        return this.oldAppObject;
    }

    public void setOldAppObject(JSONObject oldAppObject) {
        this.oldAppObject = oldAppObject;
    }

    public Map<String, List<Map<String, Object>>> getMapJsonObject() {
        return this.mapJsonObject;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public List<Object> getAppList() {
        return this.appList;
    }

    public List<Object> getMetaObject() {
        return this.metaObject;
    }

    public boolean isUploadFiles() {
        return this.uploadFiles;
    }

    public void setUploadFiles(boolean uploadFiles) {
        this.uploadFiles = uploadFiles;
    }

    public boolean isRunMetaData() {
        return this.runMetaData;
    }

    public void setRunMetaData(boolean runMetaData) {
        this.runMetaData = runMetaData;
    }

    public boolean isRunDictionary() {
        return this.runDictionary;
    }

    public void setRunDictionary(boolean runDictionary) {
        this.runDictionary = runDictionary;
    }
}

