/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.controller;

import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.locode.platform.service.EnvironmentExportManager;
import com.centit.support.common.ObjectException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/exchange"})
@Api(value="\u5e94\u7528\u8d44\u6e90\u5bfc\u5165\u5bfc\u51fa", tags={"runtime\u73af\u5883\u5bfc\u5165\u5bfc\u51fa"})
public class EnvironmentExportController
extends BaseController {
    @Autowired
    private EnvironmentExportManager environmentExportManager;
    @Autowired
    private PlatformEnvironment platformEnvironment;

    @ApiOperation(value="\u5bfc\u51fa\u5e94\u7528\u7684\u8fd0\u884c\u65f6\u73af\u5883")
    @ApiImplicitParam(name="osId", type="path", value="\u5e94\u7528ID")
    @GetMapping(value={"/export/{osId}"})
    public void exportEnvironment(@PathVariable String osId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CentitUserDetails ud = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (ud == null) {
            throw new ObjectException(302, "\u7528\u6237\u6ca1\u6709\u767b\u5f55\uff0c\u6ca1\u6709\u5bf9\u5e94\u7684\u6743\u9650\uff01");
        }
        List userGroups = this.platformEnvironment.listWorkGroup(osId, ud.getUserCode(), null);
        if (CollectionUtils.isEmpty((Collection)userGroups)) {
            throw new ObjectException(403, "\u7528\u6237\u6ca1\u6709\u6743\u9650\u5bfc\u51fa\u8fd9\u4e2a\u5e94\u7528\uff1a" + osId + "\uff01");
        }
        InputStream zipFileStream = this.environmentExportManager.exportApplication(osId, ud);
        UploadDownloadUtils.downloadFile((InputStream)zipFileStream, (String)(osId + ".zip"), (HttpServletRequest)request, (HttpServletResponse)response);
    }
}

