/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.controller;

import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.locode.platform.service.ModelExportManager;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"modelExport"})
@Api(value="\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa", tags={"\u6a21\u677f\u5bfc\u5165\u5bfc\u51fa"})
public class ModelExportController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(ModelExportController.class);
    @Value(value="${app.home:./}")
    private String appHome;
    @Autowired
    private ModelExportManager modelExportManager;
    @Autowired
    private PlatformEnvironment platformEnvironment;

    @ApiOperation(value="1.\u5bfc\u51fa\u5e94\u7528")
    @GetMapping(value={"/downloadModel/{osId}"})
    public Map<String, String> downLoadModel(@PathVariable String osId, HttpServletRequest request) throws IOException {
        if (osId == null || osId.trim().isEmpty()) {
            throw new ObjectException("osId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CentitUserDetails ud = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (ud == null) {
            throw new ObjectException(302, "\u7528\u6237\u6ca1\u6709\u767b\u5f55\uff0c\u6ca1\u6709\u5bf9\u5e94\u7684\u6743\u9650\uff01");
        }
        Map parameters = ModelExportController.collectRequestParameters((HttpServletRequest)request);
        List userGroups = this.platformEnvironment.listWorkGroup(osId, ud.getUserCode(), null);
        if (CollectionUtils.isEmpty((Collection)userGroups)) {
            throw new ObjectException(403, "\u7528\u6237\u6ca1\u6709\u6743\u9650\u5bfc\u51fa\u8fd9\u4e2a\u5e94\u7528\uff1a" + osId + "\uff01");
        }
        String fileId = this.modelExportManager.downModel(osId, parameters);
        if (fileId == null || fileId.isEmpty()) {
            throw new ObjectException(500, "\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        String fileName = fileId;
        try {
            OsInfo osInfo = this.platformEnvironment.getOsInfo(osId);
            if (osInfo != null && osInfo.getOsName() != null) {
                fileName = osInfo.getOsName();
            }
        }
        catch (Exception osInfo) {
            // empty catch block
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fileName", fileName);
        map.put("fileId", fileId);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="2.\u6839\u636e\u8fd4\u56deid\u4e0b\u8f7d\u5e94\u7528\u6587\u4ef6")
    @GetMapping(value={"/downloadModelFile"})
    public void downLoadModel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map parameters = ModelExportController.collectRequestParameters((HttpServletRequest)request);
        String fileName = StringBaseOpt.castObjectToString(parameters.get("fileName"), (String)"");
        String fileId = StringBaseOpt.objectToString(parameters.get("fileId"));
        if (fileId.isEmpty()) {
            throw new ObjectException("fileId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String safeFileName = URLEncoder.encode(fileName.isEmpty() ? fileId : fileName, "UTF-8") + ".zip";
        String filePath = this.appHome + File.separator + fileId + ".zip";
        Path fileFullPath = Paths.get(filePath, new String[0]);
        if (!Files.exists(fileFullPath, new LinkOption[0])) {
            throw new ObjectException("\u6ca1\u6709\u53d1\u73b0\u6587\u4ef6\uff01");
        }
        response.setContentType(FileType.mapExtNameToMimeType((String)"zip"));
        response.setHeader("Content-disposition", "attachment; filename=" + safeFileName);
        response.setContentLengthLong(Files.size(fileFullPath));
        try (InputStream in = Files.newInputStream(fileFullPath, new OpenOption[0]);){
            IOUtils.copy((InputStream)new BufferedInputStream(in), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)filePath, (Object)e);
        }
        finally {
            response.getOutputStream().close();
        }
    }

    /*
     * Exception decompiling
     */
    @ApiOperation(value="3.\u6587\u4ef6\u5bfc\u5165")
    @RequestMapping(value={"/updateApp"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public JSONObject upLoadModel(HttpServletRequest request) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

