/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.locode.platform.dao.AppMergeTaskDao;
import com.centit.locode.platform.dao.ApplicationVersionDao;
import com.centit.locode.platform.po.AppMergeTask;
import com.centit.locode.platform.po.ApplicationVersion;
import com.centit.locode.platform.po.HistoryVersion;
import com.centit.locode.platform.service.ApplicationVersionService;
import com.centit.locode.platform.service.HistoryVersionService;
import com.centit.locode.platform.service.ModelExportManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ApplicationVersionServiceImpl
implements ApplicationVersionService {
    @Autowired
    ApplicationVersionDao applicationVersionDao;
    @Autowired
    AppMergeTaskDao appMergeTaskDao;
    @Autowired
    PlatformEnvironment platformEnvironment;
    @Autowired
    HistoryVersionService historyVersionService;
    @Autowired
    ModelExportManager modelExportManager;

    public static void mapJsonProperties(JSONObject json, String ... props) {
        for (String p : props) {
            String sp = json.getString(p);
            if (!StringUtils.isNotBlank((CharSequence)sp)) continue;
            json.put((Object)p, JSON.parse((String)sp));
        }
    }

    private HistoryVersion createFlowHV(JSONObject jsonObject) {
        HistoryVersion hv = new HistoryVersion();
        hv.setHistoryId(UuidOpt.getUuidAsString22());
        hv.setType("1");
        hv.setRelationId(jsonObject.getString("flowCode"));
        hv.setMemo(jsonObject.getString("flowName"));
        JSONObject jsonContent = JSON.parseObject((String)jsonObject.getString("flowXmlDesc"));
        if (jsonContent != null) {
            jsonContent.put((Object)"optId", (Object)jsonObject.getString("optId"));
            jsonContent.put((Object)"flowCode", (Object)jsonObject.getString("flowCode"));
            jsonContent.put((Object)"version", (Object)jsonObject.getString("version"));
            jsonContent.put((Object)"flowName", (Object)jsonObject.getString("flowName"));
            jsonContent.put((Object)"flowDesc", (Object)jsonObject.getString("flowDesc"));
            jsonContent.put((Object)"flowClass", (Object)jsonObject.getString("flowClass"));
        } else {
            jsonContent = jsonObject;
        }
        hv.setContent(jsonContent);
        return hv;
    }

    private HistoryVersion createPageHV(JSONObject jsonObject) {
        HistoryVersion hv = new HistoryVersion();
        hv.setHistoryId(UuidOpt.getUuidAsString22());
        hv.setType("2");
        hv.setRelationId(jsonObject.getString("modelId"));
        hv.setMemo(jsonObject.getString("modelName"));
        ApplicationVersionServiceImpl.mapJsonProperties(jsonObject, "formTemplate", "mobileFormTemplate", "structureFunction");
        hv.setPushUser(jsonObject.getString("recorder"));
        hv.setContent(jsonObject);
        return hv;
    }

    private HistoryVersion createApiHV(JSONObject jsonObject) {
        HistoryVersion hv = new HistoryVersion();
        hv.setHistoryId(UuidOpt.getUuidAsString22());
        hv.setType("3");
        hv.setRelationId(jsonObject.getString("packetId"));
        hv.setMemo(jsonObject.getString("packetName"));
        ApplicationVersionServiceImpl.mapJsonProperties(jsonObject, "dataOptDescJson", "returnResult", "extProps", "schemaProps");
        hv.setPushUser(jsonObject.getString("recorder"));
        hv.setContent(jsonObject);
        return hv;
    }

    private HistoryVersion createHistoryVersion(String objType, String objectId) {
        JSONObject api;
        if ("1".equals(objType)) {
            JSONObject flow = DatabaseOptUtils.getObjectBySqlAsJson((BaseDaoImpl)this.applicationVersionDao, (String)"select b.FLOW_CODE, b.version, b.FLOW_NAME, b.FLOW_CLASS, b.FLOW_STATE, b.FLOW_DESC, b.FLOW_XML_DESC, b.Time_Limit, b.Expire_Opt,b.Opt_ID, b.OS_ID, b.SOURCE_ID, b.EXPIRE_CALL_API, b.Warning_Param   from  wf_flow_define b   where b.FLOW_CODE = ? and b.version= 0 ", (Object[])new Object[]{objectId});
            if (flow != null) {
                return this.createFlowHV(flow);
            }
        } else if ("2".equals(objType)) {
            JSONObject page = DatabaseOptUtils.getObjectBySqlAsJson((BaseDaoImpl)this.applicationVersionDao, (String)"select MODEL_ID, Model_Name, OPT_ID, os_id, Model_Type, Recorder, Model_Comment, MOBILE_FORM_TEMPLATE, form_template,STRUCTURE_FUNCTION, SOURCE_ID, MODEL_TAG   from m_meta_form_model where MODEL_ID = ?", (Object[])new Object[]{objectId});
            if (page != null) {
                return this.createPageHV(page);
            }
        } else if ("3".equals(objType) && (api = DatabaseOptUtils.getObjectBySqlAsJson((BaseDaoImpl)this.applicationVersionDao, (String)"select task_type, task_Cron, SOURCE_ID, schema_props, return_type, return_result, request_body_type, Recorder, PACKET_TYPE, PACKET_NAME, PACKET_ID, PACKET_DESC, FALL_BACK_LEVEL, os_id, OPT_ID, opt_code, need_rollback, Owner_Type, Owner_Code, is_disable, interface_name, has_data_opt, BUFFER_FRESH_PERIOD, buffer_fresh_period_type, EXT_PROPS, data_opt_desc_json, FALL_BACK_LEVEL, log_level from q_data_packet where PACKET_ID = ? ", (Object[])new Object[]{objectId})) != null) {
            return this.createApiHV(api);
        }
        return null;
    }

    private List<HistoryVersion> createHistoryVersions(String osId) {
        JSONArray apis;
        JSONArray pages;
        ArrayList<HistoryVersion> hvs = new ArrayList<HistoryVersion>(100);
        JSONArray flows = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationVersionDao, (String)"select b.FLOW_CODE, b.version, b.FLOW_NAME, b.FLOW_CLASS,  b.FLOW_STATE, b.FLOW_DESC, b.FLOW_XML_DESC, b.Time_Limit, b.Expire_Opt, b.Opt_ID, b.OS_ID, b.SOURCE_ID, b.EXPIRE_CALL_API, b.Warning_Param  from  (select FLOW_CODE, max(version) as version from wf_flow_define where os_id = ? group by flow_code) a  join wf_flow_define b on (a.flow_code=b.flow_code and a.version = b.version)  where b.FLOW_STATE = 'B'  order by b.flow_code", (Object[])new Object[]{osId});
        if (flows != null) {
            for (Object obj : flows) {
                if (!(obj instanceof JSONObject)) continue;
                hvs.add(this.createFlowHV((JSONObject)obj));
            }
        }
        if ((pages = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationVersionDao, (String)"select MODEL_ID, Model_Name, OPT_ID, os_id, Model_Type, Recorder, Model_Comment, MOBILE_FORM_TEMPLATE, form_template, STRUCTURE_FUNCTION, SOURCE_ID, MODEL_TAG   from m_meta_form_model where IS_VALID = 'F' and os_id = ? order by MODEL_ID", (Object[])new Object[]{osId})) != null) {
            for (Object obj : pages) {
                if (!(obj instanceof JSONObject)) continue;
                hvs.add(this.createPageHV((JSONObject)obj));
            }
        }
        if ((apis = DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationVersionDao, (String)"select task_type, task_Cron, SOURCE_ID, schema_props,  return_type, return_result, request_body_type, Recorder,  PACKET_TYPE, PACKET_NAME, PACKET_ID, PACKET_DESC, FALL_BACK_LEVEL,  os_id, OPT_ID, opt_code, need_rollback, Owner_Type, Owner_Code,  is_disable, interface_name, has_data_opt, BUFFER_FRESH_PERIOD, buffer_fresh_period_type,  EXT_PROPS, data_opt_desc_json, FALL_BACK_LEVEL, log_level  from q_data_packet where is_disable = 'F' and os_id = ?  order by PACKET_ID", (Object[])new Object[]{osId})) != null) {
            for (Object obj : apis) {
                if (!(obj instanceof JSONObject)) continue;
                hvs.add(this.createApiHV((JSONObject)obj));
            }
        }
        return hvs;
    }

    @Override
    public String createApplicationVersion(ApplicationVersion applicationVersion) {
        if (StringUtils.isBlank((CharSequence)applicationVersion.getApplicationId())) {
            throw new ObjectException(611, "\u6ca1\u6709\u6307\u5b9a\u5173\u8054\u5e94\u7528\u4fe1\u606f\uff01");
        }
        OsInfo osInfo = this.platformEnvironment.getOsInfo(applicationVersion.getApplicationId());
        if (osInfo == null) {
            throw new ObjectException(611, "\u5173\u8054\u5e94\u7528\u4fe1\u606f\u4e0d\u80fd\u5b58\u5728\uff01");
        }
        String fileId = "";
        IOException exception = null;
        try {
            fileId = this.modelExportManager.exportModelAndSaveToFileServer(osInfo);
        }
        catch (IOException e) {
            exception = e;
        }
        String versionId = UuidOpt.getUuidAsString22();
        applicationVersion.setVersionId(versionId);
        Date currentTime = DatetimeOpt.currentUtilDate();
        applicationVersion.setDateCreated(currentTime);
        List<HistoryVersion> hvs = this.createHistoryVersions(applicationVersion.getApplicationId());
        for (HistoryVersion hv : hvs) {
            hv.setAppVersionId(versionId);
            hv.setOsId(applicationVersion.getApplicationId());
            hv.setPushTime(currentTime);
            hv.setPushUser("system");
            hv.setLabel("\u5168\u5c40\u7248\u672c\uff1a" + versionId);
            hv.setHistorySha(hv.generateHistorySha());
            this.historyVersionService.createHistoryVersion(hv);
        }
        applicationVersion.setBackupFileId(fileId);
        this.applicationVersionDao.saveNewObject(applicationVersion);
        if (exception != null) {
            throw new RuntimeException("\u521b\u5efa\u5e94\u7528\u7248\u672c\u5b8c\u6210\uff0c\u4f46\u662f\u4e0a\u4f20\u5e94\u7528\u5feb\u7167\u5931\u8d25\uff1a" + exception.getMessage(), exception);
        }
        return versionId;
    }

    @Override
    public void updateApplicationVersion(ApplicationVersion applicationVersion) {
        applicationVersion.setBackupFileId(null);
        applicationVersion.setApplicationId(null);
        this.applicationVersionDao.updateObject(applicationVersion);
    }

    @Override
    public void deleteApplicationVersion(String versionId) {
        this.applicationVersionDao.deleteObjectById(versionId);
        this.historyVersionService.removeAppHistoryTag(versionId);
    }

    @Override
    public boolean checkMergeState(String applicationId) {
        return this.applicationVersionDao.countObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"applicationId", applicationId, "mergeStatus", "B"})) > 0;
    }

    @Override
    public List<ApplicationVersion> listApplicationVersion(String applicationId, PageDesc pageDesc, Map<String, Object> filterMap) {
        ApplicationVersion mergeObj;
        filterMap.put("applicationId", applicationId);
        List versionList = this.applicationVersionDao.listObjectsByProperties(filterMap, pageDesc);
        boolean isInMerging = false;
        if (versionList != null) {
            for (ApplicationVersion version : versionList) {
                if (!"B".equals(version.getMergeStatus())) continue;
                isInMerging = true;
                break;
            }
        }
        if (!isInMerging && (mergeObj = (ApplicationVersion)this.applicationVersionDao.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"mergeStatus", "B"}))) != null) {
            ArrayList<ApplicationVersion> versionList2 = new ArrayList<ApplicationVersion>();
            versionList2.add(mergeObj);
            if (versionList != null) {
                versionList2.addAll(versionList);
            }
            return versionList2;
        }
        return versionList;
    }

    @Override
    public ApplicationVersion getApplicationVersion(String versionId) {
        return (ApplicationVersion)this.applicationVersionDao.getObjectById(versionId);
    }

    private JSONArray compareTwoHVS(List<HistoryVersion> hvs1, List<HistoryVersion> hvs2, boolean withContent) {
        JSONObject diff;
        HistoryVersion hv1;
        int len2;
        int len1 = hvs1 == null ? 0 : hvs1.size();
        int n = len2 = hvs2 == null ? 0 : hvs2.size();
        if (len1 > 0) {
            hvs1.sort(HistoryVersion::compareTo);
        }
        if (len2 > 0) {
            hvs2.sort(HistoryVersion::compareTo);
        }
        int i = 0;
        int j = 0;
        JSONArray diffJsons = new JSONArray();
        while (i < len1 && j < len2) {
            JSONObject diff2;
            HistoryVersion hv2;
            hv1 = hvs1.get(i);
            if (hv1.compareTo(hv2 = hvs2.get(j)) == 0) {
                if (!StringUtils.equals((CharSequence)hv1.getHistorySha(), (CharSequence)hv2.getHistorySha())) {
                    diff2 = new JSONObject();
                    diff2.put((Object)"type", (Object)hv1.getType());
                    diff2.put((Object)"typeDesc", (Object)hv1.getTypeDesc());
                    diff2.put((Object)"relationId", (Object)hv1.getRelationId());
                    diff2.put((Object)"historyId", (Object)hv1.getHistoryId());
                    diff2.put((Object)"sha", (Object)hv1.getHistorySha());
                    diff2.put((Object)"historyId2", (Object)hv2.getHistoryId());
                    diff2.put((Object)"sha2", (Object)hv2.getHistorySha());
                    diff2.put((Object)"diff", (Object)"U");
                    diff2.put((Object)"diffDesc", (Object)"\u66f4\u6539");
                    diff2.put((Object)"memo", (Object)hv1.getMemo());
                    diff2.put((Object)"lastUpdateUser", (Object)(StringUtils.isBlank((CharSequence)hv2.getPushUser()) ? hv1.getPushUser() : hv2.getPushUser()));
                    if (withContent) {
                        diff2.put((Object)"content", (Object)hv2.getContent());
                    }
                    diffJsons.add((Object)diff2);
                }
                ++i;
                ++j;
                continue;
            }
            if (hv1.compareTo(hv2) < 0) {
                diff2 = new JSONObject();
                diff2.put((Object)"type", (Object)hv1.getType());
                diff2.put((Object)"typeDesc", (Object)hv1.getTypeDesc());
                diff2.put((Object)"relationId", (Object)hv1.getRelationId());
                diff2.put((Object)"historyId", (Object)hv1.getHistoryId());
                diff2.put((Object)"sha", (Object)hv1.getHistorySha());
                diff2.put((Object)"diff", (Object)"D");
                diff2.put((Object)"diffDesc", (Object)"\u5220\u9664");
                diff2.put((Object)"memo", (Object)hv1.getMemo());
                diff2.put((Object)"lastUpdateUser", (Object)hv1.getPushUser());
                diffJsons.add((Object)diff2);
                ++i;
                continue;
            }
            diff2 = new JSONObject();
            diff2.put((Object)"type", (Object)hv2.getType());
            diff2.put((Object)"typeDesc", (Object)hv2.getTypeDesc());
            diff2.put((Object)"relationId", (Object)hv2.getRelationId());
            diff2.put((Object)"historyId2", (Object)hv2.getHistoryId());
            diff2.put((Object)"sha2", (Object)hv2.getHistorySha());
            diff2.put((Object)"diff", (Object)"C");
            diff2.put((Object)"diffDesc", (Object)"\u65b0\u589e");
            diff2.put((Object)"memo", (Object)hv2.getMemo());
            if (withContent) {
                diff2.put((Object)"content", (Object)hv2.getContent());
            }
            diff2.put((Object)"lastUpdateUser", (Object)hv2.getPushUser());
            diffJsons.add((Object)diff2);
            ++j;
        }
        while (i < len1) {
            hv1 = hvs1.get(i);
            diff = new JSONObject();
            diff.put((Object)"type", (Object)hv1.getType());
            diff.put((Object)"typeDesc", (Object)hv1.getTypeDesc());
            diff.put((Object)"relationId", (Object)hv1.getRelationId());
            diff.put((Object)"historyId", (Object)hv1.getHistoryId());
            diff.put((Object)"sha", (Object)hv1.getHistorySha());
            diff.put((Object)"diff", (Object)"D");
            diff.put((Object)"diffDesc", (Object)"\u5220\u9664");
            diff.put((Object)"memo", (Object)hv1.getMemo());
            diff.put((Object)"lastUpdateUser", (Object)hv1.getPushUser());
            diffJsons.add((Object)diff);
            ++i;
        }
        while (j < len2) {
            HistoryVersion hv2 = hvs2.get(j);
            diff = new JSONObject();
            diff.put((Object)"type", (Object)hv2.getType());
            diff.put((Object)"typeDesc", (Object)hv2.getTypeDesc());
            diff.put((Object)"relationId", (Object)hv2.getRelationId());
            diff.put((Object)"historyId2", (Object)hv2.getHistoryId());
            diff.put((Object)"sha2", (Object)hv2.getHistorySha());
            diff.put((Object)"diff", (Object)"C");
            diff.put((Object)"diffDesc", (Object)"\u65b0\u589e");
            diff.put((Object)"memo", (Object)hv2.getMemo());
            if (withContent) {
                diff.put((Object)"content", (Object)hv2.getContent());
            }
            diff.put((Object)"lastUpdateUser", (Object)hv2.getPushUser());
            diffJsons.add((Object)diff);
            ++j;
        }
        return diffJsons;
    }

    @Override
    public JSONArray compareTwoVersion(String versionId, String versionId2) {
        List<HistoryVersion> hvs1 = this.historyVersionService.listHistoryByAppVersion(versionId);
        List<HistoryVersion> hvs2 = this.historyVersionService.listHistoryByAppVersion(versionId2);
        return this.compareTwoHVS(hvs1, hvs2, false);
    }

    private JSONArray innerCompareToOldVersion(String applicationId, String versionId, boolean withContent) {
        List<HistoryVersion> hvs1 = this.historyVersionService.listHistoryByAppVersion(versionId);
        List<HistoryVersion> hvs2 = this.createHistoryVersions(applicationId);
        for (HistoryVersion hv : hvs2) {
            hv.setHistorySha(hv.generateHistorySha());
        }
        return this.compareTwoHVS(hvs1, hvs2, withContent);
    }

    @Override
    public JSONArray compareToOldVersion(String applicationId, String versionId) {
        return this.innerCompareToOldVersion(applicationId, versionId, false);
    }

    @Override
    public JSONArray listAppComponents(String appVersionId, String type, PageDesc pageDesc) {
        if ("1".equals(type)) {
            return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationVersionDao, (String)"select h.history_id, h.relation_id, h.label, h.history_sha, h.os_id, h.type, f.FLOW_NAME, f.FLOW_DESC, o.OPT_NAME from history_version h join wf_flow_define f on (h.relation_id = f.FLOW_CODE and f.version =0) left join F_OPTINFO o on (f.OPT_ID = o.OPT_ID) where h.type  = '1' and h.APP_VERSION_ID = ?", (Object[])new Object[]{appVersionId}, (PageDesc)pageDesc);
        }
        if ("2".equals(type)) {
            return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationVersionDao, (String)"select h.history_id, h.relation_id, h.label, h.history_sha, h.os_id, h.type, f.Model_Name, f.Model_Comment, o.OPT_NAME  from history_version h join m_meta_form_model f on (h.relation_id = f.MODEL_ID) left join F_OPTINFO o on (f.OPT_ID = o.OPT_ID) where h.type = '2' and h.APP_VERSION_ID = ?", (Object[])new Object[]{appVersionId}, (PageDesc)pageDesc);
        }
        if ("3".equals(type)) {
            return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.applicationVersionDao, (String)"select h.history_id, h.relation_id, h.label, h.history_sha, h.os_id, h.type, p.PACKET_NAME, p.PACKET_DESC, o.OPT_NAME  from history_version h join q_data_packet p on (h.relation_id = p.PACKET_ID) left join F_OPTINFO o on (p.OPT_ID = o.OPT_ID) where h.type  = '3' and h.APP_VERSION_ID = ?", (Object[])new Object[]{appVersionId}, (PageDesc)pageDesc);
        }
        return null;
    }

    private HistoryVersion createHistoryVersion(JSONObject jsonDiff, ApplicationVersion appVersion) {
        HistoryVersion hv = new HistoryVersion();
        hv.setOsId(appVersion.getApplicationId());
        hv.setRelationId(jsonDiff.getString("relationId"));
        hv.setType(jsonDiff.getString("type"));
        hv.setContent(jsonDiff.getJSONObject("content"));
        hv.setLabel("V_recovery_" + appVersion.getVersionId());
        hv.setMemo("\u56e0\u4e3a\u6062\u590d\u7248\u672c\u800c\u521b\u5efa\u7684\uff1a" + appVersion.getVersionId());
        hv.setPushTime(DatetimeOpt.currentUtilDate());
        hv.setPushUser("system");
        hv.setHistorySha(hv.generateHistorySha());
        this.historyVersionService.createHistoryVersion(hv);
        return hv;
    }

    private void recoveryHistoryVersion(HistoryVersion hv) {
        if ("1".equals(hv.getType())) {
            JSONObject flowJson = hv.getContent();
            Object obj = DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this.applicationVersionDao, (String)"select count(*) as hasFlow from wf_flow_define where FLOW_CODE= ? and version = 0", (Object[])new Object[]{hv.getRelationId()});
            if (NumberBaseOpt.castObjectToInteger((Object)obj, (Integer)0) == 0) {
                flowJson.put((Object)"flowXmlDesc", (Object)flowJson.toString());
                flowJson.put((Object)"flowClass", (Object)StringBaseOpt.castObjectToString((Object)flowJson.get("flowClass"), (String)"R"));
                DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.applicationVersionDao, (String)"insert into wf_flow_define (FLOW_CODE, version, FLOW_XML_DESC, FLOW_NAME, FLOW_DESC, FLOW_STATE,  Time_Limit, Expire_Opt, Opt_ID, OS_ID, SOURCE_ID, EXPIRE_CALL_API, Warning_Param,flow_class ) values ( :flowCode, 0, :flowXmlDesc, :flowName, :flowDesc, 'A',:timeLimit, :expireOpt, :optId, :osId, :sourceId, :expireCallApi, :warningParam,:flowClass)", (Map)flowJson);
                return;
            }
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationVersionDao, (String)"update wf_flow_define set FLOW_XML_DESC = ?, FLOW_NAME =?, FLOW_DESC =?, FLOW_STATE='A'  where FLOW_CODE= ? and version = 0", (Object[])new Object[]{JSON.toJSONString((Object)flowJson), flowJson.getString("flowName"), flowJson.getString("flowDesc"), hv.getRelationId()});
            return;
        }
        if ("2".equals(hv.getType())) {
            JSONObject modelJson = hv.getContent();
            Object obj = DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this.applicationVersionDao, (String)"select count(*) as hasPage from m_meta_form_model_draft where MODEL_ID= ?", (Object[])new Object[]{hv.getRelationId()});
            if (NumberBaseOpt.castObjectToInteger((Object)obj, (Integer)0) == 0) {
                modelJson.put((Object)"modelId", (Object)hv.getRelationId());
                modelJson.put((Object)"lastModifyDate", (Object)DatetimeOpt.currentUtilDate());
                modelJson.put((Object)"mobileFormTemplate", (Object)modelJson.getString("mobileFormTemplate"));
                modelJson.put((Object)"formTemplate", (Object)modelJson.getString("formTemplate"));
                modelJson.put((Object)"structureFunction", (Object)modelJson.getString("structureFunction"));
                DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.applicationVersionDao, (String)"insert into m_meta_form_model_draft (MODEL_ID, Model_Name, OPT_ID, os_id, Model_Type, last_modify_Date, Recorder, Model_Comment, MOBILE_FORM_TEMPLATE, form_template,  SOURCE_ID, STRUCTURE_FUNCTION, MODEL_TAG, IS_VALID ) values ( :modelId, :modelName, :optId, :osId, :modelType,  :lastModifyDate, :recorder, :modelComment, :mobileFormTemplate, :formTemplate, :sourceId, :structureFunction, :modelTag, 'F' )", (Map)modelJson);
                return;
            }
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationVersionDao, (String)"update m_meta_form_model_draft set IS_VALID = 'F', Model_Comment = ?, MOBILE_FORM_TEMPLATE = ? , form_template= ?, STRUCTURE_FUNCTION = ?, MODEL_TAG = ? where MODEL_ID = ?", (Object[])new Object[]{modelJson.getString("modelComment"), modelJson.getString("mobileFormTemplate"), modelJson.getString("formTemplate"), modelJson.getString("structureFunction"), modelJson.getString("modelTag"), hv.getRelationId()});
            return;
        }
        if ("3".equals(hv.getType())) {
            JSONObject packetJson = hv.getContent();
            Object obj = DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this.applicationVersionDao, (String)"select count(*) as hasApi from q_data_packet_draft where PACKET_ID= ?", (Object[])new Object[]{hv.getRelationId()});
            if (NumberBaseOpt.castObjectToInteger((Object)obj, (Integer)0) == 0) {
                packetJson.put((Object)"packetId", (Object)hv.getRelationId());
                packetJson.put((Object)"recordDate", (Object)DatetimeOpt.currentUtilDate());
                packetJson.put((Object)"updateDate", (Object)DatetimeOpt.currentUtilDate());
                packetJson.put((Object)"returnResult", (Object)packetJson.getString("returnResult"));
                packetJson.put((Object)"extProps", (Object)packetJson.getString("extProps"));
                packetJson.put((Object)"dataOptDescJson", (Object)packetJson.getString("dataOptDescJson"));
                packetJson.put((Object)"schemaProps", (Object)packetJson.getString("schemaProps"));
                DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.applicationVersionDao, (String)"insert into q_data_packet_draft (PACKET_ID, os_id, Owner_Type, Owner_Code, PACKET_NAME,  PACKET_TYPE, PACKET_DESC, Recorder, Record_Date, has_data_opt,  data_opt_desc_json, task_type, task_Cron,  is_valid, interface_name, return_type, return_result, update_date, need_rollback, OPT_ID, EXT_PROPS, opt_code,  BUFFER_FRESH_PERIOD, buffer_fresh_period_type, log_level, is_disable, schema_props, request_body_type, FALL_BACK_LEVEL ) values (:packetId, :osId, :ownerType, :ownerCode, :packetName, :packetType, :packetDesc, :recorder, :recordDate, :hasDataOpt, :dataOptDescJson, :taskType, :taskCron,  'T', :interfaceName, :returnType, :returnResult, :updateDate,  :needRollback, :optId, :extProps, :optCode, :bufferFreshPeriod, :bufferFreshPeriodType, :logLevel,  'F', :schemaProps, :requestBodyType, :fallBackLevel )", (Map)packetJson);
                return;
            }
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationVersionDao, (String)"update q_data_packet_draft set is_disable = 'F', task_type = ?, schema_props = ?, return_type = ?, return_result = ?, request_body_type = ?, PACKET_TYPE = ?, PACKET_NAME = ?, PACKET_DESC  = ?,  interface_name = ?, has_data_opt = ?,  EXT_PROPS  = ?, data_opt_desc_json = ?  where PACKET_ID= ?", (Object[])new Object[]{packetJson.getString("taskType"), packetJson.getString("schemaProps"), packetJson.getString("returnType"), packetJson.getString("returnResult"), packetJson.getString("requestBodyType"), packetJson.getString("packetType"), packetJson.getString("packetName"), packetJson.getString("packetDesc"), packetJson.getString("interfaceName"), packetJson.getString("hasDataOpt"), packetJson.getString("extProps"), packetJson.getString("dataOptDescJson"), hv.getRelationId()});
        }
    }

    private void changeRelationObjectState(String objType, String relationId, boolean toGarbage) {
        if ("1".equals(objType)) {
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationVersionDao, (String)("update wf_flow_define set FLOW_STATE= " + (toGarbage ? "'D'" : "'B'") + " where FLOW_CODE= ? and version = 0"), (Object[])new Object[]{relationId});
        } else if ("2".equals(objType)) {
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationVersionDao, (String)("update m_meta_form_model_draft set IS_VALID =" + (toGarbage ? "'T'" : "'F'") + " where MODEL_ID = ?"), (Object[])new Object[]{relationId});
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationVersionDao, (String)("update m_meta_form_model set IS_VALID = " + (toGarbage ? "'T'" : "'F'") + " where MODEL_ID = ?"), (Object[])new Object[]{relationId});
        } else if ("3".equals(objType)) {
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationVersionDao, (String)("update q_data_packet_draft set is_disable = " + (toGarbage ? "'T'" : "'F'") + " where PACKET_ID= ?"), (Object[])new Object[]{relationId});
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.applicationVersionDao, (String)("update q_data_packet set is_disable = " + (toGarbage ? "'T'" : "'F'") + " where PACKET_ID= ?"), (Object[])new Object[]{relationId});
        }
    }

    @Override
    public int restoreAppVersion(String appVersionId, String userCode) {
        ApplicationVersion appVersion = (ApplicationVersion)this.applicationVersionDao.getObjectById(appVersionId);
        JSONArray diffs = this.innerCompareToOldVersion(appVersion.getApplicationId(), appVersionId, true);
        int mergeCount = 0;
        for (Object obj : diffs) {
            if (!(obj instanceof JSONObject)) continue;
            JSONObject jsonDiff = (JSONObject)obj;
            AppMergeTask mergeTask = new AppMergeTask();
            mergeTask.setAppVersionId(appVersionId);
            mergeTask.setMergeStatus("B");
            mergeTask.setRelationId(jsonDiff.getString("relationId"));
            mergeTask.setObjectType(jsonDiff.getString("type"));
            mergeTask.setUpdateUser(StringUtils.isBlank((CharSequence)jsonDiff.getString("lastUpdateUser")) ? userCode : jsonDiff.getString("lastUpdateUser"));
            if ("D".equals(jsonDiff.getString("diff"))) {
                HistoryVersion hv = this.historyVersionService.getHistoryVersion(jsonDiff.getString("historyId"));
                this.recoveryHistoryVersion(hv);
                mergeTask.setMergeType("C");
                mergeTask.setHistoryId(jsonDiff.getString("historyId"));
                mergeTask.setMergeDesc("\u521b\u5efa - " + jsonDiff.getString("memo"));
            } else if ("C".equals(jsonDiff.getString("diff"))) {
                this.changeRelationObjectState(jsonDiff.getString("type"), jsonDiff.getString("relationId"), true);
                mergeTask.setHistoryId(jsonDiff.getString("historyId2"));
                mergeTask.setMergeDesc("\u5220\u9664 - " + jsonDiff.getString("memo"));
                mergeTask.setMergeType("D");
            } else if ("U".equals(jsonDiff.getString("diff"))) {
                HistoryVersion hv2 = this.createHistoryVersion(jsonDiff, appVersion);
                HistoryVersion hv = this.historyVersionService.getHistoryVersion(jsonDiff.getString("historyId"));
                this.recoveryHistoryVersion(hv);
                mergeTask.setHistoryId(hv2.getHistoryId());
                mergeTask.setMergeDesc("\u66f4\u65b0 - " + jsonDiff.getString("memo"));
                mergeTask.setMergeType("U");
            }
            this.appMergeTaskDao.saveNewObject(mergeTask);
            ++mergeCount;
        }
        if (mergeCount > 0) {
            this.applicationVersionDao.setRestoreStatus(appVersionId, "B");
        }
        return mergeCount;
    }

    @Override
    public int mergeAppComponents(String appVersionId, JSONArray components, String userCode) {
        ApplicationVersion appVersion = (ApplicationVersion)this.applicationVersionDao.getObjectById(appVersionId);
        int mergeCount = 0;
        for (Object obj : components) {
            HistoryVersion hv;
            JSONObject jsonDiff;
            String historyId;
            if (!(obj instanceof JSONObject) || StringUtils.isBlank((CharSequence)(historyId = (jsonDiff = (JSONObject)obj).getString("historyId"))) || (hv = this.historyVersionService.getHistoryVersion(historyId)) == null) continue;
            AppMergeTask mergeTask = new AppMergeTask();
            mergeTask.setAppVersionId(appVersionId);
            mergeTask.setMergeStatus("B");
            mergeTask.setRelationId(hv.getRelationId());
            mergeTask.setObjectType(hv.getType());
            mergeTask.setUpdateUser(userCode);
            HistoryVersion hv2 = this.createHistoryVersion(hv.getType(), hv.getRelationId());
            if (hv2 == null) {
                this.recoveryHistoryVersion(hv);
                mergeTask.setMergeType("C");
                mergeTask.setHistoryId(hv.getHistoryId());
                mergeTask.setMergeDesc("\u521b\u5efa - " + hv.getMemo());
            } else {
                hv2.setOsId(appVersion.getApplicationId());
                hv2.setHistorySha(hv2.generateHistorySha());
                if (!StringUtils.equals((CharSequence)hv.getHistorySha(), (CharSequence)hv2.getHistorySha())) {
                    hv2.setLabel("V_recovery_" + appVersion.getVersionId());
                    hv2.setMemo("\u56e0\u4e3a\u6062\u590d\u7248\u672c\u800c\u521b\u5efa\u7684\uff1a" + appVersion.getVersionId());
                    hv2.setPushTime(DatetimeOpt.currentUtilDate());
                    hv2.setPushUser(userCode);
                    this.historyVersionService.createHistoryVersion(hv2);
                    this.recoveryHistoryVersion(hv);
                    mergeTask.setHistoryId(jsonDiff.getString("historyId"));
                    mergeTask.setMergeDesc("\u66f4\u65b0 - " + hv.getMemo());
                    mergeTask.setMergeType("U");
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)mergeTask.getMergeType())) continue;
            this.appMergeTaskDao.saveNewObject(mergeTask);
            ++mergeCount;
        }
        if (mergeCount > 0) {
            this.applicationVersionDao.setRestoreStatus(appVersionId, "B");
        }
        return mergeCount;
    }

    @Override
    public List<AppMergeTask> listAppMergeTasks(String appVersionId, Map<String, Object> filterMap, PageDesc pageDesc) {
        filterMap.put("appVersionId", appVersionId);
        return this.appMergeTaskDao.listObjectsByProperties(filterMap, pageDesc);
    }

    private void publishPage(String modelId) {
        String updateSql;
        String query = "select MODEL_ID, Model_Name, OPT_ID, os_id, Model_Type,  Recorder, Model_Comment, MOBILE_FORM_TEMPLATE, form_template,  SOURCE_ID, STRUCTURE_FUNCTION, MODEL_TAG, IS_VALID  from m_meta_form_model_draft where MODEL_ID = ?";
        JSONObject object = DatabaseOptUtils.getObjectBySqlAsJson((BaseDaoImpl)this.appMergeTaskDao, (String)query, (Object[])new Object[]{modelId});
        if (object == null) {
            throw new ObjectException(604, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9875\u9762\u6a21\u5757" + modelId);
        }
        Object count = DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this.appMergeTaskDao, (String)"select count(*) from m_meta_form_model where MODEL_ID = ?", (Object[])new Object[]{modelId});
        object.put((Object)"lastModifyDate", (Object)DatetimeOpt.currentUtilDate());
        object.put((Object)"publishDate", (Object)DatetimeOpt.currentUtilDate());
        if (NumberBaseOpt.castObjectToInteger((Object)count, (Integer)0) > 0) {
            updateSql = "update m_meta_form_model set  Model_Name = :modelName, OPT_ID = :optId, os_id = :osId, Model_Type = :modelType,  Recorder = :recorder, Model_Comment = :modelComment, MOBILE_FORM_TEMPLATE = :mobileFormTemplate, form_template = :formTemplate,  SOURCE_ID = :sourceId, STRUCTURE_FUNCTION = :structureFunction, MODEL_TAG = :modelTag, IS_VALID = 'F', last_modify_Date = :lastModifyDate, publish_date = :publishDate where MODEL_ID = :modelId";
            DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.appMergeTaskDao, (String)updateSql, (Map)object);
        } else {
            String insertSql = "insert into m_meta_form_model (MODEL_ID, Model_Name, OPT_ID, os_id, Model_Type,  Recorder, Model_Comment, MOBILE_FORM_TEMPLATE, form_template, last_modify_Date, SOURCE_ID, STRUCTURE_FUNCTION, MODEL_TAG, IS_VALID, publishDate ) values (:modelId, :modelName, :optId, :osId, :modelType, :recorder, :modelComment, :mobileFormTemplate, :formTemplate, :lastModifyDate, :sourceId, :structureFunction, :modelTag, 'F', :publishDate)";
            DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.appMergeTaskDao, (String)insertSql, (Map)object);
        }
        updateSql = "update m_meta_form_model_draft set  last_modify_Date = :lastModifyDate, publish_date = :publishDate where MODEL_ID = :modelId";
        DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.appMergeTaskDao, (String)updateSql, (Map)object);
    }

    private void publishApi(String apiId) {
        String query = "select PACKET_ID, os_id, Owner_Type, Owner_Code, PACKET_NAME, PACKET_TYPE, PACKET_DESC, Recorder, Record_Date, has_data_opt, data_opt_desc_json, task_type, task_Cron, is_valid, interface_name, is_while, return_type, return_result, need_rollback, OPT_ID, EXT_PROPS, opt_code, BUFFER_FRESH_PERIOD, buffer_fresh_period_type, log_level, is_disable, schema_props, request_body_type, FALL_BACK_LEVEL from q_data_packet_draft  where PACKET_ID = ?";
        JSONObject object = DatabaseOptUtils.getObjectBySqlAsJson((BaseDaoImpl)this.appMergeTaskDao, (String)query, (Object[])new Object[]{apiId});
        if (object == null) {
            throw new ObjectException(604, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684API\u63a5\u53e3\u6a21\u5757" + apiId);
        }
        Object count = DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this.appMergeTaskDao, (String)"select count(*) from q_data_packet where PACKET_ID = ?", (Object[])new Object[]{apiId});
        object.put((Object)"updateDate", (Object)DatetimeOpt.currentUtilDate());
        object.put((Object)"publishDate", (Object)DatetimeOpt.currentUtilDate());
        if (NumberBaseOpt.castObjectToInteger((Object)count, (Integer)0) > 0) {
            String updateSql = "update q_data_packet set os_id = :osId, Owner_Type = :ownerType, Owner_Code = :ownerCode, PACKET_NAME = :packetName, PACKET_TYPE = :packetType, PACKET_DESC = :packetDesc, Recorder = :recorder, Record_Date = :recordDate, has_data_opt = :hasDataOpt, data_opt_desc_json = :dataOptDescJson, task_type = :taskType, task_Cron = :taskCron, is_valid = 'T', interface_name = :interfaceName, is_while = :isWhile, return_type = :returnType, return_result = :returnResult, need_rollback = :needRollback, OPT_ID = :optId, EXT_PROPS = :extProps, opt_code = :optCode, BUFFER_FRESH_PERIOD = :bufferFreshPeriod, buffer_fresh_period_type = :bufferFreshPeriodType, log_level = :logLevel, is_disable = 'F', schema_props = :schemaProps, request_body_type = :requestBodyType, FALL_BACK_LEVEL = :fallBackLevel, update_date = :updateDate, publish_date = :publishDate where PACKET_ID = :packetId";
            DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.appMergeTaskDao, (String)updateSql, (Map)object);
        } else {
            String insertSql = "insert into q_data_packet(PACKET_ID, os_id, Owner_Type, Owner_Code, PACKET_NAME, PACKET_TYPE, PACKET_DESC, Recorder, Record_Date, has_data_opt, data_opt_desc_json, task_type, task_Cron, is_valid, interface_name, is_while, return_type, return_result, need_rollback, OPT_ID, EXT_PROPS, opt_code, BUFFER_FRESH_PERIOD, buffer_fresh_period_type, log_level, is_disable, schema_props, request_body_type, FALL_BACK_LEVEL update_date,  publish_date) values (:packetId, :osId, :ownerType, :ownerCode, :packetName,  :packetType, :packetDesc, :recorder, :recordDate, :hasDataOpt,  :dataOptDescJson, :taskType, :taskCron, 'T', :interfaceName,  :isWhile, :returnType, :returnResult, :needRollback, :optId,  :extProps, :optCode, :bufferFreshPeriod, :bufferFreshPeriodType,  :logLevel, 'F', :schemaProps, :requestBodyType, :fallBackLevel,  :updateDate, :publishDate)";
            DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.appMergeTaskDao, (String)insertSql, (Map)object);
        }
        String deleteParams = "delete from q_data_packet_param  where PACKET_ID = :packetId";
        DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.appMergeTaskDao, (String)deleteParams, (Map)object);
        String insertParams = "insert into q_data_packet_param (PACKET_ID, PARAM_Name, PARAM_Label, PARAM_Display_Style, param_Type, param_Reference_Type, param_Reference_Data, param_Validate_Regex, param_Validate_Info, param_Default_Value, PARAM_Order, IS_REQUIRED ) select PACKET_ID, PARAM_Name, PARAM_Label, PARAM_Display_Style, param_Type, param_Reference_Type, param_Reference_Data, param_Validate_Regex, param_Validate_Info, param_Default_Value, PARAM_Order, IS_REQUIRED from q_data_packet_param_draft where PACKET_ID = ?";
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.appMergeTaskDao, (String)insertParams, (Object[])new Object[]{apiId});
        String updateSql = "update q_data_packet_draft set  update_date = :updateDate,  publish_date = :publishDate where PACKET_ID = :packetId";
        DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this.appMergeTaskDao, (String)updateSql, (Map)object);
    }

    @Override
    public void mergeCompleted(AppMergeTask task) {
        if ("2".equals(task.getObjectType())) {
            this.publishPage(task.getRelationId());
        } else if ("3".equals(task.getObjectType())) {
            this.publishApi(task.getRelationId());
        }
        this.appMergeTaskDao.markTaskComplete(task.getAppVersionId(), task.getRelationId());
    }

    @Override
    public boolean checkRestoreCompleted(String appVersionId) {
        boolean complete;
        int task = this.appMergeTaskDao.countObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"appVersionId", appVersionId, "mergeStatus", "B"}));
        boolean bl = complete = task == 0;
        if (complete) {
            this.restoreCompleted(appVersionId);
        }
        return complete;
    }

    @Override
    public void restoreCompleted(String appVersionId) {
        List<AppMergeTask> tasks = this.appMergeTaskDao.listMergeTask(appVersionId, "B");
        if (tasks != null && !tasks.isEmpty()) {
            for (AppMergeTask task : tasks) {
                if ("2".equals(task.getObjectType())) {
                    this.publishPage(task.getRelationId());
                    continue;
                }
                if (!"3".equals(task.getObjectType())) continue;
                this.publishApi(task.getRelationId());
            }
        }
        this.appMergeTaskDao.clearMergeTask(appVersionId);
        this.applicationVersionDao.setRestoreStatus(appVersionId, "A");
    }

    private void innerRollbackMergeTask(AppMergeTask task) {
        if ("C".equals(task.getMergeType())) {
            this.changeRelationObjectState(task.getObjectType(), task.getRelationId(), true);
        } else if ("U".equals(task.getMergeType())) {
            HistoryVersion hv = this.historyVersionService.getHistoryVersion(task.getHistoryId());
            this.recoveryHistoryVersion(hv);
        } else if ("D".equals(task.getMergeType())) {
            this.changeRelationObjectState(task.getObjectType(), task.getRelationId(), false);
        }
    }

    @Override
    public void rollbackMergeTask(AppMergeTask task) {
        this.innerRollbackMergeTask(task);
        this.appMergeTaskDao.markTaskRollback(task.getAppVersionId(), task.getRelationId());
    }

    @Override
    public void rollbackRestore(String appVersionId) {
        List<AppMergeTask> tasks = this.appMergeTaskDao.listMergeTask(appVersionId, "B");
        if (tasks != null && !tasks.isEmpty()) {
            for (AppMergeTask task : tasks) {
                this.innerRollbackMergeTask(task);
            }
        }
        this.restoreCompleted(appVersionId);
    }
}

