/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.dde.adapter.DdeDubboTaskRun;
import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileInfoOpt;
import com.centit.fileserver.po.FileInfo;
import com.centit.framework.common.ResponseData;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.locode.platform.dao.ApplicationTemplateDao;
import com.centit.locode.platform.service.ModelExportManager;
import com.centit.locode.platform.vo.AppTableNames;
import com.centit.locode.platform.vo.JsonAppVo;
import com.centit.product.dbdesign.service.MetaTableManager;
import com.centit.product.metadata.po.PendingMetaColumn;
import com.centit.product.metadata.po.PendingMetaTable;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.ZipCompressor;
import com.centit.support.common.JavaBeanMetaData;
import com.centit.support.common.ObjectException;
import com.centit.support.file.CsvFileIO;
import com.centit.support.file.FileSystemOpt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ModelExportMangerImpl
implements ModelExportManager {
    @Value(value="${app.home:./}")
    private String appHome;
    private static final Logger logger = LoggerFactory.getLogger(ModelExportMangerImpl.class);
    @Autowired
    private ApplicationTemplateDao applicationTemplateDao;
    @Autowired
    private MetaTableManager metaTableManager;
    @Autowired
    private FileInfoOpt fileInfoOpt;
    @Autowired
    private DdeDubboTaskRun ddeDubboTaskRun;
    @Autowired
    private PlatformEnvironment platformEnvironment;
    private static final String F_DATABASE_INFO = "F_DATABASE_INFO";
    private final Map<String, String> applicationSql = new HashMap<String, String>(16);
    private final Map<String, String> oldApplicationSql = new HashMap<String, String>(16);
    private final Map<String, String> newDatabaseSql = new HashMap<String, String>(4);
    private final Map<String, String> oldDatabaseSql = new HashMap<String, String>(4);

    @PostConstruct
    void init() {
        this.applicationSql.put(AppTableNames.F_OS_INFO.name(), "select os_id,page_flow from f_os_info where [:osId | os_id=:osId]");
        this.applicationSql.put(AppTableNames.F_OPTINFO.name(), "select * from f_optinfo where [:osId | top_opt_id=:osId]");
        this.applicationSql.put(AppTableNames.F_OPTDEF.name(), "select * from f_optdef where opt_id in (select opt_id from f_optinfo where [:osId | top_opt_id=:osId] [:(splitforin)optId | and opt_id in (:optId)])");
        this.applicationSql.put(AppTableNames.F_DATABASE_INFO.name(), "select database_code,top_unit,database_name,database_desc,source_type from f_database_info where database_code in (select DATABASE_ID from m_application_resources where [:osId | os_id=:osId])");
        this.applicationSql.put(AppTableNames.M_APPLICATION_RESOURCES.name(), "select * from m_application_resources where [:osId | os_id=:osId]");
        this.applicationSql.put(AppTableNames.F_TABLE_OPT_RELATION.name(), "select a.* from f_table_opt_relation a join f_md_table b on a.table_id=b.TABLE_ID where [:osId | a.os_id=:osId] [:(splitforin)optId | and opt_id in (:optId)]");
        this.applicationSql.put(AppTableNames.M_META_FORM_MODEL.name(), "select * from m_meta_form_model where [:osId | OS_ID=:osId] [:(splitforin)optId | and opt_id in (:optId)]");
        this.applicationSql.put(AppTableNames.Q_DATA_PACKET.name(), "select * from q_data_packet where [:osId | OS_ID=:osId] [:(splitforin)optId | and opt_id in (:optId)]");
        this.applicationSql.put(AppTableNames.WF_FLOW_DEFINE.name(), "select * from wf_flow_define where [:osId | OS_ID=:osId] and (flow_state<>'C' or version=0) [:(splitforin)optId | and opt_id in (:optId)]");
        this.applicationSql.put(AppTableNames.WF_NODE.name(), "select * from wf_node where (flow_code,version) in(select flow_code,version from wf_flow_define where [:osId | OS_ID=:osId] and flow_state='B' [:(splitforin)optId | and opt_id in (:optId)])");
        this.applicationSql.put(AppTableNames.WF_TRANSITION.name(), "select * from wf_transition where (flow_code,version) in(select flow_code,version from wf_flow_define where [:osId | OS_ID=:osId] and flow_state='B' [:(splitforin)optId | and opt_id in (:optId)])");
        this.applicationSql.put(AppTableNames.WF_FLOW_STAGE.name(), "select * from wf_flow_stage where (flow_code,version) in(select flow_code,version from wf_flow_define where [:osId | OS_ID=:osId] and flow_state='B' [:(splitforin)optId | and opt_id in (:optId)])");
        this.applicationSql.put(AppTableNames.WF_OPT_TEAM_ROLE.name(), "select * from wf_opt_team_role where opt_id in (select opt_id from f_optinfo where [:osId | top_opt_id=:osId] [:(splitforin)optId | and opt_id in (:optId)])");
        this.applicationSql.put(AppTableNames.WF_OPT_VARIABLE_DEFINE.name(), "select * from wf_opt_variable_define where opt_id in (select opt_id from f_optinfo where [:osId | top_opt_id=:osId] [:(splitforin)optId | and opt_id in (:optId)])");
        this.applicationSql.put(AppTableNames.F_DATACATALOG.name(), "select * from f_datacatalog where CATALOG_CODE in (select dictionary_id from m_application_dictionary where [:osId | os_id=:osId]) and catalog_style<>'S'");
        this.applicationSql.put(AppTableNames.F_DATADICTIONARY.name(), "select * from f_datadictionary where CATALOG_CODE in (select a.dictionary_id from m_application_dictionary a join f_datacatalog b on a.dictionary_id=b.CATALOG_CODE where [:osId | a.os_id=:osId] and catalog_style<>'S')");
        this.applicationSql.put(AppTableNames.M_APPLICATION_DICTIONARY.name(), "select * from m_application_dictionary where [:osId | os_id=:osId]");
        this.newDatabaseSql.put(AppTableNames.F_MD_TABLE.name(), "select * from f_md_table where table_id in (select table_id from f_table_opt_relation where [:osId | OS_ID=:osId] [:(splitforin)optId | and opt_id in (:optId)]) and database_code in (select DATABASE_ID from m_application_resources where [:osId | os_id=:osId])");
        this.newDatabaseSql.put(AppTableNames.F_MD_COLUMN.name(), "select * from f_md_column where table_id in (select table_id from f_table_opt_relation where [:osId | OS_ID=:osId] [:(splitforin)optId | and opt_id in (:optId)])");
        this.newDatabaseSql.put(AppTableNames.F_MD_RELATION.name(), "select * from f_md_relation where parent_table_id in (select table_id from f_table_opt_relation where [:osId | OS_ID=:osId] [:(splitforin)optId | and opt_id in (:optId)])");
        this.newDatabaseSql.put(AppTableNames.F_MD_REL_DETAIL.name(), "select * from f_md_rel_detail where relation_id in (select relation_id from f_md_relation where parent_table_id in (select table_id from f_table_opt_relation where [:osId | OS_ID=:osId] [:(splitforin)optId | and opt_id in (:optId)]))");
        this.oldDatabaseSql.put(AppTableNames.F_MD_TABLE.name(), "select table_id,table_name,DATABASE_CODE from f_md_table where database_code in (select DATABASE_ID from m_application_resources where os_id=:osId)");
        this.oldDatabaseSql.put(AppTableNames.F_MD_RELATION.name(), "select RELATION_ID,PARENT_TABLE_ID,CHILD_TABLE_ID from f_md_relation where parent_table_id in (select table_id from f_md_table where database_code in (select DATABASE_ID from m_application_resources where os_id=:osId))");
        this.oldApplicationSql.put(AppTableNames.F_OS_INFO.name(), "select os_id,os_name from f_os_info where os_id=:osId");
        this.oldApplicationSql.put(AppTableNames.F_OPTINFO.name(), "select SOURCE_ID,FORM_CODE,OPT_ID,DOC_ID,top_opt_id,opt_name from f_optinfo");
        this.oldApplicationSql.put(AppTableNames.F_OPTDEF.name(), "select a.SOURCE_ID,a.OPT_CODE,b.top_opt_id from f_optdef a join f_optinfo b on a.opt_id=b.opt_id");
        this.oldApplicationSql.put(AppTableNames.F_DATABASE_INFO.name(), "select database_code,database_name,source_type from f_database_info where database_code in (select DATABASE_ID from m_application_resources where os_id=:osId)");
        this.oldApplicationSql.put(AppTableNames.F_TABLE_OPT_RELATION.name(), "select table_id,opt_id,id from f_table_opt_relation");
        this.oldApplicationSql.put(AppTableNames.M_META_FORM_MODEL.name(), "select source_id,MODEL_ID,os_id,is_valid from m_meta_form_model");
        this.oldApplicationSql.put(AppTableNames.Q_DATA_PACKET.name(), "select source_id,packet_id,os_id,is_valid,task_cron from q_data_packet");
        this.oldApplicationSql.put(AppTableNames.WF_FLOW_DEFINE.name(), "select SOURCE_ID,FLOW_CODE,os_id from wf_flow_define");
        this.oldApplicationSql.put(AppTableNames.WF_NODE.name(), "select SOURCE_ID,NODE_ID,os_id from wf_node");
        this.oldApplicationSql.put(AppTableNames.WF_TRANSITION.name(), "select FLOW_CODE,START_NODE_ID,END_NODE_ID,TRANS_ID from wf_transition");
        this.oldApplicationSql.put(AppTableNames.WF_OPT_TEAM_ROLE.name(), "select OPT_TEAM_ROLE_ID,OPT_ID,ROLE_CODE from wf_opt_team_role");
        this.oldApplicationSql.put(AppTableNames.WF_OPT_VARIABLE_DEFINE.name(), "select VARIABLE_NAME,OPT_ID,OPT_VARIABLE_ID from wf_opt_variable_define");
        this.oldApplicationSql.put(AppTableNames.F_DATACATALOG.name(), "select catalog_code,top_unit,source_id from f_datacatalog");
        this.oldApplicationSql.put(AppTableNames.M_APPLICATION_DICTIONARY.name(), "select id,os_id,dictionary_id from m_application_dictionary");
    }

    @Override
    public String downModel(String osId, Map<String, Object> parameters) throws IOException {
        String optId;
        String fileId = DatetimeOpt.convertDateToString((Date)DatetimeOpt.currentUtilDate(), (String)"YYYYMMddHHmmss") + "_" + UUID.randomUUID().toString().substring(0, 8);
        File targetDir = new File(this.appHome, fileId);
        String filePath = targetDir.getAbsolutePath();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(1);
        paramsMap.put("osId", osId);
        boolean isModelExport = false;
        if (parameters != null && parameters.containsKey("optId") && StringUtils.isNotBlank((CharSequence)(optId = StringBaseOpt.objectToString((Object)parameters.get("optId"))))) {
            paramsMap.put("optId", optId);
            isModelExport = true;
        }
        this.processSqlEntries(this.applicationSql, paramsMap, filePath);
        this.processSqlEntries(this.newDatabaseSql, paramsMap, filePath);
        if (!isModelExport) {
            try {
                this.compressFileInfo(osId, filePath);
            }
            catch (IOException e) {
                throw new ObjectException((Throwable)e);
            }
        }
        File zipFile = new File(targetDir.getParent(), targetDir.getName() + ".zip");
        ZipCompressor.compress((String)zipFile.getAbsolutePath(), (String)filePath);
        try {
            FileSystemOpt.deleteDirect((String)filePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileId;
    }

    private void processSqlEntries(Map<String, String> sqlEntries, Map<String, Object> params, String basePath) throws IOException {
        if (sqlEntries == null || sqlEntries.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : sqlEntries.entrySet()) {
            this.createFile(params, entry.getValue(), entry.getKey(), basePath);
        }
    }

    @Override
    public String exportModelAndSaveToFileServer(OsInfo osInfo) throws IOException {
        String osId = osInfo.getOsId();
        String fileId = this.downModel(osId, null);
        String filePath = this.appHome + File.separator + fileId + ".zip";
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileName(osInfo.getOsName() + DatetimeOpt.currentDate() + ".zip");
        fileInfo.setFileType("zip");
        fileInfo.setOsId(osId);
        fileInfo.setLibraryId("backup");
        fileInfo.setFileOwner("system");
        return this.fileInfoOpt.saveFile((FileBaseInfo)fileInfo, 0L, Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));
    }

    private void createFile(Map<String, Object> map, String sql, String fileName, String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("\u65e0\u6cd5\u521b\u5efa\u76ee\u5f55: " + filePath);
        }
        JSONArray jsonArray = DatabaseOptUtils.listObjectsByParamsDriverSqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)sql, map);
        if (fileName.equals(AppTableNames.F_OPTINFO.name()) && map.containsKey("optId")) {
            jsonArray = this.parentOpt(jsonArray, map.get("optId"));
        }
        try (FileOutputStream fos = new FileOutputStream(filePath + File.separator + fileName + ".csv");){
            CsvFileIO.saveJSON2OutputStream((JSONArray)jsonArray, (OutputStream)fos, (boolean)true, null, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new ObjectException(511, "\u5bfc\u51fa\u6587\u4ef6\u51fa\u9519" + e.getMessage());
        }
    }

    private JSONArray parentOpt(JSONArray jsonArray, Object optId) {
        JSONArray resultArray = new JSONArray();
        String[] optIds = StringBaseOpt.objectToStringArray((Object)optId);
        if (optIds == null) {
            return resultArray;
        }
        for (String currentOptId : optIds) {
            JSONObject optInfo = this.getOptInfo(jsonArray, currentOptId);
            if (optInfo == null) continue;
            resultArray.add((Object)optInfo);
            String preOptId = optInfo.getString("preOptId");
            this.collectParentOptions(resultArray, jsonArray, preOptId);
        }
        return resultArray;
    }

    private void collectParentOptions(JSONArray pOptInfo, JSONArray jsonArray, String preOptId) {
        HashMap<String, JSONObject> optIdMap = new HashMap<String, JSONObject>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject item = jsonArray.getJSONObject(i);
            String optId = item.getString("optId");
            if (optId == null) continue;
            optIdMap.put(optId, item);
        }
        HashSet<String> existingOptIds = new HashSet<String>();
        for (int i = 0; i < pOptInfo.size(); ++i) {
            JSONObject item = pOptInfo.getJSONObject(i);
            String optId = item.getString("optId");
            if (optId == null) continue;
            existingOptIds.add(optId);
        }
        this.collect(pOptInfo, optIdMap, existingOptIds, preOptId);
    }

    private void collect(JSONArray pOptInfo, Map<String, JSONObject> optIdMap, Set<String> existingOptIds, String preOptId) {
        String nextPreOptId;
        if (preOptId == null || "0".equals(preOptId)) {
            return;
        }
        JSONObject optInfo = optIdMap.get(preOptId);
        if (optInfo == null) {
            return;
        }
        String currentOptId = optInfo.getString("optId");
        if (currentOptId != null && !existingOptIds.contains(currentOptId)) {
            pOptInfo.add((Object)optInfo);
            existingOptIds.add(currentOptId);
        }
        if ((nextPreOptId = optInfo.getString("preOptId")) != null && !nextPreOptId.equals("0")) {
            this.collect(pOptInfo, optIdMap, existingOptIds, nextPreOptId);
        }
    }

    private JSONObject getOptInfo(JSONArray jsonArray, String optId) {
        if (jsonArray == null || optId == null) {
            return null;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject item = jsonArray.getJSONObject(i);
            String currentOptId = item.getString("optId");
            if (!optId.equals(currentOptId)) continue;
            return item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressFileInfo(String osId, String filePath) throws IOException {
        String FILE_SEPARATOR = File.separator;
        String fileInfoSql = "select a.file_id, a.file_name from file_info a join file_store_info b on a.file_md5=b.file_md5 where a.library_id=:osId and a.file_catalog in ('A','B')";
        List objects = DatabaseOptUtils.listObjectsByNamedSql((BaseDaoImpl)this.applicationTemplateDao, (String)fileInfoSql, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"osId", osId}));
        if (objects == null || objects.isEmpty()) {
            return;
        }
        String fileInfoPath = filePath + FILE_SEPARATOR + "file";
        String zipFilePath = fileInfoPath + ".zip";
        File fileDir = new File(fileInfoPath);
        if (!fileDir.exists() && !fileDir.mkdirs()) {
            throw new RuntimeException("Failed to create directory: " + fileDir.getAbsolutePath());
        }
        for (Object[] object : objects) {
            String fileId = StringBaseOpt.castObjectToString((Object)object[0]);
            String fileName = StringBaseOpt.castObjectToString((Object)object[1]);
            try {
                InputStream inputStream = this.fileInfoOpt.loadFileStream(fileId);
                Throwable throwable = null;
                try {
                    if (inputStream == null) continue;
                    String fileIdPath = fileInfoPath + FILE_SEPARATOR + "(" + fileId + ")" + fileName;
                    FileSystemOpt.createFile((InputStream)inputStream, (String)fileIdPath);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            ZipCompressor.compress((String)zipFilePath, (String)fileInfoPath);
        }
        finally {
            FileSystemOpt.deleteDirect((String)fileInfoPath);
        }
    }

    @Override
    public JSONObject uploadModel(File zipFile) throws Exception {
        if (zipFile == null || !zipFile.exists()) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u7684 ZIP \u6587\u4ef6\u65e0\u6548");
        }
        JSONObject returnJsonObject = new JSONObject();
        String timestamp = DatetimeOpt.convertDateToString((Date)DatetimeOpt.currentUtilDate(), (String)"yyyyMMddHHmmss");
        String filePath = this.appHome + File.separator + "c" + timestamp;
        File targetDir = new File(filePath);
        if (!targetDir.mkdirs() && !targetDir.isDirectory()) {
            throw new IOException("\u65e0\u6cd5\u521b\u5efa\u76ee\u6807\u76ee\u5f55: " + filePath);
        }
        try {
            ZipCompressor.release((File)zipFile, (String)filePath);
            JSONObject jsonObject = new JSONObject();
            this.parseCsvToJson(jsonObject, filePath);
            returnJsonObject.put((Object)"file", (Object)filePath);
            returnJsonObject.put((Object)F_DATABASE_INFO, jsonObject.get(F_DATABASE_INFO));
        }
        catch (Exception e) {
            this.deleteDirectoryRecursively(targetDir);
            throw e;
        }
        return returnJsonObject;
    }

    private void deleteDirectoryRecursively(File dir) {
        if (dir != null && dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    this.deleteDirectoryRecursively(file);
                }
                file.delete();
            }
        }
        dir.delete();
    }

    @Override
    public JSONObject prepareApp(JSONObject jsonObject, String osId, CentitUserDetails currentUserDetails) {
        try {
            if (!jsonObject.containsKey("file")) {
                throw new IllegalArgumentException("Missing 'file' field in input JSON");
            }
            String zipFilePath = jsonObject.getString("file");
            JSONObject sourceJson = new JSONObject();
            this.parseCsvToJson(sourceJson, zipFilePath);
            JSONObject copyJson = JSON.parseObject((String)JSON.toJSONString((Object)jsonObject));
            sourceJson.put((Object)F_DATABASE_INFO, copyJson.get(F_DATABASE_INFO));
            JsonAppVo jsonAppVo = new JsonAppVo(sourceJson, this.getOldApplication(osId), osId, currentUserDetails, this.appHome, this.fileInfoOpt, zipFilePath);
            jsonAppVo.setUploadFiles(false);
            jsonAppVo.updatePrimary();
            List<Map<String, Object>> pendingTableList = jsonAppVo.getMapJsonObject().get(AppTableNames.F_MD_TABLE.name());
            List<Map<String, Object>> pendingColumnsList = jsonAppVo.getMapJsonObject().get(AppTableNames.F_MD_COLUMN.name());
            List<Map<String, Object>> databaseList = jsonAppVo.getMapJsonObject().get(AppTableNames.F_DATABASE_INFO.name());
            HashMap<String, List> appSqls = new HashMap<String, List>(4);
            JavaBeanMetaData tableMeta = JavaBeanMetaData.createBeanMetaDataFromType(PendingMetaTable.class);
            JavaBeanMetaData columnMeta = JavaBeanMetaData.createBeanMetaDataFromType(PendingMetaColumn.class);
            HashMap columnsByTableId = new HashMap();
            for (Map<String, Object> map : pendingColumnsList) {
                PendingMetaColumn column = (PendingMetaColumn)columnMeta.createBeanObjectFromMap(map);
                column.setMaxLength(NumberBaseOpt.castObjectToInteger((Object)map.get("columnLength")));
                columnsByTableId.computeIfAbsent(column.getTableId(), k -> new ArrayList()).add(column);
            }
            for (Map<String, Object> map : pendingTableList) {
                PendingMetaTable table = (PendingMetaTable)tableMeta.createBeanObjectFromMap(map);
                table.setMdColumns(columnsByTableId.getOrDefault(table.getTableId(), Collections.emptyList()));
                List list = this.metaTableManager.makeAlterTableSqlList(table);
                appSqls.computeIfAbsent(table.getDatabaseCode(), k -> new ArrayList()).addAll(list);
            }
            JavaBeanMetaData sourceInfoMeta = JavaBeanMetaData.createBeanMetaDataFromType(SourceInfo.class);
            HashMap DDLs = new HashMap(4);
            for (Map map : databaseList) {
                SourceInfo sourceInfo = (SourceInfo)sourceInfoMeta.createBeanObjectFromMap(map);
                List sqlList = (List)appSqls.get(sourceInfo.getDatabaseCode());
                if (sqlList == null || sqlList.isEmpty()) continue;
                DDLs.put(sourceInfo.getDatabaseName() + "(" + sourceInfo.getDatabaseCode() + ")", new ArrayList(sqlList));
            }
            JSONObject returnJson = new JSONObject();
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)F_DATABASE_INFO, jsonObject.get(F_DATABASE_INFO));
            jSONObject.put((Object)"file", jsonObject.get("file"));
            jSONObject.put((Object)"targetOsId", (Object)osId);
            returnJson.put((Object)"jsonAppVo", (Object)jSONObject);
            returnJson.put((Object)"DDL", DDLs);
            returnJson.put((Object)"runDDL", (Object)true);
            return returnJson;
        }
        catch (Exception e) {
            throw new ObjectException((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONArray importApp(JSONObject jsonObject, CentitUserDetails userDetails) throws Exception {
        String osId;
        if (jsonObject == null || !jsonObject.containsKey("jsonAppVo")) {
            throw new IllegalArgumentException("jsonObject \u6216 jsonAppVo \u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject jsonAppVoJson = jsonObject.getJSONObject("jsonAppVo");
        JSONObject sourceJson = new JSONObject();
        String filePath = StringBaseOpt.objectToString((Object)jsonAppVoJson.get("file"));
        if (StringUtils.isBlank((CharSequence)filePath)) {
            throw new IllegalArgumentException("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.parseCsvToJson(sourceJson, filePath);
        Object dbInfo = jsonAppVoJson.get(F_DATABASE_INFO);
        if (dbInfo != null) {
            sourceJson.put((Object)F_DATABASE_INFO, dbInfo);
        }
        if (StringBaseOpt.isNvl((String)(osId = jsonAppVoJson.getString("targetOsId")))) {
            throw new IllegalArgumentException("targetOsId\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List userGroups = this.platformEnvironment.listWorkGroup(osId, userDetails.getUserCode(), null);
        if (CollectionUtils.isEmpty((Collection)userGroups)) {
            throw new ObjectException(403, "\u7528\u6237\u6ca1\u6709\u6743\u9650\u5bfc\u51fa\u8fd9\u4e2a\u5e94\u7528\uff1a" + osId + "\uff01");
        }
        JsonAppVo jsonAppVo = new JsonAppVo(sourceJson, this.getOldApplication(osId), osId, userDetails, this.appHome, this.fileInfoOpt, filePath);
        jsonAppVo.setRunDictionary(BooleanBaseOpt.castObjectToBoolean((Object)jsonObject.get("runDictionary"), (Boolean)true));
        jsonAppVo.setRunMetaData(BooleanBaseOpt.castObjectToBoolean((Object)jsonObject.get("runMetaData"), (Boolean)true));
        jsonAppVo.prepareApp();
        boolean runDDL = BooleanBaseOpt.castObjectToBoolean((Object)jsonObject.get("runDDL"), (Boolean)true);
        try {
            if (!jsonAppVo.getAppList().isEmpty()) {
                if (!runDDL) {
                    logger.info("\u5f00\u59cb\u66f4\u6539\u5f85\u53d1\u5e03\u72b6\u6001");
                    for (Object object : jsonAppVo.getAppList()) {
                        if (!(object instanceof PendingMetaTable)) continue;
                        ((PendingMetaTable)object).setTableState("S");
                    }
                    logger.info("\u66f4\u6539\u5f85\u53d1\u5e03\u5b8c\u6210");
                }
                logger.info("\u5f00\u59cb\u66f4\u65b0\u6570\u636e");
                try {
                    DatabaseOptUtils.batchMergeObjects((BaseDaoImpl)this.applicationTemplateDao, jsonAppVo.getAppList());
                }
                catch (Exception e) {
                    logger.error("\u6279\u91cf\u5408\u5e76\u5bf9\u8c61\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
                    throw new ObjectException((Object)"\u6279\u91cf\u5408\u5e76\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
                }
                logger.info("\u66f4\u65b0\u6570\u636e\u5b8c\u6210");
                if (runDDL) {
                    logger.info("\u5f00\u59cb\u53d1\u5e03\u6570\u636e\u5e93");
                    for (String databaseCode : jsonAppVo.getPublishDatabaseCode()) {
                        ResponseData responseData = this.metaTableManager.publishDatabase(databaseCode, jsonAppVo.getUserCode());
                        if (responseData.getCode() >= 0) continue;
                        logger.error("\u53d1\u5e03\u6570\u636e\u5e93 {} \u5931\u8d25: {}, \u6570\u636e: {}", new Object[]{databaseCode, responseData.getMessage(), JSON.toJSONString((Object)responseData.getData())});
                    }
                    logger.info("\u53d1\u5e03\u6570\u636e\u5e93\u5b8c\u6210");
                }
            }
            if (!jsonAppVo.getMetaObject().isEmpty()) {
                logger.info("\u5f00\u59cb\u66f4\u65b0\u5143\u6570\u636e");
                DatabaseOptUtils.batchMergeObjects((BaseDaoImpl)this.applicationTemplateDao, jsonAppVo.getMetaObject());
                logger.info("\u66f4\u65b0\u5143\u6570\u636e\u5b8c\u6210");
            }
            logger.info("\u5f00\u59cb\u5237\u65b0\u7f13\u5b58");
            jsonAppVo.refreshCache(this.ddeDubboTaskRun);
            logger.info("\u5237\u65b0\u7f13\u5b58\u5b8c\u6210");
        }
        catch (Exception e) {
            String errorMessage = "\u5bfc\u5165\u5e94\u7528\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38: " + e.getMessage();
            logger.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
        finally {
            try {
                FileSystemOpt.deleteDirect((String)filePath);
            }
            catch (Exception e) {
                logger.warn("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25: {}", (Object)filePath, (Object)e);
            }
        }
        return jsonAppVo.getDiffIds();
    }

    private void parseCsvToJson(JSONObject jsonObject, String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            return;
        }
        List files = FileSystemOpt.findFiles((String)filePath, (String)"*.csv");
        if (files == null || files.isEmpty()) {
            return;
        }
        for (File file : files) {
            String path = file.getPath();
            String fileName = FileSystemOpt.extractFileName((String)path);
            try {
                InputStream is = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    jsonObject.put((Object)fileName, (Object)CsvFileIO.readDataFromInputStream((InputStream)is, (boolean)true, null, (String)"UTF-8"));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (Exception e) {
                logger.error("\u8bfb\u53d6CSV\u6587\u4ef6\u5931\u8d25: {}", (Object)path);
            }
        }
    }

    private JSONObject getOldApplication(String osId) {
        if (StringUtils.isBlank((CharSequence)osId)) {
            return new JSONObject();
        }
        try {
            Map mapApplication = CollectionsOpt.createHashMap((Object[])new Object[]{"osId", osId});
            JSONObject jsonObject = new JSONObject();
            this.processSqlEntries(this.oldApplicationSql, (Map<String, Object>)mapApplication, jsonObject);
            this.processSqlEntries(this.oldDatabaseSql, (Map<String, Object>)mapApplication, jsonObject);
            return jsonObject;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return new JSONObject();
        }
    }

    private void processSqlEntries(Map<String, String> sqlEntries, Map<String, Object> params, JSONObject jsonObject) {
        if (sqlEntries == null || sqlEntries.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : sqlEntries.entrySet()) {
            JSONArray jsonArray = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this.applicationTemplateDao, (String)entry.getValue(), params);
            if (jsonArray == null) continue;
            jsonObject.put((Object)entry.getKey(), (Object)jsonArray);
        }
    }
}

